/*
 * Decompiled with CFR 0.152.
 */
package org.mpizutil.electrolist.testing;

import java.util.LinkedList;
import java.util.List;
import org.mpizutil.electrolist.structure.ElectroList;

public class TestingStructures {
    public static void main(String[] args) {
        TestingStructures.testOnlyAdd(100);
        TestingStructures.testOnlyAdd(1000);
        TestingStructures.testOnlyAdd(10000);
        TestingStructures.testOnlyAdd(100000);
        TestingStructures.testOnlyAdd(1000000);
        TestingStructures.testOnlyAdd(10000000);
        System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++");
    }

    private static double getTime() {
        long nanos = System.nanoTime();
        return (double)nanos / 1000.0;
    }

    private static String getDiff(double ti, double tf) {
        return tf - ti + " microseconds";
    }

    private static void testIntegerLists(int size) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        ElectroList<Integer> electroList = new ElectroList<Integer>();
        System.out.println("===============================================================");
        System.out.println("--------------------------------------------");
        TestingStructures.add(linkedList, size);
        TestingStructures.add(electroList, size);
        System.out.println("--------------------------------------------");
        TestingStructures.getMiddle(linkedList);
        TestingStructures.getMiddle(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.setMiddle(linkedList);
        TestingStructures.setMiddle(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.removeMiddle(linkedList);
        TestingStructures.removeMiddle(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.foreach(linkedList);
        TestingStructures.foreach(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.foreachLambdaSimple(linkedList);
        TestingStructures.foreachLambdaSimple(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.foreachLambdaSequential(linkedList);
        TestingStructures.foreachLambdaSequential(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.foreachLambdaParallel(linkedList);
        TestingStructures.foreachLambdaParallel(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.mapSequential(linkedList);
        TestingStructures.mapSequential(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.mapParallel(linkedList);
        TestingStructures.mapParallel(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.filterSequential(linkedList);
        TestingStructures.filterSequential(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.filterParallel(linkedList);
        TestingStructures.filterParallel(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.exoticLambdaSequential(linkedList);
        TestingStructures.exoticLambdaSequential(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.exoticLambdaParallel(linkedList);
        TestingStructures.exoticLambdaParallel(electroList);
        System.out.println("--------------------------------------------");
        System.out.println("===============================================================");
    }

    private static void testStringLists(int size) {
        LinkedList<String> linkedList = new LinkedList<String>();
        ElectroList<String> electroList = new ElectroList<String>();
        System.out.println("===============================================================");
        System.out.println("--------------------------------------------");
        TestingStructures.addStringList(linkedList, size);
        TestingStructures.addStringList(electroList, size);
        System.out.println("--------------------------------------------");
        TestingStructures.getMiddleStringList(linkedList);
        TestingStructures.getMiddleStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.setMiddleStringList(linkedList);
        TestingStructures.setMiddleStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.removeMiddleStringList(linkedList);
        TestingStructures.removeMiddleStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.foreachStringList(linkedList);
        TestingStructures.foreachStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.foreachLambdaSimpleStringList(linkedList);
        TestingStructures.foreachLambdaSimpleStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.foreachLambdaSequentialStringList(linkedList);
        TestingStructures.foreachLambdaSequentialStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.foreachLambdaParallelStringList(linkedList);
        TestingStructures.foreachLambdaParallelStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.mapSequentialStringList(linkedList);
        TestingStructures.mapSequentialStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.mapParallelStringList(linkedList);
        TestingStructures.mapParallelStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.filterSequentialStringList(linkedList);
        TestingStructures.filterSequentialStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.filterParallelStringList(linkedList);
        TestingStructures.filterParallelStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.exoticLambdaSequentialStringList(linkedList);
        TestingStructures.exoticLambdaSequentialStringList(electroList);
        System.out.println("--------------------------------------------");
        TestingStructures.exoticLambdaParallelStringList(linkedList);
        TestingStructures.exoticLambdaParallelStringList(electroList);
        System.out.println("--------------------------------------------");
        System.out.println("===============================================================");
    }

    private static void testOnlyAdd(int size) {
        int i;
        LinkedList<String> linkedList = new LinkedList<String>();
        ElectroList<String> electroList = new ElectroList<String>();
        double times = 0.0;
        System.out.println("===============================================================");
        System.out.println("--------------------------------------------");
        for (i = 0; i < 10; ++i) {
            times += TestingStructures.addStringList(linkedList, size);
        }
        System.out.println("Average LinkedList add time: " + times / 10.0);
        times = 0.0;
        for (i = 0; i < 10; ++i) {
            times += TestingStructures.addStringList(electroList, size);
        }
        System.out.println("Average ElectroList add time: " + times / 10.0);
        System.out.println("--------------------------------------------");
        System.out.println("===============================================================");
    }

    private static void add(List<Integer> list, int size) {
        double ti = TestingStructures.getTime();
        for (int i = 0; i < size; ++i) {
            list.add(i);
        }
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] ADD " + size + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    private static void getMiddle(List<Integer> list) {
        int size = list.size();
        double ti = TestingStructures.getTime();
        list.get(size / 2);
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] GET MIDDLE " + size + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void setMiddle(List<Integer> list) {
        int size = list.size();
        double ti = TestingStructures.getTime();
        list.set(size / 2, Integer.MAX_VALUE);
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] SET MIDDLE " + size + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void removeMiddle(List<Integer> list) {
        int size = list.size();
        double ti = TestingStructures.getTime();
        list.remove(size / 2);
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] REMOVE MIDDLE " + size + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void forI(List<Integer> list) {
        int size = list.size();
        double ti = TestingStructures.getTime();
        for (int i = 0; i < size; ++i) {
            list.get(i);
        }
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FORI " + size + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void foreach(List<Integer> list) {
        double ti = TestingStructures.getTime();
        for (Integer n : list) {
        }
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FOREACH " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void foreachLambdaSimple(List<Integer> list) {
        double ti = TestingStructures.getTime();
        list.forEach(element -> {});
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FOREACH LAMBDA SIMPLE " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void foreachLambdaSequential(List<Integer> list) {
        double ti = TestingStructures.getTime();
        list.stream().forEach(element -> {});
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FOREACH LAMBDA SEQUENTIAL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void foreachLambdaParallel(List<Integer> list) {
        double ti = TestingStructures.getTime();
        list.parallelStream().forEach(element -> {});
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FOREACH LAMBDA PARALLEL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void mapSequential(List<Integer> list) {
        double ti = TestingStructures.getTime();
        list.stream().map(element -> element + 1);
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] MAP SEQUENTIAL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void mapParallel(List<Integer> list) {
        double ti = TestingStructures.getTime();
        list.parallelStream().map(element -> element + 1);
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] MAP PARALLEL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void filterSequential(List<Integer> list) {
        double ti = TestingStructures.getTime();
        list.stream().filter(element -> element > Integer.MIN_VALUE);
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FILTER SEQUENTIAL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void filterParallel(List<Integer> list) {
        double ti = TestingStructures.getTime();
        list.parallelStream().filter(element -> element > Integer.MIN_VALUE);
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FILTER PARALLEL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void exoticLambdaSequential(List<Integer> list) {
        double ti = TestingStructures.getTime();
        list.stream().filter(element -> !element.equals("A")).map(element -> "XD").forEach(element -> System.out.print(""));
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] EXOTIC LAMBDA SEQUENTIAL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void exoticLambdaParallel(List<Integer> list) {
        double ti = TestingStructures.getTime();
        list.parallelStream().filter(element -> !element.equals("A")).map(element -> "XD").forEach(element -> System.out.print(""));
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] EXOTIC LAMBDA PARALLEL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    private static double addStringList(List<String> list, int size) {
        double ti = TestingStructures.getTime();
        for (int i = 0; i < size; ++i) {
            list.add(String.valueOf(i));
        }
        double tf = TestingStructures.getTime();
        return tf - ti;
    }

    private static void getMiddleStringList(List<String> list) {
        int size = list.size();
        double ti = TestingStructures.getTime();
        list.get(size / 2);
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] GET MIDDLE " + size + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void setMiddleStringList(List<String> list) {
        int size = list.size();
        double ti = TestingStructures.getTime();
        list.set(size / 2, "XD");
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] SET MIDDLE " + size + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void removeMiddleStringList(List<String> list) {
        int size = list.size();
        double ti = TestingStructures.getTime();
        list.remove(size / 2);
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] REMOVE MIDDLE " + size + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void forIStringList(List<String> list) {
        int size = list.size();
        double ti = TestingStructures.getTime();
        for (int i = 0; i < size; ++i) {
            list.get(i);
        }
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FORI " + size + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void foreachStringList(List<String> list) {
        double ti = TestingStructures.getTime();
        for (String string : list) {
        }
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FOREACH " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void foreachLambdaSimpleStringList(List<String> list) {
        double ti = TestingStructures.getTime();
        list.forEach(element -> {});
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FOREACH LAMBDA SIMPLE " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void foreachLambdaSequentialStringList(List<String> list) {
        double ti = TestingStructures.getTime();
        list.stream().forEach(element -> {});
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FOREACH LAMBDA SEQUENTIAL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void foreachLambdaParallelStringList(List<String> list) {
        double ti = TestingStructures.getTime();
        list.parallelStream().forEach(element -> {});
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FOREACH LAMBDA PARALLEL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void mapSequentialStringList(List<String> list) {
        double ti = TestingStructures.getTime();
        list.stream().map(element -> element + "1");
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] MAP SEQUENTIAL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void mapParallelStringList(List<String> list) {
        double ti = TestingStructures.getTime();
        list.parallelStream().map(element -> element + "1");
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] MAP PARALLEL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void filterSequentialStringList(List<String> list) {
        double ti = TestingStructures.getTime();
        list.stream().filter(element -> !element.equals("XD"));
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FILTER SEQUENTIAL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void filterParallelStringList(List<String> list) {
        double ti = TestingStructures.getTime();
        list.parallelStream().filter(element -> !element.equals("XD"));
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] FILTER PARALLEL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void exoticLambdaSequentialStringList(List<String> list) {
        double ti = TestingStructures.getTime();
        list.stream().filter(element -> !element.equals("A")).map(element -> "XD").forEach(element -> System.out.print(""));
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] EXOTIC LAMBDA SEQUENTIAL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }

    public static void exoticLambdaParallelStringList(List<String> list) {
        double ti = TestingStructures.getTime();
        list.parallelStream().filter(element -> !element.equals("A")).map(element -> "XD").forEach(element -> System.out.print(""));
        double tf = TestingStructures.getTime();
        System.out.println("[" + list.getClass().getSimpleName() + "] EXOTIC LAMBDA PARALLEL " + list.size() + " elements: " + TestingStructures.getDiff(ti, tf));
    }
}

