/*
 * Decompiled with CFR 0.152.
 */
package org.mpizutil.electrolist.search;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mpizutil.electrolist.structure.ElectroList;
import org.mpizutil.electrolist.structure.Node;

public class TSearcher<T>
extends Thread {
    private final ElectroList<T> listToSearch;
    private final ElectroList<T> listResults;
    private final Predicate<? super T> condition;
    private final boolean isDescending;
    private Method getNodeMethod;

    public TSearcher(ElectroList<T> listToSearch, ElectroList<T> listResults, Predicate<? super T> condition) {
        this(listToSearch, listResults, condition, false);
    }

    public TSearcher(ElectroList<T> listToSearch, ElectroList<T> listResults, Predicate<? super T> condition, boolean isDescending) {
        Method[] listMethods;
        this.listToSearch = listToSearch;
        this.listResults = listResults;
        this.condition = condition;
        this.isDescending = isDescending;
        for (Method method : listMethods = ElectroList.class.getDeclaredMethods()) {
            if (!method.getName().equals("getNode")) continue;
            this.getNodeMethod = method;
            this.getNodeMethod.setAccessible(true);
            break;
        }
        this.start();
        this.setName("@" + this.hashCode() + "TSearcherFor" + listToSearch.getName());
        listMethods = null;
    }

    public boolean isFinished() {
        return this.getState() == Thread.State.TERMINATED;
    }

    public boolean hasResults() {
        return !this.listResults.isEmpty();
    }

    public T getFirstOcurrence() {
        return this.listResults.getFirst();
    }

    private Node<T> getNode(int index) {
        try {
            return (Node)this.getNodeMethod.invoke(this.listToSearch, index);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            Logger.getLogger(TSearcher.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void run() {
        int listSize = this.listToSearch.size();
        boolean firstIndex = false;
        int lastIndex = listSize - 1;
        int middle = listSize >> 1;
        if (this.isDescending) {
            Node<Object> node = this.getNode(lastIndex);
            for (int i = lastIndex; i > middle; --i) {
                if (this.condition.test(node.data)) {
                    this.listResults.add(node.data);
                }
                node = node.prev;
            }
        } else {
            Node<Object> node = this.getNode(0);
            for (int i = 0; i <= middle; ++i) {
                if (this.condition.test(node.data)) {
                    this.listResults.add(node.data);
                }
                node = node.next;
            }
        }
    }
}

