/*
 * Decompiled with CFR 0.152.
 */
package org.mpiztools.clinter.cmd;

public class Command {
    private final String order;
    private final String[] options;

    public Command(String order, String ... options) {
        this.order = order;
        this.options = options;
    }

    public Command(String strCmd) {
        if (strCmd.contains(" ")) {
            String[] split = strCmd.split(" ");
            this.order = split[0];
            this.options = new String[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                this.options[i - 1] = split[i];
            }
        } else {
            this.order = strCmd;
            this.options = null;
        }
    }

    public String getOrder() {
        return this.order;
    }

    public String[] getOptions() {
        return this.options;
    }

    public String getOptionAt(int index) {
        return this.options[index];
    }

    public String toString() {
        StringBuilder sbCmd = new StringBuilder();
        sbCmd.append(this.order);
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                sbCmd.append(' ').append(this.options[i]);
            }
        }
        return sbCmd.toString();
    }
}

