/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import com.mongodb.util.JSON;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;

public class MongoConfigUtil {
    private static final Log log = LogFactory.getLog(MongoConfigUtil.class);
    private static final Mongo.Holder _mongos = new Mongo.Holder();
    public static final String JOB_VERBOSE = "mongo.job.verbose";
    public static final String JOB_BACKGROUND = "mongo.job.background";
    public static final String JOB_MAPPER = "mongo.job.mapper";
    public static final String JOB_COMBINER = "mongo.job.combiner";
    public static final String JOB_PARTITIONER = "mongo.job.partitioner";
    public static final String JOB_REDUCER = "mongo.job.reducer";
    public static final String JOB_SORT_COMPARATOR = "mongo.job.sort_comparator";
    public static final String JOB_MAPPER_OUTPUT_KEY = "mongo.job.mapper.output.key";
    public static final String JOB_MAPPER_OUTPUT_VALUE = "mongo.job.mapper.output.value";
    public static final String JOB_INPUT_FORMAT = "mongo.job.input.format";
    public static final String JOB_OUTPUT_FORMAT = "mongo.job.output.format";
    public static final String JOB_OUTPUT_KEY = "mongo.job.output.key";
    public static final String JOB_OUTPUT_VALUE = "mongo.job.output.value";
    public static final String INPUT_URI = "mongo.input.uri";
    public static final String OUTPUT_URI = "mongo.output.uri";
    public static final String INPUT_KEY = "mongo.input.key";
    public static final String INPUT_NOTIMEOUT = "mongo.input.notimeout";
    public static final String INPUT_QUERY = "mongo.input.query";
    public static final String INPUT_FIELDS = "mongo.input.fields";
    public static final String INPUT_SORT = "mongo.input.sort";
    public static final String INPUT_LIMIT = "mongo.input.limit";
    public static final String INPUT_SKIP = "mongo.input.skip";
    public static final String INPUT_SPLIT_SIZE = "mongo.input.split_size";
    public static final int DEFAULT_SPLIT_SIZE = 8;
    public static final String INPUT_SPLIT_KEY_PATTERN = "mongo.input.split.split_key_pattern";
    public static final String CREATE_INPUT_SPLITS = "mongo.input.split.create_input_splits";
    public static final String SPLITS_USE_SHARDS = "mongo.input.split.read_from_shards";
    public static final String SPLITS_USE_CHUNKS = "mongo.input.split.read_shard_chunks";
    public static final String SPLITS_SLAVE_OK = "mongo.input.split.allow_read_from_secondaries";

    public static boolean isJobVerbose(Configuration configuration) {
        return configuration.getBoolean(JOB_VERBOSE, false);
    }

    public static void setJobVerbose(Configuration configuration, boolean bl) {
        configuration.setBoolean(JOB_VERBOSE, bl);
    }

    public static boolean isJobBackground(Configuration configuration) {
        return configuration.getBoolean(JOB_BACKGROUND, false);
    }

    public static void setJobBackground(Configuration configuration, boolean bl) {
        configuration.setBoolean(JOB_BACKGROUND, bl);
    }

    public static Class<? extends Mapper> getMapper(Configuration configuration) {
        return configuration.getClass(JOB_MAPPER, null, Mapper.class);
    }

    public static void setMapper(Configuration configuration, Class<? extends Mapper> clazz) {
        configuration.setClass(JOB_MAPPER, clazz, Mapper.class);
    }

    public static Class<?> getMapperOutputKey(Configuration configuration) {
        return configuration.getClass(JOB_MAPPER_OUTPUT_KEY, null);
    }

    public static void setMapperOutputKey(Configuration configuration, Class<?> clazz) {
        configuration.setClass(JOB_MAPPER_OUTPUT_KEY, clazz, Object.class);
    }

    public static Class<?> getMapperOutputValue(Configuration configuration) {
        return configuration.getClass(JOB_MAPPER_OUTPUT_VALUE, null);
    }

    public static void setMapperOutputValue(Configuration configuration, Class<?> clazz) {
        configuration.setClass(JOB_MAPPER_OUTPUT_VALUE, clazz, Object.class);
    }

    public static Class<? extends Reducer> getCombiner(Configuration configuration) {
        return configuration.getClass(JOB_COMBINER, null, Reducer.class);
    }

    public static void setCombiner(Configuration configuration, Class<? extends Reducer> clazz) {
        configuration.setClass(JOB_COMBINER, clazz, Reducer.class);
    }

    public static Class<? extends Reducer> getReducer(Configuration configuration) {
        return configuration.getClass(JOB_REDUCER, null, Reducer.class);
    }

    public static void setReducer(Configuration configuration, Class<? extends Reducer> clazz) {
        configuration.setClass(JOB_REDUCER, clazz, Reducer.class);
    }

    public static Class<? extends Partitioner> getPartitioner(Configuration configuration) {
        return configuration.getClass(JOB_PARTITIONER, null, Partitioner.class);
    }

    public static void setPartitioner(Configuration configuration, Class<? extends Partitioner> clazz) {
        configuration.setClass(JOB_PARTITIONER, clazz, Partitioner.class);
    }

    public static Class<? extends RawComparator> getSortComparator(Configuration configuration) {
        return configuration.getClass(JOB_SORT_COMPARATOR, null, RawComparator.class);
    }

    public static void setSortComparator(Configuration configuration, Class<? extends RawComparator> clazz) {
        configuration.setClass(JOB_SORT_COMPARATOR, clazz, RawComparator.class);
    }

    public static Class<? extends OutputFormat> getOutputFormat(Configuration configuration) {
        return configuration.getClass(JOB_OUTPUT_FORMAT, null, OutputFormat.class);
    }

    public static void setOutputFormat(Configuration configuration, Class<? extends OutputFormat> clazz) {
        configuration.setClass(JOB_OUTPUT_FORMAT, clazz, OutputFormat.class);
    }

    public static Class<?> getOutputKey(Configuration configuration) {
        return configuration.getClass(JOB_OUTPUT_KEY, null);
    }

    public static void setOutputKey(Configuration configuration, Class<?> clazz) {
        configuration.setClass(JOB_OUTPUT_KEY, clazz, Object.class);
    }

    public static Class<?> getOutputValue(Configuration configuration) {
        return configuration.getClass(JOB_OUTPUT_VALUE, null);
    }

    public static void setOutputValue(Configuration configuration, Class<?> clazz) {
        configuration.setClass(JOB_OUTPUT_VALUE, clazz, Object.class);
    }

    public static Class<? extends InputFormat> getInputFormat(Configuration configuration) {
        return configuration.getClass(JOB_INPUT_FORMAT, null, InputFormat.class);
    }

    public static void setInputFormat(Configuration configuration, Class<? extends InputFormat> clazz) {
        configuration.setClass(JOB_INPUT_FORMAT, clazz, InputFormat.class);
    }

    public static MongoURI getMongoURI(Configuration configuration, String string) {
        String string2 = configuration.get(string);
        if (string2 != null && !string2.trim().isEmpty()) {
            return new MongoURI(string2);
        }
        return null;
    }

    public static MongoURI getInputURI(Configuration configuration) {
        return MongoConfigUtil.getMongoURI(configuration, INPUT_URI);
    }

    public static DBCollection getCollection(MongoURI mongoURI) {
        try {
            Mongo mongo = _mongos.connect(mongoURI);
            DB dB = mongo.getDB(mongoURI.getDatabase());
            if (mongoURI.getUsername() != null && mongoURI.getPassword() != null && !dB.isAuthenticated()) {
                boolean bl = dB.authenticate(mongoURI.getUsername(), mongoURI.getPassword());
                if (bl) {
                    log.info((Object)"Sucessfully authenticated with collection.");
                } else {
                    throw new IllegalArgumentException("Unable to connect to collection.");
                }
            }
            return mongoURI.connectCollection(mongo);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to connect to collection." + exception.getMessage(), exception);
        }
    }

    public static DBCollection getOutputCollection(Configuration configuration) {
        try {
            MongoURI mongoURI = MongoConfigUtil.getOutputURI(configuration);
            return MongoConfigUtil.getCollection(mongoURI);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to connect to MongoDB Output Collection.", exception);
        }
    }

    public static DBCollection getInputCollection(Configuration configuration) {
        try {
            MongoURI mongoURI = MongoConfigUtil.getInputURI(configuration);
            return MongoConfigUtil.getCollection(mongoURI);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to connect to MongoDB Input Collection at '" + MongoConfigUtil.getInputURI(configuration) + "'", exception);
        }
    }

    public static void setMongoURI(Configuration configuration, String string, MongoURI mongoURI) {
        configuration.set(string, mongoURI.toString());
    }

    public static void setMongoURIString(Configuration configuration, String string, String string2) {
        try {
            MongoURI mongoURI = new MongoURI(string2);
            MongoConfigUtil.setMongoURI(configuration, string, mongoURI);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid Mongo URI '" + string2 + "' for Input URI", exception);
        }
    }

    public static void setInputURI(Configuration configuration, String string) {
        MongoConfigUtil.setMongoURIString(configuration, INPUT_URI, string);
    }

    public static void setInputURI(Configuration configuration, MongoURI mongoURI) {
        MongoConfigUtil.setMongoURI(configuration, INPUT_URI, mongoURI);
    }

    public static MongoURI getOutputURI(Configuration configuration) {
        return MongoConfigUtil.getMongoURI(configuration, OUTPUT_URI);
    }

    public static void setOutputURI(Configuration configuration, String string) {
        MongoConfigUtil.setMongoURIString(configuration, OUTPUT_URI, string);
    }

    public static void setOutputURI(Configuration configuration, MongoURI mongoURI) {
        MongoConfigUtil.setMongoURI(configuration, OUTPUT_URI, mongoURI);
    }

    public static void setJSON(Configuration configuration, String string, String string2) {
        try {
            Object object = JSON.parse(string2);
            MongoConfigUtil.setDBObject(configuration, string, (DBObject)object);
        }
        catch (Exception exception) {
            log.error((Object)"Cannot parse JSON...", (Throwable)exception);
            throw new IllegalArgumentException("Provided JSON String is not representable/parseable as a DBObject.", exception);
        }
    }

    public static DBObject getDBObject(Configuration configuration, String string) {
        try {
            String string2 = configuration.get(string);
            DBObject dBObject = (DBObject)JSON.parse(string2);
            if (dBObject == null) {
                return new BasicDBObject();
            }
            return dBObject;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Provided JSON String is not representable/parseable as a DBObject.", exception);
        }
    }

    public static void setDBObject(Configuration configuration, String string, DBObject dBObject) {
        configuration.set(string, JSON.serialize(dBObject));
    }

    public static void setQuery(Configuration configuration, String string) {
        MongoConfigUtil.setJSON(configuration, INPUT_QUERY, string);
    }

    public static void setQuery(Configuration configuration, DBObject dBObject) {
        MongoConfigUtil.setDBObject(configuration, INPUT_QUERY, dBObject);
    }

    public static DBObject getQuery(Configuration configuration) {
        return MongoConfigUtil.getDBObject(configuration, INPUT_QUERY);
    }

    public static void setFields(Configuration configuration, String string) {
        MongoConfigUtil.setJSON(configuration, INPUT_FIELDS, string);
    }

    public static void setFields(Configuration configuration, DBObject dBObject) {
        MongoConfigUtil.setDBObject(configuration, INPUT_FIELDS, dBObject);
    }

    public static DBObject getFields(Configuration configuration) {
        return MongoConfigUtil.getDBObject(configuration, INPUT_FIELDS);
    }

    public static void setSort(Configuration configuration, String string) {
        MongoConfigUtil.setJSON(configuration, INPUT_SORT, string);
    }

    public static void setSort(Configuration configuration, DBObject dBObject) {
        MongoConfigUtil.setDBObject(configuration, INPUT_SORT, dBObject);
    }

    public static DBObject getSort(Configuration configuration) {
        return MongoConfigUtil.getDBObject(configuration, INPUT_SORT);
    }

    public static int getLimit(Configuration configuration) {
        return configuration.getInt(INPUT_LIMIT, 0);
    }

    public static void setLimit(Configuration configuration, int n) {
        configuration.setInt(INPUT_LIMIT, n);
    }

    public static int getSkip(Configuration configuration) {
        return configuration.getInt(INPUT_SKIP, 0);
    }

    public static void setSkip(Configuration configuration, int n) {
        configuration.setInt(INPUT_SKIP, n);
    }

    public static int getSplitSize(Configuration configuration) {
        return configuration.getInt(INPUT_SPLIT_SIZE, 8);
    }

    public static void setSplitSize(Configuration configuration, int n) {
        configuration.setInt(INPUT_SPLIT_SIZE, n);
    }

    public static boolean canReadSplitsFromShards(Configuration configuration) {
        return configuration.getBoolean(SPLITS_USE_SHARDS, false);
    }

    public static void setReadSplitsFromShards(Configuration configuration, boolean bl) {
        configuration.setBoolean(SPLITS_USE_SHARDS, bl);
    }

    public static boolean isShardChunkedSplittingEnabled(Configuration configuration) {
        return configuration.getBoolean(SPLITS_USE_CHUNKS, true);
    }

    public static void setShardChunkSplittingEnabled(Configuration configuration, boolean bl) {
        configuration.setBoolean(SPLITS_USE_CHUNKS, bl);
    }

    public static boolean canReadSplitsFromSecondary(Configuration configuration) {
        return configuration.getBoolean(SPLITS_SLAVE_OK, false);
    }

    public static void setReadSplitsFromSecondary(Configuration configuration, boolean bl) {
        configuration.getBoolean(SPLITS_SLAVE_OK, bl);
    }

    public static boolean createInputSplits(Configuration configuration) {
        return configuration.getBoolean(CREATE_INPUT_SPLITS, true);
    }

    public static void setCreateInputSplits(Configuration configuration, boolean bl) {
        configuration.setBoolean(CREATE_INPUT_SPLITS, bl);
    }

    public static void setInputSplitKeyPattern(Configuration configuration, String string) {
        MongoConfigUtil.setJSON(configuration, INPUT_SPLIT_KEY_PATTERN, string);
    }

    public static void setInputSplitKey(Configuration configuration, DBObject dBObject) {
        MongoConfigUtil.setDBObject(configuration, INPUT_SPLIT_KEY_PATTERN, dBObject);
    }

    public static String getInputSplitKeyPattern(Configuration configuration) {
        return configuration.get(INPUT_SPLIT_KEY_PATTERN, "{ \"_id\": 1 }");
    }

    public static DBObject getInputSplitKey(Configuration configuration) {
        try {
            String string = MongoConfigUtil.getInputSplitKeyPattern(configuration);
            DBObject dBObject = (DBObject)JSON.parse(string);
            if (dBObject == null) {
                return new BasicDBObject("_id", (Object)1);
            }
            return dBObject;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Provided JSON String is not representable/parseable as a DBObject.", exception);
        }
    }

    public static void setInputKey(Configuration configuration, String string) {
        configuration.set(INPUT_KEY, string);
    }

    public static String getInputKey(Configuration configuration) {
        return configuration.get(INPUT_KEY, "_id");
    }

    public static void setNoTimeout(Configuration configuration, boolean bl) {
        configuration.setBoolean(INPUT_NOTIMEOUT, bl);
    }

    public static boolean isNoTimeout(Configuration configuration) {
        return configuration.getBoolean(INPUT_NOTIMEOUT, false);
    }
}

