/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.io.Bits;

public class BSONLoader
implements Iterable<BSONObject>,
Iterator<BSONObject> {
    private final BSONDecoder decoder = new BasicBSONDecoder();
    private final BSONCallback callback = new BasicBSONCallback();
    private volatile byte[] nextHdr;
    private volatile int nextLen;
    private AtomicBoolean hasMore = new AtomicBoolean(true);
    private final DataInputStream _input;
    private static final Log log = LogFactory.getLog(BSONLoader.class);

    public BSONLoader(InputStream inputStream) {
        this._input = new DataInputStream(inputStream);
    }

    @Override
    public Iterator<BSONObject> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkHeader();
        return this.hasMore.get();
    }

    private synchronized void checkHeader() {
        byte[] byArray = new byte[4];
        try {
            this._input.readFully(byArray);
            this.nextLen = Bits.readInt(byArray);
            this.nextHdr = byArray;
            this.hasMore.set(true);
        }
        catch (Exception exception) {
            log.debug((Object)("Failed to get next header: " + exception), (Throwable)exception);
            this.hasMore.set(false);
            try {
                this._input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public BSONObject next() {
        try {
            byte[] byArray = new byte[this.nextLen + 4];
            System.arraycopy(this.nextHdr, 0, byArray, 0, 4);
            this._input.readFully(byArray, 4, this.nextLen - 4);
            this.decoder.decode(byArray, this.callback);
            return (BSONObject)this.callback.get();
        }
        catch (IOException iOException) {
            log.info((Object)("No Length Header available." + iOException));
            this.hasMore.set(false);
            try {
                this._input.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw new NoSuchElementException("Iteration completed.");
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

