/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.input;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoURI;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.io.Bits;

public class MongoInputSplit
extends InputSplit
implements Writable {
    private MongoURI _mongoURI;
    private String _keyField;
    private DBObject _querySpec;
    private DBObject _fieldSpec;
    private DBObject _sortSpec;
    private boolean _notimeout;
    private int _limit = 0;
    private int _skip = 0;
    private long _length = -1L;
    private transient DBCursor _cursor;
    private transient BSONEncoder _bsonEncoder;
    private transient BSONDecoder _bsonDecoder;
    private static final Log log = LogFactory.getLog(MongoInputSplit.class);

    public MongoInputSplit(MongoURI mongoURI, String string, DBObject dBObject, DBObject dBObject2, DBObject dBObject3, int n, int n2, boolean bl) {
        log.debug((Object)("Creating a new MongoInputSplit for MongoURI '" + mongoURI + "', keyField: " + string + ", query: '" + dBObject + "', fieldSpec: '" + dBObject2 + "', sort: '" + dBObject3 + "', limit: " + n + ", skip: " + n2 + " noTimeout? " + bl + "."));
        this._mongoURI = mongoURI;
        this._keyField = string;
        this._querySpec = dBObject;
        this._fieldSpec = dBObject2;
        this._sortSpec = dBObject3;
        this._limit = n;
        this._skip = n2;
        this._notimeout = bl;
        this.getCursor();
        this.getBSONDecoder();
        this.getBSONEncoder();
    }

    public long getLength() {
        return Long.MAX_VALUE;
    }

    public String[] getLocations() {
        return this._mongoURI.getHosts().toArray(new String[this._mongoURI.getHosts().size()]);
    }

    public void write(DataOutput dataOutput) throws IOException {
        BSONEncoder bSONEncoder = this.getBSONEncoder();
        DBObject dBObject = BasicDBObjectBuilder.start().add("uri", this._mongoURI.toString()).add("key", this._keyField).add("query", this._querySpec).add("field", this._fieldSpec).add("sort", this._sortSpec).add("limit", this._limit).add("skip", this._skip).add("notimeout", this._notimeout).get();
        byte[] byArray = bSONEncoder.encode(dBObject);
        dataOutput.write(byArray);
    }

    public void readFields(DataInput dataInput) throws IOException {
        BSONObject bSONObject;
        BSONDecoder bSONDecoder = this.getBSONDecoder();
        BasicBSONCallback basicBSONCallback = new BasicBSONCallback();
        byte[] byArray = new byte[4];
        try {
            dataInput.readFully(byArray);
            int n = Bits.readInt(byArray);
            if (log.isDebugEnabled()) {
                log.debug((Object)("*** Expected DataLen: " + n));
            }
            byte[] byArray2 = new byte[n + 4];
            System.arraycopy(byArray, 0, byArray2, 0, 4);
            dataInput.readFully(byArray2, 4, n - 4);
            bSONDecoder.decode(byArray2, (BSONCallback)basicBSONCallback);
            bSONObject = (BSONObject)basicBSONCallback.get();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Decoded a BSON Object: " + bSONObject));
            }
        }
        catch (Exception exception) {
            log.info((Object)("No Length Header available." + exception));
            bSONObject = new BasicDBObject();
        }
        this._mongoURI = new MongoURI((String)bSONObject.get("uri"));
        this._keyField = (String)bSONObject.get("key");
        this._querySpec = new BasicDBObject(((BSONObject)bSONObject.get("query")).toMap());
        this._fieldSpec = new BasicDBObject(((BSONObject)bSONObject.get("field")).toMap());
        this._sortSpec = new BasicDBObject(((BSONObject)bSONObject.get("sort")).toMap());
        this._limit = (Integer)bSONObject.get("limit");
        this._skip = (Integer)bSONObject.get("skip");
        this._notimeout = (Boolean)bSONObject.get("notimeout");
        this.getCursor();
        log.info((Object)("Deserialized MongoInputSplit ... { length = " + this.getLength() + ", locations = " + Arrays.toString(this.getLocations()) + ", keyField = " + this._keyField + ", query = " + this._querySpec + ", fields = " + this._fieldSpec + ", sort = " + this._sortSpec + ", limit = " + this._limit + ", skip = " + this._skip + ", noTimeout = " + this._notimeout + "}"));
    }

    DBCursor getCursor() {
        if (this._cursor == null) {
            this._cursor = MongoConfigUtil.getCollection(this._mongoURI).find(this._querySpec, this._fieldSpec).sort(this._sortSpec);
            if (this._notimeout) {
                this._cursor.setOptions(16);
            }
            this._cursor.slaveOk();
        }
        return this._cursor;
    }

    BSONEncoder getBSONEncoder() {
        if (this._bsonEncoder == null) {
            this._bsonEncoder = new BasicBSONEncoder();
        }
        return this._bsonEncoder;
    }

    BSONDecoder getBSONDecoder() {
        if (this._bsonDecoder == null) {
            this._bsonDecoder = new BasicBSONDecoder();
        }
        return this._bsonDecoder;
    }

    public String toString() {
        return "MongoInputSplit{URI=" + this._mongoURI + ", keyField=" + this._keyField + ", query=" + this._querySpec + ", sort=" + this._sortSpec + ", fields=" + this._fieldSpec + '}';
    }

    public MongoInputSplit() {
    }

    public MongoURI getMongoURI() {
        return this._mongoURI;
    }

    public DBObject getQuerySpec() {
        return this._querySpec;
    }

    public DBObject getFieldSpec() {
        return this._fieldSpec;
    }

    public DBObject getSortSpec() {
        return this._sortSpec;
    }

    public int getLimit() {
        return this._limit;
    }

    public int getSkip() {
        return this._skip;
    }

    public String getKeyField() {
        return this._keyField;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        MongoInputSplit mongoInputSplit = (MongoInputSplit)((Object)object);
        if (this._limit != mongoInputSplit._limit) {
            return false;
        }
        if (this._notimeout != mongoInputSplit._notimeout) {
            return false;
        }
        if (this._skip != mongoInputSplit._skip) {
            return false;
        }
        if (this._fieldSpec != null ? !this._fieldSpec.equals(mongoInputSplit._fieldSpec) : mongoInputSplit._fieldSpec != null) {
            return false;
        }
        if (this._keyField != null ? !this._keyField.equals(mongoInputSplit._keyField) : mongoInputSplit._keyField != null) {
            return false;
        }
        if (this._mongoURI != null ? !this._mongoURI.toString().equals(mongoInputSplit._mongoURI.toString()) : mongoInputSplit._mongoURI != null) {
            return false;
        }
        if (this._querySpec != null ? !this._querySpec.equals(mongoInputSplit._querySpec) : mongoInputSplit._querySpec != null) {
            return false;
        }
        return !(this._sortSpec != null ? !this._sortSpec.equals(mongoInputSplit._sortSpec) : mongoInputSplit._sortSpec != null);
    }

    public int hashCode() {
        int n = this._mongoURI != null ? this._mongoURI.hashCode() : 0;
        n = 31 * n + (this._keyField != null ? this._keyField.hashCode() : 0);
        n = 31 * n + (this._querySpec != null ? this._querySpec.hashCode() : 0);
        n = 31 * n + (this._fieldSpec != null ? this._fieldSpec.hashCode() : 0);
        n = 31 * n + (this._sortSpec != null ? this._sortSpec.hashCode() : 0);
        n = 31 * n + (this._notimeout ? 1 : 0);
        n = 31 * n + this._limit;
        n = 31 * n + this._skip;
        return n;
    }
}

