/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop;

import com.mongodb.hadoop.io.BSONFile;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class BSONFileOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    private static final Log log = LogFactory.getLog(BSONFileOutputFormat.class);

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        Path path = this.getDefaultWorkFile(taskAttemptContext, "");
        FileSystem fileSystem = path.getFileSystem(configuration);
        final BSONFile.Writer writer = new BSONFile.Writer(fileSystem, configuration, path);
        return new RecordWriter<K, V>(){

            public void write(K k, V v) throws IOException {
                writer.append(k, v);
            }

            public void close(TaskAttemptContext taskAttemptContext) throws IOException {
                writer.close();
            }
        };
    }
}

