/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.gelfback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metastatic.gelfback.GELFCodec;
import org.metastatic.gelfback.WrappedLoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GELFTCPAppender
extends AppenderBase<ILoggingEvent> {
    private static final Pattern keyValuePattern = Pattern.compile("(?<key>[^=]+)=(?<value>[^,]+)(?:,|$)");
    private static final int QUEUE_SIZE = 1024;
    private final BlockingQueue<ILoggingEvent> events = new ArrayBlockingQueue<ILoggingEvent>(1024);
    private AtomicReference<SocketChannel> channel = new AtomicReference();
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private final Object connectedMonitor = new Object();
    private final Lock reconnectLock = new ReentrantLock();
    private final Condition reconnectCondition = this.reconnectLock.newCondition();
    private String host;
    private int port;
    private String localhost;
    private boolean includeCallerData;
    private boolean includeStackTrace;
    private AtomicReference<GELFCodec> codec = new AtomicReference();
    private int ttlSeconds = 60;
    private Map<String, String> staticFields;
    private long inflight = 0L;
    static GELFTCPAppender self;
    static final boolean debugging;

    public GELFTCPAppender() {
        if (debugging) {
            System.err.println("GELFTCPAppender created");
        }
        self = this;
    }

    public void start() {
        this.codec.set(new GELFCodec(this.localhost, this.includeCallerData, this.includeStackTrace));
        if (this.isStarted.compareAndSet(false, true)) {
            this.isRunning.set(true);
            Thread connectorThread = new Thread((Runnable)new Connector(), "GELF-TCP-Connector");
            connectorThread.setDaemon(true);
            connectorThread.start();
            Thread senderThread = new Thread((Runnable)new Sender(), "GELF-TCP-Sender");
            senderThread.setDaemon(true);
            senderThread.start();
        }
        super.start();
    }

    public void stop() {
        this.isRunning.set(false);
        super.stop();
    }

    protected void append(ILoggingEvent e) {
        GELFTCPAppender.debug("appending event %s", e);
        this.events.add(new WrappedLoggingEvent(e, this.includeCallerData));
        ++this.inflight;
    }

    public void setGelfPort(int port) {
        GELFTCPAppender.debug("setting port to %d", port);
        this.port = port;
        this.reconnectLock.lock();
        try {
            this.reconnectCondition.signal();
        }
        finally {
            this.reconnectLock.unlock();
        }
    }

    public void setGelfHost(String host) {
        GELFTCPAppender.debug("setting host to %s", host);
        this.host = host;
        this.reconnectLock.lock();
        try {
            this.reconnectCondition.signal();
        }
        finally {
            this.reconnectLock.unlock();
        }
    }

    public void setLocalHost(String host) {
        GELFTCPAppender.debug("setting local host: %s", host);
        this.localhost = host;
        if (this.isStarted.get()) {
            this.codec.set(new GELFCodec(this.localhost, this.includeCallerData, this.includeStackTrace));
        }
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        GELFTCPAppender.debug("setting include caller data: %s", includeCallerData);
        this.includeCallerData = includeCallerData;
        if (this.isStarted.get()) {
            this.codec.set(new GELFCodec(this.localhost, includeCallerData, this.includeStackTrace));
        }
    }

    public void setIncludeStackTrace(boolean includeStackTrace) {
        GELFTCPAppender.debug("setting include stack trace: %s", includeStackTrace);
        this.includeStackTrace = includeStackTrace;
        if (this.isStarted.get()) {
            this.codec.set(new GELFCodec(this.localhost, this.includeCallerData, includeStackTrace));
        }
    }

    public void setTtlSeconds(int ttlSeconds) {
        GELFTCPAppender.debug("setting ttlSeconds: %s", ttlSeconds);
        this.ttlSeconds = ttlSeconds;
    }

    public void setStaticFields(String staticFields) {
        GELFTCPAppender.debug("setting static fields: %s", staticFields);
        Matcher matcher = keyValuePattern.matcher(staticFields);
        LinkedHashMap<String, String> kvs = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            kvs.put(matcher.group("key"), matcher.group("value"));
        }
        this.staticFields = kvs;
        GELFTCPAppender.debug("static fields: %s", kvs);
    }

    private static void debug(String fmt, Object ... args) {
        if (debugging) {
            System.err.println(String.format(fmt, args));
        }
    }

    private static void debug(Throwable t, String fmt, Object ... args) {
        GELFTCPAppender.debug(fmt, args);
        if (debugging) {
            t.printStackTrace(System.err);
        }
    }

    public static boolean drained() {
        return GELFTCPAppender.self.events.isEmpty() && GELFTCPAppender.self.inflight == 0L;
    }

    static {
        String s = System.getenv("GELFBACK_DEBUG_TO_STDERR");
        debugging = s != null && s.equalsIgnoreCase("true");
    }

    private class Connector
    implements Runnable {
        private Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean complainedAboutUnknownHost = false;
            GELFTCPAppender.debug("GELF Connector thread starting", new Object[0]);
            while (GELFTCPAppender.this.isRunning.get()) {
                try {
                    SocketChannel channel;
                    GELFTCPAppender.debug("connector waiting for %s..", new Object[]{GELFTCPAppender.this.connectedMonitor});
                    Object object = GELFTCPAppender.this.connectedMonitor;
                    synchronized (object) {
                        GELFTCPAppender.debug("connector locked %s", new Object[]{GELFTCPAppender.this.connectedMonitor});
                        GELFTCPAppender.debug("resolving %s...", new Object[]{GELFTCPAppender.this.host});
                        InetAddress hostaddr = InetAddress.getByName(GELFTCPAppender.this.host);
                        GELFTCPAppender.debug("resolved to %s", new Object[]{hostaddr});
                        InetSocketAddress address = new InetSocketAddress(hostaddr, GELFTCPAppender.this.port);
                        GELFTCPAppender.debug("connecting to %s:%d...", new Object[]{GELFTCPAppender.this.host, GELFTCPAppender.this.port});
                        channel = SocketChannel.open();
                        channel.connect(address);
                        GELFTCPAppender.this.channel.set(channel);
                        GELFTCPAppender.this.connectedMonitor.notify();
                    }
                    GELFTCPAppender.debug("GELF TCP connected!", new Object[0]);
                    GELFTCPAppender.this.reconnectLock.lock();
                    try {
                        GELFTCPAppender.this.reconnectCondition.await(GELFTCPAppender.this.ttlSeconds, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                    }
                    finally {
                        GELFTCPAppender.this.reconnectLock.unlock();
                    }
                    GELFTCPAppender.debug("reconnect TTL expired, reconnecting...", new Object[0]);
                    Object e = GELFTCPAppender.this.connectedMonitor;
                    synchronized (e) {
                        GELFTCPAppender.this.channel.set(null);
                        channel.close();
                    }
                }
                catch (UnknownHostException uhe) {
                    if (!complainedAboutUnknownHost) {
                        GELFTCPAppender.this.addError("Unknown host: " + GELFTCPAppender.this.host);
                        complainedAboutUnknownHost = true;
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {}
                }
                catch (IOException e) {
                    GELFTCPAppender.debug(e, "exception caught connecting: %s", new Object[]{e});
                }
                catch (Exception e) {
                    GELFTCPAppender.debug(e, "exception in connector loop", new Object[0]);
                }
            }
        }
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            GELFTCPAppender.debug("GELF Sender thread starting", new Object[0]);
            while (GELFTCPAppender.this.isRunning.get()) {
                try {
                    ILoggingEvent event = (ILoggingEvent)GELFTCPAppender.this.events.take();
                    GELFTCPAppender.debug("received event: %s", new Object[]{event});
                    SocketChannel channel = null;
                    GELFTCPAppender.debug("sender waiting for %s..", new Object[]{GELFTCPAppender.this.connectedMonitor});
                    Object object = GELFTCPAppender.this.connectedMonitor;
                    synchronized (object) {
                        GELFTCPAppender.debug("sender locked %s", new Object[]{GELFTCPAppender.this.connectedMonitor});
                        while (GELFTCPAppender.this.isRunning.get() && (channel = (SocketChannel)GELFTCPAppender.this.channel.get()) == null) {
                            try {
                                GELFTCPAppender.debug("waiting for connection...", new Object[0]);
                                GELFTCPAppender.this.connectedMonitor.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        if (!GELFTCPAppender.this.isRunning.get() || channel == null) {
                            continue;
                        }
                        GELFCodec codec = (GELFCodec)GELFTCPAppender.this.codec.get();
                        if (codec == null) {
                            continue;
                        }
                        ByteBuffer[] formatted = codec.framed(event, GELFTCPAppender.this.staticFields != null ? GELFTCPAppender.this.staticFields : Collections.emptyMap());
                        channel.write(formatted);
                        GELFTCPAppender.debug("sent message!", new Object[0]);
                        GELFTCPAppender.this.inflight--;
                    }
                }
                catch (Exception e) {
                    GELFTCPAppender.debug(e, "exception on sender loop", new Object[0]);
                }
            }
        }
    }
}

