/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.gelfback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.metastatic.gelfback.ByteBuffersOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GELFCodec {
    public static final String GELF_VERSION = "1.1";
    private static final BigDecimal TIMESTAMP_DIVISOR = BigDecimal.valueOf(1000L);
    private final String host;
    private final boolean includeCallerData;
    private final boolean includeStackTrace;
    private static final int SYSLOG_ERROR = 3;
    private static final int SYSLOG_WARN = 4;
    private static final int SYSLOG_NOTICE = 5;
    private static final int SYSLOG_INFO = 6;
    private static final int SYSLOG_DEBUG = 7;

    public GELFCodec(String host, boolean includeCallerData, boolean includeStackTrace) {
        if (host == null) {
            throw new NullPointerException();
        }
        if (host.length() == 0) {
            throw new IllegalArgumentException("host must not be empty");
        }
        this.host = host;
        this.includeCallerData = includeCallerData;
        this.includeStackTrace = includeStackTrace;
    }

    public ByteBuffer[] framed(ILoggingEvent event, Map<String, String> staticFields) {
        ByteBuffersOutputStream out = new ByteBuffersOutputStream();
        this.encodeTo(event, staticFields, out);
        out.write(0);
        return out.toBuffers();
    }

    public ByteBuffer[] framed(ILoggingEvent event) {
        return this.framed(event, Collections.<String, String>emptyMap());
    }

    private void encodeTo(ILoggingEvent event, Map<String, String> staticFields, OutputStream out) {
        try {
            StackTraceElement[] stack;
            OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
            w.write(123);
            GELFCodec.writeJsonString(w, "version");
            w.write(58);
            GELFCodec.writeJsonString(w, GELF_VERSION);
            w.write(44);
            GELFCodec.writeJsonString(w, "level");
            w.write(58);
            GELFCodec.writeJsonInt(w, GELFCodec.mapLevelToSyslog(event.getLevel()));
            w.write(44);
            GELFCodec.writeJsonString(w, "host");
            w.write(58);
            GELFCodec.writeJsonString(w, this.host);
            w.write(44);
            String message = event.getFormattedMessage();
            if (message.indexOf(10) > 0) {
                GELFCodec.writeJsonString(w, "full_message");
                w.write(58);
                GELFCodec.writeJsonString(w, message);
                w.write(44);
                GELFCodec.writeJsonString(w, "short_message");
                w.write(58);
                GELFCodec.writeJsonString(w, message.substring(0, message.indexOf(10)));
                w.write(44);
            } else {
                GELFCodec.writeJsonString(w, "short_message");
                w.write(58);
                GELFCodec.writeJsonString(w, message);
                w.write(44);
            }
            if (event.getThrowableProxy() != null) {
                if (this.includeStackTrace) {
                    ThrowableProxyConverter converter = new ThrowableProxyConverter();
                    converter.setOptionList(Collections.singletonList("full"));
                    converter.start();
                    GELFCodec.writeJsonString(w, "_stack_trace");
                    w.write(58);
                    GELFCodec.writeJsonString(w, converter.convert(event));
                    w.write(44);
                }
                GELFCodec.writeJsonString(w, "_exception");
                w.write(58);
                GELFCodec.writeJsonString(w, event.getThrowableProxy().getClassName() + ": " + event.getThrowableProxy().getMessage());
                w.write(44);
            }
            GELFCodec.writeJsonString(w, "timestamp");
            w.write(58);
            GELFCodec.writeJsonString(w, BigDecimal.valueOf(event.getTimeStamp()).divide(TIMESTAMP_DIVISOR, 1).toPlainString());
            w.write(44);
            GELFCodec.writeJsonString(w, "_logger");
            w.write(58);
            GELFCodec.writeJsonString(w, event.getLoggerName());
            w.write(44);
            GELFCodec.writeJsonString(w, "_thread");
            w.write(58);
            GELFCodec.writeJsonString(w, event.getThreadName());
            if ((this.includeCallerData || event.hasCallerData()) && (stack = event.getCallerData()) != null && stack.length > 0) {
                w.write(44);
                GELFCodec.writeJsonString(w, "_file");
                w.write(58);
                GELFCodec.writeJsonString(w, stack[0].getFileName());
                w.write(44);
                GELFCodec.writeJsonString(w, "_line");
                w.write(58);
                GELFCodec.writeJsonInt(w, stack[0].getLineNumber());
                w.write(44);
                GELFCodec.writeJsonString(w, "_class");
                w.write(58);
                GELFCodec.writeJsonString(w, stack[0].getClassName());
                w.write(44);
                GELFCodec.writeJsonString(w, "_method");
                w.write(58);
                GELFCodec.writeJsonString(w, stack[0].getMethodName());
            }
            if (staticFields != null) {
                for (Map.Entry<String, String> e : staticFields.entrySet()) {
                    w.write(44);
                    GELFCodec.writeJsonString(w, "_" + e.getKey());
                    w.write(58);
                    GELFCodec.writeJsonString(w, e.getValue());
                }
            }
            w.write(125);
            w.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static int mapLevelToSyslog(Level l) {
        if (l.isGreaterOrEqual(Level.ERROR)) {
            return 3;
        }
        if (l.isGreaterOrEqual(Level.WARN)) {
            return 4;
        }
        if (l.isGreaterOrEqual(Level.INFO)) {
            return 6;
        }
        return 7;
    }

    private static void writeJsonInt(Writer w, Integer i) throws IOException {
        w.write(i.toString());
    }

    private static void writeJsonString(Writer w, String s) throws IOException {
        w.write(34);
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isISOControl(ch)) {
                w.write(String.format("\\u%04x", ch));
                continue;
            }
            if (ch == '\"' || ch == '\\') {
                w.write(92);
                w.write(ch);
                continue;
            }
            w.write(ch);
        }
        w.write(34);
    }
}

