/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.gelfback;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class ByteBuffersOutputStream
extends OutputStream {
    private final LinkedList<ByteBuffer> buffers;
    private final int slabSize;

    public ByteBuffersOutputStream(int slabSize, int initialCapacity) {
        if (slabSize <= 0) {
            throw new IllegalArgumentException("slabSize must be positive");
        }
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("initialCapacity must be positive");
        }
        this.buffers = new LinkedList();
        for (int i = 0; i < initialCapacity; i += slabSize) {
            this.buffers.add(ByteBuffer.allocate(slabSize));
        }
        this.slabSize = slabSize;
    }

    public ByteBuffersOutputStream(int slabSize) {
        this(slabSize, slabSize);
    }

    public ByteBuffersOutputStream() {
        this(4096);
    }

    public ByteBuffer[] toBuffers() {
        ByteBuffer[] ret = this.buffers.toArray(new ByteBuffer[this.buffers.size()]);
        for (int i = 0; i < ret.length; ++i) {
            ByteBuffer b = ret[i];
            ret[i] = ((ByteBuffer)b.flip()).slice().asReadOnlyBuffer();
        }
        return ret;
    }

    private void extend() {
        this.buffers.add(ByteBuffer.allocate(this.slabSize));
    }

    public void write(int b) {
        this.write(new byte[]{(byte)b});
    }

    public void write(byte[] b, int offset, int length) {
        int n = 0;
        while (n < length) {
            int w = Math.min(length - n, this.buffers.getLast().remaining());
            if (w == 0) {
                this.extend();
                continue;
            }
            this.buffers.getLast().put(b, offset + n, w);
            n += w;
        }
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }
}

