/*
 * Decompiled with CFR 0.152.
 */
package com.barbarysoftware.watchservice;

import com.barbarysoftware.watchservice.AbstractWatchService;
import com.barbarysoftware.watchservice.MacOSXWatchKey;
import com.barbarysoftware.watchservice.WatchableFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class MacOSXPollingWatchService
extends AbstractWatchService {
    private static final int INITIAL_DELAY = 10;
    private static final int DELAY = 10;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "WatchService Thread");
        }
    });

    MacOSXPollingWatchService() {
    }

    @Override
    WatchKey register(WatchableFile watchableFile, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifers) throws IOException {
        File file = watchableFile.getFile();
        Map<File, Long> lastModifiedMap = this.createLastModifiedMap(file);
        MacOSXWatchKey watchKey = new MacOSXWatchKey(this, events);
        final FileTreeScanner scanner = new FileTreeScanner(watchKey, lastModifiedMap, file);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                scanner.scan();
            }
        };
        this.executor.scheduleWithFixedDelay(r, 10L, 10L, TimeUnit.SECONDS);
        return watchKey;
    }

    private Map<File, Long> createLastModifiedMap(File file) {
        ConcurrentHashMap<File, Long> lastModifiedMap = new ConcurrentHashMap<File, Long>();
        for (File child : MacOSXPollingWatchService.recursiveListFiles(file)) {
            lastModifiedMap.put(child, child.lastModified());
        }
        return lastModifiedMap;
    }

    private static Set<File> recursiveListFiles(File file) {
        HashSet<File> files = new HashSet<File>();
        files.add(file);
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                files.addAll(MacOSXPollingWatchService.recursiveListFiles(child));
            }
        }
        return files;
    }

    @Override
    void implClose() {
        this.executor.shutdown();
    }

    private static class FileTreeScanner {
        private final MacOSXWatchKey watchKey;
        private final Map<File, Long> lastModifiedMap;
        private final File folder;

        private FileTreeScanner(MacOSXWatchKey watchKey, Map<File, Long> lastModifiedMap, File folder) {
            this.watchKey = watchKey;
            this.lastModifiedMap = lastModifiedMap;
            this.folder = folder;
        }

        public void scan() {
            this.scanFolderForChanges(this.folder);
        }

        private void scanFolderForChanges(File folder) {
            Set filesOnDisk = MacOSXPollingWatchService.recursiveListFiles(folder);
            for (File file : this.findCreatedFiles(filesOnDisk)) {
                if (this.watchKey.isReportCreateEvents()) {
                    this.watchKey.signalEvent(StandardWatchEventKinds.ENTRY_CREATE, file);
                }
                this.lastModifiedMap.put(file, file.lastModified());
            }
            for (File file : this.findModifiedFiles(filesOnDisk)) {
                if (this.watchKey.isReportModifyEvents()) {
                    this.watchKey.signalEvent(StandardWatchEventKinds.ENTRY_MODIFY, file);
                }
                this.lastModifiedMap.put(file, file.lastModified());
            }
            for (File file : this.findDeletedFiles(filesOnDisk)) {
                if (this.watchKey.isReportDeleteEvents()) {
                    this.watchKey.signalEvent(StandardWatchEventKinds.ENTRY_DELETE, file);
                }
                this.lastModifiedMap.remove(file);
            }
        }

        private List<File> findModifiedFiles(Set<File> filesOnDisk) {
            ArrayList<File> modifiedFileList = new ArrayList<File>();
            for (File file : filesOnDisk) {
                Long lastModified = this.lastModifiedMap.get(file);
                if (lastModified == null || lastModified.longValue() == file.lastModified()) continue;
                modifiedFileList.add(file);
            }
            return modifiedFileList;
        }

        private List<File> findCreatedFiles(Set<File> filesOnDisk) {
            ArrayList<File> createdFileList = new ArrayList<File>();
            for (File file : filesOnDisk) {
                if (this.lastModifiedMap.containsKey(file)) continue;
                createdFileList.add(file);
            }
            return createdFileList;
        }

        private List<File> findDeletedFiles(Set<File> filesOnDisk) {
            ArrayList<File> deletedFileList = new ArrayList<File>();
            for (File file : this.lastModifiedMap.keySet()) {
                if (filesOnDisk.contains(file)) continue;
                deletedFileList.add(file);
            }
            return deletedFileList;
        }
    }
}

