/*
 * Decompiled with CFR 0.152.
 */
package com.barbarysoftware.watchservice;

import com.barbarysoftware.watchservice.MacOSXWatchService;
import com.barbarysoftware.watchservice.WatchableFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class Demo {
    public static void main(String[] args) throws IOException, InterruptedException {
        WatchService watcher = MacOSXWatchService.newWatchService();
        System.out.println(watcher);
        String home = System.getProperty("user.home");
        WatchableFile file2 = new WatchableFile(new File("/Users/jshaw/Projects/github/barbarywatchservice-read-only"));
        file2.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        Thread consumer = new Thread(Demo.createRunnable(watcher));
        consumer.start();
        System.out.println("Watching for changes for 1 minute...");
        Thread.sleep(6000000L);
        consumer.interrupt();
        watcher.close();
    }

    private static Runnable createRunnable(final WatchService watcher) {
        return new Runnable(){

            @Override
            public void run() {
                WatchKey key;
                boolean valid;
                do {
                    try {
                        key = watcher.take();
                    }
                    catch (InterruptedException x) {
                        return;
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        WatchEvent<?> ev = event;
                        System.out.println("detected file system event: " + ev.context() + " " + kind);
                    }
                } while (valid = key.reset());
            }
        };
    }
}

