(ns mathbox.primitives.draw.grid
  (:require ["mathbox-react" :as box]
            [reagent.core :as r]))

(def ^{:doc "*Draw a 2D line grid*

:axes `[1, 2]` (swizzle(2) axis) - Axis pair
:baseX `10` (number) - Power base for sub/super units
:baseY `10` (number) - Power base for sub/super units
:blending `\\\"normal\\\"` (blending) - Blending mode ('no, normal, add, subtract, multiply)
:classes `[]` (string array) - Custom classes, e.g. `[\\\"big\\\"]`
:closed `false` (bool) - Close line
:closedX `false` (bool) - Close X lines
:closedY `false` (bool) - Close Y lines
:color `\\\"rgb(128, 128, 128)\\\"` (color) - Color
:crossed `true` (bool) - UVWO map on matching axes
:crossedX `true` (bool) - UVWO map on matching axis
:crossedY `true` (bool) - UVWO map on matching axis
:depth `1` (number) - Depth scaling
:detailX `1` (number) - Geometric detail
:detailY `1` (number) - Geometric detail
:divideX `10` (number) - Number of divisions
:divideY `10` (number) - Number of divisions
:endX `true` (bool) - Include end
:endY `true` (bool) - Include end
:factorX `1` (positive number) - Scale factor
:factorY `1` (positive number) - Scale factor
:id `null` (nullable string) - Unique ID, e.g. `\\\"sampler\\\"`
:lineX `true` (bool) - Draw X lines
:lineY `true` (bool) - Draw Y lines
:modeX `\\\"linear\\\"` (scale) - Scale type
:modeY `\\\"linear\\\"` (scale) - Scale type
:niceX `true` (bool) - Snap to nice numbers
:niceY `true` (bool) - Snap to nice numbers
:opacity `1` (positive number) - Opacity
:origin `[0, 0, 0, 0]` (vec4) - 4D Origin
:proximity `null` (nullable number) - Proximity threshold, e.g. `10`
:rangeX `[-1, 1]` (vec2) - Range on axis
:rangeY `[-1, 1]` (vec2) - Range on axis
:startX `true` (bool) - Include start
:startY `true` (bool) - Include start
:stroke `\\\"solid\\\"` (stroke) - Line stroke (solid, dotted, dashed)
:unitX `1` (number) - Reference unit
:unitY `1` (number) - Reference unit
:visible `true` (bool) - Visibility for rendering
:width `1` (positive number) - Line width
:zBias `-2` (positive number) - Z-Bias (3D stacking)
:zIndex `0` (positive int) - Z-Index (2D stacking)
:zOrder `null` (nullable number) - Z-Order (drawing order), e.g. `2`
:zTest `true` (bool) - Test Z buffer
:zWrite `true` (bool) - Write Z buffer
:zeroX `true` (bool) - Include zero
:zeroY `true` (bool) - Include zero"}
  Grid
  (r/adapt-react-class box/Grid))
