(ns mathbox.primitives.draw.axis
  (:require ["mathbox-react" :as box]
            [reagent.core :as r]))

(def ^{:doc "*Draw an axis*

:axis `1` (axis) - Axis
:blending `\\\"normal\\\"` (blending) - Blending mode ('no, normal, add, subtract, multiply)
:classes `[]` (string array) - Custom classes, e.g. `[\\\"big\\\"]`
:closed `false` (bool) - Close line
:color `\\\"rgb(128, 128, 128)\\\"` (color) - Color
:crossed `true` (bool) - UVWO map on matching axis
:depth `1` (number) - Depth scaling
:detail `1` (number) - Geometric detail
:end `true` (bool) - Draw end arrow
:id `null` (nullable string) - Unique ID, e.g. `\\\"sampler\\\"`
:opacity `1` (positive number) - Opacity
:origin `[0, 0, 0, 0]` (vec4) - 4D Origin
:proximity `null` (nullable number) - Proximity threshold, e.g. `10`
:range `[-1, 1]` (vec2) - Range on axis
:size `3` (number) - Arrow size
:start `true` (bool) - Draw start arrow
:stroke `\\\"solid\\\"` (stroke) - Line stroke (solid, dotted, dashed)
:visible `true` (bool) - Visibility for rendering
:width `2` (positive number) - Line width
:zBias `-1` (positive number) - Z-Bias (3D stacking)
:zIndex `0` (positive int) - Z-Index (2D stacking)
:zOrder `null` (nullable number) - Z-Order (drawing order), e.g. `2`
:zTest `true` (bool) - Test Z buffer
:zWrite `true` (bool) - Write Z buffer"}
  Axis
  (r/adapt-react-class box/Axis))
