(ns lotuc.sci-rt.temporal.csk
  (:require
   [clojure.walk :as walk]
   [lotuc.camel-snake-kebab.core :as csk]
   [lotuc.camel-snake-kebab.extras :as cske]))

;;; compile time check
(assert (= :md5 (csk/->kebab-case-keyword "md5")))

(defn ^{:doc "@see `clojure.walk/walk`"}
  walkable?
  [form]
  (or
   (list? form)
   (instance? clojure.lang.IMapEntry form)
   (seq? form)
   (instance? clojure.lang.IRecord form)
   (coll? form)))

(defn ->walkable [v]
  (letfn [(->one [v]
            (cond
              (instance? clojure.lang.IRecord v) (into {} v)
              (walkable? v) v
              (instance? java.util.List v) (->all (into [] v))
              (instance? java.util.Map v) (->all (into {} v))
              (instance? java.util.Iterator v) (map ->all (iterator-seq v))
              :else v))
          (->all [v]
            (walk/postwalk ->one v))]
    (->all v)))

(defn named->string [v]
  (if (or (symbol? v) (keyword? v)) (name v) v))

(defn ->keyword [v]
  (if (or (symbol? v) (keyword? v) (string? v)) (keyword v) v))

(defn transform-keys [t v]
  (cske/transform-keys t (->walkable v)))

(defn transform-keys->keyword [v]
  (cske/transform-keys keyword (->walkable v)))

(defn transform-named->string [v]
  (clojure.walk/postwalk named->string (->walkable v)))

(comment
  (transform-keys csk/->kebab-case-string {:md5 "hello"})
  (transform-named->string {:a 'a 'b [:b 'b "b"]}))
