/*
 * Decompiled with CFR 0.152.
 */
package lotuc.quartz.util.jndi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class SimpleNamingContext
implements Context {
    private final String root;
    private final Hashtable<String, Object> boundObjects;
    private final Hashtable<String, Object> environment = new Hashtable();

    public SimpleNamingContext(String string, Hashtable<String, Object> hashtable, Hashtable<String, Object> hashtable2) {
        this.root = string;
        this.boundObjects = hashtable;
        if (hashtable2 != null) {
            this.environment.putAll(hashtable2);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return new NameClassPairEnumeration(this, string);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return new BindingEnumeration(this, string);
    }

    @Override
    public Object lookup(String string) throws NameNotFoundException {
        String string2 = this.root + string;
        if (string2.isEmpty()) {
            return new SimpleNamingContext(this.root, this.boundObjects, this.environment);
        }
        Object object = this.boundObjects.get(string2);
        if (object == null) {
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            for (String string3 : this.boundObjects.keySet()) {
                if (!string3.startsWith(string2)) continue;
                return new SimpleNamingContext(string2, this.boundObjects, this.environment);
            }
            throw new NameNotFoundException("Name [" + this.root + string + "] not bound");
        }
        return object;
    }

    @Override
    public Object lookupLink(String string) throws NameNotFoundException {
        return this.lookup(string);
    }

    @Override
    public void bind(String string, Object object) {
        this.boundObjects.put(this.root + string, object);
    }

    @Override
    public void unbind(String string) {
        this.boundObjects.remove(this.root + string);
    }

    @Override
    public void rebind(String string, Object object) {
        this.bind(string, object);
    }

    @Override
    public void rename(String string, String string2) throws NameNotFoundException {
        Object object = this.lookup(string);
        this.unbind(string);
        this.bind(string2, object);
    }

    @Override
    public Context createSubcontext(String string) {
        String string2 = this.root + string;
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        SimpleNamingContext simpleNamingContext = new SimpleNamingContext(string2, this.boundObjects, this.environment);
        this.bind(string, (Object)simpleNamingContext);
        return simpleNamingContext;
    }

    @Override
    public void destroySubcontext(String string) {
        this.unbind(string);
    }

    @Override
    public String composeName(String string, String string2) {
        return string2 + string;
    }

    public Hashtable<String, Object> getEnvironment() {
        return this.environment;
    }

    @Override
    public Object addToEnvironment(String string, Object object) {
        return this.environment.put(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) {
        return this.environment.remove(string);
    }

    @Override
    public void close() {
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    private static final class NameClassPairEnumeration
    extends AbstractNamingEnumeration<NameClassPair> {
        private NameClassPairEnumeration(SimpleNamingContext simpleNamingContext, String string) throws NamingException {
            super(simpleNamingContext, string);
        }

        @Override
        protected NameClassPair createObject(String string, Object object) {
            return new NameClassPair(string, object.getClass().getName());
        }
    }

    private static final class BindingEnumeration
    extends AbstractNamingEnumeration<Binding> {
        private BindingEnumeration(SimpleNamingContext simpleNamingContext, String string) throws NamingException {
            super(simpleNamingContext, string);
        }

        @Override
        protected Binding createObject(String string, Object object) {
            return new Binding(string, object);
        }
    }

    private static abstract class AbstractNamingEnumeration<T>
    implements NamingEnumeration<T> {
        private final Iterator<T> iterator;

        private AbstractNamingEnumeration(SimpleNamingContext simpleNamingContext, String object) throws NamingException {
            if (!((String)object).isEmpty() && !((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            String string = simpleNamingContext.root + (String)object;
            HashMap<String, T> hashMap = new HashMap<String, T>();
            for (String string2 : simpleNamingContext.boundObjects.keySet()) {
                int n;
                int n2;
                String string3;
                if (!string2.startsWith(string) || hashMap.containsKey(string3 = (n2 = string2.indexOf(47, n = string.length())) != -1 ? string2.substring(n, n2) : string2.substring(n))) continue;
                try {
                    hashMap.put(string3, this.createObject(string3, simpleNamingContext.lookup((String)object + string3)));
                }
                catch (NameNotFoundException nameNotFoundException) {}
            }
            if (hashMap.size() == 0) {
                throw new NamingException("Invalid root: [" + simpleNamingContext.root + (String)object + "]");
            }
            this.iterator = hashMap.values().iterator();
        }

        protected abstract T createObject(String var1, Object var2);

        @Override
        public boolean hasMore() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }

        @Override
        public void close() {
        }
    }
}

