(ns ^:no-doc lotuc.camel-snake-kebab.internals.misc
  (:require [clojure.string :refer [join upper-case capitalize]]
            [lotuc.camel-snake-kebab.internals.string-separator :refer [split generic-separator]]))

(defn convert-case [first-fn rest-fn sep s & {:keys [separator]
                                              :or   {separator generic-separator}}]
  (if-let [[first & rest] (seq (split separator s))]
    (join sep (cons (first-fn first) (map rest-fn rest)))
    ""))

(def upper-case-http-headers
  #{"CSP" "ATT" "WAP" "IP" "HTTP" "CPU" "DNT" "SSL" "UA" "TE" "WWW" "XSS" "MD5"})

(defn capitalize-http-header [s]
  (or (upper-case-http-headers (upper-case s))
      (capitalize s)))
