/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.ATransientMap;
import clojure.lang.Box;
import clojure.lang.Cons;
import clojure.lang.IDeref;
import clojure.lang.IEditableCollection;
import clojure.lang.IFn;
import clojure.lang.IKVReduce;
import clojure.lang.IMapEntry;
import clojure.lang.IMapIterable;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.ITransientMap;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class PersistentHashMap
extends APersistentMap
implements IEditableCollection,
IObj,
IMapIterable,
IKVReduce {
    final int count;
    final INode root;
    final boolean hasNull;
    final Object nullValue;
    final IPersistentMap _meta;
    public static final PersistentHashMap EMPTY = new PersistentHashMap(0, null, false, null);
    private static final Object NOT_FOUND = new Object();
    static final Iterator EMPTY_ITER = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public static IPersistentMap create(Map other) {
        ITransientMap ret = EMPTY.asTransient();
        Iterator iterator = other.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e2 = o = iterator.next();
            ret = ret.assoc(e2.getKey(), e2.getValue());
        }
        return ret.persistent();
    }

    public static PersistentHashMap create(Object ... init) {
        ITransientMap ret = EMPTY.asTransient();
        for (int i = 0; i < init.length; i += 2) {
            ret = ret.assoc(init[i], init[i + 1]);
        }
        return (PersistentHashMap)ret.persistent();
    }

    public static PersistentHashMap createWithCheck(Object ... init) {
        ITransientMap ret = EMPTY.asTransient();
        for (int i = 0; i < init.length; i += 2) {
            if ((ret = ret.assoc(init[i], init[i + 1])).count() == i / 2 + 1) continue;
            throw new IllegalArgumentException("Duplicate key: " + init[i]);
        }
        return (PersistentHashMap)ret.persistent();
    }

    public static PersistentHashMap create(ISeq items) {
        ITransientMap ret = EMPTY.asTransient();
        while (items != null) {
            if (items.next() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", items.first()));
            }
            ret = ret.assoc(items.first(), RT.second(items));
            items = items.next().next();
        }
        return (PersistentHashMap)ret.persistent();
    }

    public static PersistentHashMap createWithCheck(ISeq items) {
        ITransientMap ret = EMPTY.asTransient();
        int i = 0;
        while (items != null) {
            if (items.next() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", items.first()));
            }
            if ((ret = ret.assoc(items.first(), RT.second(items))).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + items.first());
            }
            items = items.next().next();
            ++i;
        }
        return (PersistentHashMap)ret.persistent();
    }

    public static PersistentHashMap create(IPersistentMap meta, Object ... init) {
        return PersistentHashMap.create(init).withMeta(meta);
    }

    PersistentHashMap(int count2, INode root2, boolean hasNull, Object nullValue) {
        this.count = count2;
        this.root = root2;
        this.hasNull = hasNull;
        this.nullValue = nullValue;
        this._meta = null;
    }

    public PersistentHashMap(IPersistentMap meta, int count2, INode root2, boolean hasNull, Object nullValue) {
        this._meta = meta;
        this.count = count2;
        this.root = root2;
        this.hasNull = hasNull;
        this.nullValue = nullValue;
    }

    static int hash(Object k) {
        return Util.hasheq(k);
    }

    @Override
    public boolean containsKey(Object key2) {
        if (key2 == null) {
            return this.hasNull;
        }
        return this.root != null ? this.root.find(0, PersistentHashMap.hash(key2), key2, NOT_FOUND) != NOT_FOUND : false;
    }

    @Override
    public IMapEntry entryAt(Object key2) {
        if (key2 == null) {
            return this.hasNull ? MapEntry.create(null, this.nullValue) : null;
        }
        return this.root != null ? this.root.find(0, PersistentHashMap.hash(key2), key2) : null;
    }

    @Override
    public IPersistentMap assoc(Object key2, Object val2) {
        if (key2 == null) {
            if (this.hasNull && val2 == this.nullValue) {
                return this;
            }
            return new PersistentHashMap(this.meta(), this.hasNull ? this.count : this.count + 1, this.root, true, val2);
        }
        Box addedLeaf = new Box(null);
        INode newroot = (this.root == null ? BitmapIndexedNode.EMPTY : this.root).assoc(0, PersistentHashMap.hash(key2), key2, val2, addedLeaf);
        if (newroot == this.root) {
            return this;
        }
        return new PersistentHashMap(this.meta(), addedLeaf.val == null ? this.count : this.count + 1, newroot, this.hasNull, this.nullValue);
    }

    @Override
    public Object valAt(Object key2, Object notFound) {
        if (key2 == null) {
            return this.hasNull ? this.nullValue : notFound;
        }
        return this.root != null ? this.root.find(0, PersistentHashMap.hash(key2), key2, notFound) : notFound;
    }

    @Override
    public Object valAt(Object key2) {
        return this.valAt(key2, null);
    }

    @Override
    public IPersistentMap assocEx(Object key2, Object val2) {
        if (this.containsKey(key2)) {
            throw Util.runtimeException("Key already present");
        }
        return this.assoc(key2, val2);
    }

    @Override
    public IPersistentMap without(Object key2) {
        if (key2 == null) {
            return this.hasNull ? new PersistentHashMap(this.meta(), this.count - 1, this.root, false, null) : this;
        }
        if (this.root == null) {
            return this;
        }
        INode newroot = this.root.without(0, PersistentHashMap.hash(key2), key2);
        if (newroot == this.root) {
            return this;
        }
        return new PersistentHashMap(this.meta(), this.count - 1, newroot, this.hasNull, this.nullValue);
    }

    private Iterator iterator(final IFn f) {
        Iterator rootIter;
        Iterator iterator = rootIter = this.root == null ? EMPTY_ITER : this.root.iterator(f);
        if (this.hasNull) {
            return new Iterator(){
                private boolean seen = false;

                @Override
                public boolean hasNext() {
                    if (!this.seen) {
                        return true;
                    }
                    return rootIter.hasNext();
                }

                public Object next() {
                    if (!this.seen) {
                        this.seen = true;
                        return f.invoke(null, PersistentHashMap.this.nullValue);
                    }
                    return rootIter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return rootIter;
    }

    public Iterator iterator() {
        return this.iterator(APersistentMap.MAKE_ENTRY);
    }

    @Override
    public Iterator keyIterator() {
        return this.iterator(APersistentMap.MAKE_KEY);
    }

    @Override
    public Iterator valIterator() {
        return this.iterator(APersistentMap.MAKE_VAL);
    }

    @Override
    public Object kvreduce(IFn f, Object init) {
        Object object = init = this.hasNull ? f.invoke(init, null, this.nullValue) : init;
        if (RT.isReduced(init)) {
            return ((IDeref)init).deref();
        }
        if (this.root != null) {
            if (RT.isReduced(init = this.root.kvreduce(f, init))) {
                return ((IDeref)init).deref();
            }
            return init;
        }
        return init;
    }

    public Object fold(long n, final IFn combinef, final IFn reducef, IFn fjinvoke, final IFn fjtask, final IFn fjfork, final IFn fjjoin) {
        Callable top = new Callable(){

            public Object call() throws Exception {
                Object ret = combinef.invoke();
                if (PersistentHashMap.this.root != null) {
                    ret = combinef.invoke(ret, PersistentHashMap.this.root.fold(combinef, reducef, fjtask, fjfork, fjjoin));
                }
                return PersistentHashMap.this.hasNull ? combinef.invoke(ret, reducef.invoke(combinef.invoke(), null, PersistentHashMap.this.nullValue)) : ret;
            }
        };
        return fjinvoke.invoke(top);
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public ISeq seq() {
        ISeq s = this.root != null ? this.root.nodeSeq() : null;
        return this.hasNull ? new Cons(MapEntry.create(null, this.nullValue), s) : s;
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    static int mask(int hash2, int shift) {
        return hash2 >>> shift & 0x1F;
    }

    @Override
    public PersistentHashMap withMeta(IPersistentMap meta) {
        if (this._meta == meta) {
            return this;
        }
        return new PersistentHashMap(meta, this.count, this.root, this.hasNull, this.nullValue);
    }

    @Override
    public TransientHashMap asTransient() {
        return new TransientHashMap(this);
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    private static INode[] cloneAndSet(INode[] array2, int i, INode a) {
        INode[] clone = (INode[])array2.clone();
        clone[i] = a;
        return clone;
    }

    private static Object[] cloneAndSet(Object[] array2, int i, Object a) {
        Object[] clone = (Object[])array2.clone();
        clone[i] = a;
        return clone;
    }

    private static Object[] cloneAndSet(Object[] array2, int i, Object a, int j, Object b) {
        Object[] clone = (Object[])array2.clone();
        clone[i] = a;
        clone[j] = b;
        return clone;
    }

    private static Object[] removePair(Object[] array2, int i) {
        Object[] newArray = new Object[array2.length - 2];
        System.arraycopy(array2, 0, newArray, 0, 2 * i);
        System.arraycopy(array2, 2 * (i + 1), newArray, 2 * i, newArray.length - 2 * i);
        return newArray;
    }

    private static INode createNode(int shift, Object key1, Object val1, int key2hash, Object key2, Object val2) {
        int key1hash = PersistentHashMap.hash(key1);
        if (key1hash == key2hash) {
            return new HashCollisionNode(null, key1hash, 2, key1, val1, key2, val2);
        }
        Box addedLeaf = new Box(null);
        AtomicReference<Thread> edit2 = new AtomicReference<Thread>();
        return BitmapIndexedNode.EMPTY.assoc(edit2, shift, key1hash, key1, val1, addedLeaf).assoc(edit2, shift, key2hash, key2, val2, addedLeaf);
    }

    private static INode createNode(AtomicReference<Thread> edit2, int shift, Object key1, Object val1, int key2hash, Object key2, Object val2) {
        int key1hash = PersistentHashMap.hash(key1);
        if (key1hash == key2hash) {
            return new HashCollisionNode(null, key1hash, 2, key1, val1, key2, val2);
        }
        Box addedLeaf = new Box(null);
        return BitmapIndexedNode.EMPTY.assoc(edit2, shift, key1hash, key1, val1, addedLeaf).assoc(edit2, shift, key2hash, key2, val2, addedLeaf);
    }

    private static int bitpos(int hash2, int shift) {
        return 1 << PersistentHashMap.mask(hash2, shift);
    }

    static final class NodeSeq
    extends ASeq {
        final Object[] array;
        final int i;
        final ISeq s;

        NodeSeq(Object[] array2, int i) {
            this(null, array2, i, null);
        }

        static ISeq create(Object[] array2) {
            return NodeSeq.create(array2, 0, null);
        }

        public static Object kvreduce(Object[] array2, IFn f, Object init) {
            for (int i = 0; i < array2.length; i += 2) {
                if (array2[i] != null) {
                    init = f.invoke(init, array2[i], array2[i + 1]);
                } else {
                    INode node2 = (INode)array2[i + 1];
                    if (node2 != null) {
                        init = node2.kvreduce(f, init);
                    }
                }
                if (!RT.isReduced(init)) continue;
                return init;
            }
            return init;
        }

        private static ISeq create(Object[] array2, int i, ISeq s) {
            if (s != null) {
                return new NodeSeq(null, array2, i, s);
            }
            for (int j = i; j < array2.length; j += 2) {
                ISeq nodeSeq;
                if (array2[j] != null) {
                    return new NodeSeq(null, array2, j, null);
                }
                INode node2 = (INode)array2[j + 1];
                if (node2 == null || (nodeSeq = node2.nodeSeq()) == null) continue;
                return new NodeSeq(null, array2, j + 2, nodeSeq);
            }
            return null;
        }

        NodeSeq(IPersistentMap meta, Object[] array2, int i, ISeq s) {
            super(meta);
            this.array = array2;
            this.i = i;
            this.s = s;
        }

        @Override
        public Obj withMeta(IPersistentMap meta) {
            if (this.meta() == meta) {
                return this;
            }
            return new NodeSeq(meta, this.array, this.i, this.s);
        }

        @Override
        public Object first() {
            if (this.s != null) {
                return this.s.first();
            }
            return MapEntry.create(this.array[this.i], this.array[this.i + 1]);
        }

        @Override
        public ISeq next() {
            if (this.s != null) {
                return NodeSeq.create(this.array, this.i, this.s.next());
            }
            return NodeSeq.create(this.array, this.i + 2, null);
        }
    }

    static final class NodeIter
    implements Iterator {
        private static final Object NULL = new Object();
        final Object[] array;
        final IFn f;
        private int i = 0;
        private Object nextEntry = NULL;
        private Iterator nextIter;

        NodeIter(Object[] array2, IFn f) {
            this.array = array2;
            this.f = f;
        }

        private boolean advance() {
            while (this.i < this.array.length) {
                Iterator iter;
                Object key2 = this.array[this.i];
                Object nodeOrVal = this.array[this.i + 1];
                this.i += 2;
                if (key2 != null) {
                    this.nextEntry = this.f.invoke(key2, nodeOrVal);
                    return true;
                }
                if (nodeOrVal == null || (iter = ((INode)nodeOrVal).iterator(this.f)) == null || !iter.hasNext()) continue;
                this.nextIter = iter;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != NULL || this.nextIter != null) {
                return true;
            }
            return this.advance();
        }

        public Object next() {
            Object ret = this.nextEntry;
            if (ret != NULL) {
                this.nextEntry = NULL;
                return ret;
            }
            if (this.nextIter != null) {
                ret = this.nextIter.next();
                if (!this.nextIter.hasNext()) {
                    this.nextIter = null;
                }
                return ret;
            }
            if (this.advance()) {
                return this.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class HashCollisionNode
    implements INode {
        final int hash;
        int count;
        Object[] array;
        final AtomicReference<Thread> edit;

        HashCollisionNode(AtomicReference<Thread> edit2, int hash2, int count2, Object ... array2) {
            this.edit = edit2;
            this.hash = hash2;
            this.count = count2;
            this.array = array2;
        }

        @Override
        public INode assoc(int shift, int hash2, Object key2, Object val2, Box addedLeaf) {
            if (hash2 == this.hash) {
                int idx = this.findIndex(key2);
                if (idx != -1) {
                    if (this.array[idx + 1] == val2) {
                        return this;
                    }
                    return new HashCollisionNode(null, hash2, this.count, PersistentHashMap.cloneAndSet(this.array, idx + 1, val2));
                }
                Object[] newArray = new Object[2 * (this.count + 1)];
                System.arraycopy(this.array, 0, newArray, 0, 2 * this.count);
                newArray[2 * this.count] = key2;
                newArray[2 * this.count + 1] = val2;
                addedLeaf.val = addedLeaf;
                return new HashCollisionNode(this.edit, hash2, this.count + 1, newArray);
            }
            return new BitmapIndexedNode(null, PersistentHashMap.bitpos(this.hash, shift), new Object[]{null, this}).assoc(shift, hash2, key2, val2, addedLeaf);
        }

        @Override
        public INode without(int shift, int hash2, Object key2) {
            int idx = this.findIndex(key2);
            if (idx == -1) {
                return this;
            }
            if (this.count == 1) {
                return null;
            }
            return new HashCollisionNode(null, hash2, this.count - 1, PersistentHashMap.removePair(this.array, idx / 2));
        }

        @Override
        public IMapEntry find(int shift, int hash2, Object key2) {
            int idx = this.findIndex(key2);
            if (idx < 0) {
                return null;
            }
            return MapEntry.create(this.array[idx], this.array[idx + 1]);
        }

        @Override
        public Object find(int shift, int hash2, Object key2, Object notFound) {
            int idx = this.findIndex(key2);
            if (idx < 0) {
                return notFound;
            }
            return this.array[idx + 1];
        }

        @Override
        public ISeq nodeSeq() {
            return NodeSeq.create(this.array);
        }

        @Override
        public Iterator iterator(IFn f) {
            return new NodeIter(this.array, f);
        }

        @Override
        public Object kvreduce(IFn f, Object init) {
            return NodeSeq.kvreduce(this.array, f, init);
        }

        @Override
        public Object fold(IFn combinef, IFn reducef, IFn fjtask, IFn fjfork, IFn fjjoin) {
            return NodeSeq.kvreduce(this.array, reducef, combinef.invoke());
        }

        public int findIndex(Object key2) {
            for (int i = 0; i < 2 * this.count; i += 2) {
                if (!Util.equiv(key2, this.array[i])) continue;
                return i;
            }
            return -1;
        }

        private HashCollisionNode ensureEditable(AtomicReference<Thread> edit2) {
            if (this.edit == edit2) {
                return this;
            }
            Object[] newArray = new Object[2 * (this.count + 1)];
            System.arraycopy(this.array, 0, newArray, 0, 2 * this.count);
            return new HashCollisionNode(edit2, this.hash, this.count, newArray);
        }

        private HashCollisionNode ensureEditable(AtomicReference<Thread> edit2, int count2, Object[] array2) {
            if (this.edit == edit2) {
                this.array = array2;
                this.count = count2;
                return this;
            }
            return new HashCollisionNode(edit2, this.hash, count2, array2);
        }

        private HashCollisionNode editAndSet(AtomicReference<Thread> edit2, int i, Object a) {
            HashCollisionNode editable = this.ensureEditable(edit2);
            editable.array[i] = a;
            return editable;
        }

        private HashCollisionNode editAndSet(AtomicReference<Thread> edit2, int i, Object a, int j, Object b) {
            HashCollisionNode editable = this.ensureEditable(edit2);
            editable.array[i] = a;
            editable.array[j] = b;
            return editable;
        }

        @Override
        public INode assoc(AtomicReference<Thread> edit2, int shift, int hash2, Object key2, Object val2, Box addedLeaf) {
            if (hash2 == this.hash) {
                int idx = this.findIndex(key2);
                if (idx != -1) {
                    if (this.array[idx + 1] == val2) {
                        return this;
                    }
                    return this.editAndSet(edit2, idx + 1, val2);
                }
                if (this.array.length > 2 * this.count) {
                    addedLeaf.val = addedLeaf;
                    HashCollisionNode editable = this.editAndSet(edit2, 2 * this.count, key2, 2 * this.count + 1, val2);
                    ++editable.count;
                    return editable;
                }
                Object[] newArray = new Object[this.array.length + 2];
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                newArray[this.array.length] = key2;
                newArray[this.array.length + 1] = val2;
                addedLeaf.val = addedLeaf;
                return this.ensureEditable(edit2, this.count + 1, newArray);
            }
            return new BitmapIndexedNode(edit2, PersistentHashMap.bitpos(this.hash, shift), new Object[]{null, this, null, null}).assoc(edit2, shift, hash2, key2, val2, addedLeaf);
        }

        @Override
        public INode without(AtomicReference<Thread> edit2, int shift, int hash2, Object key2, Box removedLeaf) {
            int idx = this.findIndex(key2);
            if (idx == -1) {
                return this;
            }
            removedLeaf.val = removedLeaf;
            if (this.count == 1) {
                return null;
            }
            HashCollisionNode editable = this.ensureEditable(edit2);
            editable.array[idx] = editable.array[2 * this.count - 2];
            editable.array[idx + 1] = editable.array[2 * this.count - 1];
            editable.array[2 * this.count - 1] = null;
            editable.array[2 * this.count - 2] = null;
            --editable.count;
            return editable;
        }
    }

    static final class BitmapIndexedNode
    implements INode {
        static final BitmapIndexedNode EMPTY = new BitmapIndexedNode(null, 0, new Object[0]);
        int bitmap;
        Object[] array;
        final AtomicReference<Thread> edit;

        final int index(int bit) {
            return Integer.bitCount(this.bitmap & bit - 1);
        }

        BitmapIndexedNode(AtomicReference<Thread> edit2, int bitmap, Object[] array2) {
            this.bitmap = bitmap;
            this.array = array2;
            this.edit = edit2;
        }

        @Override
        public INode assoc(int shift, int hash2, Object key2, Object val2, Box addedLeaf) {
            int bit = PersistentHashMap.bitpos(hash2, shift);
            int idx = this.index(bit);
            if ((this.bitmap & bit) != 0) {
                Object keyOrNull = this.array[2 * idx];
                Object valOrNode = this.array[2 * idx + 1];
                if (keyOrNull == null) {
                    INode n = ((INode)valOrNode).assoc(shift + 5, hash2, key2, val2, addedLeaf);
                    if (n == valOrNode) {
                        return this;
                    }
                    return new BitmapIndexedNode(null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx + 1, n));
                }
                if (Util.equiv(key2, keyOrNull)) {
                    if (val2 == valOrNode) {
                        return this;
                    }
                    return new BitmapIndexedNode(null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx + 1, val2));
                }
                addedLeaf.val = addedLeaf;
                return new BitmapIndexedNode(null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx, null, 2 * idx + 1, PersistentHashMap.createNode(shift + 5, keyOrNull, valOrNode, hash2, key2, val2)));
            }
            int n = Integer.bitCount(this.bitmap);
            if (n >= 16) {
                INode[] nodes2 = new INode[32];
                int jdx = PersistentHashMap.mask(hash2, shift);
                nodes2[jdx] = EMPTY.assoc(shift + 5, hash2, key2, val2, addedLeaf);
                int j = 0;
                for (int i = 0; i < 32; ++i) {
                    if ((this.bitmap >>> i & 1) == 0) continue;
                    nodes2[i] = this.array[j] == null ? (INode)this.array[j + 1] : EMPTY.assoc(shift + 5, PersistentHashMap.hash(this.array[j]), this.array[j], this.array[j + 1], addedLeaf);
                    j += 2;
                }
                return new ArrayNode(null, n + 1, nodes2);
            }
            Object[] newArray = new Object[2 * (n + 1)];
            System.arraycopy(this.array, 0, newArray, 0, 2 * idx);
            newArray[2 * idx] = key2;
            addedLeaf.val = addedLeaf;
            newArray[2 * idx + 1] = val2;
            System.arraycopy(this.array, 2 * idx, newArray, 2 * (idx + 1), 2 * (n - idx));
            return new BitmapIndexedNode(null, this.bitmap | bit, newArray);
        }

        @Override
        public INode without(int shift, int hash2, Object key2) {
            int bit = PersistentHashMap.bitpos(hash2, shift);
            if ((this.bitmap & bit) == 0) {
                return this;
            }
            int idx = this.index(bit);
            Object keyOrNull = this.array[2 * idx];
            Object valOrNode = this.array[2 * idx + 1];
            if (keyOrNull == null) {
                INode n = ((INode)valOrNode).without(shift + 5, hash2, key2);
                if (n == valOrNode) {
                    return this;
                }
                if (n != null) {
                    return new BitmapIndexedNode(null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx + 1, n));
                }
                if (this.bitmap == bit) {
                    return null;
                }
                return new BitmapIndexedNode(null, this.bitmap ^ bit, PersistentHashMap.removePair(this.array, idx));
            }
            if (Util.equiv(key2, keyOrNull)) {
                if (this.bitmap == bit) {
                    return null;
                }
                return new BitmapIndexedNode(null, this.bitmap ^ bit, PersistentHashMap.removePair(this.array, idx));
            }
            return this;
        }

        @Override
        public IMapEntry find(int shift, int hash2, Object key2) {
            int bit = PersistentHashMap.bitpos(hash2, shift);
            if ((this.bitmap & bit) == 0) {
                return null;
            }
            int idx = this.index(bit);
            Object keyOrNull = this.array[2 * idx];
            Object valOrNode = this.array[2 * idx + 1];
            if (keyOrNull == null) {
                return ((INode)valOrNode).find(shift + 5, hash2, key2);
            }
            if (Util.equiv(key2, keyOrNull)) {
                return MapEntry.create(keyOrNull, valOrNode);
            }
            return null;
        }

        @Override
        public Object find(int shift, int hash2, Object key2, Object notFound) {
            int bit = PersistentHashMap.bitpos(hash2, shift);
            if ((this.bitmap & bit) == 0) {
                return notFound;
            }
            int idx = this.index(bit);
            Object keyOrNull = this.array[2 * idx];
            Object valOrNode = this.array[2 * idx + 1];
            if (keyOrNull == null) {
                return ((INode)valOrNode).find(shift + 5, hash2, key2, notFound);
            }
            if (Util.equiv(key2, keyOrNull)) {
                return valOrNode;
            }
            return notFound;
        }

        @Override
        public ISeq nodeSeq() {
            return NodeSeq.create(this.array);
        }

        @Override
        public Iterator iterator(IFn f) {
            return new NodeIter(this.array, f);
        }

        @Override
        public Object kvreduce(IFn f, Object init) {
            return NodeSeq.kvreduce(this.array, f, init);
        }

        @Override
        public Object fold(IFn combinef, IFn reducef, IFn fjtask, IFn fjfork, IFn fjjoin) {
            return NodeSeq.kvreduce(this.array, reducef, combinef.invoke());
        }

        private BitmapIndexedNode ensureEditable(AtomicReference<Thread> edit2) {
            if (this.edit == edit2) {
                return this;
            }
            int n = Integer.bitCount(this.bitmap);
            Object[] newArray = new Object[n >= 0 ? 2 * (n + 1) : 4];
            System.arraycopy(this.array, 0, newArray, 0, 2 * n);
            return new BitmapIndexedNode(edit2, this.bitmap, newArray);
        }

        private BitmapIndexedNode editAndSet(AtomicReference<Thread> edit2, int i, Object a) {
            BitmapIndexedNode editable = this.ensureEditable(edit2);
            editable.array[i] = a;
            return editable;
        }

        private BitmapIndexedNode editAndSet(AtomicReference<Thread> edit2, int i, Object a, int j, Object b) {
            BitmapIndexedNode editable = this.ensureEditable(edit2);
            editable.array[i] = a;
            editable.array[j] = b;
            return editable;
        }

        private BitmapIndexedNode editAndRemovePair(AtomicReference<Thread> edit2, int bit, int i) {
            if (this.bitmap == bit) {
                return null;
            }
            BitmapIndexedNode editable = this.ensureEditable(edit2);
            editable.bitmap ^= bit;
            System.arraycopy(editable.array, 2 * (i + 1), editable.array, 2 * i, editable.array.length - 2 * (i + 1));
            editable.array[editable.array.length - 2] = null;
            editable.array[editable.array.length - 1] = null;
            return editable;
        }

        @Override
        public INode assoc(AtomicReference<Thread> edit2, int shift, int hash2, Object key2, Object val2, Box addedLeaf) {
            int bit = PersistentHashMap.bitpos(hash2, shift);
            int idx = this.index(bit);
            if ((this.bitmap & bit) != 0) {
                Object keyOrNull = this.array[2 * idx];
                Object valOrNode = this.array[2 * idx + 1];
                if (keyOrNull == null) {
                    INode n = ((INode)valOrNode).assoc(edit2, shift + 5, hash2, key2, val2, addedLeaf);
                    if (n == valOrNode) {
                        return this;
                    }
                    return this.editAndSet(edit2, 2 * idx + 1, n);
                }
                if (Util.equiv(key2, keyOrNull)) {
                    if (val2 == valOrNode) {
                        return this;
                    }
                    return this.editAndSet(edit2, 2 * idx + 1, val2);
                }
                addedLeaf.val = addedLeaf;
                return this.editAndSet(edit2, 2 * idx, null, 2 * idx + 1, PersistentHashMap.createNode(edit2, shift + 5, keyOrNull, valOrNode, hash2, key2, val2));
            }
            int n = Integer.bitCount(this.bitmap);
            if (n * 2 < this.array.length) {
                addedLeaf.val = addedLeaf;
                BitmapIndexedNode editable = this.ensureEditable(edit2);
                System.arraycopy(editable.array, 2 * idx, editable.array, 2 * (idx + 1), 2 * (n - idx));
                editable.array[2 * idx] = key2;
                editable.array[2 * idx + 1] = val2;
                editable.bitmap |= bit;
                return editable;
            }
            if (n >= 16) {
                INode[] nodes2 = new INode[32];
                int jdx = PersistentHashMap.mask(hash2, shift);
                nodes2[jdx] = EMPTY.assoc(edit2, shift + 5, hash2, key2, val2, addedLeaf);
                int j = 0;
                for (int i = 0; i < 32; ++i) {
                    if ((this.bitmap >>> i & 1) == 0) continue;
                    nodes2[i] = this.array[j] == null ? (INode)this.array[j + 1] : EMPTY.assoc(edit2, shift + 5, PersistentHashMap.hash(this.array[j]), this.array[j], this.array[j + 1], addedLeaf);
                    j += 2;
                }
                return new ArrayNode(edit2, n + 1, nodes2);
            }
            Object[] newArray = new Object[2 * (n + 4)];
            System.arraycopy(this.array, 0, newArray, 0, 2 * idx);
            newArray[2 * idx] = key2;
            addedLeaf.val = addedLeaf;
            newArray[2 * idx + 1] = val2;
            System.arraycopy(this.array, 2 * idx, newArray, 2 * (idx + 1), 2 * (n - idx));
            BitmapIndexedNode editable = this.ensureEditable(edit2);
            editable.array = newArray;
            editable.bitmap |= bit;
            return editable;
        }

        @Override
        public INode without(AtomicReference<Thread> edit2, int shift, int hash2, Object key2, Box removedLeaf) {
            int bit = PersistentHashMap.bitpos(hash2, shift);
            if ((this.bitmap & bit) == 0) {
                return this;
            }
            int idx = this.index(bit);
            Object keyOrNull = this.array[2 * idx];
            Object valOrNode = this.array[2 * idx + 1];
            if (keyOrNull == null) {
                INode n = ((INode)valOrNode).without(edit2, shift + 5, hash2, key2, removedLeaf);
                if (n == valOrNode) {
                    return this;
                }
                if (n != null) {
                    return this.editAndSet(edit2, 2 * idx + 1, n);
                }
                if (this.bitmap == bit) {
                    return null;
                }
                return this.editAndRemovePair(edit2, bit, idx);
            }
            if (Util.equiv(key2, keyOrNull)) {
                removedLeaf.val = removedLeaf;
                return this.editAndRemovePair(edit2, bit, idx);
            }
            return this;
        }
    }

    static final class ArrayNode
    implements INode {
        int count;
        final INode[] array;
        final AtomicReference<Thread> edit;

        ArrayNode(AtomicReference<Thread> edit2, int count2, INode[] array2) {
            this.array = array2;
            this.edit = edit2;
            this.count = count2;
        }

        @Override
        public INode assoc(int shift, int hash2, Object key2, Object val2, Box addedLeaf) {
            int idx = PersistentHashMap.mask(hash2, shift);
            INode node2 = this.array[idx];
            if (node2 == null) {
                return new ArrayNode(null, this.count + 1, PersistentHashMap.cloneAndSet(this.array, idx, BitmapIndexedNode.EMPTY.assoc(shift + 5, hash2, key2, val2, addedLeaf)));
            }
            INode n = node2.assoc(shift + 5, hash2, key2, val2, addedLeaf);
            if (n == node2) {
                return this;
            }
            return new ArrayNode(null, this.count, PersistentHashMap.cloneAndSet(this.array, idx, n));
        }

        @Override
        public INode without(int shift, int hash2, Object key2) {
            int idx = PersistentHashMap.mask(hash2, shift);
            INode node2 = this.array[idx];
            if (node2 == null) {
                return this;
            }
            INode n = node2.without(shift + 5, hash2, key2);
            if (n == node2) {
                return this;
            }
            if (n == null) {
                if (this.count <= 8) {
                    return this.pack(null, idx);
                }
                return new ArrayNode(null, this.count - 1, PersistentHashMap.cloneAndSet(this.array, idx, n));
            }
            return new ArrayNode(null, this.count, PersistentHashMap.cloneAndSet(this.array, idx, n));
        }

        @Override
        public IMapEntry find(int shift, int hash2, Object key2) {
            int idx = PersistentHashMap.mask(hash2, shift);
            INode node2 = this.array[idx];
            if (node2 == null) {
                return null;
            }
            return node2.find(shift + 5, hash2, key2);
        }

        @Override
        public Object find(int shift, int hash2, Object key2, Object notFound) {
            int idx = PersistentHashMap.mask(hash2, shift);
            INode node2 = this.array[idx];
            if (node2 == null) {
                return notFound;
            }
            return node2.find(shift + 5, hash2, key2, notFound);
        }

        @Override
        public ISeq nodeSeq() {
            return Seq.create(this.array);
        }

        @Override
        public Iterator iterator(IFn f) {
            return new Iter(this.array, f);
        }

        @Override
        public Object kvreduce(IFn f, Object init) {
            for (INode node2 : this.array) {
                if (node2 == null || !RT.isReduced(init = node2.kvreduce(f, init))) continue;
                return init;
            }
            return init;
        }

        @Override
        public Object fold(final IFn combinef, final IFn reducef, final IFn fjtask, final IFn fjfork, final IFn fjjoin) {
            ArrayList<Callable> tasks = new ArrayList<Callable>();
            for (final INode node2 : this.array) {
                if (node2 == null) continue;
                tasks.add(new Callable(){

                    public Object call() throws Exception {
                        return node2.fold(combinef, reducef, fjtask, fjfork, fjjoin);
                    }
                });
            }
            return ArrayNode.foldTasks(tasks, combinef, fjtask, fjfork, fjjoin);
        }

        public static Object foldTasks(List<Callable> tasks, final IFn combinef, final IFn fjtask, final IFn fjfork, final IFn fjjoin) {
            if (tasks.isEmpty()) {
                return combinef.invoke();
            }
            if (tasks.size() == 1) {
                Object ret = null;
                try {
                    return tasks.get(0).call();
                }
                catch (Exception e2) {
                    throw Util.sneakyThrow(e2);
                }
            }
            List<Callable> t1 = tasks.subList(0, tasks.size() / 2);
            final List<Callable> t2 = tasks.subList(tasks.size() / 2, tasks.size());
            Object forked = fjfork.invoke(fjtask.invoke(new Callable(){

                public Object call() throws Exception {
                    return ArrayNode.foldTasks(t2, combinef, fjtask, fjfork, fjjoin);
                }
            }));
            return combinef.invoke(ArrayNode.foldTasks(t1, combinef, fjtask, fjfork, fjjoin), fjjoin.invoke(forked));
        }

        private ArrayNode ensureEditable(AtomicReference<Thread> edit2) {
            if (this.edit == edit2) {
                return this;
            }
            return new ArrayNode(edit2, this.count, (INode[])this.array.clone());
        }

        private ArrayNode editAndSet(AtomicReference<Thread> edit2, int i, INode n) {
            ArrayNode editable = this.ensureEditable(edit2);
            editable.array[i] = n;
            return editable;
        }

        private INode pack(AtomicReference<Thread> edit2, int idx) {
            int i;
            Object[] newArray = new Object[2 * (this.count - 1)];
            int j = 1;
            int bitmap = 0;
            for (i = 0; i < idx; ++i) {
                if (this.array[i] == null) continue;
                newArray[j] = this.array[i];
                bitmap |= 1 << i;
                j += 2;
            }
            for (i = idx + 1; i < this.array.length; ++i) {
                if (this.array[i] == null) continue;
                newArray[j] = this.array[i];
                bitmap |= 1 << i;
                j += 2;
            }
            return new BitmapIndexedNode(edit2, bitmap, newArray);
        }

        @Override
        public INode assoc(AtomicReference<Thread> edit2, int shift, int hash2, Object key2, Object val2, Box addedLeaf) {
            int idx = PersistentHashMap.mask(hash2, shift);
            INode node2 = this.array[idx];
            if (node2 == null) {
                ArrayNode editable = this.editAndSet(edit2, idx, BitmapIndexedNode.EMPTY.assoc(edit2, shift + 5, hash2, key2, val2, addedLeaf));
                ++editable.count;
                return editable;
            }
            INode n = node2.assoc(edit2, shift + 5, hash2, key2, val2, addedLeaf);
            if (n == node2) {
                return this;
            }
            return this.editAndSet(edit2, idx, n);
        }

        @Override
        public INode without(AtomicReference<Thread> edit2, int shift, int hash2, Object key2, Box removedLeaf) {
            int idx = PersistentHashMap.mask(hash2, shift);
            INode node2 = this.array[idx];
            if (node2 == null) {
                return this;
            }
            INode n = node2.without(edit2, shift + 5, hash2, key2, removedLeaf);
            if (n == node2) {
                return this;
            }
            if (n == null) {
                if (this.count <= 8) {
                    return this.pack(edit2, idx);
                }
                ArrayNode editable = this.editAndSet(edit2, idx, n);
                --editable.count;
                return editable;
            }
            return this.editAndSet(edit2, idx, n);
        }

        static class Iter
        implements Iterator {
            private final INode[] array;
            private final IFn f;
            private int i = 0;
            private Iterator nestedIter;

            private Iter(INode[] array2, IFn f) {
                this.array = array2;
                this.f = f;
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    INode node2;
                    if (this.nestedIter != null) {
                        if (this.nestedIter.hasNext()) {
                            return true;
                        }
                        this.nestedIter = null;
                    }
                    if (this.i >= this.array.length) break;
                    if ((node2 = this.array[this.i++]) == null) continue;
                    this.nestedIter = node2.iterator(this.f);
                }
                return false;
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.nestedIter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        static class Seq
        extends ASeq {
            final INode[] nodes;
            final int i;
            final ISeq s;

            static ISeq create(INode[] nodes2) {
                return Seq.create(null, nodes2, 0, null);
            }

            private static ISeq create(IPersistentMap meta, INode[] nodes2, int i, ISeq s) {
                if (s != null) {
                    return new Seq(meta, nodes2, i, s);
                }
                for (int j = i; j < nodes2.length; ++j) {
                    ISeq ns2;
                    if (nodes2[j] == null || (ns2 = nodes2[j].nodeSeq()) == null) continue;
                    return new Seq(meta, nodes2, j + 1, ns2);
                }
                return null;
            }

            private Seq(IPersistentMap meta, INode[] nodes2, int i, ISeq s) {
                super(meta);
                this.nodes = nodes2;
                this.i = i;
                this.s = s;
            }

            @Override
            public Obj withMeta(IPersistentMap meta) {
                if (this.meta() == meta) {
                    return this;
                }
                return new Seq(meta, this.nodes, this.i, this.s);
            }

            @Override
            public Object first() {
                return this.s.first();
            }

            @Override
            public ISeq next() {
                return Seq.create(null, this.nodes, this.i, this.s.next());
            }
        }
    }

    static interface INode
    extends Serializable {
        public INode assoc(int var1, int var2, Object var3, Object var4, Box var5);

        public INode without(int var1, int var2, Object var3);

        public IMapEntry find(int var1, int var2, Object var3);

        public Object find(int var1, int var2, Object var3, Object var4);

        public ISeq nodeSeq();

        public INode assoc(AtomicReference<Thread> var1, int var2, int var3, Object var4, Object var5, Box var6);

        public INode without(AtomicReference<Thread> var1, int var2, int var3, Object var4, Box var5);

        public Object kvreduce(IFn var1, Object var2);

        public Object fold(IFn var1, IFn var2, IFn var3, IFn var4, IFn var5);

        public Iterator iterator(IFn var1);
    }

    static final class TransientHashMap
    extends ATransientMap {
        final AtomicReference<Thread> edit;
        volatile INode root;
        volatile int count;
        volatile boolean hasNull;
        volatile Object nullValue;
        final Box leafFlag = new Box(null);

        TransientHashMap(PersistentHashMap m) {
            this(new AtomicReference<Thread>(Thread.currentThread()), m.root, m.count, m.hasNull, m.nullValue);
        }

        TransientHashMap(AtomicReference<Thread> edit2, INode root2, int count2, boolean hasNull, Object nullValue) {
            this.edit = edit2;
            this.root = root2;
            this.count = count2;
            this.hasNull = hasNull;
            this.nullValue = nullValue;
        }

        @Override
        ITransientMap doAssoc(Object key2, Object val2) {
            if (key2 == null) {
                if (this.nullValue != val2) {
                    this.nullValue = val2;
                }
                if (!this.hasNull) {
                    ++this.count;
                    this.hasNull = true;
                }
                return this;
            }
            this.leafFlag.val = null;
            INode n = (this.root == null ? BitmapIndexedNode.EMPTY : this.root).assoc(this.edit, 0, PersistentHashMap.hash(key2), key2, val2, this.leafFlag);
            if (n != this.root) {
                this.root = n;
            }
            if (this.leafFlag.val != null) {
                ++this.count;
            }
            return this;
        }

        @Override
        ITransientMap doWithout(Object key2) {
            if (key2 == null) {
                if (!this.hasNull) {
                    return this;
                }
                this.hasNull = false;
                this.nullValue = null;
                --this.count;
                return this;
            }
            if (this.root == null) {
                return this;
            }
            this.leafFlag.val = null;
            INode n = this.root.without(this.edit, 0, PersistentHashMap.hash(key2), key2, this.leafFlag);
            if (n != this.root) {
                this.root = n;
            }
            if (this.leafFlag.val != null) {
                --this.count;
            }
            return this;
        }

        @Override
        IPersistentMap doPersistent() {
            this.edit.set(null);
            return new PersistentHashMap(this.count, this.root, this.hasNull, this.nullValue);
        }

        @Override
        Object doValAt(Object key2, Object notFound) {
            if (key2 == null) {
                if (this.hasNull) {
                    return this.nullValue;
                }
                return notFound;
            }
            if (this.root == null) {
                return notFound;
            }
            return this.root.find(0, PersistentHashMap.hash(key2), key2, notFound);
        }

        @Override
        int doCount() {
            return this.count;
        }

        @Override
        void ensureEditable() {
            if (this.edit.get() == null) {
                throw new IllegalAccessError("Transient used after persistent! call");
            }
        }
    }
}

