/*
 * Decompiled with CFR 0.152.
 */
package org.logolith.kzgo;

import java.math.BigInteger;

public class PolynomialInterpolator {
    private static BigInteger[] computeLagrangeBasisCoeffs(int j, int degree, BigInteger modulus) {
        int i;
        if (j < 0 || j > degree) {
            throw new IllegalArgumentException("j out of range");
        }
        BigInteger denominator = BigInteger.ONE;
        BigInteger bigJ = BigInteger.valueOf(j);
        for (int i2 = 0; i2 <= degree; ++i2) {
            if (i2 == j) continue;
            denominator = denominator.multiply(bigJ.subtract(BigInteger.valueOf(i2))).mod(modulus);
        }
        BigInteger invDenominator = denominator.modInverse(modulus);
        BigInteger[] numeratorCoeffs = new BigInteger[degree + 1];
        for (int i3 = 0; i3 <= degree; ++i3) {
            numeratorCoeffs[i3] = BigInteger.ZERO;
        }
        numeratorCoeffs[0] = BigInteger.ONE;
        int currentDegree = 0;
        for (i = 0; i <= degree; ++i) {
            if (i == j) continue;
            BigInteger bigI = BigInteger.valueOf(i);
            BigInteger prevCoeff = BigInteger.ZERO;
            for (int k = 0; k <= currentDegree; ++k) {
                BigInteger currentCoeff = numeratorCoeffs[k];
                numeratorCoeffs[k] = prevCoeff.subtract(currentCoeff.multiply(bigI)).mod(modulus);
                prevCoeff = currentCoeff;
            }
            numeratorCoeffs[currentDegree + 1] = prevCoeff;
            ++currentDegree;
        }
        for (i = 0; i <= degree; ++i) {
            numeratorCoeffs[i] = numeratorCoeffs[i].multiply(invDenominator).mod(modulus);
        }
        return numeratorCoeffs;
    }

    public static BigInteger[] interpolate(BigInteger[] evaluations, BigInteger modulus) {
        int n = evaluations.length;
        if (n == 0) {
            return new BigInteger[0];
        }
        int degree = n - 1;
        BigInteger[] resultCoeffs = new BigInteger[n];
        for (int i = 0; i < n; ++i) {
            resultCoeffs[i] = BigInteger.ZERO;
        }
        for (int j = 0; j < n; ++j) {
            if (evaluations[j].equals(BigInteger.ZERO)) continue;
            BigInteger[] ljCoeffs = PolynomialInterpolator.computeLagrangeBasisCoeffs(j, degree, modulus);
            for (int i = 0; i < n; ++i) {
                resultCoeffs[i] = resultCoeffs[i].add(evaluations[j].multiply(ljCoeffs[i])).mod(modulus);
            }
        }
        return resultCoeffs;
    }
}

