/*
 * Decompiled with CFR 0.152.
 */
package org.logolith.kzgo;

import com.sun.jna.Memory;
import com.sun.jna.ptr.IntByReference;
import java.util.Objects;
import org.logolith.kzgo.CBuffer;
import org.logolith.kzgo.KZGBridgeNative;

public class KZG {
    private static final int SUCCESS = 0;
    private static final int ERR_INVALID_INPUT = 1;
    private static final int ERR_COMMIT_FAILED = 2;
    private static final int ERR_OPEN_FAILED = 3;
    private static final int ERR_VERIFY_FAILED = 4;
    private static final int ERR_INTERNAL = 5;
    private static final int ERR_DESERIALIZE = 6;
    private static final int ERR_SRS_MISMATCH = 7;
    private static final int ERR_HASH_TO_FIELD_FAILED = 8;

    private static CBuffer.ByValue createInputBufferByValue(byte[] data) {
        if (data == null || data.length == 0) {
            return new CBuffer.ByValue();
        }
        Memory mem = new Memory((long)data.length);
        mem.write(0L, data, 0, data.length);
        CBuffer.ByValue buf = new CBuffer.ByValue();
        buf.data = mem;
        buf.len = data.length;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] commit(byte[] polyCoeffsBytes) throws KZGException {
        CBuffer.ByValue inputBuf = KZG.createInputBufferByValue(polyCoeffsBytes);
        CBuffer resultBuf = new CBuffer();
        IntByReference errorCodeRef = new IntByReference();
        int overallStatus = -1;
        try {
            byte[] resultBytes;
            overallStatus = KZGBridgeNative.INSTANCE.commit_to_poly(inputBuf, resultBuf, errorCodeRef);
            if (overallStatus != 0 || errorCodeRef.getValue() != 0) {
                int finalErrorCode;
                int n = finalErrorCode = overallStatus != 0 ? overallStatus : errorCodeRef.getValue();
                if (resultBuf.data != null) {
                    KZGBridgeNative.INSTANCE.free_buffer(resultBuf.asByValue());
                }
                throw new KZGException("commit_to_poly failed", finalErrorCode);
            }
            byte[] byArray = resultBytes = resultBuf.readBytes();
            return byArray;
        }
        finally {
            if (overallStatus == 0 && errorCodeRef.getValue() == 0 && resultBuf.data != null) {
                KZGBridgeNative.INSTANCE.free_buffer(resultBuf.asByValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] commitFromEvaluations(byte[] evaluationsBytes) throws KZGException {
        if (evaluationsBytes == null || evaluationsBytes.length == 0) {
            throw new KZGException("Evaluations cannot be null or empty", 1);
        }
        if (evaluationsBytes.length % 32 != 0) {
            throw new KZGException("Evaluations byte length must be multiple of 32", 1);
        }
        CBuffer.ByValue inputBuf = KZG.createInputBufferByValue(evaluationsBytes);
        CBuffer resultBuf = new CBuffer();
        IntByReference errorCodeRef = new IntByReference();
        int overallStatus = -1;
        try {
            byte[] resultBytes;
            overallStatus = KZGBridgeNative.INSTANCE.commit_from_evaluations(inputBuf, resultBuf, errorCodeRef);
            if (overallStatus != 0 || errorCodeRef.getValue() != 0) {
                int finalErrorCode;
                int n = finalErrorCode = overallStatus != 0 ? overallStatus : errorCodeRef.getValue();
                if (resultBuf.data != null) {
                    KZGBridgeNative.INSTANCE.free_buffer(resultBuf.asByValue());
                }
                throw new KZGException("commit_from_evaluations failed", finalErrorCode);
            }
            byte[] byArray = resultBytes = resultBuf.readBytes();
            return byArray;
        }
        finally {
            if (overallStatus == 0 && errorCodeRef.getValue() == 0 && resultBuf.data != null) {
                KZGBridgeNative.INSTANCE.free_buffer(resultBuf.asByValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenResultData open(byte[] polyCoeffsBytes, byte[] pointZBytes) throws KZGException {
        CBuffer.ByValue coeffsBuf = KZG.createInputBufferByValue(polyCoeffsBytes);
        CBuffer.ByValue pointBuf = KZG.createInputBufferByValue(pointZBytes);
        CBuffer proofHBuf = new CBuffer();
        CBuffer claimedValueBuf = new CBuffer();
        IntByReference errorCodeRef = new IntByReference();
        int overallStatus = -1;
        try {
            overallStatus = KZGBridgeNative.INSTANCE.open_poly(coeffsBuf, pointBuf, proofHBuf, claimedValueBuf, errorCodeRef);
            if (overallStatus != 0 || errorCodeRef.getValue() != 0) {
                int finalErrorCode;
                int n = finalErrorCode = overallStatus != 0 ? overallStatus : errorCodeRef.getValue();
                if (proofHBuf.data != null) {
                    KZGBridgeNative.INSTANCE.free_buffer(proofHBuf.asByValue());
                }
                if (claimedValueBuf.data != null) {
                    KZGBridgeNative.INSTANCE.free_buffer(claimedValueBuf.asByValue());
                }
                throw new KZGException("open_poly failed", finalErrorCode);
            }
            byte[] proofH = proofHBuf.readBytes();
            byte[] claimedValue = claimedValueBuf.readBytes();
            OpenResultData openResultData = new OpenResultData(proofH, claimedValue);
            return openResultData;
        }
        finally {
            if (overallStatus == 0 && errorCodeRef.getValue() == 0) {
                if (proofHBuf.data != null) {
                    KZGBridgeNative.INSTANCE.free_buffer(proofHBuf.asByValue());
                }
                if (claimedValueBuf.data != null) {
                    KZGBridgeNative.INSTANCE.free_buffer(claimedValueBuf.asByValue());
                }
            }
        }
    }

    public static boolean verify(byte[] commitmentBytes, byte[] proofHBytes, byte[] pointZBytes, byte[] claimedValueBytes) throws KZGException {
        CBuffer.ByValue claimedValueBuf;
        CBuffer.ByValue pointZBuf;
        CBuffer.ByValue proofHBuf;
        CBuffer.ByValue commitmentBuf = KZG.createInputBufferByValue(commitmentBytes);
        int result = KZGBridgeNative.INSTANCE.verify_poly_proof(commitmentBuf, proofHBuf = KZG.createInputBufferByValue(proofHBytes), pointZBuf = KZG.createInputBufferByValue(pointZBytes), claimedValueBuf = KZG.createInputBufferByValue(claimedValueBytes));
        if (result == 0) {
            return true;
        }
        if (result == 4) {
            return false;
        }
        throw new KZGException("verify_poly_proof failed", result);
    }

    public static boolean verifyWithVk(byte[] commitmentBytes, byte[] proofHBytes, byte[] pointZBytes, byte[] claimedValueBytes, byte[] vkBytes) throws KZGException {
        CBuffer.ByValue vkBuf;
        CBuffer.ByValue claimedValueBuf;
        CBuffer.ByValue pointZBuf;
        CBuffer.ByValue proofHBuf;
        CBuffer.ByValue commitmentBuf = KZG.createInputBufferByValue(commitmentBytes);
        int result = KZGBridgeNative.INSTANCE.verify_poly_proof_with_vk(commitmentBuf, proofHBuf = KZG.createInputBufferByValue(proofHBytes), pointZBuf = KZG.createInputBufferByValue(pointZBytes), claimedValueBuf = KZG.createInputBufferByValue(claimedValueBytes), vkBuf = KZG.createInputBufferByValue(vkBytes));
        if (result == 0) {
            return true;
        }
        if (result == 4) {
            return false;
        }
        throw new KZGException("verify_poly_proof_with_vk failed", result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] interpolate(byte[] valuesBytes) throws KZGException {
        byte[] byArray;
        if (valuesBytes == null || valuesBytes.length == 0) {
            throw new KZGException("Interpolation values cannot be null or empty", 1);
        }
        CBuffer.ByValue valuesBuf = KZG.createInputBufferByValue(valuesBytes);
        CBuffer resultCoeffsBuf = new CBuffer();
        IntByReference errorCodeRef = new IntByReference();
        int overallStatus = -1;
        try {
            byte[] resultBytes;
            overallStatus = KZGBridgeNative.INSTANCE.interpolate_poly(valuesBuf, resultCoeffsBuf, errorCodeRef);
            if (overallStatus != 0 || errorCodeRef.getValue() != 0) {
                int finalErrorCode;
                int n = finalErrorCode = overallStatus != 0 ? overallStatus : errorCodeRef.getValue();
                if (resultCoeffsBuf.data != null) {
                    CBuffer.ByValue bufferToFree = new CBuffer.ByValue();
                    bufferToFree.data = resultCoeffsBuf.data;
                    bufferToFree.len = resultCoeffsBuf.len;
                    KZGBridgeNative.INSTANCE.free_buffer(bufferToFree);
                }
                throw new KZGException("interpolate_poly failed", finalErrorCode);
            }
            byArray = resultBytes = resultCoeffsBuf.readBytes();
        }
        catch (Throwable throwable) {
            if (overallStatus == 0 && errorCodeRef.getValue() == 0 && resultCoeffsBuf != null && resultCoeffsBuf.data != null) {
                CBuffer.ByValue bufferToFree = new CBuffer.ByValue();
                bufferToFree.data = resultCoeffsBuf.data;
                bufferToFree.len = resultCoeffsBuf.len;
                KZGBridgeNative.INSTANCE.free_buffer(bufferToFree);
            }
            throw throwable;
        }
        if (overallStatus == 0 && errorCodeRef.getValue() == 0 && resultCoeffsBuf != null && resultCoeffsBuf.data != null) {
            CBuffer.ByValue bufferToFree = new CBuffer.ByValue();
            bufferToFree.data = resultCoeffsBuf.data;
            bufferToFree.len = resultCoeffsBuf.len;
            KZGBridgeNative.INSTANCE.free_buffer(bufferToFree);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hashToFr(byte[] msgBytes, byte[] domainBytes) throws KZGException {
        CBuffer.ByValue msgBuf = KZG.createInputBufferByValue(msgBytes);
        CBuffer.ByValue domainBuf = KZG.createInputBufferByValue(domainBytes);
        CBuffer resultBuf = new CBuffer();
        IntByReference errorCodeRef = new IntByReference();
        int overallStatus = -1;
        try {
            byte[] frBytes;
            overallStatus = KZGBridgeNative.INSTANCE.hash_to_fr(msgBuf, domainBuf, resultBuf, errorCodeRef);
            if (overallStatus != 0 || errorCodeRef.getValue() != 0) {
                int finalErrorCode;
                int n = finalErrorCode = overallStatus != 0 ? overallStatus : errorCodeRef.getValue();
                if (resultBuf.data != null) {
                    KZGBridgeNative.INSTANCE.free_buffer(resultBuf.asByValue());
                }
                throw new KZGException("hash_to_fr failed", finalErrorCode);
            }
            byte[] byArray = frBytes = resultBuf.readBytes();
            return byArray;
        }
        finally {
            if (overallStatus == 0 && errorCodeRef.getValue() == 0 && resultBuf.data != null) {
                KZGBridgeNative.INSTANCE.free_buffer(resultBuf.asByValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] commitNode(byte[] nodeDataBytes) throws KZGException {
        CBuffer.ByValue inputBuf = KZG.createInputBufferByValue(nodeDataBytes);
        CBuffer resultBuf = new CBuffer();
        IntByReference errorCodeRef = new IntByReference();
        int overallStatus = -1;
        try {
            byte[] resultBytes;
            overallStatus = KZGBridgeNative.INSTANCE.commit_node(inputBuf, resultBuf, errorCodeRef);
            if (overallStatus != 0 || errorCodeRef.getValue() != 0) {
                int finalErrorCode;
                int n = finalErrorCode = overallStatus != 0 ? overallStatus : errorCodeRef.getValue();
                if (resultBuf.data != null) {
                    KZGBridgeNative.INSTANCE.free_buffer(resultBuf.asByValue());
                }
                throw new KZGException("commit_node failed", finalErrorCode);
            }
            byte[] byArray = resultBytes = resultBuf.readBytes();
            return byArray;
        }
        finally {
            if (overallStatus == 0 && errorCodeRef.getValue() == 0 && resultBuf.data != null) {
                KZGBridgeNative.INSTANCE.free_buffer(resultBuf.asByValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] interpolateNode(byte[] nodeDataBytes) throws KZGException {
        Objects.requireNonNull(nodeDataBytes, "Node data bytes cannot be null");
        CBuffer.ByValue inputBuf = KZG.createInputBufferByValue(nodeDataBytes);
        CBuffer resultBuf = new CBuffer();
        IntByReference errorCodeRef = new IntByReference();
        int overallStatus = -1;
        try {
            byte[] coeffBytes;
            overallStatus = KZGBridgeNative.INSTANCE.interpolate_node(inputBuf, resultBuf, errorCodeRef);
            int errorCode = errorCodeRef.getValue();
            if (errorCode != 0) {
                throw new KZGException("interpolate_node failed", errorCode);
            }
            if (overallStatus != 0) {
                throw new KZGException("interpolate_node status check failed", overallStatus);
            }
            byte[] byArray = coeffBytes = resultBuf.readBytes();
            return byArray;
        }
        finally {
            if (overallStatus == 0 && errorCodeRef.getValue() == 0 && resultBuf.data != null) {
                KZGBridgeNative.INSTANCE.free_buffer(resultBuf.asByValue());
            }
        }
    }

    public static class KZGException
    extends Exception {
        public final int errorCode;

        public KZGException(String message, int errorCode) {
            super(message + " (code: " + errorCode + ")");
            this.errorCode = errorCode;
        }
    }

    public static class OpenResultData {
        public final byte[] proofH;
        public final byte[] claimedValue;

        public OpenResultData(byte[] proofH, byte[] claimedValue) {
            this.proofH = proofH;
            this.claimedValue = claimedValue;
        }
    }
}

