/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.pool.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.pool.PooledConnection;
import org.apache.tomcat.jdbc.pool.interceptor.StatementDecoratorInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementCache
extends StatementDecoratorInterceptor {
    protected static final String[] ALL_TYPES = new String[]{"prepareStatement", "prepareCall"};
    protected static final String[] CALLABLE_TYPE = new String[]{"prepareCall"};
    protected static final String[] PREPARED_TYPE = new String[]{"prepareStatement"};
    protected static final String[] NO_TYPE = new String[0];
    protected static final String STATEMENT_CACHE_ATTR = StatementCache.class.getName() + ".cache";
    private boolean cachePrepared = true;
    private boolean cacheCallable = false;
    private int maxCacheSize = 50;
    private PooledConnection pcon;
    private String[] types;
    private static ConcurrentHashMap<ConnectionPool, AtomicInteger> cacheSizeMap = new ConcurrentHashMap();
    private AtomicInteger cacheSize;

    public boolean isCachePrepared() {
        return this.cachePrepared;
    }

    public boolean isCacheCallable() {
        return this.cacheCallable;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public String[] getTypes() {
        return this.types;
    }

    public AtomicInteger getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setProperties(Map<String, PoolProperties.InterceptorProperty> properties) {
        super.setProperties(properties);
        PoolProperties.InterceptorProperty p = properties.get("prepared");
        if (p != null) {
            this.cachePrepared = p.getValueAsBoolean(this.cachePrepared);
        }
        if ((p = properties.get("callable")) != null) {
            this.cacheCallable = p.getValueAsBoolean(this.cacheCallable);
        }
        if ((p = properties.get("max")) != null) {
            this.maxCacheSize = p.getValueAsInt(this.maxCacheSize);
        }
        this.types = this.cachePrepared && this.cacheCallable ? ALL_TYPES : (this.cachePrepared ? PREPARED_TYPE : (this.cacheCallable ? CALLABLE_TYPE : NO_TYPE));
    }

    @Override
    public void poolStarted(ConnectionPool pool) {
        cacheSizeMap.putIfAbsent(pool, new AtomicInteger(0));
        super.poolStarted(pool);
    }

    @Override
    public void poolClosed(ConnectionPool pool) {
        cacheSizeMap.remove(pool);
        super.poolClosed(pool);
    }

    @Override
    public void reset(ConnectionPool parent, PooledConnection con) {
        super.reset(parent, con);
        if (parent == null) {
            this.cacheSize = null;
            this.pcon = null;
        } else {
            this.cacheSize = cacheSizeMap.get(parent);
            this.pcon = con;
            if (!this.pcon.getAttributes().containsKey(STATEMENT_CACHE_ATTR)) {
                ConcurrentHashMap cache2 = new ConcurrentHashMap();
                this.pcon.getAttributes().put(STATEMENT_CACHE_ATTR, cache2);
            }
        }
    }

    @Override
    public void disconnected(ConnectionPool parent, PooledConnection con, boolean finalizing) {
        ConcurrentHashMap statements = (ConcurrentHashMap)con.getAttributes().get(STATEMENT_CACHE_ATTR);
        if (statements != null) {
            for (Map.Entry p : statements.entrySet()) {
                this.closeStatement((CachedStatement)p.getValue());
            }
            statements.clear();
        }
        super.disconnected(parent, con, finalizing);
    }

    public void closeStatement(CachedStatement st) {
        if (st == null) {
            return;
        }
        st.forceClose();
    }

    @Override
    protected Object createDecorator(Object proxy, Method method, Object[] args, Object statement, Constructor<?> constructor, String sql) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        boolean process = this.process(this.types, method, false);
        if (process) {
            Object result = null;
            CachedStatement statementProxy = new CachedStatement((Statement)statement, sql);
            result = constructor.newInstance(statementProxy);
            statementProxy.setActualProxy(result);
            statementProxy.setConnection(proxy);
            statementProxy.setConstructor(constructor);
            return result;
        }
        return super.createDecorator(proxy, method, args, statement, constructor, sql);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean process = this.process(this.types, method, false);
        if (process && args.length > 0 && args[0] instanceof String) {
            CachedStatement statement = this.isCached((String)args[0]);
            if (statement != null) {
                this.removeStatement(statement);
                return statement.getActualProxy();
            }
            return super.invoke(proxy, method, args);
        }
        return super.invoke(proxy, method, args);
    }

    public CachedStatement isCached(String sql) {
        ConcurrentHashMap cache2 = (ConcurrentHashMap)this.pcon.getAttributes().get(STATEMENT_CACHE_ATTR);
        return (CachedStatement)cache2.get(sql);
    }

    public boolean cacheStatement(CachedStatement proxy) {
        ConcurrentHashMap cache2 = (ConcurrentHashMap)this.pcon.getAttributes().get(STATEMENT_CACHE_ATTR);
        if (proxy.getSql() == null) {
            return false;
        }
        if (cache2.containsKey(proxy.getSql())) {
            return false;
        }
        if (this.cacheSize.get() >= this.maxCacheSize) {
            return false;
        }
        if (this.cacheSize.incrementAndGet() > this.maxCacheSize) {
            this.cacheSize.decrementAndGet();
            return false;
        }
        cache2.put(proxy.getSql(), proxy);
        return true;
    }

    public boolean removeStatement(CachedStatement proxy) {
        ConcurrentHashMap cache2 = (ConcurrentHashMap)this.pcon.getAttributes().get(STATEMENT_CACHE_ATTR);
        if (cache2.remove(proxy.getSql()) != null) {
            this.cacheSize.decrementAndGet();
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CachedStatement
    extends StatementDecoratorInterceptor.StatementProxy<Statement> {
        boolean cached;

        public CachedStatement(Statement parent, String sql) {
            super((StatementDecoratorInterceptor)StatementCache.this, parent, sql);
            this.cached = false;
        }

        @Override
        public void closeInvoked() {
            boolean shouldClose = true;
            if (StatementCache.this.cacheSize.get() < StatementCache.this.maxCacheSize) {
                CachedStatement proxy = new CachedStatement((Statement)this.getDelegate(), this.getSql());
                try {
                    Object actualProxy = this.getConstructor().newInstance(proxy);
                    proxy.setActualProxy(actualProxy);
                    proxy.setConnection(this.getConnection());
                    proxy.setConstructor(this.getConstructor());
                    if (StatementCache.this.cacheStatement(proxy)) {
                        proxy.cached = true;
                        shouldClose = false;
                    }
                }
                catch (Exception x) {
                    StatementCache.this.removeStatement(proxy);
                }
            }
            this.closed = true;
            this.delegate = null;
            if (shouldClose) {
                super.closeInvoked();
            }
        }

        public void forceClose() {
            StatementCache.this.removeStatement(this);
            super.closeInvoked();
        }
    }
}

