/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.digester;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.NodeDescriptor;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.expression.IteratorExpression;
import org.apache.commons.betwixt.expression.MapEntryAdder;
import org.apache.commons.betwixt.expression.MethodExpression;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.betwixt.strategy.PluralStemmer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLIntrospectorHelper {
    protected static Log log = LogFactory.getLog(class$org$apache$commons$betwixt$digester$XMLIntrospectorHelper == null ? (class$org$apache$commons$betwixt$digester$XMLIntrospectorHelper = XMLIntrospectorHelper.class$("org.apache.commons.betwixt.digester.XMLIntrospectorHelper")) : class$org$apache$commons$betwixt$digester$XMLIntrospectorHelper);
    static /* synthetic */ Class class$org$apache$commons$betwixt$digester$XMLIntrospectorHelper;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public static Log getLog() {
        return log;
    }

    public static void setLog(Log aLog) {
        log = aLog;
    }

    public static NodeDescriptor createDescriptor(PropertyDescriptor propertyDescriptor, boolean useAttributesForPrimitives, XMLIntrospector introspector) throws IntrospectionException {
        String name = propertyDescriptor.getName();
        Class<?> type = propertyDescriptor.getPropertyType();
        if (log.isTraceEnabled()) {
            log.trace("Creating descriptor for property: name=" + name + " type=" + type);
        }
        NodeDescriptor nodeDescriptor = null;
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (readMethod == null) {
            if (log.isTraceEnabled()) {
                log.trace("No read method for property: name=" + name + " type=" + type);
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("Read method=" + readMethod.getName());
        }
        if ((class$java$lang$Class == null ? (class$java$lang$Class = XMLIntrospectorHelper.class$("java.lang.Class")) : class$java$lang$Class).equals(type) && "class".equals(name)) {
            log.trace("Ignoring class property");
            return null;
        }
        if (XMLIntrospectorHelper.isPrimitiveType(type)) {
            if (log.isTraceEnabled()) {
                log.trace("Primitive type: " + name);
            }
            if (useAttributesForPrimitives) {
                if (log.isTraceEnabled()) {
                    log.trace("Adding property as attribute: " + name);
                }
                nodeDescriptor = new AttributeDescriptor();
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("Adding property as element: " + name);
                }
                nodeDescriptor = new ElementDescriptor(true);
            }
            nodeDescriptor.setTextExpression(new MethodExpression(readMethod));
            if (writeMethod != null) {
                nodeDescriptor.setUpdater(new MethodUpdater(writeMethod));
            }
        } else if (XMLIntrospectorHelper.isLoopType(type)) {
            if (log.isTraceEnabled()) {
                log.trace("Loop type: " + name);
                log.trace("Wrap in collections? " + introspector.isWrapCollectionsInElement());
            }
            ElementDescriptor loopDescriptor = new ElementDescriptor();
            loopDescriptor.setContextExpression(new IteratorExpression(new MethodExpression(readMethod)));
            loopDescriptor.setWrapCollectionsInElement(introspector.isWrapCollectionsInElement());
            if ((class$java$util$Map == null ? (class$java$util$Map = XMLIntrospectorHelper.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type)) {
                loopDescriptor.setQualifiedName("entry");
                loopDescriptor.addElementDescriptor(new ElementDescriptor("key"));
                loopDescriptor.addElementDescriptor(new ElementDescriptor("value"));
            }
            ElementDescriptor elementDescriptor = new ElementDescriptor();
            elementDescriptor.setWrapCollectionsInElement(introspector.isWrapCollectionsInElement());
            elementDescriptor.setElementDescriptors(new ElementDescriptor[]{loopDescriptor});
            nodeDescriptor = elementDescriptor;
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Standard property: " + name);
            }
            ElementDescriptor elementDescriptor = new ElementDescriptor();
            elementDescriptor.setContextExpression(new MethodExpression(readMethod));
            if (writeMethod != null) {
                elementDescriptor.setUpdater(new MethodUpdater(writeMethod));
            }
            nodeDescriptor = elementDescriptor;
        }
        if (nodeDescriptor instanceof AttributeDescriptor) {
            nodeDescriptor.setLocalName(introspector.getAttributeNameMapper().mapTypeToElementName(name));
        } else {
            nodeDescriptor.setLocalName(introspector.getElementNameMapper().mapTypeToElementName(name));
        }
        nodeDescriptor.setPropertyName(propertyDescriptor.getName());
        nodeDescriptor.setPropertyType(type);
        if (log.isTraceEnabled()) {
            log.trace("Created descriptor:");
            log.trace(nodeDescriptor);
        }
        return nodeDescriptor;
    }

    public static void configureProperty(ElementDescriptor elementDescriptor, PropertyDescriptor propertyDescriptor) {
        XMLIntrospectorHelper.configureProperty(elementDescriptor, propertyDescriptor, null, null);
    }

    public static void configureProperty(ElementDescriptor elementDescriptor, PropertyDescriptor propertyDescriptor, String updateMethodName, Class beanClass) {
        Class<?> type = propertyDescriptor.getPropertyType();
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        elementDescriptor.setLocalName(propertyDescriptor.getName());
        elementDescriptor.setPropertyType(type);
        if (readMethod == null) {
            log.trace("No read method");
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Read method=" + readMethod.getName());
        }
        if ((class$java$lang$Class == null ? (class$java$lang$Class = XMLIntrospectorHelper.class$("java.lang.Class")) : class$java$lang$Class).equals(type) && "class".equals(propertyDescriptor.getName())) {
            log.trace("Ignoring class property");
            return;
        }
        if (XMLIntrospectorHelper.isPrimitiveType(type)) {
            elementDescriptor.setTextExpression(new MethodExpression(readMethod));
        } else if (XMLIntrospectorHelper.isLoopType(type)) {
            log.trace("Loop type ??");
            elementDescriptor.setContextExpression(new IteratorExpression(new MethodExpression(readMethod)));
            writeMethod = null;
        } else {
            log.trace("Standard property");
            elementDescriptor.setContextExpression(new MethodExpression(readMethod));
        }
        if (updateMethodName == null) {
            if (writeMethod != null) {
                elementDescriptor.setUpdater(new MethodUpdater(writeMethod));
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Finding custom method: ");
                log.trace("  on:" + beanClass);
                log.trace("  name:" + updateMethodName);
            }
            Method updateMethod = null;
            Method[] methods = beanClass.getMethods();
            int size = methods.length;
            for (int i = 0; i < size; ++i) {
                Method method = methods[i];
                if (!updateMethodName.equals(method.getName()) || methods[i].getParameterTypes().length != 1) continue;
                updateMethod = methods[i];
                if (!log.isTraceEnabled()) break;
                log.trace("Matched method:" + updateMethod);
                break;
            }
            if (updateMethod == null) {
                if (log.isInfoEnabled()) {
                    log.info("No method with name '" + updateMethodName + "' found for update");
                }
            } else {
                elementDescriptor.setUpdater(new MethodUpdater(updateMethod));
                elementDescriptor.setSingularPropertyType(updateMethod.getParameterTypes()[0]);
                if (log.isTraceEnabled()) {
                    log.trace("Set custom updater on " + elementDescriptor);
                }
            }
        }
    }

    public static void configureProperty(AttributeDescriptor attributeDescriptor, PropertyDescriptor propertyDescriptor) {
        Class<?> type = propertyDescriptor.getPropertyType();
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (readMethod == null) {
            log.trace("No read method");
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Read method=" + readMethod);
        }
        if ((class$java$lang$Class == null ? (class$java$lang$Class = XMLIntrospectorHelper.class$("java.lang.Class")) : class$java$lang$Class).equals(type) && "class".equals(propertyDescriptor.getName())) {
            log.trace("Ignoring class property");
            return;
        }
        if (XMLIntrospectorHelper.isLoopType(type)) {
            log.warn("Using loop type for an attribute. Type = " + type.getName() + " attribute: " + attributeDescriptor.getQualifiedName());
        }
        log.trace("Standard property");
        attributeDescriptor.setTextExpression(new MethodExpression(readMethod));
        if (writeMethod != null) {
            attributeDescriptor.setUpdater(new MethodUpdater(writeMethod));
        }
        attributeDescriptor.setLocalName(propertyDescriptor.getName());
        attributeDescriptor.setPropertyType(type);
    }

    public static void defaultAddMethods(XMLIntrospector introspector, ElementDescriptor rootDescriptor, Class beanClass) {
        if (beanClass != null) {
            Method[] methods = beanClass.getMethods();
            int size = methods.length;
            for (int i = 0; i < size; ++i) {
                String propertyName;
                Class<?>[] types;
                Method method = methods[i];
                String name = method.getName();
                if (!name.startsWith("add") || (types = method.getParameterTypes()) == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Searching for match for " + method);
                }
                if (types.length != 1 && types.length != 2 || (propertyName = Introspector.decapitalize(name.substring(3))).length() == 0) continue;
                if (log.isTraceEnabled()) {
                    log.trace(name + "->" + propertyName);
                }
                ElementDescriptor descriptor = XMLIntrospectorHelper.findGetCollectionDescriptor(introspector, rootDescriptor, propertyName);
                if (log.isDebugEnabled()) {
                    log.debug("!! " + propertyName + " -> " + descriptor);
                    log.debug("!! " + name + " -> " + (descriptor != null ? descriptor.getPropertyName() : ""));
                }
                if (descriptor != null) {
                    ElementDescriptor[] children;
                    boolean isMapDescriptor = (class$java$util$Map == null ? XMLIntrospectorHelper.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(descriptor.getPropertyType());
                    if (!isMapDescriptor && types.length == 1) {
                        ElementDescriptor child;
                        String localName;
                        log.trace("Matching collection or iteration");
                        descriptor.setUpdater(new MethodUpdater(method));
                        descriptor.setSingularPropertyType(types[0]);
                        if (log.isDebugEnabled()) {
                            log.debug("!! " + method);
                            log.debug("!! " + types[0]);
                        }
                        if ((children = descriptor.getElementDescriptors()) == null || children.length <= 0 || (localName = (child = children[0]).getLocalName()) != null && localName.length() != 0) continue;
                        child.setLocalName(introspector.getElementNameMapper().mapTypeToElementName(propertyName));
                        continue;
                    }
                    if (!isMapDescriptor || types.length != 2) continue;
                    log.trace("Matching map");
                    children = descriptor.getElementDescriptors();
                    if (children.length == 0) {
                        log.info("'entry' descriptor is missing for map. Updaters cannot be set");
                        continue;
                    }
                    ElementDescriptor[] grandchildren = children[0].getElementDescriptors();
                    MapEntryAdder adder = new MapEntryAdder(method);
                    int noOfGrandChildren = grandchildren.length;
                    for (int n = 0; n < noOfGrandChildren; ++n) {
                        if ("key".equals(grandchildren[n].getLocalName())) {
                            grandchildren[n].setUpdater(adder.getKeyUpdater());
                            grandchildren[n].setSingularPropertyType(types[0]);
                            if (!log.isTraceEnabled()) continue;
                            log.trace("Key descriptor: " + grandchildren[n]);
                            continue;
                        }
                        if (!"value".equals(grandchildren[n].getLocalName())) continue;
                        grandchildren[n].setUpdater(adder.getValueUpdater());
                        grandchildren[n].setSingularPropertyType(types[1]);
                        if (!log.isTraceEnabled()) continue;
                        log.trace("Value descriptor: " + grandchildren[n]);
                    }
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Could not find an ElementDescriptor with property name: " + propertyName + " to attach the add method: " + method);
            }
        }
    }

    public static boolean isLoopType(Class type) {
        if (type == null) {
            log.trace("isLoopType: type is null");
            return false;
        }
        return type.isArray() || (class$java$util$Map == null ? (class$java$util$Map = XMLIntrospectorHelper.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type) || (class$java$util$Collection == null ? (class$java$util$Collection = XMLIntrospectorHelper.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(type) || (class$java$util$Enumeration == null ? (class$java$util$Enumeration = XMLIntrospectorHelper.class$("java.util.Enumeration")) : class$java$util$Enumeration).isAssignableFrom(type) || (class$java$util$Iterator == null ? (class$java$util$Iterator = XMLIntrospectorHelper.class$("java.util.Iterator")) : class$java$util$Iterator).isAssignableFrom(type);
    }

    public static boolean isPrimitiveType(Class type) {
        if (type == null) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type.equals(class$java$lang$Object == null ? (class$java$lang$Object = XMLIntrospectorHelper.class$("java.lang.Object")) : class$java$lang$Object)) {
            return false;
        }
        return type.getName().startsWith("java.lang.") || (class$java$lang$Number == null ? (class$java$lang$Number = XMLIntrospectorHelper.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type) || (class$java$lang$String == null ? (class$java$lang$String = XMLIntrospectorHelper.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type) || (class$java$util$Date == null ? (class$java$util$Date = XMLIntrospectorHelper.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(type) || (class$java$sql$Date == null ? (class$java$sql$Date = XMLIntrospectorHelper.class$("java.sql.Date")) : class$java$sql$Date).isAssignableFrom(type) || (class$java$sql$Time == null ? (class$java$sql$Time = XMLIntrospectorHelper.class$("java.sql.Time")) : class$java$sql$Time).isAssignableFrom(type) || (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = XMLIntrospectorHelper.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).isAssignableFrom(type) || (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XMLIntrospectorHelper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(type) || (class$java$math$BigInteger == null ? (class$java$math$BigInteger = XMLIntrospectorHelper.class$("java.math.BigInteger")) : class$java$math$BigInteger).isAssignableFrom(type);
    }

    protected static ElementDescriptor findGetCollectionDescriptor(XMLIntrospector introspector, ElementDescriptor rootDescriptor, String propertyName) {
        HashMap<String, ElementDescriptor> map = new HashMap<String, ElementDescriptor>();
        if (log.isTraceEnabled()) {
            log.trace("findPluralDescriptor( " + propertyName + " ):root property name=" + rootDescriptor.getPropertyName());
        }
        if (rootDescriptor.getPropertyName() != null) {
            map.put(propertyName, rootDescriptor);
        }
        XMLIntrospectorHelper.makeElementDescriptorMap(rootDescriptor, map);
        PluralStemmer stemmer = introspector.getPluralStemmer();
        ElementDescriptor elementDescriptor = stemmer.findPluralDescriptor(propertyName, map);
        if (log.isTraceEnabled()) {
            log.trace("findPluralDescriptor( " + propertyName + " ):ElementDescriptor=" + elementDescriptor);
        }
        return elementDescriptor;
    }

    protected static void makeElementDescriptorMap(ElementDescriptor rootDescriptor, Map map) {
        ElementDescriptor[] children = rootDescriptor.getElementDescriptors();
        if (children != null) {
            int size = children.length;
            for (int i = 0; i < size; ++i) {
                ElementDescriptor child = children[i];
                String propertyName = child.getPropertyName();
                if (propertyName != null) {
                    map.put(propertyName, child);
                }
                XMLIntrospectorHelper.makeElementDescriptorMap(child, map);
            }
        }
    }

    protected static void swapDescriptor(ElementDescriptor rootDescriptor, ElementDescriptor oldValue, ElementDescriptor newValue) {
        ElementDescriptor[] children = rootDescriptor.getElementDescriptors();
        if (children != null) {
            int size = children.length;
            for (int i = 0; i < size; ++i) {
                ElementDescriptor child = children[i];
                if (child == oldValue) {
                    children[i] = newValue;
                    break;
                }
                XMLIntrospectorHelper.swapDescriptor(child, oldValue, newValue);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

