/*
 * Decompiled with CFR 0.152.
 */
package org.lambdaroyal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public final class ObjectBlobConverter {
    static final int BUFFER_SIZE = 1024;

    private ObjectBlobConverter() {
    }

    public static byte[] o2b(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(o);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static ObjectInputStream o2is(Object o) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(ObjectBlobConverter.o2b(o));
        return new ObjectInputStream(bis);
    }

    public static Object b2o(byte[] o) throws IOException, ClassNotFoundException {
        if (o == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(o);
        try (ObjectInputStream ois = new ObjectInputStream(bis);){
            Object object = ois.readObject();
            return object;
        }
    }

    public static Object b2o(Blob o) throws IOException, ClassNotFoundException, SQLException {
        if (o == null) {
            return null;
        }
        try (ObjectInputStream ois = new ObjectInputStream(o.getBinaryStream());){
            Object object = ois.readObject();
            return object;
        }
    }

    static {
        new ObjectBlobConverter();
    }
}

