/*
 * Decompiled with CFR 0.152.
 */
package org.lambdaroyal.util;

public final class ConsoleProgress {
    private volatile boolean finished = false;
    private volatile int currentProgress;
    private volatile String currentTask = "";
    private volatile String currentString = "";
    private volatile long start;
    private final char progressIndicator;

    public ConsoleProgress() {
        this.progressIndicator = (char)178;
    }

    public ConsoleProgress(char progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showProgress(String task, int progress) {
        if (this.finished) return;
        Class<ConsoleProgress> clazz = ConsoleProgress.class;
        synchronized (ConsoleProgress.class) {
            int i;
            StringBuilder b;
            if (this.start == 0L) {
                this.start = System.currentTimeMillis();
            }
            if (this.currentTask.equals(task) && this.currentProgress == progress || progress > 100) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            System.out.print('\r');
            if (!this.currentTask.equals(task)) {
                b = new StringBuilder();
                for (i = 0; i < this.currentString.length(); ++i) {
                    b.append(' ');
                }
                System.out.print(b.toString());
                System.out.print('\r');
            }
            b = new StringBuilder();
            b.append(" [");
            i = 0;
            while ((double)i < Math.floor((double)progress / 10.0)) {
                b.append(this.progressIndicator);
                ++i;
            }
            while (i < 10) {
                b.append(' ');
                ++i;
            }
            b.append("] ").append(String.format("%3d", progress)).append("% ");
            if (this.currentProgress != progress || !this.currentTask.equals(task) || progress >= 100) {
                System.out.print(b.toString());
                this.currentProgress = progress;
            }
            if (!this.currentTask.equals(task) || progress >= 100) {
                System.out.print(task);
                this.currentTask = task;
            }
            b.append(task);
            this.currentString = b.toString();
            if (progress < 100) return;
            this.finished = true;
            System.out.println(String.format(" %dms", System.currentTimeMillis() - this.start));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) throws InterruptedException {
        ConsoleProgress cp = new ConsoleProgress();
        for (int i = 0; i < 1000; ++i) {
            cp.showProgress("Lade Pfade vsch20130318.csv" + i / 100, (int)Math.ceil((double)i / 10.0));
            Thread.sleep(5L);
        }
        Thread.sleep(2000L);
    }
}

