/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddForeignKeyChange;
import org.apache.ddlutils.alteration.AddIndexChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.AddTableChange;
import org.apache.ddlutils.alteration.ColumnAutoIncrementChange;
import org.apache.ddlutils.alteration.ColumnDataTypeChange;
import org.apache.ddlutils.alteration.ColumnDefaultValueChange;
import org.apache.ddlutils.alteration.ColumnOrderChange;
import org.apache.ddlutils.alteration.ColumnRequiredChange;
import org.apache.ddlutils.alteration.ColumnSizeChange;
import org.apache.ddlutils.alteration.ModelChange;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemoveForeignKeyChange;
import org.apache.ddlutils.alteration.RemoveIndexChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveTableChange;
import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;

public class ModelComparator {
    private final Log _log = LogFactory.getLog(class$org$apache$ddlutils$alteration$ModelComparator == null ? (class$org$apache$ddlutils$alteration$ModelComparator = ModelComparator.class$("org.apache.ddlutils.alteration.ModelComparator")) : class$org$apache$ddlutils$alteration$ModelComparator);
    private PlatformInfo _platformInfo;
    private boolean _caseSensitive;
    static /* synthetic */ Class class$org$apache$ddlutils$alteration$ModelComparator;

    public ModelComparator(PlatformInfo platformInfo, boolean caseSensitive) {
        this._platformInfo = platformInfo;
        this._caseSensitive = caseSensitive;
    }

    public List compare(Database sourceModel, Database targetModel) {
        int fkIdx;
        int tableIdx;
        ArrayList<ModelChange> changes = new ArrayList<ModelChange>();
        for (tableIdx = 0; tableIdx < targetModel.getTableCount(); ++tableIdx) {
            Table targetTable = targetModel.getTable(tableIdx);
            Table sourceTable = sourceModel.findTable(targetTable.getName(), this._caseSensitive);
            if (sourceTable == null) {
                if (this._log.isInfoEnabled()) {
                    this._log.info("Table " + targetTable.getName() + " needs to be added");
                }
                changes.add(new AddTableChange(targetTable));
                for (fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
                    changes.add(new AddForeignKeyChange(targetTable, targetTable.getForeignKey(fkIdx)));
                }
                continue;
            }
            changes.addAll(this.compareTables(sourceModel, sourceTable, targetModel, targetTable));
        }
        for (tableIdx = 0; tableIdx < sourceModel.getTableCount(); ++tableIdx) {
            Table sourceTable = sourceModel.getTable(tableIdx);
            Table targetTable = targetModel.findTable(sourceTable.getName(), this._caseSensitive);
            if (targetTable != null || sourceTable.getName() == null || sourceTable.getName().length() <= 0) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info("Table " + sourceTable.getName() + " needs to be removed");
            }
            changes.add(new RemoveTableChange(sourceTable));
            for (fkIdx = 0; fkIdx < sourceTable.getForeignKeyCount(); ++fkIdx) {
                changes.add(new RemoveForeignKeyChange(sourceTable, sourceTable.getForeignKey(fkIdx)));
            }
        }
        return changes;
    }

    public List compareTables(Database sourceModel, Table sourceTable, Database targetModel, Table targetTable) {
        AddColumnChange change;
        Column targetColumn;
        int columnIdx;
        int indexIdx;
        int fkIdx;
        ArrayList<TableChangeImplBase> changes = new ArrayList<TableChangeImplBase>();
        for (fkIdx = 0; fkIdx < sourceTable.getForeignKeyCount(); ++fkIdx) {
            ForeignKey sourceFk = sourceTable.getForeignKey(fkIdx);
            ForeignKey targetFk = this.findCorrespondingForeignKey(targetTable, sourceFk);
            if (targetFk != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info("Foreign key " + sourceFk + " needs to be removed from table " + sourceTable.getName());
            }
            changes.add(new RemoveForeignKeyChange(sourceTable, sourceFk));
        }
        for (fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
            ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
            ForeignKey sourceFk = this.findCorrespondingForeignKey(sourceTable, targetFk);
            if (sourceFk != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info("Foreign key " + targetFk + " needs to be created for table " + sourceTable.getName());
            }
            changes.add(new AddForeignKeyChange(targetTable, targetFk));
        }
        for (indexIdx = 0; indexIdx < sourceTable.getIndexCount(); ++indexIdx) {
            Index sourceIndex = sourceTable.getIndex(indexIdx);
            Index targetIndex = this.findCorrespondingIndex(targetTable, sourceIndex);
            if (targetIndex != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info("Index " + sourceIndex.getName() + " needs to be removed from table " + sourceTable.getName());
            }
            changes.add(new RemoveIndexChange(sourceTable, sourceIndex));
        }
        for (indexIdx = 0; indexIdx < targetTable.getIndexCount(); ++indexIdx) {
            Index targetIndex = targetTable.getIndex(indexIdx);
            Index sourceIndex = this.findCorrespondingIndex(sourceTable, targetIndex);
            if (sourceIndex != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info("Index " + targetIndex.getName() + " needs to be created for table " + sourceTable.getName());
            }
            changes.add(new AddIndexChange(targetTable, targetIndex));
        }
        HashMap<Column, AddColumnChange> addColumnChanges = new HashMap<Column, AddColumnChange>();
        for (columnIdx = 0; columnIdx < targetTable.getColumnCount(); ++columnIdx) {
            targetColumn = targetTable.getColumn(columnIdx);
            Column sourceColumn = sourceTable.findColumn(targetColumn.getName(), this._caseSensitive);
            if (sourceColumn == null) {
                if (this._log.isInfoEnabled()) {
                    this._log.info("Column " + targetColumn.getName() + " needs to be created for table " + sourceTable.getName());
                }
                AddColumnChange change2 = new AddColumnChange(sourceTable, targetColumn, columnIdx > 0 ? targetTable.getColumn(columnIdx - 1) : null, columnIdx < targetTable.getColumnCount() - 1 ? targetTable.getColumn(columnIdx + 1) : null);
                changes.add(change2);
                addColumnChanges.put(targetColumn, change2);
                continue;
            }
            changes.addAll(this.compareColumns(sourceTable, sourceColumn, targetTable, targetColumn));
        }
        for (columnIdx = targetTable.getColumnCount() - 1; columnIdx >= 0 && (change = (AddColumnChange)addColumnChanges.get(targetColumn = targetTable.getColumn(columnIdx))) != null; --columnIdx) {
            change.setAtEnd(true);
        }
        Column[] sourcePK = sourceTable.getPrimaryKeyColumns();
        Column[] targetPK = targetTable.getPrimaryKeyColumns();
        if (sourcePK.length == 0 && targetPK.length > 0) {
            if (this._log.isInfoEnabled()) {
                this._log.info("A primary key needs to be added to the table " + sourceTable.getName());
            }
            changes.add(new AddPrimaryKeyChange(targetTable, targetPK));
        } else if (targetPK.length == 0 && sourcePK.length > 0) {
            if (this._log.isInfoEnabled()) {
                this._log.info("The primary key needs to be removed from the table " + sourceTable.getName());
            }
            changes.add(new RemovePrimaryKeyChange(sourceTable, sourcePK));
        } else if (sourcePK.length > 0 && targetPK.length > 0) {
            boolean changePK = false;
            if (sourcePK.length != targetPK.length) {
                changePK = true;
            } else {
                for (int pkColumnIdx = 0; pkColumnIdx < sourcePK.length && !changePK; ++pkColumnIdx) {
                    if ((!this._caseSensitive || sourcePK[pkColumnIdx].getName().equals(targetPK[pkColumnIdx].getName())) && (this._caseSensitive || sourcePK[pkColumnIdx].getName().equalsIgnoreCase(targetPK[pkColumnIdx].getName()))) continue;
                    changePK = true;
                }
            }
            if (changePK) {
                if (this._log.isInfoEnabled()) {
                    this._log.info("The primary key of table " + sourceTable.getName() + " needs to be changed");
                }
                changes.add(new PrimaryKeyChange(sourceTable, sourcePK, targetPK));
            }
        }
        HashMap<Column, Integer> columnPosChanges = new HashMap<Column, Integer>();
        for (int columnIdx2 = 0; columnIdx2 < sourceTable.getColumnCount(); ++columnIdx2) {
            Column sourceColumn = sourceTable.getColumn(columnIdx2);
            Column targetColumn2 = targetTable.findColumn(sourceColumn.getName(), this._caseSensitive);
            if (targetColumn2 == null) {
                if (this._log.isInfoEnabled()) {
                    this._log.info("Column " + sourceColumn.getName() + " needs to be removed from table " + sourceTable.getName());
                }
                changes.add(new RemoveColumnChange(sourceTable, sourceColumn));
                continue;
            }
            int targetColumnIdx = targetTable.getColumnIndex(targetColumn2);
            if (targetColumnIdx == columnIdx2) continue;
            columnPosChanges.put(sourceColumn, new Integer(targetColumnIdx));
        }
        if (!columnPosChanges.isEmpty()) {
            changes.add(new ColumnOrderChange(sourceTable, columnPosChanges));
        }
        return changes;
    }

    public List compareColumns(Table sourceTable, Column sourceColumn, Table targetTable, Column targetColumn) {
        ArrayList<TableChangeImplBase> changes = new ArrayList<TableChangeImplBase>();
        if (this._platformInfo.getTargetJdbcType(targetColumn.getTypeCode()) != sourceColumn.getTypeCode()) {
            changes.add(new ColumnDataTypeChange(sourceTable, sourceColumn, targetColumn.getTypeCode()));
        }
        boolean sizeMatters = this._platformInfo.hasSize(sourceColumn.getTypeCode());
        boolean scaleMatters = this._platformInfo.hasPrecisionAndScale(sourceColumn.getTypeCode());
        if (sizeMatters && !StringUtils.equals(sourceColumn.getSize(), targetColumn.getSize())) {
            changes.add(new ColumnSizeChange(sourceTable, sourceColumn, targetColumn.getSizeAsInt(), targetColumn.getScale()));
        } else if (scaleMatters && (!StringUtils.equals(sourceColumn.getSize(), targetColumn.getSize()) || sourceColumn.getScale() != targetColumn.getScale())) {
            changes.add(new ColumnSizeChange(sourceTable, sourceColumn, targetColumn.getSizeAsInt(), targetColumn.getScale()));
        }
        Object sourceDefaultValue = sourceColumn.getParsedDefaultValue();
        Object targetDefaultValue = targetColumn.getParsedDefaultValue();
        if (sourceDefaultValue == null && targetDefaultValue != null || sourceDefaultValue != null && !sourceDefaultValue.equals(targetDefaultValue)) {
            changes.add(new ColumnDefaultValueChange(sourceTable, sourceColumn, targetColumn.getDefaultValue()));
        }
        if (sourceColumn.isRequired() != targetColumn.isRequired()) {
            changes.add(new ColumnRequiredChange(sourceTable, sourceColumn));
        }
        if (sourceColumn.isAutoIncrement() != targetColumn.isAutoIncrement()) {
            changes.add(new ColumnAutoIncrementChange(sourceTable, sourceColumn));
        }
        return changes;
    }

    private ForeignKey findCorrespondingForeignKey(Table table, ForeignKey fk) {
        for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
            ForeignKey curFk = table.getForeignKey(fkIdx);
            if ((!this._caseSensitive || !fk.equals(curFk)) && (this._caseSensitive || !fk.equalsIgnoreCase(curFk))) continue;
            return curFk;
        }
        return null;
    }

    private Index findCorrespondingIndex(Table table, Index index) {
        for (int indexIdx = 0; indexIdx < table.getIndexCount(); ++indexIdx) {
            Index curIndex = table.getIndex(indexIdx);
            if ((!this._caseSensitive || !index.equals(curIndex)) && (this._caseSensitive || !index.equalsIgnoreCase(curIndex))) continue;
            return curIndex;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

