/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.strategy;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.strategy.ConvertUtilsObjectStringConverter;

public class DefaultObjectStringConverter
extends ConvertUtilsObjectStringConverter {
    private final SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.UK);
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public String objectToString(Object object, Class type, String flavour, Context context) {
        if (object != null) {
            if (object instanceof Class) {
                return ((Class)object).getName();
            }
            if (object instanceof Date && this.isUtilDate(type)) {
                return this.formatter.format((Date)object);
            }
            return super.objectToString(object, type, flavour, context);
        }
        return "";
    }

    public Object stringToObject(String value, Class type, String flavour, Context context) {
        if (this.isUtilDate(type)) {
            try {
                return this.formatter.parse(value);
            }
            catch (ParseException ex) {
                this.handleException(ex);
                return value;
            }
        }
        return super.stringToObject(value, type, flavour, context);
    }

    protected void handleException(Exception e) {
        throw new ConversionException("String to object conversion failed: " + e.getMessage(), e);
    }

    private boolean isUtilDate(Class type) {
        return (class$java$util$Date == null ? (class$java$util$Date = DefaultObjectStringConverter.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(type) && !(class$java$sql$Date == null ? (class$java$sql$Date = DefaultObjectStringConverter.class$("java.sql.Date")) : class$java$sql$Date).isAssignableFrom(type) && !(class$java$sql$Time == null ? (class$java$sql$Time = DefaultObjectStringConverter.class$("java.sql.Time")) : class$java$sql$Time).isAssignableFrom(type) && !(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DefaultObjectStringConverter.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).isAssignableFrom(type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

