/*
 * Decompiled with CFR 0.152.
 */
package clojure.tools.nrepl;

import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Seqable;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Connection
implements Closeable {
    private static Var connect;
    private static Var urlConnect;
    private static Var createClient;
    private static Var clientSession;
    private static Var newSession;
    private static Var message;
    private static Var combineResponses;
    private static Var map;
    private static Var readString;
    private static Var stringifyKeys;
    public final Closeable transport;
    public final IFn client;
    public final String url;

    public static Var find(String ns2, String name2) {
        return Var.find(Symbol.intern(ns2, name2));
    }

    public Connection(String url) throws Exception {
        this(url, Long.MAX_VALUE);
    }

    public Connection(String url, long readTimeout) throws Exception {
        this.url = url;
        this.transport = (Closeable)urlConnect.invoke(this.url);
        this.client = (IFn)createClient.invoke(this.transport, readTimeout);
    }

    public void close() throws IOException {
        this.transport.close();
    }

    public Response send(String ... kvs) {
        try {
            PersistentHashMap msg = PersistentHashMap.createWithCheck(kvs);
            return new Response((ISeq)message.invoke(this.client, msg));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public Response sendSession(String session2, String ... kvs) {
        try {
            PersistentHashMap msg = PersistentHashMap.createWithCheck(kvs);
            return new Response((ISeq)message.invoke(clientSession.invoke(this.client, Keyword.intern("session"), session2), msg));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public String newSession(String cloneSessionId) {
        try {
            if (cloneSessionId == null) {
                return (String)newSession.invoke(this.client);
            }
            return (String)newSession.invoke(this.client, Keyword.intern("clone"), cloneSessionId);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    static {
        try {
            RT.var("clojure.core", "require").invoke(Symbol.intern("clojure.tools.nrepl"));
            RT.var("clojure.core", "require").invoke(Symbol.intern("clojure.walk"));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        connect = Connection.find("clojure.tools.nrepl", "connect");
        urlConnect = Connection.find("clojure.tools.nrepl", "url-connect");
        createClient = Connection.find("clojure.tools.nrepl", "client");
        clientSession = Connection.find("clojure.tools.nrepl", "client-session");
        newSession = Connection.find("clojure.tools.nrepl", "new-session");
        message = Connection.find("clojure.tools.nrepl", "message");
        combineResponses = Connection.find("clojure.tools.nrepl", "combine-responses");
        map = Connection.find("clojure.core", "map");
        readString = Connection.find("clojure.core", "read-string");
        stringifyKeys = Connection.find("clojure.walk", "stringify-keys");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Response
    implements Seqable {
        private ISeq responses;
        private Map<String, Object> response;

        private Response(ISeq responses) {
            this.responses = responses;
        }

        public synchronized Map<String, Object> combinedResponse() {
            try {
                if (this.response == null) {
                    this.response = (Map)stringifyKeys.invoke(combineResponses.invoke(this.responses));
                    this.responses = null;
                }
                return this.response;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        public Set<String> statuses() {
            try {
                return (Set)this.combinedResponse().get("status");
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        public List<Object> values() {
            try {
                return (List)map.invoke(readString, this.combinedResponse().get("value"));
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public ISeq seq() {
            return this.responses;
        }
    }
}

