// Input 0
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
// Input 1
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
// Input 2
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
// Input 3
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
// Input 4
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
// Input 5
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
// Input 6
goog.provide("goog.string.format");
goog.require("goog.string");
goog.string.format = function(formatString, var_args) {
  var args = Array.prototype.slice.call(arguments);
  var template = args.shift();
  if(typeof template == "undefined") {
    throw Error("[goog.string.format] Template required");
  }
  var formatRe = /%([0\-\ \+]*)(\d+)?(\.(\d+))?([%sfdiu])/g;
  function replacerDemuxer(match, flags, width, dotp, precision, type, offset, wholeString) {
    if(type == "%") {
      return"%"
    }
    var value = args.shift();
    if(typeof value == "undefined") {
      throw Error("[goog.string.format] Not enough arguments");
    }
    arguments[0] = value;
    return goog.string.format.demuxes_[type].apply(null, arguments)
  }
  return template.replace(formatRe, replacerDemuxer)
};
goog.string.format.demuxes_ = {};
goog.string.format.demuxes_["s"] = function(value, flags, width, dotp, precision, type, offset, wholeString) {
  var replacement = value;
  if(isNaN(width) || width == "" || replacement.length >= width) {
    return replacement
  }
  if(flags.indexOf("-", 0) > -1) {
    replacement = replacement + goog.string.repeat(" ", width - replacement.length)
  }else {
    replacement = goog.string.repeat(" ", width - replacement.length) + replacement
  }
  return replacement
};
goog.string.format.demuxes_["f"] = function(value, flags, width, dotp, precision, type, offset, wholeString) {
  var replacement = value.toString();
  if(!(isNaN(precision) || precision == "")) {
    replacement = value.toFixed(precision)
  }
  var sign;
  if(value < 0) {
    sign = "-"
  }else {
    if(flags.indexOf("+") >= 0) {
      sign = "+"
    }else {
      if(flags.indexOf(" ") >= 0) {
        sign = " "
      }else {
        sign = ""
      }
    }
  }
  if(value >= 0) {
    replacement = sign + replacement
  }
  if(isNaN(width) || replacement.length >= width) {
    return replacement
  }
  replacement = isNaN(precision) ? Math.abs(value).toString() : Math.abs(value).toFixed(precision);
  var padCount = width - replacement.length - sign.length;
  if(flags.indexOf("-", 0) >= 0) {
    replacement = sign + replacement + goog.string.repeat(" ", padCount)
  }else {
    var paddingChar = flags.indexOf("0", 0) >= 0 ? "0" : " ";
    replacement = sign + goog.string.repeat(paddingChar, padCount) + replacement
  }
  return replacement
};
goog.string.format.demuxes_["d"] = function(value, flags, width, dotp, precision, type, offset, wholeString) {
  return goog.string.format.demuxes_["f"](parseInt(value, 10), flags, width, dotp, 0, type, offset, wholeString)
};
goog.string.format.demuxes_["i"] = goog.string.format.demuxes_["d"];
goog.string.format.demuxes_["u"] = goog.string.format.demuxes_["d"];
// Input 7
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
// Input 8
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
// Input 9
goog.provide("cljs.core");
goog.require("goog.array");
goog.require("goog.object");
goog.require("goog.string.format");
goog.require("goog.string.StringBuffer");
goog.require("goog.string");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  var x__6256 = x == null ? null : x;
  if(p[goog.typeOf(x__6256)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error(["No protocol method ", proto, " defined for type ", goog.typeOf(obj), ": ", obj].join(""))
};
cljs.core.aclone = function aclone(array_like) {
  return array_like.slice()
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__6257__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__6257 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__6257__delegate.call(this, array, i, idxs)
    };
    G__6257.cljs$lang$maxFixedArity = 2;
    G__6257.cljs$lang$applyTo = function(arglist__6258) {
      var array = cljs.core.first(arglist__6258);
      var i = cljs.core.first(cljs.core.next(arglist__6258));
      var idxs = cljs.core.rest(cljs.core.next(arglist__6258));
      return G__6257__delegate(array, i, idxs)
    };
    G__6257.cljs$lang$arity$variadic = G__6257__delegate;
    return G__6257
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3822__auto____6343 = this$;
      if(and__3822__auto____6343) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3822__auto____6343
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      var x__2363__auto____6344 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6345 = cljs.core._invoke[goog.typeOf(x__2363__auto____6344)];
        if(or__3824__auto____6345) {
          return or__3824__auto____6345
        }else {
          var or__3824__auto____6346 = cljs.core._invoke["_"];
          if(or__3824__auto____6346) {
            return or__3824__auto____6346
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3822__auto____6347 = this$;
      if(and__3822__auto____6347) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3822__auto____6347
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      var x__2363__auto____6348 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6349 = cljs.core._invoke[goog.typeOf(x__2363__auto____6348)];
        if(or__3824__auto____6349) {
          return or__3824__auto____6349
        }else {
          var or__3824__auto____6350 = cljs.core._invoke["_"];
          if(or__3824__auto____6350) {
            return or__3824__auto____6350
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3822__auto____6351 = this$;
      if(and__3822__auto____6351) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3822__auto____6351
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      var x__2363__auto____6352 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6353 = cljs.core._invoke[goog.typeOf(x__2363__auto____6352)];
        if(or__3824__auto____6353) {
          return or__3824__auto____6353
        }else {
          var or__3824__auto____6354 = cljs.core._invoke["_"];
          if(or__3824__auto____6354) {
            return or__3824__auto____6354
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3822__auto____6355 = this$;
      if(and__3822__auto____6355) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3822__auto____6355
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      var x__2363__auto____6356 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6357 = cljs.core._invoke[goog.typeOf(x__2363__auto____6356)];
        if(or__3824__auto____6357) {
          return or__3824__auto____6357
        }else {
          var or__3824__auto____6358 = cljs.core._invoke["_"];
          if(or__3824__auto____6358) {
            return or__3824__auto____6358
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3822__auto____6359 = this$;
      if(and__3822__auto____6359) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3822__auto____6359
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      var x__2363__auto____6360 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6361 = cljs.core._invoke[goog.typeOf(x__2363__auto____6360)];
        if(or__3824__auto____6361) {
          return or__3824__auto____6361
        }else {
          var or__3824__auto____6362 = cljs.core._invoke["_"];
          if(or__3824__auto____6362) {
            return or__3824__auto____6362
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3822__auto____6363 = this$;
      if(and__3822__auto____6363) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3822__auto____6363
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      var x__2363__auto____6364 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6365 = cljs.core._invoke[goog.typeOf(x__2363__auto____6364)];
        if(or__3824__auto____6365) {
          return or__3824__auto____6365
        }else {
          var or__3824__auto____6366 = cljs.core._invoke["_"];
          if(or__3824__auto____6366) {
            return or__3824__auto____6366
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3822__auto____6367 = this$;
      if(and__3822__auto____6367) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3822__auto____6367
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      var x__2363__auto____6368 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6369 = cljs.core._invoke[goog.typeOf(x__2363__auto____6368)];
        if(or__3824__auto____6369) {
          return or__3824__auto____6369
        }else {
          var or__3824__auto____6370 = cljs.core._invoke["_"];
          if(or__3824__auto____6370) {
            return or__3824__auto____6370
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3822__auto____6371 = this$;
      if(and__3822__auto____6371) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3822__auto____6371
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      var x__2363__auto____6372 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6373 = cljs.core._invoke[goog.typeOf(x__2363__auto____6372)];
        if(or__3824__auto____6373) {
          return or__3824__auto____6373
        }else {
          var or__3824__auto____6374 = cljs.core._invoke["_"];
          if(or__3824__auto____6374) {
            return or__3824__auto____6374
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3822__auto____6375 = this$;
      if(and__3822__auto____6375) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3822__auto____6375
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      var x__2363__auto____6376 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6377 = cljs.core._invoke[goog.typeOf(x__2363__auto____6376)];
        if(or__3824__auto____6377) {
          return or__3824__auto____6377
        }else {
          var or__3824__auto____6378 = cljs.core._invoke["_"];
          if(or__3824__auto____6378) {
            return or__3824__auto____6378
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3822__auto____6379 = this$;
      if(and__3822__auto____6379) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3822__auto____6379
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      var x__2363__auto____6380 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6381 = cljs.core._invoke[goog.typeOf(x__2363__auto____6380)];
        if(or__3824__auto____6381) {
          return or__3824__auto____6381
        }else {
          var or__3824__auto____6382 = cljs.core._invoke["_"];
          if(or__3824__auto____6382) {
            return or__3824__auto____6382
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3822__auto____6383 = this$;
      if(and__3822__auto____6383) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3822__auto____6383
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      var x__2363__auto____6384 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6385 = cljs.core._invoke[goog.typeOf(x__2363__auto____6384)];
        if(or__3824__auto____6385) {
          return or__3824__auto____6385
        }else {
          var or__3824__auto____6386 = cljs.core._invoke["_"];
          if(or__3824__auto____6386) {
            return or__3824__auto____6386
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3822__auto____6387 = this$;
      if(and__3822__auto____6387) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3822__auto____6387
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      var x__2363__auto____6388 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6389 = cljs.core._invoke[goog.typeOf(x__2363__auto____6388)];
        if(or__3824__auto____6389) {
          return or__3824__auto____6389
        }else {
          var or__3824__auto____6390 = cljs.core._invoke["_"];
          if(or__3824__auto____6390) {
            return or__3824__auto____6390
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3822__auto____6391 = this$;
      if(and__3822__auto____6391) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3822__auto____6391
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      var x__2363__auto____6392 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6393 = cljs.core._invoke[goog.typeOf(x__2363__auto____6392)];
        if(or__3824__auto____6393) {
          return or__3824__auto____6393
        }else {
          var or__3824__auto____6394 = cljs.core._invoke["_"];
          if(or__3824__auto____6394) {
            return or__3824__auto____6394
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3822__auto____6395 = this$;
      if(and__3822__auto____6395) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3822__auto____6395
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      var x__2363__auto____6396 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6397 = cljs.core._invoke[goog.typeOf(x__2363__auto____6396)];
        if(or__3824__auto____6397) {
          return or__3824__auto____6397
        }else {
          var or__3824__auto____6398 = cljs.core._invoke["_"];
          if(or__3824__auto____6398) {
            return or__3824__auto____6398
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3822__auto____6399 = this$;
      if(and__3822__auto____6399) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3822__auto____6399
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      var x__2363__auto____6400 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6401 = cljs.core._invoke[goog.typeOf(x__2363__auto____6400)];
        if(or__3824__auto____6401) {
          return or__3824__auto____6401
        }else {
          var or__3824__auto____6402 = cljs.core._invoke["_"];
          if(or__3824__auto____6402) {
            return or__3824__auto____6402
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3822__auto____6403 = this$;
      if(and__3822__auto____6403) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3822__auto____6403
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      var x__2363__auto____6404 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6405 = cljs.core._invoke[goog.typeOf(x__2363__auto____6404)];
        if(or__3824__auto____6405) {
          return or__3824__auto____6405
        }else {
          var or__3824__auto____6406 = cljs.core._invoke["_"];
          if(or__3824__auto____6406) {
            return or__3824__auto____6406
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3822__auto____6407 = this$;
      if(and__3822__auto____6407) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3822__auto____6407
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      var x__2363__auto____6408 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6409 = cljs.core._invoke[goog.typeOf(x__2363__auto____6408)];
        if(or__3824__auto____6409) {
          return or__3824__auto____6409
        }else {
          var or__3824__auto____6410 = cljs.core._invoke["_"];
          if(or__3824__auto____6410) {
            return or__3824__auto____6410
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3822__auto____6411 = this$;
      if(and__3822__auto____6411) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3822__auto____6411
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      var x__2363__auto____6412 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6413 = cljs.core._invoke[goog.typeOf(x__2363__auto____6412)];
        if(or__3824__auto____6413) {
          return or__3824__auto____6413
        }else {
          var or__3824__auto____6414 = cljs.core._invoke["_"];
          if(or__3824__auto____6414) {
            return or__3824__auto____6414
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3822__auto____6415 = this$;
      if(and__3822__auto____6415) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3822__auto____6415
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      var x__2363__auto____6416 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6417 = cljs.core._invoke[goog.typeOf(x__2363__auto____6416)];
        if(or__3824__auto____6417) {
          return or__3824__auto____6417
        }else {
          var or__3824__auto____6418 = cljs.core._invoke["_"];
          if(or__3824__auto____6418) {
            return or__3824__auto____6418
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3822__auto____6419 = this$;
      if(and__3822__auto____6419) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3822__auto____6419
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      var x__2363__auto____6420 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6421 = cljs.core._invoke[goog.typeOf(x__2363__auto____6420)];
        if(or__3824__auto____6421) {
          return or__3824__auto____6421
        }else {
          var or__3824__auto____6422 = cljs.core._invoke["_"];
          if(or__3824__auto____6422) {
            return or__3824__auto____6422
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3822__auto____6423 = this$;
      if(and__3822__auto____6423) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3822__auto____6423
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      var x__2363__auto____6424 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6425 = cljs.core._invoke[goog.typeOf(x__2363__auto____6424)];
        if(or__3824__auto____6425) {
          return or__3824__auto____6425
        }else {
          var or__3824__auto____6426 = cljs.core._invoke["_"];
          if(or__3824__auto____6426) {
            return or__3824__auto____6426
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3822__auto____6431 = coll;
    if(and__3822__auto____6431) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3822__auto____6431
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    var x__2363__auto____6432 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6433 = cljs.core._count[goog.typeOf(x__2363__auto____6432)];
      if(or__3824__auto____6433) {
        return or__3824__auto____6433
      }else {
        var or__3824__auto____6434 = cljs.core._count["_"];
        if(or__3824__auto____6434) {
          return or__3824__auto____6434
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3822__auto____6439 = coll;
    if(and__3822__auto____6439) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3822__auto____6439
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    var x__2363__auto____6440 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6441 = cljs.core._empty[goog.typeOf(x__2363__auto____6440)];
      if(or__3824__auto____6441) {
        return or__3824__auto____6441
      }else {
        var or__3824__auto____6442 = cljs.core._empty["_"];
        if(or__3824__auto____6442) {
          return or__3824__auto____6442
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3822__auto____6447 = coll;
    if(and__3822__auto____6447) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3822__auto____6447
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    var x__2363__auto____6448 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6449 = cljs.core._conj[goog.typeOf(x__2363__auto____6448)];
      if(or__3824__auto____6449) {
        return or__3824__auto____6449
      }else {
        var or__3824__auto____6450 = cljs.core._conj["_"];
        if(or__3824__auto____6450) {
          return or__3824__auto____6450
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3822__auto____6459 = coll;
      if(and__3822__auto____6459) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3822__auto____6459
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      var x__2363__auto____6460 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____6461 = cljs.core._nth[goog.typeOf(x__2363__auto____6460)];
        if(or__3824__auto____6461) {
          return or__3824__auto____6461
        }else {
          var or__3824__auto____6462 = cljs.core._nth["_"];
          if(or__3824__auto____6462) {
            return or__3824__auto____6462
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3822__auto____6463 = coll;
      if(and__3822__auto____6463) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3822__auto____6463
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      var x__2363__auto____6464 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____6465 = cljs.core._nth[goog.typeOf(x__2363__auto____6464)];
        if(or__3824__auto____6465) {
          return or__3824__auto____6465
        }else {
          var or__3824__auto____6466 = cljs.core._nth["_"];
          if(or__3824__auto____6466) {
            return or__3824__auto____6466
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
cljs.core.ASeq = {};
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3822__auto____6471 = coll;
    if(and__3822__auto____6471) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3822__auto____6471
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    var x__2363__auto____6472 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6473 = cljs.core._first[goog.typeOf(x__2363__auto____6472)];
      if(or__3824__auto____6473) {
        return or__3824__auto____6473
      }else {
        var or__3824__auto____6474 = cljs.core._first["_"];
        if(or__3824__auto____6474) {
          return or__3824__auto____6474
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3822__auto____6479 = coll;
    if(and__3822__auto____6479) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3822__auto____6479
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    var x__2363__auto____6480 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6481 = cljs.core._rest[goog.typeOf(x__2363__auto____6480)];
      if(or__3824__auto____6481) {
        return or__3824__auto____6481
      }else {
        var or__3824__auto____6482 = cljs.core._rest["_"];
        if(or__3824__auto____6482) {
          return or__3824__auto____6482
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.INext = {};
cljs.core._next = function _next(coll) {
  if(function() {
    var and__3822__auto____6487 = coll;
    if(and__3822__auto____6487) {
      return coll.cljs$core$INext$_next$arity$1
    }else {
      return and__3822__auto____6487
    }
  }()) {
    return coll.cljs$core$INext$_next$arity$1(coll)
  }else {
    var x__2363__auto____6488 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6489 = cljs.core._next[goog.typeOf(x__2363__auto____6488)];
      if(or__3824__auto____6489) {
        return or__3824__auto____6489
      }else {
        var or__3824__auto____6490 = cljs.core._next["_"];
        if(or__3824__auto____6490) {
          return or__3824__auto____6490
        }else {
          throw cljs.core.missing_protocol.call(null, "INext.-next", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3822__auto____6499 = o;
      if(and__3822__auto____6499) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3822__auto____6499
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      var x__2363__auto____6500 = o == null ? null : o;
      return function() {
        var or__3824__auto____6501 = cljs.core._lookup[goog.typeOf(x__2363__auto____6500)];
        if(or__3824__auto____6501) {
          return or__3824__auto____6501
        }else {
          var or__3824__auto____6502 = cljs.core._lookup["_"];
          if(or__3824__auto____6502) {
            return or__3824__auto____6502
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3822__auto____6503 = o;
      if(and__3822__auto____6503) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3822__auto____6503
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      var x__2363__auto____6504 = o == null ? null : o;
      return function() {
        var or__3824__auto____6505 = cljs.core._lookup[goog.typeOf(x__2363__auto____6504)];
        if(or__3824__auto____6505) {
          return or__3824__auto____6505
        }else {
          var or__3824__auto____6506 = cljs.core._lookup["_"];
          if(or__3824__auto____6506) {
            return or__3824__auto____6506
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3822__auto____6511 = coll;
    if(and__3822__auto____6511) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3822__auto____6511
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    var x__2363__auto____6512 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6513 = cljs.core._contains_key_QMARK_[goog.typeOf(x__2363__auto____6512)];
      if(or__3824__auto____6513) {
        return or__3824__auto____6513
      }else {
        var or__3824__auto____6514 = cljs.core._contains_key_QMARK_["_"];
        if(or__3824__auto____6514) {
          return or__3824__auto____6514
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3822__auto____6519 = coll;
    if(and__3822__auto____6519) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3822__auto____6519
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    var x__2363__auto____6520 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6521 = cljs.core._assoc[goog.typeOf(x__2363__auto____6520)];
      if(or__3824__auto____6521) {
        return or__3824__auto____6521
      }else {
        var or__3824__auto____6522 = cljs.core._assoc["_"];
        if(or__3824__auto____6522) {
          return or__3824__auto____6522
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3822__auto____6527 = coll;
    if(and__3822__auto____6527) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3822__auto____6527
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    var x__2363__auto____6528 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6529 = cljs.core._dissoc[goog.typeOf(x__2363__auto____6528)];
      if(or__3824__auto____6529) {
        return or__3824__auto____6529
      }else {
        var or__3824__auto____6530 = cljs.core._dissoc["_"];
        if(or__3824__auto____6530) {
          return or__3824__auto____6530
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3822__auto____6535 = coll;
    if(and__3822__auto____6535) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3822__auto____6535
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    var x__2363__auto____6536 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6537 = cljs.core._key[goog.typeOf(x__2363__auto____6536)];
      if(or__3824__auto____6537) {
        return or__3824__auto____6537
      }else {
        var or__3824__auto____6538 = cljs.core._key["_"];
        if(or__3824__auto____6538) {
          return or__3824__auto____6538
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3822__auto____6543 = coll;
    if(and__3822__auto____6543) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3822__auto____6543
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    var x__2363__auto____6544 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6545 = cljs.core._val[goog.typeOf(x__2363__auto____6544)];
      if(or__3824__auto____6545) {
        return or__3824__auto____6545
      }else {
        var or__3824__auto____6546 = cljs.core._val["_"];
        if(or__3824__auto____6546) {
          return or__3824__auto____6546
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3822__auto____6551 = coll;
    if(and__3822__auto____6551) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3822__auto____6551
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    var x__2363__auto____6552 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6553 = cljs.core._disjoin[goog.typeOf(x__2363__auto____6552)];
      if(or__3824__auto____6553) {
        return or__3824__auto____6553
      }else {
        var or__3824__auto____6554 = cljs.core._disjoin["_"];
        if(or__3824__auto____6554) {
          return or__3824__auto____6554
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3822__auto____6559 = coll;
    if(and__3822__auto____6559) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3822__auto____6559
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    var x__2363__auto____6560 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6561 = cljs.core._peek[goog.typeOf(x__2363__auto____6560)];
      if(or__3824__auto____6561) {
        return or__3824__auto____6561
      }else {
        var or__3824__auto____6562 = cljs.core._peek["_"];
        if(or__3824__auto____6562) {
          return or__3824__auto____6562
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3822__auto____6567 = coll;
    if(and__3822__auto____6567) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3822__auto____6567
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    var x__2363__auto____6568 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6569 = cljs.core._pop[goog.typeOf(x__2363__auto____6568)];
      if(or__3824__auto____6569) {
        return or__3824__auto____6569
      }else {
        var or__3824__auto____6570 = cljs.core._pop["_"];
        if(or__3824__auto____6570) {
          return or__3824__auto____6570
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3822__auto____6575 = coll;
    if(and__3822__auto____6575) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3822__auto____6575
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    var x__2363__auto____6576 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6577 = cljs.core._assoc_n[goog.typeOf(x__2363__auto____6576)];
      if(or__3824__auto____6577) {
        return or__3824__auto____6577
      }else {
        var or__3824__auto____6578 = cljs.core._assoc_n["_"];
        if(or__3824__auto____6578) {
          return or__3824__auto____6578
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3822__auto____6583 = o;
    if(and__3822__auto____6583) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3822__auto____6583
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    var x__2363__auto____6584 = o == null ? null : o;
    return function() {
      var or__3824__auto____6585 = cljs.core._deref[goog.typeOf(x__2363__auto____6584)];
      if(or__3824__auto____6585) {
        return or__3824__auto____6585
      }else {
        var or__3824__auto____6586 = cljs.core._deref["_"];
        if(or__3824__auto____6586) {
          return or__3824__auto____6586
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3822__auto____6591 = o;
    if(and__3822__auto____6591) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3822__auto____6591
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    var x__2363__auto____6592 = o == null ? null : o;
    return function() {
      var or__3824__auto____6593 = cljs.core._deref_with_timeout[goog.typeOf(x__2363__auto____6592)];
      if(or__3824__auto____6593) {
        return or__3824__auto____6593
      }else {
        var or__3824__auto____6594 = cljs.core._deref_with_timeout["_"];
        if(or__3824__auto____6594) {
          return or__3824__auto____6594
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3822__auto____6599 = o;
    if(and__3822__auto____6599) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3822__auto____6599
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    var x__2363__auto____6600 = o == null ? null : o;
    return function() {
      var or__3824__auto____6601 = cljs.core._meta[goog.typeOf(x__2363__auto____6600)];
      if(or__3824__auto____6601) {
        return or__3824__auto____6601
      }else {
        var or__3824__auto____6602 = cljs.core._meta["_"];
        if(or__3824__auto____6602) {
          return or__3824__auto____6602
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3822__auto____6607 = o;
    if(and__3822__auto____6607) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3822__auto____6607
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    var x__2363__auto____6608 = o == null ? null : o;
    return function() {
      var or__3824__auto____6609 = cljs.core._with_meta[goog.typeOf(x__2363__auto____6608)];
      if(or__3824__auto____6609) {
        return or__3824__auto____6609
      }else {
        var or__3824__auto____6610 = cljs.core._with_meta["_"];
        if(or__3824__auto____6610) {
          return or__3824__auto____6610
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3822__auto____6619 = coll;
      if(and__3822__auto____6619) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3822__auto____6619
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      var x__2363__auto____6620 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____6621 = cljs.core._reduce[goog.typeOf(x__2363__auto____6620)];
        if(or__3824__auto____6621) {
          return or__3824__auto____6621
        }else {
          var or__3824__auto____6622 = cljs.core._reduce["_"];
          if(or__3824__auto____6622) {
            return or__3824__auto____6622
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3822__auto____6623 = coll;
      if(and__3822__auto____6623) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3822__auto____6623
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      var x__2363__auto____6624 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____6625 = cljs.core._reduce[goog.typeOf(x__2363__auto____6624)];
        if(or__3824__auto____6625) {
          return or__3824__auto____6625
        }else {
          var or__3824__auto____6626 = cljs.core._reduce["_"];
          if(or__3824__auto____6626) {
            return or__3824__auto____6626
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3822__auto____6631 = coll;
    if(and__3822__auto____6631) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3822__auto____6631
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    var x__2363__auto____6632 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6633 = cljs.core._kv_reduce[goog.typeOf(x__2363__auto____6632)];
      if(or__3824__auto____6633) {
        return or__3824__auto____6633
      }else {
        var or__3824__auto____6634 = cljs.core._kv_reduce["_"];
        if(or__3824__auto____6634) {
          return or__3824__auto____6634
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3822__auto____6639 = o;
    if(and__3822__auto____6639) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3822__auto____6639
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    var x__2363__auto____6640 = o == null ? null : o;
    return function() {
      var or__3824__auto____6641 = cljs.core._equiv[goog.typeOf(x__2363__auto____6640)];
      if(or__3824__auto____6641) {
        return or__3824__auto____6641
      }else {
        var or__3824__auto____6642 = cljs.core._equiv["_"];
        if(or__3824__auto____6642) {
          return or__3824__auto____6642
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3822__auto____6647 = o;
    if(and__3822__auto____6647) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3822__auto____6647
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    var x__2363__auto____6648 = o == null ? null : o;
    return function() {
      var or__3824__auto____6649 = cljs.core._hash[goog.typeOf(x__2363__auto____6648)];
      if(or__3824__auto____6649) {
        return or__3824__auto____6649
      }else {
        var or__3824__auto____6650 = cljs.core._hash["_"];
        if(or__3824__auto____6650) {
          return or__3824__auto____6650
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3822__auto____6655 = o;
    if(and__3822__auto____6655) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3822__auto____6655
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    var x__2363__auto____6656 = o == null ? null : o;
    return function() {
      var or__3824__auto____6657 = cljs.core._seq[goog.typeOf(x__2363__auto____6656)];
      if(or__3824__auto____6657) {
        return or__3824__auto____6657
      }else {
        var or__3824__auto____6658 = cljs.core._seq["_"];
        if(or__3824__auto____6658) {
          return or__3824__auto____6658
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.ISequential = {};
cljs.core.IList = {};
cljs.core.IRecord = {};
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3822__auto____6663 = coll;
    if(and__3822__auto____6663) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3822__auto____6663
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    var x__2363__auto____6664 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6665 = cljs.core._rseq[goog.typeOf(x__2363__auto____6664)];
      if(or__3824__auto____6665) {
        return or__3824__auto____6665
      }else {
        var or__3824__auto____6666 = cljs.core._rseq["_"];
        if(or__3824__auto____6666) {
          return or__3824__auto____6666
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3822__auto____6671 = coll;
    if(and__3822__auto____6671) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3822__auto____6671
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    var x__2363__auto____6672 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6673 = cljs.core._sorted_seq[goog.typeOf(x__2363__auto____6672)];
      if(or__3824__auto____6673) {
        return or__3824__auto____6673
      }else {
        var or__3824__auto____6674 = cljs.core._sorted_seq["_"];
        if(or__3824__auto____6674) {
          return or__3824__auto____6674
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3822__auto____6679 = coll;
    if(and__3822__auto____6679) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3822__auto____6679
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    var x__2363__auto____6680 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6681 = cljs.core._sorted_seq_from[goog.typeOf(x__2363__auto____6680)];
      if(or__3824__auto____6681) {
        return or__3824__auto____6681
      }else {
        var or__3824__auto____6682 = cljs.core._sorted_seq_from["_"];
        if(or__3824__auto____6682) {
          return or__3824__auto____6682
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3822__auto____6687 = coll;
    if(and__3822__auto____6687) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3822__auto____6687
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    var x__2363__auto____6688 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6689 = cljs.core._entry_key[goog.typeOf(x__2363__auto____6688)];
      if(or__3824__auto____6689) {
        return or__3824__auto____6689
      }else {
        var or__3824__auto____6690 = cljs.core._entry_key["_"];
        if(or__3824__auto____6690) {
          return or__3824__auto____6690
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3822__auto____6695 = coll;
    if(and__3822__auto____6695) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3822__auto____6695
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    var x__2363__auto____6696 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6697 = cljs.core._comparator[goog.typeOf(x__2363__auto____6696)];
      if(or__3824__auto____6697) {
        return or__3824__auto____6697
      }else {
        var or__3824__auto____6698 = cljs.core._comparator["_"];
        if(or__3824__auto____6698) {
          return or__3824__auto____6698
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3822__auto____6703 = o;
    if(and__3822__auto____6703) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3822__auto____6703
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    var x__2363__auto____6704 = o == null ? null : o;
    return function() {
      var or__3824__auto____6705 = cljs.core._pr_seq[goog.typeOf(x__2363__auto____6704)];
      if(or__3824__auto____6705) {
        return or__3824__auto____6705
      }else {
        var or__3824__auto____6706 = cljs.core._pr_seq["_"];
        if(or__3824__auto____6706) {
          return or__3824__auto____6706
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3822__auto____6711 = d;
    if(and__3822__auto____6711) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3822__auto____6711
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    var x__2363__auto____6712 = d == null ? null : d;
    return function() {
      var or__3824__auto____6713 = cljs.core._realized_QMARK_[goog.typeOf(x__2363__auto____6712)];
      if(or__3824__auto____6713) {
        return or__3824__auto____6713
      }else {
        var or__3824__auto____6714 = cljs.core._realized_QMARK_["_"];
        if(or__3824__auto____6714) {
          return or__3824__auto____6714
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3822__auto____6719 = this$;
    if(and__3822__auto____6719) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3822__auto____6719
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    var x__2363__auto____6720 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____6721 = cljs.core._notify_watches[goog.typeOf(x__2363__auto____6720)];
      if(or__3824__auto____6721) {
        return or__3824__auto____6721
      }else {
        var or__3824__auto____6722 = cljs.core._notify_watches["_"];
        if(or__3824__auto____6722) {
          return or__3824__auto____6722
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3822__auto____6727 = this$;
    if(and__3822__auto____6727) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3822__auto____6727
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    var x__2363__auto____6728 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____6729 = cljs.core._add_watch[goog.typeOf(x__2363__auto____6728)];
      if(or__3824__auto____6729) {
        return or__3824__auto____6729
      }else {
        var or__3824__auto____6730 = cljs.core._add_watch["_"];
        if(or__3824__auto____6730) {
          return or__3824__auto____6730
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3822__auto____6735 = this$;
    if(and__3822__auto____6735) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3822__auto____6735
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    var x__2363__auto____6736 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____6737 = cljs.core._remove_watch[goog.typeOf(x__2363__auto____6736)];
      if(or__3824__auto____6737) {
        return or__3824__auto____6737
      }else {
        var or__3824__auto____6738 = cljs.core._remove_watch["_"];
        if(or__3824__auto____6738) {
          return or__3824__auto____6738
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3822__auto____6743 = coll;
    if(and__3822__auto____6743) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3822__auto____6743
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    var x__2363__auto____6744 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6745 = cljs.core._as_transient[goog.typeOf(x__2363__auto____6744)];
      if(or__3824__auto____6745) {
        return or__3824__auto____6745
      }else {
        var or__3824__auto____6746 = cljs.core._as_transient["_"];
        if(or__3824__auto____6746) {
          return or__3824__auto____6746
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3822__auto____6751 = tcoll;
    if(and__3822__auto____6751) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3822__auto____6751
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    var x__2363__auto____6752 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____6753 = cljs.core._conj_BANG_[goog.typeOf(x__2363__auto____6752)];
      if(or__3824__auto____6753) {
        return or__3824__auto____6753
      }else {
        var or__3824__auto____6754 = cljs.core._conj_BANG_["_"];
        if(or__3824__auto____6754) {
          return or__3824__auto____6754
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3822__auto____6759 = tcoll;
    if(and__3822__auto____6759) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3822__auto____6759
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    var x__2363__auto____6760 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____6761 = cljs.core._persistent_BANG_[goog.typeOf(x__2363__auto____6760)];
      if(or__3824__auto____6761) {
        return or__3824__auto____6761
      }else {
        var or__3824__auto____6762 = cljs.core._persistent_BANG_["_"];
        if(or__3824__auto____6762) {
          return or__3824__auto____6762
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3822__auto____6767 = tcoll;
    if(and__3822__auto____6767) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3822__auto____6767
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    var x__2363__auto____6768 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____6769 = cljs.core._assoc_BANG_[goog.typeOf(x__2363__auto____6768)];
      if(or__3824__auto____6769) {
        return or__3824__auto____6769
      }else {
        var or__3824__auto____6770 = cljs.core._assoc_BANG_["_"];
        if(or__3824__auto____6770) {
          return or__3824__auto____6770
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3822__auto____6775 = tcoll;
    if(and__3822__auto____6775) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3822__auto____6775
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    var x__2363__auto____6776 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____6777 = cljs.core._dissoc_BANG_[goog.typeOf(x__2363__auto____6776)];
      if(or__3824__auto____6777) {
        return or__3824__auto____6777
      }else {
        var or__3824__auto____6778 = cljs.core._dissoc_BANG_["_"];
        if(or__3824__auto____6778) {
          return or__3824__auto____6778
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3822__auto____6783 = tcoll;
    if(and__3822__auto____6783) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3822__auto____6783
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    var x__2363__auto____6784 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____6785 = cljs.core._assoc_n_BANG_[goog.typeOf(x__2363__auto____6784)];
      if(or__3824__auto____6785) {
        return or__3824__auto____6785
      }else {
        var or__3824__auto____6786 = cljs.core._assoc_n_BANG_["_"];
        if(or__3824__auto____6786) {
          return or__3824__auto____6786
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3822__auto____6791 = tcoll;
    if(and__3822__auto____6791) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3822__auto____6791
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    var x__2363__auto____6792 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____6793 = cljs.core._pop_BANG_[goog.typeOf(x__2363__auto____6792)];
      if(or__3824__auto____6793) {
        return or__3824__auto____6793
      }else {
        var or__3824__auto____6794 = cljs.core._pop_BANG_["_"];
        if(or__3824__auto____6794) {
          return or__3824__auto____6794
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3822__auto____6799 = tcoll;
    if(and__3822__auto____6799) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3822__auto____6799
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    var x__2363__auto____6800 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____6801 = cljs.core._disjoin_BANG_[goog.typeOf(x__2363__auto____6800)];
      if(or__3824__auto____6801) {
        return or__3824__auto____6801
      }else {
        var or__3824__auto____6802 = cljs.core._disjoin_BANG_["_"];
        if(or__3824__auto____6802) {
          return or__3824__auto____6802
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
cljs.core.IComparable = {};
cljs.core._compare = function _compare(x, y) {
  if(function() {
    var and__3822__auto____6807 = x;
    if(and__3822__auto____6807) {
      return x.cljs$core$IComparable$_compare$arity$2
    }else {
      return and__3822__auto____6807
    }
  }()) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y)
  }else {
    var x__2363__auto____6808 = x == null ? null : x;
    return function() {
      var or__3824__auto____6809 = cljs.core._compare[goog.typeOf(x__2363__auto____6808)];
      if(or__3824__auto____6809) {
        return or__3824__auto____6809
      }else {
        var or__3824__auto____6810 = cljs.core._compare["_"];
        if(or__3824__auto____6810) {
          return or__3824__auto____6810
        }else {
          throw cljs.core.missing_protocol.call(null, "IComparable.-compare", x);
        }
      }
    }().call(null, x, y)
  }
};
cljs.core.IChunk = {};
cljs.core._drop_first = function _drop_first(coll) {
  if(function() {
    var and__3822__auto____6815 = coll;
    if(and__3822__auto____6815) {
      return coll.cljs$core$IChunk$_drop_first$arity$1
    }else {
      return and__3822__auto____6815
    }
  }()) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll)
  }else {
    var x__2363__auto____6816 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6817 = cljs.core._drop_first[goog.typeOf(x__2363__auto____6816)];
      if(or__3824__auto____6817) {
        return or__3824__auto____6817
      }else {
        var or__3824__auto____6818 = cljs.core._drop_first["_"];
        if(or__3824__auto____6818) {
          return or__3824__auto____6818
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunk.-drop-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IChunkedSeq = {};
cljs.core._chunked_first = function _chunked_first(coll) {
  if(function() {
    var and__3822__auto____6823 = coll;
    if(and__3822__auto____6823) {
      return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1
    }else {
      return and__3822__auto____6823
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll)
  }else {
    var x__2363__auto____6824 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6825 = cljs.core._chunked_first[goog.typeOf(x__2363__auto____6824)];
      if(or__3824__auto____6825) {
        return or__3824__auto____6825
      }else {
        var or__3824__auto____6826 = cljs.core._chunked_first["_"];
        if(or__3824__auto____6826) {
          return or__3824__auto____6826
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunkedSeq.-chunked-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._chunked_rest = function _chunked_rest(coll) {
  if(function() {
    var and__3822__auto____6831 = coll;
    if(and__3822__auto____6831) {
      return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1
    }else {
      return and__3822__auto____6831
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll)
  }else {
    var x__2363__auto____6832 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6833 = cljs.core._chunked_rest[goog.typeOf(x__2363__auto____6832)];
      if(or__3824__auto____6833) {
        return or__3824__auto____6833
      }else {
        var or__3824__auto____6834 = cljs.core._chunked_rest["_"];
        if(or__3824__auto____6834) {
          return or__3824__auto____6834
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunkedSeq.-chunked-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IChunkedNext = {};
cljs.core._chunked_next = function _chunked_next(coll) {
  if(function() {
    var and__3822__auto____6839 = coll;
    if(and__3822__auto____6839) {
      return coll.cljs$core$IChunkedNext$_chunked_next$arity$1
    }else {
      return and__3822__auto____6839
    }
  }()) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll)
  }else {
    var x__2363__auto____6840 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6841 = cljs.core._chunked_next[goog.typeOf(x__2363__auto____6840)];
      if(or__3824__auto____6841) {
        return or__3824__auto____6841
      }else {
        var or__3824__auto____6842 = cljs.core._chunked_next["_"];
        if(or__3824__auto____6842) {
          return or__3824__auto____6842
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunkedNext.-chunked-next", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3824__auto____6844 = x === y;
    if(or__3824__auto____6844) {
      return or__3824__auto____6844
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__6845__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.next.call(null, more)) {
            var G__6846 = y;
            var G__6847 = cljs.core.first.call(null, more);
            var G__6848 = cljs.core.next.call(null, more);
            x = G__6846;
            y = G__6847;
            more = G__6848;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__6845 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__6845__delegate.call(this, x, y, more)
    };
    G__6845.cljs$lang$maxFixedArity = 2;
    G__6845.cljs$lang$applyTo = function(arglist__6849) {
      var x = cljs.core.first(arglist__6849);
      var y = cljs.core.first(cljs.core.next(arglist__6849));
      var more = cljs.core.rest(cljs.core.next(arglist__6849));
      return G__6845__delegate(x, y, more)
    };
    G__6845.cljs$lang$arity$variadic = G__6845__delegate;
    return G__6845
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(x == null) {
    return null
  }else {
    return x.constructor
  }
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o instanceof t
};
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__6850 = null;
  var G__6850__2 = function(o, k) {
    return null
  };
  var G__6850__3 = function(o, k, not_found) {
    return not_found
  };
  G__6850 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6850__2.call(this, o, k);
      case 3:
        return G__6850__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6850
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.INext["null"] = true;
cljs.core._next["null"] = function(_) {
  return null
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__6851 = null;
  var G__6851__2 = function(_, f) {
    return f.call(null)
  };
  var G__6851__3 = function(_, f, start) {
    return start
  };
  G__6851 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__6851__2.call(this, _, f);
      case 3:
        return G__6851__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6851
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__6852 = null;
  var G__6852__2 = function(_, n) {
    return null
  };
  var G__6852__3 = function(_, n, not_found) {
    return not_found
  };
  G__6852 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6852__2.call(this, _, n);
      case 3:
        return G__6852__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6852
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var and__3822__auto____6853 = cljs.core.instance_QMARK_.call(null, Date, other);
  if(and__3822__auto____6853) {
    return o.toString() === other.toString()
  }else {
    return and__3822__auto____6853
  }
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  if(o === true) {
    return 1
  }else {
    return 0
  }
};
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  return goog.getUid(o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    var cnt__6866 = cljs.core._count.call(null, cicoll);
    if(cnt__6866 === 0) {
      return f.call(null)
    }else {
      var val__6867 = cljs.core._nth.call(null, cicoll, 0);
      var n__6868 = 1;
      while(true) {
        if(n__6868 < cnt__6866) {
          var nval__6869 = f.call(null, val__6867, cljs.core._nth.call(null, cicoll, n__6868));
          if(cljs.core.reduced_QMARK_.call(null, nval__6869)) {
            return cljs.core.deref.call(null, nval__6869)
          }else {
            var G__6878 = nval__6869;
            var G__6879 = n__6868 + 1;
            val__6867 = G__6878;
            n__6868 = G__6879;
            continue
          }
        }else {
          return val__6867
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var cnt__6870 = cljs.core._count.call(null, cicoll);
    var val__6871 = val;
    var n__6872 = 0;
    while(true) {
      if(n__6872 < cnt__6870) {
        var nval__6873 = f.call(null, val__6871, cljs.core._nth.call(null, cicoll, n__6872));
        if(cljs.core.reduced_QMARK_.call(null, nval__6873)) {
          return cljs.core.deref.call(null, nval__6873)
        }else {
          var G__6880 = nval__6873;
          var G__6881 = n__6872 + 1;
          val__6871 = G__6880;
          n__6872 = G__6881;
          continue
        }
      }else {
        return val__6871
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var cnt__6874 = cljs.core._count.call(null, cicoll);
    var val__6875 = val;
    var n__6876 = idx;
    while(true) {
      if(n__6876 < cnt__6874) {
        var nval__6877 = f.call(null, val__6875, cljs.core._nth.call(null, cicoll, n__6876));
        if(cljs.core.reduced_QMARK_.call(null, nval__6877)) {
          return cljs.core.deref.call(null, nval__6877)
        }else {
          var G__6882 = nval__6877;
          var G__6883 = n__6876 + 1;
          val__6875 = G__6882;
          n__6876 = G__6883;
          continue
        }
      }else {
        return val__6875
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
cljs.core.array_reduce = function() {
  var array_reduce = null;
  var array_reduce__2 = function(arr, f) {
    var cnt__6896 = arr.length;
    if(arr.length === 0) {
      return f.call(null)
    }else {
      var val__6897 = arr[0];
      var n__6898 = 1;
      while(true) {
        if(n__6898 < cnt__6896) {
          var nval__6899 = f.call(null, val__6897, arr[n__6898]);
          if(cljs.core.reduced_QMARK_.call(null, nval__6899)) {
            return cljs.core.deref.call(null, nval__6899)
          }else {
            var G__6908 = nval__6899;
            var G__6909 = n__6898 + 1;
            val__6897 = G__6908;
            n__6898 = G__6909;
            continue
          }
        }else {
          return val__6897
        }
        break
      }
    }
  };
  var array_reduce__3 = function(arr, f, val) {
    var cnt__6900 = arr.length;
    var val__6901 = val;
    var n__6902 = 0;
    while(true) {
      if(n__6902 < cnt__6900) {
        var nval__6903 = f.call(null, val__6901, arr[n__6902]);
        if(cljs.core.reduced_QMARK_.call(null, nval__6903)) {
          return cljs.core.deref.call(null, nval__6903)
        }else {
          var G__6910 = nval__6903;
          var G__6911 = n__6902 + 1;
          val__6901 = G__6910;
          n__6902 = G__6911;
          continue
        }
      }else {
        return val__6901
      }
      break
    }
  };
  var array_reduce__4 = function(arr, f, val, idx) {
    var cnt__6904 = arr.length;
    var val__6905 = val;
    var n__6906 = idx;
    while(true) {
      if(n__6906 < cnt__6904) {
        var nval__6907 = f.call(null, val__6905, arr[n__6906]);
        if(cljs.core.reduced_QMARK_.call(null, nval__6907)) {
          return cljs.core.deref.call(null, nval__6907)
        }else {
          var G__6912 = nval__6907;
          var G__6913 = n__6906 + 1;
          val__6905 = G__6912;
          n__6906 = G__6913;
          continue
        }
      }else {
        return val__6905
      }
      break
    }
  };
  array_reduce = function(arr, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return array_reduce__2.call(this, arr, f);
      case 3:
        return array_reduce__3.call(this, arr, f, val);
      case 4:
        return array_reduce__4.call(this, arr, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_reduce.cljs$lang$arity$2 = array_reduce__2;
  array_reduce.cljs$lang$arity$3 = array_reduce__3;
  array_reduce.cljs$lang$arity$4 = array_reduce__4;
  return array_reduce
}();
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 166199546
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6914 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var this__6915 = this;
  if(this__6915.i + 1 < this__6915.a.length) {
    return new cljs.core.IndexedSeq(this__6915.a, this__6915.i + 1)
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6916 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__6917 = this;
  var c__6918 = coll.cljs$core$ICounted$_count$arity$1(coll);
  if(c__6918 > 0) {
    return new cljs.core.RSeq(coll, c__6918 - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__6919 = this;
  var this__6920 = this;
  return cljs.core.pr_str.call(null, this__6920)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__6921 = this;
  if(cljs.core.counted_QMARK_.call(null, this__6921.a)) {
    return cljs.core.ci_reduce.call(null, this__6921.a, f, this__6921.a[this__6921.i], this__6921.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__6921.a[this__6921.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__6922 = this;
  if(cljs.core.counted_QMARK_.call(null, this__6922.a)) {
    return cljs.core.ci_reduce.call(null, this__6922.a, f, start, this__6922.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__6923 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__6924 = this;
  return this__6924.a.length - this__6924.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__6925 = this;
  return this__6925.a[this__6925.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__6926 = this;
  if(this__6926.i + 1 < this__6926.a.length) {
    return new cljs.core.IndexedSeq(this__6926.a, this__6926.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6927 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__6928 = this;
  var i__6929 = n + this__6928.i;
  if(i__6929 < this__6928.a.length) {
    return this__6928.a[i__6929]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__6930 = this;
  var i__6931 = n + this__6930.i;
  if(i__6931 < this__6930.a.length) {
    return this__6930.a[i__6931]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__6932 = null;
  var G__6932__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__6932__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__6932 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__6932__2.call(this, array, f);
      case 3:
        return G__6932__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6932
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__6933 = null;
  var G__6933__2 = function(array, k) {
    return array[k]
  };
  var G__6933__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__6933 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6933__2.call(this, array, k);
      case 3:
        return G__6933__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6933
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__6934 = null;
  var G__6934__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__6934__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__6934 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6934__2.call(this, array, n);
      case 3:
        return G__6934__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__6934
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850570
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/RSeq")
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__6935 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__6936 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.RSeq.prototype.toString = function() {
  var this__6937 = this;
  var this__6938 = this;
  return cljs.core.pr_str.call(null, this__6938)
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__6939 = this;
  return coll
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__6940 = this;
  return this__6940.i + 1
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__6941 = this;
  return cljs.core._nth.call(null, this__6941.ci, this__6941.i)
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__6942 = this;
  if(this__6942.i > 0) {
    return new cljs.core.RSeq(this__6942.ci, this__6942.i - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__6943 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var this__6944 = this;
  return new cljs.core.RSeq(this__6944.ci, this__6944.i, new_meta)
};
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__6945 = this;
  return this__6945.meta
};
cljs.core.RSeq;
cljs.core.seq = function seq(coll) {
  if(coll == null) {
    return null
  }else {
    if(function() {
      var G__6949__6950 = coll;
      if(G__6949__6950) {
        if(function() {
          var or__3824__auto____6951 = G__6949__6950.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3824__auto____6951) {
            return or__3824__auto____6951
          }else {
            return G__6949__6950.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__6949__6950.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__6949__6950)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__6949__6950)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }
};
cljs.core.first = function first(coll) {
  if(coll == null) {
    return null
  }else {
    if(function() {
      var G__6956__6957 = coll;
      if(G__6956__6957) {
        if(function() {
          var or__3824__auto____6958 = G__6956__6957.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3824__auto____6958) {
            return or__3824__auto____6958
          }else {
            return G__6956__6957.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__6956__6957.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__6956__6957)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__6956__6957)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__6959 = cljs.core.seq.call(null, coll);
      if(s__6959 == null) {
        return null
      }else {
        return cljs.core._first.call(null, s__6959)
      }
    }
  }
};
cljs.core.rest = function rest(coll) {
  if(!(coll == null)) {
    if(function() {
      var G__6964__6965 = coll;
      if(G__6964__6965) {
        if(function() {
          var or__3824__auto____6966 = G__6964__6965.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3824__auto____6966) {
            return or__3824__auto____6966
          }else {
            return G__6964__6965.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__6964__6965.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__6964__6965)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__6964__6965)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__6967 = cljs.core.seq.call(null, coll);
      if(!(s__6967 == null)) {
        return cljs.core._rest.call(null, s__6967)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll == null) {
    return null
  }else {
    if(function() {
      var G__6971__6972 = coll;
      if(G__6971__6972) {
        if(function() {
          var or__3824__auto____6973 = G__6971__6972.cljs$lang$protocol_mask$partition0$ & 128;
          if(or__3824__auto____6973) {
            return or__3824__auto____6973
          }else {
            return G__6971__6972.cljs$core$INext$
          }
        }()) {
          return true
        }else {
          if(!G__6971__6972.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.INext, G__6971__6972)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.INext, G__6971__6972)
      }
    }()) {
      return cljs.core._next.call(null, coll)
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    var sn__6975 = cljs.core.next.call(null, s);
    if(!(sn__6975 == null)) {
      var G__6976 = sn__6975;
      s = G__6976;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__6977__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__6978 = conj.call(null, coll, x);
          var G__6979 = cljs.core.first.call(null, xs);
          var G__6980 = cljs.core.next.call(null, xs);
          coll = G__6978;
          x = G__6979;
          xs = G__6980;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__6977 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__6977__delegate.call(this, coll, x, xs)
    };
    G__6977.cljs$lang$maxFixedArity = 2;
    G__6977.cljs$lang$applyTo = function(arglist__6981) {
      var coll = cljs.core.first(arglist__6981);
      var x = cljs.core.first(cljs.core.next(arglist__6981));
      var xs = cljs.core.rest(cljs.core.next(arglist__6981));
      return G__6977__delegate(coll, x, xs)
    };
    G__6977.cljs$lang$arity$variadic = G__6977__delegate;
    return G__6977
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__6984 = cljs.core.seq.call(null, coll);
  var acc__6985 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__6984)) {
      return acc__6985 + cljs.core._count.call(null, s__6984)
    }else {
      var G__6986 = cljs.core.next.call(null, s__6984);
      var G__6987 = acc__6985 + 1;
      s__6984 = G__6986;
      acc__6985 = G__6987;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.seq.call(null, coll)) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.seq.call(null, coll)) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.seq.call(null, coll)) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.seq.call(null, coll)) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll == null) {
      return null
    }else {
      if(function() {
        var G__6994__6995 = coll;
        if(G__6994__6995) {
          if(function() {
            var or__3824__auto____6996 = G__6994__6995.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3824__auto____6996) {
              return or__3824__auto____6996
            }else {
              return G__6994__6995.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__6994__6995.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__6994__6995)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__6994__6995)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(!(coll == null)) {
      if(function() {
        var G__6997__6998 = coll;
        if(G__6997__6998) {
          if(function() {
            var or__3824__auto____6999 = G__6997__6998.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3824__auto____6999) {
              return or__3824__auto____6999
            }else {
              return G__6997__6998.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__6997__6998.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__6997__6998)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__6997__6998)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__7002__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__7001 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__7003 = ret__7001;
          var G__7004 = cljs.core.first.call(null, kvs);
          var G__7005 = cljs.core.second.call(null, kvs);
          var G__7006 = cljs.core.nnext.call(null, kvs);
          coll = G__7003;
          k = G__7004;
          v = G__7005;
          kvs = G__7006;
          continue
        }else {
          return ret__7001
        }
        break
      }
    };
    var G__7002 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7002__delegate.call(this, coll, k, v, kvs)
    };
    G__7002.cljs$lang$maxFixedArity = 3;
    G__7002.cljs$lang$applyTo = function(arglist__7007) {
      var coll = cljs.core.first(arglist__7007);
      var k = cljs.core.first(cljs.core.next(arglist__7007));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7007)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7007)));
      return G__7002__delegate(coll, k, v, kvs)
    };
    G__7002.cljs$lang$arity$variadic = G__7002__delegate;
    return G__7002
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__7010__delegate = function(coll, k, ks) {
      while(true) {
        var ret__7009 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__7011 = ret__7009;
          var G__7012 = cljs.core.first.call(null, ks);
          var G__7013 = cljs.core.next.call(null, ks);
          coll = G__7011;
          k = G__7012;
          ks = G__7013;
          continue
        }else {
          return ret__7009
        }
        break
      }
    };
    var G__7010 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7010__delegate.call(this, coll, k, ks)
    };
    G__7010.cljs$lang$maxFixedArity = 2;
    G__7010.cljs$lang$applyTo = function(arglist__7014) {
      var coll = cljs.core.first(arglist__7014);
      var k = cljs.core.first(cljs.core.next(arglist__7014));
      var ks = cljs.core.rest(cljs.core.next(arglist__7014));
      return G__7010__delegate(coll, k, ks)
    };
    G__7010.cljs$lang$arity$variadic = G__7010__delegate;
    return G__7010
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__7018__7019 = o;
    if(G__7018__7019) {
      if(function() {
        var or__3824__auto____7020 = G__7018__7019.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3824__auto____7020) {
          return or__3824__auto____7020
        }else {
          return G__7018__7019.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7018__7019.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7018__7019)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7018__7019)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__7023__delegate = function(coll, k, ks) {
      while(true) {
        var ret__7022 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__7024 = ret__7022;
          var G__7025 = cljs.core.first.call(null, ks);
          var G__7026 = cljs.core.next.call(null, ks);
          coll = G__7024;
          k = G__7025;
          ks = G__7026;
          continue
        }else {
          return ret__7022
        }
        break
      }
    };
    var G__7023 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7023__delegate.call(this, coll, k, ks)
    };
    G__7023.cljs$lang$maxFixedArity = 2;
    G__7023.cljs$lang$applyTo = function(arglist__7027) {
      var coll = cljs.core.first(arglist__7027);
      var k = cljs.core.first(cljs.core.next(arglist__7027));
      var ks = cljs.core.rest(cljs.core.next(arglist__7027));
      return G__7023__delegate(coll, k, ks)
    };
    G__7023.cljs$lang$arity$variadic = G__7023__delegate;
    return G__7023
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = 0;
cljs.core.add_to_string_hash_cache = function add_to_string_hash_cache(k) {
  var h__7029 = goog.string.hashCode(k);
  cljs.core.string_hash_cache[k] = h__7029;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h__7029
};
cljs.core.check_string_hash_cache = function check_string_hash_cache(k) {
  if(cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = {};
    cljs.core.string_hash_cache_count = 0
  }else {
  }
  var h__7031 = cljs.core.string_hash_cache[k];
  if(!(h__7031 == null)) {
    return h__7031
  }else {
    return cljs.core.add_to_string_hash_cache.call(null, k)
  }
};
cljs.core.hash = function() {
  var hash = null;
  var hash__1 = function(o) {
    return hash.call(null, o, true)
  };
  var hash__2 = function(o, check_cache) {
    if(function() {
      var and__3822__auto____7033 = goog.isString(o);
      if(and__3822__auto____7033) {
        return check_cache
      }else {
        return and__3822__auto____7033
      }
    }()) {
      return cljs.core.check_string_hash_cache.call(null, o)
    }else {
      return cljs.core._hash.call(null, o)
    }
  };
  hash = function(o, check_cache) {
    switch(arguments.length) {
      case 1:
        return hash__1.call(this, o);
      case 2:
        return hash__2.call(this, o, check_cache)
    }
    throw"Invalid arity: " + arguments.length;
  };
  hash.cljs$lang$arity$1 = hash__1;
  hash.cljs$lang$arity$2 = hash__2;
  return hash
}();
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__7037__7038 = x;
    if(G__7037__7038) {
      if(function() {
        var or__3824__auto____7039 = G__7037__7038.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3824__auto____7039) {
          return or__3824__auto____7039
        }else {
          return G__7037__7038.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__7037__7038.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__7037__7038)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__7037__7038)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__7043__7044 = x;
    if(G__7043__7044) {
      if(function() {
        var or__3824__auto____7045 = G__7043__7044.cljs$lang$protocol_mask$partition0$ & 4096;
        if(or__3824__auto____7045) {
          return or__3824__auto____7045
        }else {
          return G__7043__7044.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__7043__7044.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__7043__7044)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__7043__7044)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__7049__7050 = x;
  if(G__7049__7050) {
    if(function() {
      var or__3824__auto____7051 = G__7049__7050.cljs$lang$protocol_mask$partition0$ & 512;
      if(or__3824__auto____7051) {
        return or__3824__auto____7051
      }else {
        return G__7049__7050.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__7049__7050.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__7049__7050)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__7049__7050)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__7055__7056 = x;
  if(G__7055__7056) {
    if(function() {
      var or__3824__auto____7057 = G__7055__7056.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3824__auto____7057) {
        return or__3824__auto____7057
      }else {
        return G__7055__7056.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__7055__7056.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__7055__7056)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__7055__7056)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__7061__7062 = x;
  if(G__7061__7062) {
    if(function() {
      var or__3824__auto____7063 = G__7061__7062.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3824__auto____7063) {
        return or__3824__auto____7063
      }else {
        return G__7061__7062.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__7061__7062.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__7061__7062)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__7061__7062)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__7067__7068 = x;
  if(G__7067__7068) {
    if(function() {
      var or__3824__auto____7069 = G__7067__7068.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3824__auto____7069) {
        return or__3824__auto____7069
      }else {
        return G__7067__7068.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__7067__7068.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__7067__7068)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__7067__7068)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__7073__7074 = x;
  if(G__7073__7074) {
    if(function() {
      var or__3824__auto____7075 = G__7073__7074.cljs$lang$protocol_mask$partition0$ & 524288;
      if(or__3824__auto____7075) {
        return or__3824__auto____7075
      }else {
        return G__7073__7074.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__7073__7074.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7073__7074)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7073__7074)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__7079__7080 = x;
    if(G__7079__7080) {
      if(function() {
        var or__3824__auto____7081 = G__7079__7080.cljs$lang$protocol_mask$partition0$ & 1024;
        if(or__3824__auto____7081) {
          return or__3824__auto____7081
        }else {
          return G__7079__7080.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__7079__7080.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__7079__7080)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__7079__7080)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__7085__7086 = x;
  if(G__7085__7086) {
    if(function() {
      var or__3824__auto____7087 = G__7085__7086.cljs$lang$protocol_mask$partition0$ & 16384;
      if(or__3824__auto____7087) {
        return or__3824__auto____7087
      }else {
        return G__7085__7086.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__7085__7086.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__7085__7086)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__7085__7086)
  }
};
cljs.core.chunked_seq_QMARK_ = function chunked_seq_QMARK_(x) {
  var G__7091__7092 = x;
  if(G__7091__7092) {
    if(cljs.core.truth_(function() {
      var or__3824__auto____7093 = null;
      if(cljs.core.truth_(or__3824__auto____7093)) {
        return or__3824__auto____7093
      }else {
        return G__7091__7092.cljs$core$IChunkedSeq$
      }
    }())) {
      return true
    }else {
      if(!G__7091__7092.cljs$lang$protocol_mask$partition$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedSeq, G__7091__7092)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedSeq, G__7091__7092)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__7094__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__7094 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__7094__delegate.call(this, keyvals)
    };
    G__7094.cljs$lang$maxFixedArity = 0;
    G__7094.cljs$lang$applyTo = function(arglist__7095) {
      var keyvals = cljs.core.seq(arglist__7095);
      return G__7094__delegate(keyvals)
    };
    G__7094.cljs$lang$arity$variadic = G__7094__delegate;
    return G__7094
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(cljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__7097 = [];
  goog.object.forEach(obj, function(val, key, obj) {
    return keys__7097.push(key)
  });
  return keys__7097
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__7101 = i;
  var j__7102 = j;
  var len__7103 = len;
  while(true) {
    if(len__7103 === 0) {
      return to
    }else {
      to[j__7102] = from[i__7101];
      var G__7104 = i__7101 + 1;
      var G__7105 = j__7102 + 1;
      var G__7106 = len__7103 - 1;
      i__7101 = G__7104;
      j__7102 = G__7105;
      len__7103 = G__7106;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__7110 = i + (len - 1);
  var j__7111 = j + (len - 1);
  var len__7112 = len;
  while(true) {
    if(len__7112 === 0) {
      return to
    }else {
      to[j__7111] = from[i__7110];
      var G__7113 = i__7110 - 1;
      var G__7114 = j__7111 - 1;
      var G__7115 = len__7112 - 1;
      i__7110 = G__7113;
      j__7111 = G__7114;
      len__7112 = G__7115;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__7119__7120 = s;
    if(G__7119__7120) {
      if(function() {
        var or__3824__auto____7121 = G__7119__7120.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3824__auto____7121) {
          return or__3824__auto____7121
        }else {
          return G__7119__7120.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__7119__7120.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7119__7120)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7119__7120)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__7125__7126 = s;
  if(G__7125__7126) {
    if(function() {
      var or__3824__auto____7127 = G__7125__7126.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3824__auto____7127) {
        return or__3824__auto____7127
      }else {
        return G__7125__7126.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__7125__7126.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__7125__7126)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__7125__7126)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3822__auto____7130 = goog.isString(x);
  if(and__3822__auto____7130) {
    return!function() {
      var or__3824__auto____7131 = x.charAt(0) === "\ufdd0";
      if(or__3824__auto____7131) {
        return or__3824__auto____7131
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }()
  }else {
    return and__3822__auto____7130
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3822__auto____7133 = goog.isString(x);
  if(and__3822__auto____7133) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3822__auto____7133
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3822__auto____7135 = goog.isString(x);
  if(and__3822__auto____7135) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3822__auto____7135
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber(n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction(f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3824__auto____7140 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3824__auto____7140) {
    return or__3824__auto____7140
  }else {
    var G__7141__7142 = f;
    if(G__7141__7142) {
      if(function() {
        var or__3824__auto____7143 = G__7141__7142.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3824__auto____7143) {
          return or__3824__auto____7143
        }else {
          return G__7141__7142.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__7141__7142.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__7141__7142)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__7141__7142)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3822__auto____7145 = cljs.core.number_QMARK_.call(null, n);
  if(and__3822__auto____7145) {
    return n == n.toFixed()
  }else {
    return and__3822__auto____7145
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3822__auto____7148 = coll;
    if(cljs.core.truth_(and__3822__auto____7148)) {
      var and__3822__auto____7149 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3822__auto____7149) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3822__auto____7149
      }
    }else {
      return and__3822__auto____7148
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)], true)
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return!cljs.core._EQ_.call(null, x, y)
  };
  var distinct_QMARK___3 = function() {
    var G__7158__delegate = function(x, y, more) {
      if(!cljs.core._EQ_.call(null, x, y)) {
        var s__7154 = cljs.core.PersistentHashSet.fromArray([y, x]);
        var xs__7155 = more;
        while(true) {
          var x__7156 = cljs.core.first.call(null, xs__7155);
          var etc__7157 = cljs.core.next.call(null, xs__7155);
          if(cljs.core.truth_(xs__7155)) {
            if(cljs.core.contains_QMARK_.call(null, s__7154, x__7156)) {
              return false
            }else {
              var G__7159 = cljs.core.conj.call(null, s__7154, x__7156);
              var G__7160 = etc__7157;
              s__7154 = G__7159;
              xs__7155 = G__7160;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__7158 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7158__delegate.call(this, x, y, more)
    };
    G__7158.cljs$lang$maxFixedArity = 2;
    G__7158.cljs$lang$applyTo = function(arglist__7161) {
      var x = cljs.core.first(arglist__7161);
      var y = cljs.core.first(cljs.core.next(arglist__7161));
      var more = cljs.core.rest(cljs.core.next(arglist__7161));
      return G__7158__delegate(x, y, more)
    };
    G__7158.cljs$lang$arity$variadic = G__7158__delegate;
    return G__7158
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(x === y) {
    return 0
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
          if(function() {
            var G__7165__7166 = x;
            if(G__7165__7166) {
              if(cljs.core.truth_(function() {
                var or__3824__auto____7167 = null;
                if(cljs.core.truth_(or__3824__auto____7167)) {
                  return or__3824__auto____7167
                }else {
                  return G__7165__7166.cljs$core$IComparable$
                }
              }())) {
                return true
              }else {
                if(!G__7165__7166.cljs$lang$protocol_mask$partition$) {
                  return cljs.core.type_satisfies_.call(null, cljs.core.IComparable, G__7165__7166)
                }else {
                  return false
                }
              }
            }else {
              return cljs.core.type_satisfies_.call(null, cljs.core.IComparable, G__7165__7166)
            }
          }()) {
            return cljs.core._compare.call(null, x, y)
          }else {
            return goog.array.defaultCompare(x, y)
          }
        }else {
          if("\ufdd0'else") {
            throw new Error("compare on non-nil objects of different types");
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function() {
  var compare_indexed = null;
  var compare_indexed__2 = function(xs, ys) {
    var xl__7172 = cljs.core.count.call(null, xs);
    var yl__7173 = cljs.core.count.call(null, ys);
    if(xl__7172 < yl__7173) {
      return-1
    }else {
      if(xl__7172 > yl__7173) {
        return 1
      }else {
        if("\ufdd0'else") {
          return compare_indexed.call(null, xs, ys, xl__7172, 0)
        }else {
          return null
        }
      }
    }
  };
  var compare_indexed__4 = function(xs, ys, len, n) {
    while(true) {
      var d__7174 = cljs.core.compare.call(null, cljs.core.nth.call(null, xs, n), cljs.core.nth.call(null, ys, n));
      if(function() {
        var and__3822__auto____7175 = d__7174 === 0;
        if(and__3822__auto____7175) {
          return n + 1 < len
        }else {
          return and__3822__auto____7175
        }
      }()) {
        var G__7176 = xs;
        var G__7177 = ys;
        var G__7178 = len;
        var G__7179 = n + 1;
        xs = G__7176;
        ys = G__7177;
        len = G__7178;
        n = G__7179;
        continue
      }else {
        return d__7174
      }
      break
    }
  };
  compare_indexed = function(xs, ys, len, n) {
    switch(arguments.length) {
      case 2:
        return compare_indexed__2.call(this, xs, ys);
      case 4:
        return compare_indexed__4.call(this, xs, ys, len, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  compare_indexed.cljs$lang$arity$2 = compare_indexed__2;
  compare_indexed.cljs$lang$arity$4 = compare_indexed__4;
  return compare_indexed
}();
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__7181 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__7181)) {
        return r__7181
      }else {
        if(cljs.core.truth_(r__7181)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.seq.call(null, coll)) {
      var a__7183 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort(a__7183, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__7183)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3971__auto____7189 = cljs.core.seq.call(null, coll);
    if(temp__3971__auto____7189) {
      var s__7190 = temp__3971__auto____7189;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__7190), cljs.core.next.call(null, s__7190))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__7191 = val;
    var coll__7192 = cljs.core.seq.call(null, coll);
    while(true) {
      if(coll__7192) {
        var nval__7193 = f.call(null, val__7191, cljs.core.first.call(null, coll__7192));
        if(cljs.core.reduced_QMARK_.call(null, nval__7193)) {
          return cljs.core.deref.call(null, nval__7193)
        }else {
          var G__7194 = nval__7193;
          var G__7195 = cljs.core.next.call(null, coll__7192);
          val__7191 = G__7194;
          coll__7192 = G__7195;
          continue
        }
      }else {
        return val__7191
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.shuffle = function shuffle(coll) {
  var a__7197 = cljs.core.to_array.call(null, coll);
  goog.array.shuffle(a__7197);
  return cljs.core.vec.call(null, a__7197)
};
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__7204__7205 = coll;
      if(G__7204__7205) {
        if(function() {
          var or__3824__auto____7206 = G__7204__7205.cljs$lang$protocol_mask$partition0$ & 524288;
          if(or__3824__auto____7206) {
            return or__3824__auto____7206
          }else {
            return G__7204__7205.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__7204__7205.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7204__7205)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7204__7205)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__7207__7208 = coll;
      if(G__7207__7208) {
        if(function() {
          var or__3824__auto____7209 = G__7207__7208.cljs$lang$protocol_mask$partition0$ & 524288;
          if(or__3824__auto____7209) {
            return or__3824__auto____7209
          }else {
            return G__7207__7208.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__7207__7208.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7207__7208)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7207__7208)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32768
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__7210 = this;
  return this__7210.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__7211__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__7211 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7211__delegate.call(this, x, y, more)
    };
    G__7211.cljs$lang$maxFixedArity = 2;
    G__7211.cljs$lang$applyTo = function(arglist__7212) {
      var x = cljs.core.first(arglist__7212);
      var y = cljs.core.first(cljs.core.next(arglist__7212));
      var more = cljs.core.rest(cljs.core.next(arglist__7212));
      return G__7211__delegate(x, y, more)
    };
    G__7211.cljs$lang$arity$variadic = G__7211__delegate;
    return G__7211
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__7213__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__7213 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7213__delegate.call(this, x, y, more)
    };
    G__7213.cljs$lang$maxFixedArity = 2;
    G__7213.cljs$lang$applyTo = function(arglist__7214) {
      var x = cljs.core.first(arglist__7214);
      var y = cljs.core.first(cljs.core.next(arglist__7214));
      var more = cljs.core.rest(cljs.core.next(arglist__7214));
      return G__7213__delegate(x, y, more)
    };
    G__7213.cljs$lang$arity$variadic = G__7213__delegate;
    return G__7213
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__7215__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__7215 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7215__delegate.call(this, x, y, more)
    };
    G__7215.cljs$lang$maxFixedArity = 2;
    G__7215.cljs$lang$applyTo = function(arglist__7216) {
      var x = cljs.core.first(arglist__7216);
      var y = cljs.core.first(cljs.core.next(arglist__7216));
      var more = cljs.core.rest(cljs.core.next(arglist__7216));
      return G__7215__delegate(x, y, more)
    };
    G__7215.cljs$lang$arity$variadic = G__7215__delegate;
    return G__7215
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__7217__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__7217 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7217__delegate.call(this, x, y, more)
    };
    G__7217.cljs$lang$maxFixedArity = 2;
    G__7217.cljs$lang$applyTo = function(arglist__7218) {
      var x = cljs.core.first(arglist__7218);
      var y = cljs.core.first(cljs.core.next(arglist__7218));
      var more = cljs.core.rest(cljs.core.next(arglist__7218));
      return G__7217__delegate(x, y, more)
    };
    G__7217.cljs$lang$arity$variadic = G__7217__delegate;
    return G__7217
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__7219__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.next.call(null, more)) {
            var G__7220 = y;
            var G__7221 = cljs.core.first.call(null, more);
            var G__7222 = cljs.core.next.call(null, more);
            x = G__7220;
            y = G__7221;
            more = G__7222;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7219 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7219__delegate.call(this, x, y, more)
    };
    G__7219.cljs$lang$maxFixedArity = 2;
    G__7219.cljs$lang$applyTo = function(arglist__7223) {
      var x = cljs.core.first(arglist__7223);
      var y = cljs.core.first(cljs.core.next(arglist__7223));
      var more = cljs.core.rest(cljs.core.next(arglist__7223));
      return G__7219__delegate(x, y, more)
    };
    G__7219.cljs$lang$arity$variadic = G__7219__delegate;
    return G__7219
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__7224__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.next.call(null, more)) {
            var G__7225 = y;
            var G__7226 = cljs.core.first.call(null, more);
            var G__7227 = cljs.core.next.call(null, more);
            x = G__7225;
            y = G__7226;
            more = G__7227;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7224 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7224__delegate.call(this, x, y, more)
    };
    G__7224.cljs$lang$maxFixedArity = 2;
    G__7224.cljs$lang$applyTo = function(arglist__7228) {
      var x = cljs.core.first(arglist__7228);
      var y = cljs.core.first(cljs.core.next(arglist__7228));
      var more = cljs.core.rest(cljs.core.next(arglist__7228));
      return G__7224__delegate(x, y, more)
    };
    G__7224.cljs$lang$arity$variadic = G__7224__delegate;
    return G__7224
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__7229__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.next.call(null, more)) {
            var G__7230 = y;
            var G__7231 = cljs.core.first.call(null, more);
            var G__7232 = cljs.core.next.call(null, more);
            x = G__7230;
            y = G__7231;
            more = G__7232;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7229 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7229__delegate.call(this, x, y, more)
    };
    G__7229.cljs$lang$maxFixedArity = 2;
    G__7229.cljs$lang$applyTo = function(arglist__7233) {
      var x = cljs.core.first(arglist__7233);
      var y = cljs.core.first(cljs.core.next(arglist__7233));
      var more = cljs.core.rest(cljs.core.next(arglist__7233));
      return G__7229__delegate(x, y, more)
    };
    G__7229.cljs$lang$arity$variadic = G__7229__delegate;
    return G__7229
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__7234__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.next.call(null, more)) {
            var G__7235 = y;
            var G__7236 = cljs.core.first.call(null, more);
            var G__7237 = cljs.core.next.call(null, more);
            x = G__7235;
            y = G__7236;
            more = G__7237;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7234 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7234__delegate.call(this, x, y, more)
    };
    G__7234.cljs$lang$maxFixedArity = 2;
    G__7234.cljs$lang$applyTo = function(arglist__7238) {
      var x = cljs.core.first(arglist__7238);
      var y = cljs.core.first(cljs.core.next(arglist__7238));
      var more = cljs.core.rest(cljs.core.next(arglist__7238));
      return G__7234__delegate(x, y, more)
    };
    G__7234.cljs$lang$arity$variadic = G__7234__delegate;
    return G__7234
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__7239__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__7239 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7239__delegate.call(this, x, y, more)
    };
    G__7239.cljs$lang$maxFixedArity = 2;
    G__7239.cljs$lang$applyTo = function(arglist__7240) {
      var x = cljs.core.first(arglist__7240);
      var y = cljs.core.first(cljs.core.next(arglist__7240));
      var more = cljs.core.rest(cljs.core.next(arglist__7240));
      return G__7239__delegate(x, y, more)
    };
    G__7239.cljs$lang$arity$variadic = G__7239__delegate;
    return G__7239
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__7241__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__7241 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7241__delegate.call(this, x, y, more)
    };
    G__7241.cljs$lang$maxFixedArity = 2;
    G__7241.cljs$lang$applyTo = function(arglist__7242) {
      var x = cljs.core.first(arglist__7242);
      var y = cljs.core.first(cljs.core.next(arglist__7242));
      var more = cljs.core.rest(cljs.core.next(arglist__7242));
      return G__7241__delegate(x, y, more)
    };
    G__7241.cljs$lang$arity$variadic = G__7241__delegate;
    return G__7241
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__7244 = n % d;
  return cljs.core.fix.call(null, (n - rem__7244) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__7246 = cljs.core.quot.call(null, n, d);
  return n - d * q__7246
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(v) {
  var v__7249 = v - (v >> 1 & 1431655765);
  var v__7250 = (v__7249 & 858993459) + (v__7249 >> 2 & 858993459);
  return(v__7250 + (v__7250 >> 4) & 252645135) * 16843009 >> 24
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__7251__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.next.call(null, more)) {
            var G__7252 = y;
            var G__7253 = cljs.core.first.call(null, more);
            var G__7254 = cljs.core.next.call(null, more);
            x = G__7252;
            y = G__7253;
            more = G__7254;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7251 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7251__delegate.call(this, x, y, more)
    };
    G__7251.cljs$lang$maxFixedArity = 2;
    G__7251.cljs$lang$applyTo = function(arglist__7255) {
      var x = cljs.core.first(arglist__7255);
      var y = cljs.core.first(cljs.core.next(arglist__7255));
      var more = cljs.core.rest(cljs.core.next(arglist__7255));
      return G__7251__delegate(x, y, more)
    };
    G__7251.cljs$lang$arity$variadic = G__7251__delegate;
    return G__7251
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__7259 = n;
  var xs__7260 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3822__auto____7261 = xs__7260;
      if(and__3822__auto____7261) {
        return n__7259 > 0
      }else {
        return and__3822__auto____7261
      }
    }())) {
      var G__7262 = n__7259 - 1;
      var G__7263 = cljs.core.next.call(null, xs__7260);
      n__7259 = G__7262;
      xs__7260 = G__7263;
      continue
    }else {
      return xs__7260
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__7264__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__7265 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__7266 = cljs.core.next.call(null, more);
            sb = G__7265;
            more = G__7266;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__7264 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7264__delegate.call(this, x, ys)
    };
    G__7264.cljs$lang$maxFixedArity = 1;
    G__7264.cljs$lang$applyTo = function(arglist__7267) {
      var x = cljs.core.first(arglist__7267);
      var ys = cljs.core.rest(arglist__7267);
      return G__7264__delegate(x, ys)
    };
    G__7264.cljs$lang$arity$variadic = G__7264__delegate;
    return G__7264
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__7268__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__7269 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__7270 = cljs.core.next.call(null, more);
            sb = G__7269;
            more = G__7270;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__7268 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7268__delegate.call(this, x, ys)
    };
    G__7268.cljs$lang$maxFixedArity = 1;
    G__7268.cljs$lang$applyTo = function(arglist__7271) {
      var x = cljs.core.first(arglist__7271);
      var ys = cljs.core.rest(arglist__7271);
      return G__7268__delegate(x, ys)
    };
    G__7268.cljs$lang$arity$variadic = G__7268__delegate;
    return G__7268
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.format = function() {
  var format__delegate = function(fmt, args) {
    return cljs.core.apply.call(null, goog.string.format, fmt, args)
  };
  var format = function(fmt, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return format__delegate.call(this, fmt, args)
  };
  format.cljs$lang$maxFixedArity = 1;
  format.cljs$lang$applyTo = function(arglist__7272) {
    var fmt = cljs.core.first(arglist__7272);
    var args = cljs.core.rest(arglist__7272);
    return format__delegate(fmt, args)
  };
  format.cljs$lang$arity$variadic = format__delegate;
  return format
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__7275 = cljs.core.seq.call(null, x);
    var ys__7276 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__7275 == null) {
        return ys__7276 == null
      }else {
        if(ys__7276 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__7275), cljs.core.first.call(null, ys__7276))) {
            var G__7277 = cljs.core.next.call(null, xs__7275);
            var G__7278 = cljs.core.next.call(null, ys__7276);
            xs__7275 = G__7277;
            ys__7276 = G__7278;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__7279_SHARP_, p2__7280_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__7279_SHARP_, cljs.core.hash.call(null, p2__7280_SHARP_, false))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll), false), cljs.core.next.call(null, coll))
};
cljs.core.hash_imap = function hash_imap(m) {
  var h__7284 = 0;
  var s__7285 = cljs.core.seq.call(null, m);
  while(true) {
    if(s__7285) {
      var e__7286 = cljs.core.first.call(null, s__7285);
      var G__7287 = (h__7284 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__7286)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__7286)))) % 4503599627370496;
      var G__7288 = cljs.core.next.call(null, s__7285);
      h__7284 = G__7287;
      s__7285 = G__7288;
      continue
    }else {
      return h__7284
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__7292 = 0;
  var s__7293 = cljs.core.seq.call(null, s);
  while(true) {
    if(s__7293) {
      var e__7294 = cljs.core.first.call(null, s__7293);
      var G__7295 = (h__7292 + cljs.core.hash.call(null, e__7294)) % 4503599627370496;
      var G__7296 = cljs.core.next.call(null, s__7293);
      h__7292 = G__7295;
      s__7293 = G__7296;
      continue
    }else {
      return h__7292
    }
    break
  }
};
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__7317__7318 = cljs.core.seq.call(null, fn_map);
  if(G__7317__7318) {
    var G__7320__7322 = cljs.core.first.call(null, G__7317__7318);
    var vec__7321__7323 = G__7320__7322;
    var key_name__7324 = cljs.core.nth.call(null, vec__7321__7323, 0, null);
    var f__7325 = cljs.core.nth.call(null, vec__7321__7323, 1, null);
    var G__7317__7326 = G__7317__7318;
    var G__7320__7327 = G__7320__7322;
    var G__7317__7328 = G__7317__7326;
    while(true) {
      var vec__7329__7330 = G__7320__7327;
      var key_name__7331 = cljs.core.nth.call(null, vec__7329__7330, 0, null);
      var f__7332 = cljs.core.nth.call(null, vec__7329__7330, 1, null);
      var G__7317__7333 = G__7317__7328;
      var str_name__7334 = cljs.core.name.call(null, key_name__7331);
      obj[str_name__7334] = f__7332;
      var temp__3974__auto____7335 = cljs.core.next.call(null, G__7317__7333);
      if(temp__3974__auto____7335) {
        var G__7317__7336 = temp__3974__auto____7335;
        var G__7337 = cljs.core.first.call(null, G__7317__7336);
        var G__7338 = G__7317__7336;
        G__7320__7327 = G__7337;
        G__7317__7328 = G__7338;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 65413358
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/List")
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__7339 = this;
  var h__2192__auto____7340 = this__7339.__hash;
  if(!(h__2192__auto____7340 == null)) {
    return h__2192__auto____7340
  }else {
    var h__2192__auto____7341 = cljs.core.hash_coll.call(null, coll);
    this__7339.__hash = h__2192__auto____7341;
    return h__2192__auto____7341
  }
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__7342 = this;
  if(this__7342.count === 1) {
    return null
  }else {
    return this__7342.rest
  }
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__7343 = this;
  return new cljs.core.List(this__7343.meta, o, coll, this__7343.count + 1, null)
};
cljs.core.List.prototype.toString = function() {
  var this__7344 = this;
  var this__7345 = this;
  return cljs.core.pr_str.call(null, this__7345)
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7346 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__7347 = this;
  return this__7347.count
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__7348 = this;
  return this__7348.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__7349 = this;
  return coll.cljs$core$ISeq$_rest$arity$1(coll)
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7350 = this;
  return this__7350.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7351 = this;
  if(this__7351.count === 1) {
    return cljs.core.List.EMPTY
  }else {
    return this__7351.rest
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7352 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__7353 = this;
  return new cljs.core.List(meta, this__7353.first, this__7353.rest, this__7353.count, this__7353.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7354 = this;
  return this__7354.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__7355 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 65413326
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__7356 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__7357 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__7358 = this;
  return new cljs.core.List(this__7358.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__7359 = this;
  var this__7360 = this;
  return cljs.core.pr_str.call(null, this__7360)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7361 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__7362 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__7363 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__7364 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7365 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7366 = this;
  return cljs.core.List.EMPTY
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7367 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__7368 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7369 = this;
  return this__7369.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__7370 = this;
  return coll
};
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__7374__7375 = coll;
  if(G__7374__7375) {
    if(function() {
      var or__3824__auto____7376 = G__7374__7375.cljs$lang$protocol_mask$partition0$ & 134217728;
      if(or__3824__auto____7376) {
        return or__3824__auto____7376
      }else {
        return G__7374__7375.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__7374__7375.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__7374__7375)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__7374__7375)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  if(cljs.core.reversible_QMARK_.call(null, coll)) {
    return cljs.core.rseq.call(null, coll)
  }else {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
  }
};
cljs.core.list = function() {
  var list = null;
  var list__0 = function() {
    return cljs.core.List.EMPTY
  };
  var list__1 = function(x) {
    return cljs.core.conj.call(null, cljs.core.List.EMPTY, x)
  };
  var list__2 = function(x, y) {
    return cljs.core.conj.call(null, list.call(null, y), x)
  };
  var list__3 = function(x, y, z) {
    return cljs.core.conj.call(null, list.call(null, y, z), x)
  };
  var list__4 = function() {
    var G__7377__delegate = function(x, y, z, items) {
      return cljs.core.conj.call(null, cljs.core.conj.call(null, cljs.core.conj.call(null, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items)), z), y), x)
    };
    var G__7377 = function(x, y, z, var_args) {
      var items = null;
      if(goog.isDef(var_args)) {
        items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7377__delegate.call(this, x, y, z, items)
    };
    G__7377.cljs$lang$maxFixedArity = 3;
    G__7377.cljs$lang$applyTo = function(arglist__7378) {
      var x = cljs.core.first(arglist__7378);
      var y = cljs.core.first(cljs.core.next(arglist__7378));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7378)));
      var items = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7378)));
      return G__7377__delegate(x, y, z, items)
    };
    G__7377.cljs$lang$arity$variadic = G__7377__delegate;
    return G__7377
  }();
  list = function(x, y, z, var_args) {
    var items = var_args;
    switch(arguments.length) {
      case 0:
        return list__0.call(this);
      case 1:
        return list__1.call(this, x);
      case 2:
        return list__2.call(this, x, y);
      case 3:
        return list__3.call(this, x, y, z);
      default:
        return list__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list.cljs$lang$maxFixedArity = 3;
  list.cljs$lang$applyTo = list__4.cljs$lang$applyTo;
  list.cljs$lang$arity$0 = list__0;
  list.cljs$lang$arity$1 = list__1;
  list.cljs$lang$arity$2 = list__2;
  list.cljs$lang$arity$3 = list__3;
  list.cljs$lang$arity$variadic = list__4.cljs$lang$arity$variadic;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 65405164
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__7379 = this;
  var h__2192__auto____7380 = this__7379.__hash;
  if(!(h__2192__auto____7380 == null)) {
    return h__2192__auto____7380
  }else {
    var h__2192__auto____7381 = cljs.core.hash_coll.call(null, coll);
    this__7379.__hash = h__2192__auto____7381;
    return h__2192__auto____7381
  }
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__7382 = this;
  if(this__7382.rest == null) {
    return null
  }else {
    return cljs.core._seq.call(null, this__7382.rest)
  }
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__7383 = this;
  return new cljs.core.Cons(null, o, coll, this__7383.__hash)
};
cljs.core.Cons.prototype.toString = function() {
  var this__7384 = this;
  var this__7385 = this;
  return cljs.core.pr_str.call(null, this__7385)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7386 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7387 = this;
  return this__7387.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7388 = this;
  if(this__7388.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__7388.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7389 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__7390 = this;
  return new cljs.core.Cons(meta, this__7390.first, this__7390.rest, this__7390.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7391 = this;
  return this__7391.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__7392 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__7392.meta)
};
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3824__auto____7397 = coll == null;
    if(or__3824__auto____7397) {
      return or__3824__auto____7397
    }else {
      var G__7398__7399 = coll;
      if(G__7398__7399) {
        if(function() {
          var or__3824__auto____7400 = G__7398__7399.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3824__auto____7400) {
            return or__3824__auto____7400
          }else {
            return G__7398__7399.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__7398__7399.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7398__7399)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7398__7399)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__7404__7405 = x;
  if(G__7404__7405) {
    if(function() {
      var or__3824__auto____7406 = G__7404__7405.cljs$lang$protocol_mask$partition0$ & 33554432;
      if(or__3824__auto____7406) {
        return or__3824__auto____7406
      }else {
        return G__7404__7405.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__7404__7405.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__7404__7405)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__7404__7405)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__7407 = null;
  var G__7407__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__7407__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__7407 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__7407__2.call(this, string, f);
      case 3:
        return G__7407__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7407
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__7408 = null;
  var G__7408__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__7408__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__7408 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7408__2.call(this, string, k);
      case 3:
        return G__7408__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7408
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__7409 = null;
  var G__7409__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__7409__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__7409 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7409__2.call(this, string, n);
      case 3:
        return G__7409__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7409
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode(o)
};
cljs.core.Keyword = function(k) {
  this.k = k;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Keyword")
};
cljs.core.Keyword.prototype.call = function() {
  var G__7421 = null;
  var G__7421__2 = function(this_sym7412, coll) {
    var this__7414 = this;
    var this_sym7412__7415 = this;
    var ___7416 = this_sym7412__7415;
    if(coll == null) {
      return null
    }else {
      var strobj__7417 = coll.strobj;
      if(strobj__7417 == null) {
        return cljs.core._lookup.call(null, coll, this__7414.k, null)
      }else {
        return strobj__7417[this__7414.k]
      }
    }
  };
  var G__7421__3 = function(this_sym7413, coll, not_found) {
    var this__7414 = this;
    var this_sym7413__7418 = this;
    var ___7419 = this_sym7413__7418;
    if(coll == null) {
      return not_found
    }else {
      return cljs.core._lookup.call(null, coll, this__7414.k, not_found)
    }
  };
  G__7421 = function(this_sym7413, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7421__2.call(this, this_sym7413, coll);
      case 3:
        return G__7421__3.call(this, this_sym7413, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7421
}();
cljs.core.Keyword.prototype.apply = function(this_sym7410, args7411) {
  var this__7420 = this;
  return this_sym7410.call.apply(this_sym7410, [this_sym7410].concat(args7411.slice()))
};
cljs.core.Keyword;
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__7430 = null;
  var G__7430__2 = function(this_sym7424, coll) {
    var this_sym7424__7426 = this;
    var this__7427 = this_sym7424__7426;
    return cljs.core._lookup.call(null, coll, this__7427.toString(), null)
  };
  var G__7430__3 = function(this_sym7425, coll, not_found) {
    var this_sym7425__7428 = this;
    var this__7429 = this_sym7425__7428;
    return cljs.core._lookup.call(null, coll, this__7429.toString(), not_found)
  };
  G__7430 = function(this_sym7425, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7430__2.call(this, this_sym7425, coll);
      case 3:
        return G__7430__3.call(this, this_sym7425, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7430
}();
String.prototype.apply = function(this_sym7422, args7423) {
  return this_sym7422.call.apply(this_sym7422, [this_sym7422].concat(args7423.slice()))
};
String.prototype.apply = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core._lookup.call(null, args[0], s, null)
  }else {
    return cljs.core._lookup.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__7432 = lazy_seq.x;
  if(lazy_seq.realized) {
    return x__7432
  }else {
    lazy_seq.x = x__7432.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850700
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__7433 = this;
  var h__2192__auto____7434 = this__7433.__hash;
  if(!(h__2192__auto____7434 == null)) {
    return h__2192__auto____7434
  }else {
    var h__2192__auto____7435 = cljs.core.hash_coll.call(null, coll);
    this__7433.__hash = h__2192__auto____7435;
    return h__2192__auto____7435
  }
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__7436 = this;
  return cljs.core._seq.call(null, coll.cljs$core$ISeq$_rest$arity$1(coll))
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__7437 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__7438 = this;
  var this__7439 = this;
  return cljs.core.pr_str.call(null, this__7439)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7440 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7441 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7442 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7443 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__7444 = this;
  return new cljs.core.LazySeq(meta, this__7444.realized, this__7444.x, this__7444.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7445 = this;
  return this__7445.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__7446 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__7446.meta)
};
cljs.core.LazySeq;
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ChunkBuffer")
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__7447 = this;
  return this__7447.end
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var this__7448 = this;
  var ___7449 = this;
  this__7448.buf[this__7448.end] = o;
  return this__7448.end = this__7448.end + 1
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var this__7450 = this;
  var ___7451 = this;
  var ret__7452 = new cljs.core.ArrayChunk(this__7450.buf, 0, this__7450.end);
  this__7450.buf = null;
  return ret__7452
};
cljs.core.ChunkBuffer;
cljs.core.chunk_buffer = function chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(cljs.core.make_array.call(null, capacity), 0)
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 524306
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ArrayChunk")
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__7453 = this;
  return cljs.core.ci_reduce.call(null, coll, f, this__7453.arr[this__7453.off], this__7453.off + 1)
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__7454 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start, this__7454.off)
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var this__7455 = this;
  if(this__7455.off === this__7455.end) {
    throw new Error("-drop-first of empty chunk");
  }else {
    return new cljs.core.ArrayChunk(this__7455.arr, this__7455.off + 1, this__7455.end)
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var this__7456 = this;
  return this__7456.arr[this__7456.off + i]
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var this__7457 = this;
  if(function() {
    var and__3822__auto____7458 = i >= 0;
    if(and__3822__auto____7458) {
      return i < this__7457.end - this__7457.off
    }else {
      return and__3822__auto____7458
    }
  }()) {
    return this__7457.arr[this__7457.off + i]
  }else {
    return not_found
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__7459 = this;
  return this__7459.end - this__7459.off
};
cljs.core.ArrayChunk;
cljs.core.array_chunk = function() {
  var array_chunk = null;
  var array_chunk__1 = function(arr) {
    return array_chunk.call(null, arr, 0, arr.length)
  };
  var array_chunk__2 = function(arr, off) {
    return array_chunk.call(null, arr, off, arr.length)
  };
  var array_chunk__3 = function(arr, off, end) {
    return new cljs.core.ArrayChunk(arr, off, end)
  };
  array_chunk = function(arr, off, end) {
    switch(arguments.length) {
      case 1:
        return array_chunk__1.call(this, arr);
      case 2:
        return array_chunk__2.call(this, arr, off);
      case 3:
        return array_chunk__3.call(this, arr, off, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_chunk.cljs$lang$arity$1 = array_chunk__1;
  array_chunk.cljs$lang$arity$2 = array_chunk__2;
  array_chunk.cljs$lang$arity$3 = array_chunk__3;
  return array_chunk
}();
cljs.core.ChunkedCons = function(chunk, more, meta) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 27656296
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ChunkedCons")
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var this__7460 = this;
  return cljs.core.cons.call(null, o, this$)
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7461 = this;
  return coll
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7462 = this;
  return cljs.core._nth.call(null, this__7462.chunk, 0)
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7463 = this;
  if(cljs.core._count.call(null, this__7463.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first.call(null, this__7463.chunk), this__7463.more, this__7463.meta)
  }else {
    if(this__7463.more == null) {
      return cljs.core.List.EMPTY
    }else {
      return this__7463.more
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var this__7464 = this;
  if(this__7464.more == null) {
    return null
  }else {
    return this__7464.more
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7465 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var this__7466 = this;
  return new cljs.core.ChunkedCons(this__7466.chunk, this__7466.more, m)
};
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7467 = this;
  return this__7467.meta
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var this__7468 = this;
  return this__7468.chunk
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var this__7469 = this;
  if(this__7469.more == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__7469.more
  }
};
cljs.core.ChunkedCons;
cljs.core.chunk_cons = function chunk_cons(chunk, rest) {
  if(cljs.core._count.call(null, chunk) === 0) {
    return rest
  }else {
    return new cljs.core.ChunkedCons(chunk, rest, null)
  }
};
cljs.core.chunk_append = function chunk_append(b, x) {
  return b.add(x)
};
cljs.core.chunk = function chunk(b) {
  return b.chunk()
};
cljs.core.chunk_first = function chunk_first(s) {
  return cljs.core._chunked_first.call(null, s)
};
cljs.core.chunk_rest = function chunk_rest(s) {
  return cljs.core._chunked_rest.call(null, s)
};
cljs.core.chunk_next = function chunk_next(s) {
  if(function() {
    var G__7473__7474 = s;
    if(G__7473__7474) {
      if(cljs.core.truth_(function() {
        var or__3824__auto____7475 = null;
        if(cljs.core.truth_(or__3824__auto____7475)) {
          return or__3824__auto____7475
        }else {
          return G__7473__7474.cljs$core$IChunkedNext$
        }
      }())) {
        return true
      }else {
        if(!G__7473__7474.cljs$lang$protocol_mask$partition$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedNext, G__7473__7474)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedNext, G__7473__7474)
    }
  }()) {
    return cljs.core._chunked_next.call(null, s)
  }else {
    return cljs.core.seq.call(null, cljs.core._chunked_rest.call(null, s))
  }
};
cljs.core.to_array = function to_array(s) {
  var ary__7478 = [];
  var s__7479 = s;
  while(true) {
    if(cljs.core.seq.call(null, s__7479)) {
      ary__7478.push(cljs.core.first.call(null, s__7479));
      var G__7480 = cljs.core.next.call(null, s__7479);
      s__7479 = G__7480;
      continue
    }else {
      return ary__7478
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__7484 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__7485 = 0;
  var xs__7486 = cljs.core.seq.call(null, coll);
  while(true) {
    if(xs__7486) {
      ret__7484[i__7485] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__7486));
      var G__7487 = i__7485 + 1;
      var G__7488 = cljs.core.next.call(null, xs__7486);
      i__7485 = G__7487;
      xs__7486 = G__7488;
      continue
    }else {
    }
    break
  }
  return ret__7484
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__7496 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__7497 = cljs.core.seq.call(null, init_val_or_seq);
      var i__7498 = 0;
      var s__7499 = s__7497;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3822__auto____7500 = s__7499;
          if(and__3822__auto____7500) {
            return i__7498 < size
          }else {
            return and__3822__auto____7500
          }
        }())) {
          a__7496[i__7498] = cljs.core.first.call(null, s__7499);
          var G__7503 = i__7498 + 1;
          var G__7504 = cljs.core.next.call(null, s__7499);
          i__7498 = G__7503;
          s__7499 = G__7504;
          continue
        }else {
          return a__7496
        }
        break
      }
    }else {
      var n__2527__auto____7501 = size;
      var i__7502 = 0;
      while(true) {
        if(i__7502 < n__2527__auto____7501) {
          a__7496[i__7502] = init_val_or_seq;
          var G__7505 = i__7502 + 1;
          i__7502 = G__7505;
          continue
        }else {
        }
        break
      }
      return a__7496
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__7513 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__7514 = cljs.core.seq.call(null, init_val_or_seq);
      var i__7515 = 0;
      var s__7516 = s__7514;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3822__auto____7517 = s__7516;
          if(and__3822__auto____7517) {
            return i__7515 < size
          }else {
            return and__3822__auto____7517
          }
        }())) {
          a__7513[i__7515] = cljs.core.first.call(null, s__7516);
          var G__7520 = i__7515 + 1;
          var G__7521 = cljs.core.next.call(null, s__7516);
          i__7515 = G__7520;
          s__7516 = G__7521;
          continue
        }else {
          return a__7513
        }
        break
      }
    }else {
      var n__2527__auto____7518 = size;
      var i__7519 = 0;
      while(true) {
        if(i__7519 < n__2527__auto____7518) {
          a__7513[i__7519] = init_val_or_seq;
          var G__7522 = i__7519 + 1;
          i__7519 = G__7522;
          continue
        }else {
        }
        break
      }
      return a__7513
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__7530 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__7531 = cljs.core.seq.call(null, init_val_or_seq);
      var i__7532 = 0;
      var s__7533 = s__7531;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3822__auto____7534 = s__7533;
          if(and__3822__auto____7534) {
            return i__7532 < size
          }else {
            return and__3822__auto____7534
          }
        }())) {
          a__7530[i__7532] = cljs.core.first.call(null, s__7533);
          var G__7537 = i__7532 + 1;
          var G__7538 = cljs.core.next.call(null, s__7533);
          i__7532 = G__7537;
          s__7533 = G__7538;
          continue
        }else {
          return a__7530
        }
        break
      }
    }else {
      var n__2527__auto____7535 = size;
      var i__7536 = 0;
      while(true) {
        if(i__7536 < n__2527__auto____7535) {
          a__7530[i__7536] = init_val_or_seq;
          var G__7539 = i__7536 + 1;
          i__7536 = G__7539;
          continue
        }else {
        }
        break
      }
      return a__7530
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__7544 = s;
    var i__7545 = n;
    var sum__7546 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3822__auto____7547 = i__7545 > 0;
        if(and__3822__auto____7547) {
          return cljs.core.seq.call(null, s__7544)
        }else {
          return and__3822__auto____7547
        }
      }())) {
        var G__7548 = cljs.core.next.call(null, s__7544);
        var G__7549 = i__7545 - 1;
        var G__7550 = sum__7546 + 1;
        s__7544 = G__7548;
        i__7545 = G__7549;
        sum__7546 = G__7550;
        continue
      }else {
        return sum__7546
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    }, null)
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    }, null)
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__7555 = cljs.core.seq.call(null, x);
      if(s__7555) {
        if(cljs.core.chunked_seq_QMARK_.call(null, s__7555)) {
          return cljs.core.chunk_cons.call(null, cljs.core.chunk_first.call(null, s__7555), concat.call(null, cljs.core.chunk_rest.call(null, s__7555), y))
        }else {
          return cljs.core.cons.call(null, cljs.core.first.call(null, s__7555), concat.call(null, cljs.core.rest.call(null, s__7555), y))
        }
      }else {
        return y
      }
    }, null)
  };
  var concat__3 = function() {
    var G__7559__delegate = function(x, y, zs) {
      var cat__7558 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__7557 = cljs.core.seq.call(null, xys);
          if(xys__7557) {
            if(cljs.core.chunked_seq_QMARK_.call(null, xys__7557)) {
              return cljs.core.chunk_cons.call(null, cljs.core.chunk_first.call(null, xys__7557), cat.call(null, cljs.core.chunk_rest.call(null, xys__7557), zs))
            }else {
              return cljs.core.cons.call(null, cljs.core.first.call(null, xys__7557), cat.call(null, cljs.core.rest.call(null, xys__7557), zs))
            }
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        }, null)
      };
      return cat__7558.call(null, concat.call(null, x, y), zs)
    };
    var G__7559 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7559__delegate.call(this, x, y, zs)
    };
    G__7559.cljs$lang$maxFixedArity = 2;
    G__7559.cljs$lang$applyTo = function(arglist__7560) {
      var x = cljs.core.first(arglist__7560);
      var y = cljs.core.first(cljs.core.next(arglist__7560));
      var zs = cljs.core.rest(cljs.core.next(arglist__7560));
      return G__7559__delegate(x, y, zs)
    };
    G__7559.cljs$lang$arity$variadic = G__7559__delegate;
    return G__7559
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__7561__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__7561 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__7561__delegate.call(this, a, b, c, d, more)
    };
    G__7561.cljs$lang$maxFixedArity = 4;
    G__7561.cljs$lang$applyTo = function(arglist__7562) {
      var a = cljs.core.first(arglist__7562);
      var b = cljs.core.first(cljs.core.next(arglist__7562));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7562)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7562))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7562))));
      return G__7561__delegate(a, b, c, d, more)
    };
    G__7561.cljs$lang$arity$variadic = G__7561__delegate;
    return G__7561
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__7604 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__7605 = cljs.core._first.call(null, args__7604);
    var args__7606 = cljs.core._rest.call(null, args__7604);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__7605)
      }else {
        return f.call(null, a__7605)
      }
    }else {
      var b__7607 = cljs.core._first.call(null, args__7606);
      var args__7608 = cljs.core._rest.call(null, args__7606);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__7605, b__7607)
        }else {
          return f.call(null, a__7605, b__7607)
        }
      }else {
        var c__7609 = cljs.core._first.call(null, args__7608);
        var args__7610 = cljs.core._rest.call(null, args__7608);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__7605, b__7607, c__7609)
          }else {
            return f.call(null, a__7605, b__7607, c__7609)
          }
        }else {
          var d__7611 = cljs.core._first.call(null, args__7610);
          var args__7612 = cljs.core._rest.call(null, args__7610);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__7605, b__7607, c__7609, d__7611)
            }else {
              return f.call(null, a__7605, b__7607, c__7609, d__7611)
            }
          }else {
            var e__7613 = cljs.core._first.call(null, args__7612);
            var args__7614 = cljs.core._rest.call(null, args__7612);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__7605, b__7607, c__7609, d__7611, e__7613)
              }else {
                return f.call(null, a__7605, b__7607, c__7609, d__7611, e__7613)
              }
            }else {
              var f__7615 = cljs.core._first.call(null, args__7614);
              var args__7616 = cljs.core._rest.call(null, args__7614);
              if(argc === 6) {
                if(f__7615.cljs$lang$arity$6) {
                  return f__7615.cljs$lang$arity$6(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615)
                }else {
                  return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615)
                }
              }else {
                var g__7617 = cljs.core._first.call(null, args__7616);
                var args__7618 = cljs.core._rest.call(null, args__7616);
                if(argc === 7) {
                  if(f__7615.cljs$lang$arity$7) {
                    return f__7615.cljs$lang$arity$7(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617)
                  }else {
                    return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617)
                  }
                }else {
                  var h__7619 = cljs.core._first.call(null, args__7618);
                  var args__7620 = cljs.core._rest.call(null, args__7618);
                  if(argc === 8) {
                    if(f__7615.cljs$lang$arity$8) {
                      return f__7615.cljs$lang$arity$8(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619)
                    }else {
                      return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619)
                    }
                  }else {
                    var i__7621 = cljs.core._first.call(null, args__7620);
                    var args__7622 = cljs.core._rest.call(null, args__7620);
                    if(argc === 9) {
                      if(f__7615.cljs$lang$arity$9) {
                        return f__7615.cljs$lang$arity$9(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621)
                      }else {
                        return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621)
                      }
                    }else {
                      var j__7623 = cljs.core._first.call(null, args__7622);
                      var args__7624 = cljs.core._rest.call(null, args__7622);
                      if(argc === 10) {
                        if(f__7615.cljs$lang$arity$10) {
                          return f__7615.cljs$lang$arity$10(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623)
                        }else {
                          return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623)
                        }
                      }else {
                        var k__7625 = cljs.core._first.call(null, args__7624);
                        var args__7626 = cljs.core._rest.call(null, args__7624);
                        if(argc === 11) {
                          if(f__7615.cljs$lang$arity$11) {
                            return f__7615.cljs$lang$arity$11(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625)
                          }else {
                            return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625)
                          }
                        }else {
                          var l__7627 = cljs.core._first.call(null, args__7626);
                          var args__7628 = cljs.core._rest.call(null, args__7626);
                          if(argc === 12) {
                            if(f__7615.cljs$lang$arity$12) {
                              return f__7615.cljs$lang$arity$12(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627)
                            }else {
                              return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627)
                            }
                          }else {
                            var m__7629 = cljs.core._first.call(null, args__7628);
                            var args__7630 = cljs.core._rest.call(null, args__7628);
                            if(argc === 13) {
                              if(f__7615.cljs$lang$arity$13) {
                                return f__7615.cljs$lang$arity$13(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629)
                              }else {
                                return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629)
                              }
                            }else {
                              var n__7631 = cljs.core._first.call(null, args__7630);
                              var args__7632 = cljs.core._rest.call(null, args__7630);
                              if(argc === 14) {
                                if(f__7615.cljs$lang$arity$14) {
                                  return f__7615.cljs$lang$arity$14(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631)
                                }else {
                                  return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631)
                                }
                              }else {
                                var o__7633 = cljs.core._first.call(null, args__7632);
                                var args__7634 = cljs.core._rest.call(null, args__7632);
                                if(argc === 15) {
                                  if(f__7615.cljs$lang$arity$15) {
                                    return f__7615.cljs$lang$arity$15(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633)
                                  }else {
                                    return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633)
                                  }
                                }else {
                                  var p__7635 = cljs.core._first.call(null, args__7634);
                                  var args__7636 = cljs.core._rest.call(null, args__7634);
                                  if(argc === 16) {
                                    if(f__7615.cljs$lang$arity$16) {
                                      return f__7615.cljs$lang$arity$16(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633, p__7635)
                                    }else {
                                      return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633, p__7635)
                                    }
                                  }else {
                                    var q__7637 = cljs.core._first.call(null, args__7636);
                                    var args__7638 = cljs.core._rest.call(null, args__7636);
                                    if(argc === 17) {
                                      if(f__7615.cljs$lang$arity$17) {
                                        return f__7615.cljs$lang$arity$17(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633, p__7635, q__7637)
                                      }else {
                                        return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633, p__7635, q__7637)
                                      }
                                    }else {
                                      var r__7639 = cljs.core._first.call(null, args__7638);
                                      var args__7640 = cljs.core._rest.call(null, args__7638);
                                      if(argc === 18) {
                                        if(f__7615.cljs$lang$arity$18) {
                                          return f__7615.cljs$lang$arity$18(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633, p__7635, q__7637, r__7639)
                                        }else {
                                          return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633, p__7635, q__7637, r__7639)
                                        }
                                      }else {
                                        var s__7641 = cljs.core._first.call(null, args__7640);
                                        var args__7642 = cljs.core._rest.call(null, args__7640);
                                        if(argc === 19) {
                                          if(f__7615.cljs$lang$arity$19) {
                                            return f__7615.cljs$lang$arity$19(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633, p__7635, q__7637, r__7639, s__7641)
                                          }else {
                                            return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633, p__7635, q__7637, r__7639, s__7641)
                                          }
                                        }else {
                                          var t__7643 = cljs.core._first.call(null, args__7642);
                                          var args__7644 = cljs.core._rest.call(null, args__7642);
                                          if(argc === 20) {
                                            if(f__7615.cljs$lang$arity$20) {
                                              return f__7615.cljs$lang$arity$20(a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633, p__7635, q__7637, r__7639, s__7641, t__7643)
                                            }else {
                                              return f__7615.call(null, a__7605, b__7607, c__7609, d__7611, e__7613, f__7615, g__7617, h__7619, i__7621, j__7623, k__7625, l__7627, m__7629, n__7631, o__7633, p__7635, q__7637, r__7639, s__7641, t__7643)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__7659 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__7660 = cljs.core.bounded_count.call(null, args, fixed_arity__7659 + 1);
      if(bc__7660 <= fixed_arity__7659) {
        return cljs.core.apply_to.call(null, f, bc__7660, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__7661 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__7662 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__7663 = cljs.core.bounded_count.call(null, arglist__7661, fixed_arity__7662 + 1);
      if(bc__7663 <= fixed_arity__7662) {
        return cljs.core.apply_to.call(null, f, bc__7663, arglist__7661)
      }else {
        return f.cljs$lang$applyTo(arglist__7661)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__7661))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__7664 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__7665 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__7666 = cljs.core.bounded_count.call(null, arglist__7664, fixed_arity__7665 + 1);
      if(bc__7666 <= fixed_arity__7665) {
        return cljs.core.apply_to.call(null, f, bc__7666, arglist__7664)
      }else {
        return f.cljs$lang$applyTo(arglist__7664)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__7664))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__7667 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__7668 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__7669 = cljs.core.bounded_count.call(null, arglist__7667, fixed_arity__7668 + 1);
      if(bc__7669 <= fixed_arity__7668) {
        return cljs.core.apply_to.call(null, f, bc__7669, arglist__7667)
      }else {
        return f.cljs$lang$applyTo(arglist__7667)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__7667))
    }
  };
  var apply__6 = function() {
    var G__7673__delegate = function(f, a, b, c, d, args) {
      var arglist__7670 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__7671 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__7672 = cljs.core.bounded_count.call(null, arglist__7670, fixed_arity__7671 + 1);
        if(bc__7672 <= fixed_arity__7671) {
          return cljs.core.apply_to.call(null, f, bc__7672, arglist__7670)
        }else {
          return f.cljs$lang$applyTo(arglist__7670)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__7670))
      }
    };
    var G__7673 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__7673__delegate.call(this, f, a, b, c, d, args)
    };
    G__7673.cljs$lang$maxFixedArity = 5;
    G__7673.cljs$lang$applyTo = function(arglist__7674) {
      var f = cljs.core.first(arglist__7674);
      var a = cljs.core.first(cljs.core.next(arglist__7674));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7674)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7674))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7674)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7674)))));
      return G__7673__delegate(f, a, b, c, d, args)
    };
    G__7673.cljs$lang$arity$variadic = G__7673__delegate;
    return G__7673
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__7675) {
    var obj = cljs.core.first(arglist__7675);
    var f = cljs.core.first(cljs.core.next(arglist__7675));
    var args = cljs.core.rest(cljs.core.next(arglist__7675));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return!cljs.core._EQ_.call(null, x, y)
  };
  var not_EQ___3 = function() {
    var G__7676__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__7676 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7676__delegate.call(this, x, y, more)
    };
    G__7676.cljs$lang$maxFixedArity = 2;
    G__7676.cljs$lang$applyTo = function(arglist__7677) {
      var x = cljs.core.first(arglist__7677);
      var y = cljs.core.first(cljs.core.next(arglist__7677));
      var more = cljs.core.rest(cljs.core.next(arglist__7677));
      return G__7676__delegate(x, y, more)
    };
    G__7676.cljs$lang$arity$variadic = G__7676__delegate;
    return G__7676
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.seq.call(null, coll)) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__7678 = pred;
        var G__7679 = cljs.core.next.call(null, coll);
        pred = G__7678;
        coll = G__7679;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return!cljs.core.every_QMARK_.call(null, pred, coll)
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll)) {
      var or__3824__auto____7681 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3824__auto____7681)) {
        return or__3824__auto____7681
      }else {
        var G__7682 = pred;
        var G__7683 = cljs.core.next.call(null, coll);
        pred = G__7682;
        coll = G__7683;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return!cljs.core.even_QMARK_.call(null, n)
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__7684 = null;
    var G__7684__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__7684__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__7684__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__7684__3 = function() {
      var G__7685__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__7685 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__7685__delegate.call(this, x, y, zs)
      };
      G__7685.cljs$lang$maxFixedArity = 2;
      G__7685.cljs$lang$applyTo = function(arglist__7686) {
        var x = cljs.core.first(arglist__7686);
        var y = cljs.core.first(cljs.core.next(arglist__7686));
        var zs = cljs.core.rest(cljs.core.next(arglist__7686));
        return G__7685__delegate(x, y, zs)
      };
      G__7685.cljs$lang$arity$variadic = G__7685__delegate;
      return G__7685
    }();
    G__7684 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__7684__0.call(this);
        case 1:
          return G__7684__1.call(this, x);
        case 2:
          return G__7684__2.call(this, x, y);
        default:
          return G__7684__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__7684.cljs$lang$maxFixedArity = 2;
    G__7684.cljs$lang$applyTo = G__7684__3.cljs$lang$applyTo;
    return G__7684
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__7687__delegate = function(args) {
      return x
    };
    var G__7687 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__7687__delegate.call(this, args)
    };
    G__7687.cljs$lang$maxFixedArity = 0;
    G__7687.cljs$lang$applyTo = function(arglist__7688) {
      var args = cljs.core.seq(arglist__7688);
      return G__7687__delegate(args)
    };
    G__7687.cljs$lang$arity$variadic = G__7687__delegate;
    return G__7687
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__7695 = null;
      var G__7695__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__7695__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__7695__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__7695__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__7695__4 = function() {
        var G__7696__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__7696 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7696__delegate.call(this, x, y, z, args)
        };
        G__7696.cljs$lang$maxFixedArity = 3;
        G__7696.cljs$lang$applyTo = function(arglist__7697) {
          var x = cljs.core.first(arglist__7697);
          var y = cljs.core.first(cljs.core.next(arglist__7697));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7697)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7697)));
          return G__7696__delegate(x, y, z, args)
        };
        G__7696.cljs$lang$arity$variadic = G__7696__delegate;
        return G__7696
      }();
      G__7695 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7695__0.call(this);
          case 1:
            return G__7695__1.call(this, x);
          case 2:
            return G__7695__2.call(this, x, y);
          case 3:
            return G__7695__3.call(this, x, y, z);
          default:
            return G__7695__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7695.cljs$lang$maxFixedArity = 3;
      G__7695.cljs$lang$applyTo = G__7695__4.cljs$lang$applyTo;
      return G__7695
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__7698 = null;
      var G__7698__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__7698__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__7698__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__7698__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__7698__4 = function() {
        var G__7699__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__7699 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7699__delegate.call(this, x, y, z, args)
        };
        G__7699.cljs$lang$maxFixedArity = 3;
        G__7699.cljs$lang$applyTo = function(arglist__7700) {
          var x = cljs.core.first(arglist__7700);
          var y = cljs.core.first(cljs.core.next(arglist__7700));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7700)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7700)));
          return G__7699__delegate(x, y, z, args)
        };
        G__7699.cljs$lang$arity$variadic = G__7699__delegate;
        return G__7699
      }();
      G__7698 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__7698__0.call(this);
          case 1:
            return G__7698__1.call(this, x);
          case 2:
            return G__7698__2.call(this, x, y);
          case 3:
            return G__7698__3.call(this, x, y, z);
          default:
            return G__7698__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7698.cljs$lang$maxFixedArity = 3;
      G__7698.cljs$lang$applyTo = G__7698__4.cljs$lang$applyTo;
      return G__7698
    }()
  };
  var comp__4 = function() {
    var G__7701__delegate = function(f1, f2, f3, fs) {
      var fs__7692 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__7702__delegate = function(args) {
          var ret__7693 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__7692), args);
          var fs__7694 = cljs.core.next.call(null, fs__7692);
          while(true) {
            if(fs__7694) {
              var G__7703 = cljs.core.first.call(null, fs__7694).call(null, ret__7693);
              var G__7704 = cljs.core.next.call(null, fs__7694);
              ret__7693 = G__7703;
              fs__7694 = G__7704;
              continue
            }else {
              return ret__7693
            }
            break
          }
        };
        var G__7702 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__7702__delegate.call(this, args)
        };
        G__7702.cljs$lang$maxFixedArity = 0;
        G__7702.cljs$lang$applyTo = function(arglist__7705) {
          var args = cljs.core.seq(arglist__7705);
          return G__7702__delegate(args)
        };
        G__7702.cljs$lang$arity$variadic = G__7702__delegate;
        return G__7702
      }()
    };
    var G__7701 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7701__delegate.call(this, f1, f2, f3, fs)
    };
    G__7701.cljs$lang$maxFixedArity = 3;
    G__7701.cljs$lang$applyTo = function(arglist__7706) {
      var f1 = cljs.core.first(arglist__7706);
      var f2 = cljs.core.first(cljs.core.next(arglist__7706));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7706)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7706)));
      return G__7701__delegate(f1, f2, f3, fs)
    };
    G__7701.cljs$lang$arity$variadic = G__7701__delegate;
    return G__7701
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__7707__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__7707 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__7707__delegate.call(this, args)
      };
      G__7707.cljs$lang$maxFixedArity = 0;
      G__7707.cljs$lang$applyTo = function(arglist__7708) {
        var args = cljs.core.seq(arglist__7708);
        return G__7707__delegate(args)
      };
      G__7707.cljs$lang$arity$variadic = G__7707__delegate;
      return G__7707
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__7709__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__7709 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__7709__delegate.call(this, args)
      };
      G__7709.cljs$lang$maxFixedArity = 0;
      G__7709.cljs$lang$applyTo = function(arglist__7710) {
        var args = cljs.core.seq(arglist__7710);
        return G__7709__delegate(args)
      };
      G__7709.cljs$lang$arity$variadic = G__7709__delegate;
      return G__7709
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__7711__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__7711 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__7711__delegate.call(this, args)
      };
      G__7711.cljs$lang$maxFixedArity = 0;
      G__7711.cljs$lang$applyTo = function(arglist__7712) {
        var args = cljs.core.seq(arglist__7712);
        return G__7711__delegate(args)
      };
      G__7711.cljs$lang$arity$variadic = G__7711__delegate;
      return G__7711
    }()
  };
  var partial__5 = function() {
    var G__7713__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__7714__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__7714 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__7714__delegate.call(this, args)
        };
        G__7714.cljs$lang$maxFixedArity = 0;
        G__7714.cljs$lang$applyTo = function(arglist__7715) {
          var args = cljs.core.seq(arglist__7715);
          return G__7714__delegate(args)
        };
        G__7714.cljs$lang$arity$variadic = G__7714__delegate;
        return G__7714
      }()
    };
    var G__7713 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__7713__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__7713.cljs$lang$maxFixedArity = 4;
    G__7713.cljs$lang$applyTo = function(arglist__7716) {
      var f = cljs.core.first(arglist__7716);
      var arg1 = cljs.core.first(cljs.core.next(arglist__7716));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7716)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7716))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__7716))));
      return G__7713__delegate(f, arg1, arg2, arg3, more)
    };
    G__7713.cljs$lang$arity$variadic = G__7713__delegate;
    return G__7713
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__7717 = null;
      var G__7717__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__7717__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__7717__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__7717__4 = function() {
        var G__7718__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__7718 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7718__delegate.call(this, a, b, c, ds)
        };
        G__7718.cljs$lang$maxFixedArity = 3;
        G__7718.cljs$lang$applyTo = function(arglist__7719) {
          var a = cljs.core.first(arglist__7719);
          var b = cljs.core.first(cljs.core.next(arglist__7719));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7719)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7719)));
          return G__7718__delegate(a, b, c, ds)
        };
        G__7718.cljs$lang$arity$variadic = G__7718__delegate;
        return G__7718
      }();
      G__7717 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__7717__1.call(this, a);
          case 2:
            return G__7717__2.call(this, a, b);
          case 3:
            return G__7717__3.call(this, a, b, c);
          default:
            return G__7717__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7717.cljs$lang$maxFixedArity = 3;
      G__7717.cljs$lang$applyTo = G__7717__4.cljs$lang$applyTo;
      return G__7717
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__7720 = null;
      var G__7720__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__7720__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__7720__4 = function() {
        var G__7721__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__7721 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7721__delegate.call(this, a, b, c, ds)
        };
        G__7721.cljs$lang$maxFixedArity = 3;
        G__7721.cljs$lang$applyTo = function(arglist__7722) {
          var a = cljs.core.first(arglist__7722);
          var b = cljs.core.first(cljs.core.next(arglist__7722));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7722)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7722)));
          return G__7721__delegate(a, b, c, ds)
        };
        G__7721.cljs$lang$arity$variadic = G__7721__delegate;
        return G__7721
      }();
      G__7720 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__7720__2.call(this, a, b);
          case 3:
            return G__7720__3.call(this, a, b, c);
          default:
            return G__7720__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7720.cljs$lang$maxFixedArity = 3;
      G__7720.cljs$lang$applyTo = G__7720__4.cljs$lang$applyTo;
      return G__7720
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__7723 = null;
      var G__7723__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__7723__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__7723__4 = function() {
        var G__7724__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__7724 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7724__delegate.call(this, a, b, c, ds)
        };
        G__7724.cljs$lang$maxFixedArity = 3;
        G__7724.cljs$lang$applyTo = function(arglist__7725) {
          var a = cljs.core.first(arglist__7725);
          var b = cljs.core.first(cljs.core.next(arglist__7725));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7725)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7725)));
          return G__7724__delegate(a, b, c, ds)
        };
        G__7724.cljs$lang$arity$variadic = G__7724__delegate;
        return G__7724
      }();
      G__7723 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__7723__2.call(this, a, b);
          case 3:
            return G__7723__3.call(this, a, b, c);
          default:
            return G__7723__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__7723.cljs$lang$maxFixedArity = 3;
      G__7723.cljs$lang$applyTo = G__7723__4.cljs$lang$applyTo;
      return G__7723
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__7741 = function mapi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____7749 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____7749) {
        var s__7750 = temp__3974__auto____7749;
        if(cljs.core.chunked_seq_QMARK_.call(null, s__7750)) {
          var c__7751 = cljs.core.chunk_first.call(null, s__7750);
          var size__7752 = cljs.core.count.call(null, c__7751);
          var b__7753 = cljs.core.chunk_buffer.call(null, size__7752);
          var n__2527__auto____7754 = size__7752;
          var i__7755 = 0;
          while(true) {
            if(i__7755 < n__2527__auto____7754) {
              cljs.core.chunk_append.call(null, b__7753, f.call(null, idx + i__7755, cljs.core._nth.call(null, c__7751, i__7755)));
              var G__7756 = i__7755 + 1;
              i__7755 = G__7756;
              continue
            }else {
            }
            break
          }
          return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__7753), mapi.call(null, idx + size__7752, cljs.core.chunk_rest.call(null, s__7750)))
        }else {
          return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__7750)), mapi.call(null, idx + 1, cljs.core.rest.call(null, s__7750)))
        }
      }else {
        return null
      }
    }, null)
  };
  return mapi__7741.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____7766 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____7766) {
      var s__7767 = temp__3974__auto____7766;
      if(cljs.core.chunked_seq_QMARK_.call(null, s__7767)) {
        var c__7768 = cljs.core.chunk_first.call(null, s__7767);
        var size__7769 = cljs.core.count.call(null, c__7768);
        var b__7770 = cljs.core.chunk_buffer.call(null, size__7769);
        var n__2527__auto____7771 = size__7769;
        var i__7772 = 0;
        while(true) {
          if(i__7772 < n__2527__auto____7771) {
            var x__7773 = f.call(null, cljs.core._nth.call(null, c__7768, i__7772));
            if(x__7773 == null) {
            }else {
              cljs.core.chunk_append.call(null, b__7770, x__7773)
            }
            var G__7775 = i__7772 + 1;
            i__7772 = G__7775;
            continue
          }else {
          }
          break
        }
        return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__7770), keep.call(null, f, cljs.core.chunk_rest.call(null, s__7767)))
      }else {
        var x__7774 = f.call(null, cljs.core.first.call(null, s__7767));
        if(x__7774 == null) {
          return keep.call(null, f, cljs.core.rest.call(null, s__7767))
        }else {
          return cljs.core.cons.call(null, x__7774, keep.call(null, f, cljs.core.rest.call(null, s__7767)))
        }
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__7801 = function keepi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____7811 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____7811) {
        var s__7812 = temp__3974__auto____7811;
        if(cljs.core.chunked_seq_QMARK_.call(null, s__7812)) {
          var c__7813 = cljs.core.chunk_first.call(null, s__7812);
          var size__7814 = cljs.core.count.call(null, c__7813);
          var b__7815 = cljs.core.chunk_buffer.call(null, size__7814);
          var n__2527__auto____7816 = size__7814;
          var i__7817 = 0;
          while(true) {
            if(i__7817 < n__2527__auto____7816) {
              var x__7818 = f.call(null, idx + i__7817, cljs.core._nth.call(null, c__7813, i__7817));
              if(x__7818 == null) {
              }else {
                cljs.core.chunk_append.call(null, b__7815, x__7818)
              }
              var G__7820 = i__7817 + 1;
              i__7817 = G__7820;
              continue
            }else {
            }
            break
          }
          return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__7815), keepi.call(null, idx + size__7814, cljs.core.chunk_rest.call(null, s__7812)))
        }else {
          var x__7819 = f.call(null, idx, cljs.core.first.call(null, s__7812));
          if(x__7819 == null) {
            return keepi.call(null, idx + 1, cljs.core.rest.call(null, s__7812))
          }else {
            return cljs.core.cons.call(null, x__7819, keepi.call(null, idx + 1, cljs.core.rest.call(null, s__7812)))
          }
        }
      }else {
        return null
      }
    }, null)
  };
  return keepi__7801.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____7906 = p.call(null, x);
          if(cljs.core.truth_(and__3822__auto____7906)) {
            return p.call(null, y)
          }else {
            return and__3822__auto____7906
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____7907 = p.call(null, x);
          if(cljs.core.truth_(and__3822__auto____7907)) {
            var and__3822__auto____7908 = p.call(null, y);
            if(cljs.core.truth_(and__3822__auto____7908)) {
              return p.call(null, z)
            }else {
              return and__3822__auto____7908
            }
          }else {
            return and__3822__auto____7907
          }
        }())
      };
      var ep1__4 = function() {
        var G__7977__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3822__auto____7909 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3822__auto____7909)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3822__auto____7909
            }
          }())
        };
        var G__7977 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7977__delegate.call(this, x, y, z, args)
        };
        G__7977.cljs$lang$maxFixedArity = 3;
        G__7977.cljs$lang$applyTo = function(arglist__7978) {
          var x = cljs.core.first(arglist__7978);
          var y = cljs.core.first(cljs.core.next(arglist__7978));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7978)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7978)));
          return G__7977__delegate(x, y, z, args)
        };
        G__7977.cljs$lang$arity$variadic = G__7977__delegate;
        return G__7977
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____7921 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____7921)) {
            return p2.call(null, x)
          }else {
            return and__3822__auto____7921
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____7922 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____7922)) {
            var and__3822__auto____7923 = p1.call(null, y);
            if(cljs.core.truth_(and__3822__auto____7923)) {
              var and__3822__auto____7924 = p2.call(null, x);
              if(cljs.core.truth_(and__3822__auto____7924)) {
                return p2.call(null, y)
              }else {
                return and__3822__auto____7924
              }
            }else {
              return and__3822__auto____7923
            }
          }else {
            return and__3822__auto____7922
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____7925 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____7925)) {
            var and__3822__auto____7926 = p1.call(null, y);
            if(cljs.core.truth_(and__3822__auto____7926)) {
              var and__3822__auto____7927 = p1.call(null, z);
              if(cljs.core.truth_(and__3822__auto____7927)) {
                var and__3822__auto____7928 = p2.call(null, x);
                if(cljs.core.truth_(and__3822__auto____7928)) {
                  var and__3822__auto____7929 = p2.call(null, y);
                  if(cljs.core.truth_(and__3822__auto____7929)) {
                    return p2.call(null, z)
                  }else {
                    return and__3822__auto____7929
                  }
                }else {
                  return and__3822__auto____7928
                }
              }else {
                return and__3822__auto____7927
              }
            }else {
              return and__3822__auto____7926
            }
          }else {
            return and__3822__auto____7925
          }
        }())
      };
      var ep2__4 = function() {
        var G__7979__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3822__auto____7930 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3822__auto____7930)) {
              return cljs.core.every_QMARK_.call(null, function(p1__7776_SHARP_) {
                var and__3822__auto____7931 = p1.call(null, p1__7776_SHARP_);
                if(cljs.core.truth_(and__3822__auto____7931)) {
                  return p2.call(null, p1__7776_SHARP_)
                }else {
                  return and__3822__auto____7931
                }
              }, args)
            }else {
              return and__3822__auto____7930
            }
          }())
        };
        var G__7979 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7979__delegate.call(this, x, y, z, args)
        };
        G__7979.cljs$lang$maxFixedArity = 3;
        G__7979.cljs$lang$applyTo = function(arglist__7980) {
          var x = cljs.core.first(arglist__7980);
          var y = cljs.core.first(cljs.core.next(arglist__7980));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7980)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7980)));
          return G__7979__delegate(x, y, z, args)
        };
        G__7979.cljs$lang$arity$variadic = G__7979__delegate;
        return G__7979
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____7950 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____7950)) {
            var and__3822__auto____7951 = p2.call(null, x);
            if(cljs.core.truth_(and__3822__auto____7951)) {
              return p3.call(null, x)
            }else {
              return and__3822__auto____7951
            }
          }else {
            return and__3822__auto____7950
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____7952 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____7952)) {
            var and__3822__auto____7953 = p2.call(null, x);
            if(cljs.core.truth_(and__3822__auto____7953)) {
              var and__3822__auto____7954 = p3.call(null, x);
              if(cljs.core.truth_(and__3822__auto____7954)) {
                var and__3822__auto____7955 = p1.call(null, y);
                if(cljs.core.truth_(and__3822__auto____7955)) {
                  var and__3822__auto____7956 = p2.call(null, y);
                  if(cljs.core.truth_(and__3822__auto____7956)) {
                    return p3.call(null, y)
                  }else {
                    return and__3822__auto____7956
                  }
                }else {
                  return and__3822__auto____7955
                }
              }else {
                return and__3822__auto____7954
              }
            }else {
              return and__3822__auto____7953
            }
          }else {
            return and__3822__auto____7952
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____7957 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____7957)) {
            var and__3822__auto____7958 = p2.call(null, x);
            if(cljs.core.truth_(and__3822__auto____7958)) {
              var and__3822__auto____7959 = p3.call(null, x);
              if(cljs.core.truth_(and__3822__auto____7959)) {
                var and__3822__auto____7960 = p1.call(null, y);
                if(cljs.core.truth_(and__3822__auto____7960)) {
                  var and__3822__auto____7961 = p2.call(null, y);
                  if(cljs.core.truth_(and__3822__auto____7961)) {
                    var and__3822__auto____7962 = p3.call(null, y);
                    if(cljs.core.truth_(and__3822__auto____7962)) {
                      var and__3822__auto____7963 = p1.call(null, z);
                      if(cljs.core.truth_(and__3822__auto____7963)) {
                        var and__3822__auto____7964 = p2.call(null, z);
                        if(cljs.core.truth_(and__3822__auto____7964)) {
                          return p3.call(null, z)
                        }else {
                          return and__3822__auto____7964
                        }
                      }else {
                        return and__3822__auto____7963
                      }
                    }else {
                      return and__3822__auto____7962
                    }
                  }else {
                    return and__3822__auto____7961
                  }
                }else {
                  return and__3822__auto____7960
                }
              }else {
                return and__3822__auto____7959
              }
            }else {
              return and__3822__auto____7958
            }
          }else {
            return and__3822__auto____7957
          }
        }())
      };
      var ep3__4 = function() {
        var G__7981__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3822__auto____7965 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3822__auto____7965)) {
              return cljs.core.every_QMARK_.call(null, function(p1__7777_SHARP_) {
                var and__3822__auto____7966 = p1.call(null, p1__7777_SHARP_);
                if(cljs.core.truth_(and__3822__auto____7966)) {
                  var and__3822__auto____7967 = p2.call(null, p1__7777_SHARP_);
                  if(cljs.core.truth_(and__3822__auto____7967)) {
                    return p3.call(null, p1__7777_SHARP_)
                  }else {
                    return and__3822__auto____7967
                  }
                }else {
                  return and__3822__auto____7966
                }
              }, args)
            }else {
              return and__3822__auto____7965
            }
          }())
        };
        var G__7981 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__7981__delegate.call(this, x, y, z, args)
        };
        G__7981.cljs$lang$maxFixedArity = 3;
        G__7981.cljs$lang$applyTo = function(arglist__7982) {
          var x = cljs.core.first(arglist__7982);
          var y = cljs.core.first(cljs.core.next(arglist__7982));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7982)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7982)));
          return G__7981__delegate(x, y, z, args)
        };
        G__7981.cljs$lang$arity$variadic = G__7981__delegate;
        return G__7981
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__7983__delegate = function(p1, p2, p3, ps) {
      var ps__7968 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__7778_SHARP_) {
            return p1__7778_SHARP_.call(null, x)
          }, ps__7968)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__7779_SHARP_) {
            var and__3822__auto____7973 = p1__7779_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3822__auto____7973)) {
              return p1__7779_SHARP_.call(null, y)
            }else {
              return and__3822__auto____7973
            }
          }, ps__7968)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__7780_SHARP_) {
            var and__3822__auto____7974 = p1__7780_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3822__auto____7974)) {
              var and__3822__auto____7975 = p1__7780_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3822__auto____7975)) {
                return p1__7780_SHARP_.call(null, z)
              }else {
                return and__3822__auto____7975
              }
            }else {
              return and__3822__auto____7974
            }
          }, ps__7968)
        };
        var epn__4 = function() {
          var G__7984__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3822__auto____7976 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3822__auto____7976)) {
                return cljs.core.every_QMARK_.call(null, function(p1__7781_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__7781_SHARP_, args)
                }, ps__7968)
              }else {
                return and__3822__auto____7976
              }
            }())
          };
          var G__7984 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__7984__delegate.call(this, x, y, z, args)
          };
          G__7984.cljs$lang$maxFixedArity = 3;
          G__7984.cljs$lang$applyTo = function(arglist__7985) {
            var x = cljs.core.first(arglist__7985);
            var y = cljs.core.first(cljs.core.next(arglist__7985));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7985)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7985)));
            return G__7984__delegate(x, y, z, args)
          };
          G__7984.cljs$lang$arity$variadic = G__7984__delegate;
          return G__7984
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__7983 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7983__delegate.call(this, p1, p2, p3, ps)
    };
    G__7983.cljs$lang$maxFixedArity = 3;
    G__7983.cljs$lang$applyTo = function(arglist__7986) {
      var p1 = cljs.core.first(arglist__7986);
      var p2 = cljs.core.first(cljs.core.next(arglist__7986));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7986)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7986)));
      return G__7983__delegate(p1, p2, p3, ps)
    };
    G__7983.cljs$lang$arity$variadic = G__7983__delegate;
    return G__7983
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3824__auto____8067 = p.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8067)) {
          return or__3824__auto____8067
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3824__auto____8068 = p.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8068)) {
          return or__3824__auto____8068
        }else {
          var or__3824__auto____8069 = p.call(null, y);
          if(cljs.core.truth_(or__3824__auto____8069)) {
            return or__3824__auto____8069
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__8138__delegate = function(x, y, z, args) {
          var or__3824__auto____8070 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3824__auto____8070)) {
            return or__3824__auto____8070
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__8138 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8138__delegate.call(this, x, y, z, args)
        };
        G__8138.cljs$lang$maxFixedArity = 3;
        G__8138.cljs$lang$applyTo = function(arglist__8139) {
          var x = cljs.core.first(arglist__8139);
          var y = cljs.core.first(cljs.core.next(arglist__8139));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8139)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8139)));
          return G__8138__delegate(x, y, z, args)
        };
        G__8138.cljs$lang$arity$variadic = G__8138__delegate;
        return G__8138
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3824__auto____8082 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8082)) {
          return or__3824__auto____8082
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3824__auto____8083 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8083)) {
          return or__3824__auto____8083
        }else {
          var or__3824__auto____8084 = p1.call(null, y);
          if(cljs.core.truth_(or__3824__auto____8084)) {
            return or__3824__auto____8084
          }else {
            var or__3824__auto____8085 = p2.call(null, x);
            if(cljs.core.truth_(or__3824__auto____8085)) {
              return or__3824__auto____8085
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3824__auto____8086 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8086)) {
          return or__3824__auto____8086
        }else {
          var or__3824__auto____8087 = p1.call(null, y);
          if(cljs.core.truth_(or__3824__auto____8087)) {
            return or__3824__auto____8087
          }else {
            var or__3824__auto____8088 = p1.call(null, z);
            if(cljs.core.truth_(or__3824__auto____8088)) {
              return or__3824__auto____8088
            }else {
              var or__3824__auto____8089 = p2.call(null, x);
              if(cljs.core.truth_(or__3824__auto____8089)) {
                return or__3824__auto____8089
              }else {
                var or__3824__auto____8090 = p2.call(null, y);
                if(cljs.core.truth_(or__3824__auto____8090)) {
                  return or__3824__auto____8090
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__8140__delegate = function(x, y, z, args) {
          var or__3824__auto____8091 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3824__auto____8091)) {
            return or__3824__auto____8091
          }else {
            return cljs.core.some.call(null, function(p1__7821_SHARP_) {
              var or__3824__auto____8092 = p1.call(null, p1__7821_SHARP_);
              if(cljs.core.truth_(or__3824__auto____8092)) {
                return or__3824__auto____8092
              }else {
                return p2.call(null, p1__7821_SHARP_)
              }
            }, args)
          }
        };
        var G__8140 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8140__delegate.call(this, x, y, z, args)
        };
        G__8140.cljs$lang$maxFixedArity = 3;
        G__8140.cljs$lang$applyTo = function(arglist__8141) {
          var x = cljs.core.first(arglist__8141);
          var y = cljs.core.first(cljs.core.next(arglist__8141));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8141)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8141)));
          return G__8140__delegate(x, y, z, args)
        };
        G__8140.cljs$lang$arity$variadic = G__8140__delegate;
        return G__8140
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3824__auto____8111 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8111)) {
          return or__3824__auto____8111
        }else {
          var or__3824__auto____8112 = p2.call(null, x);
          if(cljs.core.truth_(or__3824__auto____8112)) {
            return or__3824__auto____8112
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3824__auto____8113 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8113)) {
          return or__3824__auto____8113
        }else {
          var or__3824__auto____8114 = p2.call(null, x);
          if(cljs.core.truth_(or__3824__auto____8114)) {
            return or__3824__auto____8114
          }else {
            var or__3824__auto____8115 = p3.call(null, x);
            if(cljs.core.truth_(or__3824__auto____8115)) {
              return or__3824__auto____8115
            }else {
              var or__3824__auto____8116 = p1.call(null, y);
              if(cljs.core.truth_(or__3824__auto____8116)) {
                return or__3824__auto____8116
              }else {
                var or__3824__auto____8117 = p2.call(null, y);
                if(cljs.core.truth_(or__3824__auto____8117)) {
                  return or__3824__auto____8117
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3824__auto____8118 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8118)) {
          return or__3824__auto____8118
        }else {
          var or__3824__auto____8119 = p2.call(null, x);
          if(cljs.core.truth_(or__3824__auto____8119)) {
            return or__3824__auto____8119
          }else {
            var or__3824__auto____8120 = p3.call(null, x);
            if(cljs.core.truth_(or__3824__auto____8120)) {
              return or__3824__auto____8120
            }else {
              var or__3824__auto____8121 = p1.call(null, y);
              if(cljs.core.truth_(or__3824__auto____8121)) {
                return or__3824__auto____8121
              }else {
                var or__3824__auto____8122 = p2.call(null, y);
                if(cljs.core.truth_(or__3824__auto____8122)) {
                  return or__3824__auto____8122
                }else {
                  var or__3824__auto____8123 = p3.call(null, y);
                  if(cljs.core.truth_(or__3824__auto____8123)) {
                    return or__3824__auto____8123
                  }else {
                    var or__3824__auto____8124 = p1.call(null, z);
                    if(cljs.core.truth_(or__3824__auto____8124)) {
                      return or__3824__auto____8124
                    }else {
                      var or__3824__auto____8125 = p2.call(null, z);
                      if(cljs.core.truth_(or__3824__auto____8125)) {
                        return or__3824__auto____8125
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__8142__delegate = function(x, y, z, args) {
          var or__3824__auto____8126 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3824__auto____8126)) {
            return or__3824__auto____8126
          }else {
            return cljs.core.some.call(null, function(p1__7822_SHARP_) {
              var or__3824__auto____8127 = p1.call(null, p1__7822_SHARP_);
              if(cljs.core.truth_(or__3824__auto____8127)) {
                return or__3824__auto____8127
              }else {
                var or__3824__auto____8128 = p2.call(null, p1__7822_SHARP_);
                if(cljs.core.truth_(or__3824__auto____8128)) {
                  return or__3824__auto____8128
                }else {
                  return p3.call(null, p1__7822_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__8142 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8142__delegate.call(this, x, y, z, args)
        };
        G__8142.cljs$lang$maxFixedArity = 3;
        G__8142.cljs$lang$applyTo = function(arglist__8143) {
          var x = cljs.core.first(arglist__8143);
          var y = cljs.core.first(cljs.core.next(arglist__8143));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8143)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8143)));
          return G__8142__delegate(x, y, z, args)
        };
        G__8142.cljs$lang$arity$variadic = G__8142__delegate;
        return G__8142
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__8144__delegate = function(p1, p2, p3, ps) {
      var ps__8129 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__7823_SHARP_) {
            return p1__7823_SHARP_.call(null, x)
          }, ps__8129)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__7824_SHARP_) {
            var or__3824__auto____8134 = p1__7824_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3824__auto____8134)) {
              return or__3824__auto____8134
            }else {
              return p1__7824_SHARP_.call(null, y)
            }
          }, ps__8129)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__7825_SHARP_) {
            var or__3824__auto____8135 = p1__7825_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3824__auto____8135)) {
              return or__3824__auto____8135
            }else {
              var or__3824__auto____8136 = p1__7825_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3824__auto____8136)) {
                return or__3824__auto____8136
              }else {
                return p1__7825_SHARP_.call(null, z)
              }
            }
          }, ps__8129)
        };
        var spn__4 = function() {
          var G__8145__delegate = function(x, y, z, args) {
            var or__3824__auto____8137 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3824__auto____8137)) {
              return or__3824__auto____8137
            }else {
              return cljs.core.some.call(null, function(p1__7826_SHARP_) {
                return cljs.core.some.call(null, p1__7826_SHARP_, args)
              }, ps__8129)
            }
          };
          var G__8145 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__8145__delegate.call(this, x, y, z, args)
          };
          G__8145.cljs$lang$maxFixedArity = 3;
          G__8145.cljs$lang$applyTo = function(arglist__8146) {
            var x = cljs.core.first(arglist__8146);
            var y = cljs.core.first(cljs.core.next(arglist__8146));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8146)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8146)));
            return G__8145__delegate(x, y, z, args)
          };
          G__8145.cljs$lang$arity$variadic = G__8145__delegate;
          return G__8145
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__8144 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__8144__delegate.call(this, p1, p2, p3, ps)
    };
    G__8144.cljs$lang$maxFixedArity = 3;
    G__8144.cljs$lang$applyTo = function(arglist__8147) {
      var p1 = cljs.core.first(arglist__8147);
      var p2 = cljs.core.first(cljs.core.next(arglist__8147));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8147)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8147)));
      return G__8144__delegate(p1, p2, p3, ps)
    };
    G__8144.cljs$lang$arity$variadic = G__8144__delegate;
    return G__8144
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____8166 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____8166) {
        var s__8167 = temp__3974__auto____8166;
        if(cljs.core.chunked_seq_QMARK_.call(null, s__8167)) {
          var c__8168 = cljs.core.chunk_first.call(null, s__8167);
          var size__8169 = cljs.core.count.call(null, c__8168);
          var b__8170 = cljs.core.chunk_buffer.call(null, size__8169);
          var n__2527__auto____8171 = size__8169;
          var i__8172 = 0;
          while(true) {
            if(i__8172 < n__2527__auto____8171) {
              cljs.core.chunk_append.call(null, b__8170, f.call(null, cljs.core._nth.call(null, c__8168, i__8172)));
              var G__8184 = i__8172 + 1;
              i__8172 = G__8184;
              continue
            }else {
            }
            break
          }
          return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__8170), map.call(null, f, cljs.core.chunk_rest.call(null, s__8167)))
        }else {
          return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__8167)), map.call(null, f, cljs.core.rest.call(null, s__8167)))
        }
      }else {
        return null
      }
    }, null)
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__8173 = cljs.core.seq.call(null, c1);
      var s2__8174 = cljs.core.seq.call(null, c2);
      if(function() {
        var and__3822__auto____8175 = s1__8173;
        if(and__3822__auto____8175) {
          return s2__8174
        }else {
          return and__3822__auto____8175
        }
      }()) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__8173), cljs.core.first.call(null, s2__8174)), map.call(null, f, cljs.core.rest.call(null, s1__8173), cljs.core.rest.call(null, s2__8174)))
      }else {
        return null
      }
    }, null)
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__8176 = cljs.core.seq.call(null, c1);
      var s2__8177 = cljs.core.seq.call(null, c2);
      var s3__8178 = cljs.core.seq.call(null, c3);
      if(function() {
        var and__3822__auto____8179 = s1__8176;
        if(and__3822__auto____8179) {
          var and__3822__auto____8180 = s2__8177;
          if(and__3822__auto____8180) {
            return s3__8178
          }else {
            return and__3822__auto____8180
          }
        }else {
          return and__3822__auto____8179
        }
      }()) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__8176), cljs.core.first.call(null, s2__8177), cljs.core.first.call(null, s3__8178)), map.call(null, f, cljs.core.rest.call(null, s1__8176), cljs.core.rest.call(null, s2__8177), cljs.core.rest.call(null, s3__8178)))
      }else {
        return null
      }
    }, null)
  };
  var map__5 = function() {
    var G__8185__delegate = function(f, c1, c2, c3, colls) {
      var step__8183 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__8182 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__8182)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__8182), step.call(null, map.call(null, cljs.core.rest, ss__8182)))
          }else {
            return null
          }
        }, null)
      };
      return map.call(null, function(p1__7987_SHARP_) {
        return cljs.core.apply.call(null, f, p1__7987_SHARP_)
      }, step__8183.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__8185 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__8185__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__8185.cljs$lang$maxFixedArity = 4;
    G__8185.cljs$lang$applyTo = function(arglist__8186) {
      var f = cljs.core.first(arglist__8186);
      var c1 = cljs.core.first(cljs.core.next(arglist__8186));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8186)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8186))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8186))));
      return G__8185__delegate(f, c1, c2, c3, colls)
    };
    G__8185.cljs$lang$arity$variadic = G__8185__delegate;
    return G__8185
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3974__auto____8189 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____8189) {
        var s__8190 = temp__3974__auto____8189;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__8190), take.call(null, n - 1, cljs.core.rest.call(null, s__8190)))
      }else {
        return null
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.drop = function drop(n, coll) {
  var step__8196 = function(n, coll) {
    while(true) {
      var s__8194 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3822__auto____8195 = n > 0;
        if(and__3822__auto____8195) {
          return s__8194
        }else {
          return and__3822__auto____8195
        }
      }())) {
        var G__8197 = n - 1;
        var G__8198 = cljs.core.rest.call(null, s__8194);
        n = G__8197;
        coll = G__8198;
        continue
      }else {
        return s__8194
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__8196.call(null, n, coll)
  }, null)
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__8201 = cljs.core.seq.call(null, coll);
  var lead__8202 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(lead__8202) {
      var G__8203 = cljs.core.next.call(null, s__8201);
      var G__8204 = cljs.core.next.call(null, lead__8202);
      s__8201 = G__8203;
      lead__8202 = G__8204;
      continue
    }else {
      return s__8201
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__8210 = function(pred, coll) {
    while(true) {
      var s__8208 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3822__auto____8209 = s__8208;
        if(and__3822__auto____8209) {
          return pred.call(null, cljs.core.first.call(null, s__8208))
        }else {
          return and__3822__auto____8209
        }
      }())) {
        var G__8211 = pred;
        var G__8212 = cljs.core.rest.call(null, s__8208);
        pred = G__8211;
        coll = G__8212;
        continue
      }else {
        return s__8208
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__8210.call(null, pred, coll)
  }, null)
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____8215 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____8215) {
      var s__8216 = temp__3974__auto____8215;
      return cljs.core.concat.call(null, s__8216, cycle.call(null, s__8216))
    }else {
      return null
    }
  }, null)
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)], true)
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    }, null)
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    }, null)
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }, null))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__8221 = cljs.core.seq.call(null, c1);
      var s2__8222 = cljs.core.seq.call(null, c2);
      if(function() {
        var and__3822__auto____8223 = s1__8221;
        if(and__3822__auto____8223) {
          return s2__8222
        }else {
          return and__3822__auto____8223
        }
      }()) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__8221), cljs.core.cons.call(null, cljs.core.first.call(null, s2__8222), interleave.call(null, cljs.core.rest.call(null, s1__8221), cljs.core.rest.call(null, s2__8222))))
      }else {
        return null
      }
    }, null)
  };
  var interleave__3 = function() {
    var G__8225__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__8224 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__8224)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__8224), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__8224)))
        }else {
          return null
        }
      }, null)
    };
    var G__8225 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__8225__delegate.call(this, c1, c2, colls)
    };
    G__8225.cljs$lang$maxFixedArity = 2;
    G__8225.cljs$lang$applyTo = function(arglist__8226) {
      var c1 = cljs.core.first(arglist__8226);
      var c2 = cljs.core.first(cljs.core.next(arglist__8226));
      var colls = cljs.core.rest(cljs.core.next(arglist__8226));
      return G__8225__delegate(c1, c2, colls)
    };
    G__8225.cljs$lang$arity$variadic = G__8225__delegate;
    return G__8225
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__8236 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3971__auto____8234 = cljs.core.seq.call(null, coll);
      if(temp__3971__auto____8234) {
        var coll__8235 = temp__3971__auto____8234;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__8235), cat.call(null, cljs.core.rest.call(null, coll__8235), colls))
      }else {
        if(cljs.core.seq.call(null, colls)) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    }, null)
  };
  return cat__8236.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__8237__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__8237 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__8237__delegate.call(this, f, coll, colls)
    };
    G__8237.cljs$lang$maxFixedArity = 2;
    G__8237.cljs$lang$applyTo = function(arglist__8238) {
      var f = cljs.core.first(arglist__8238);
      var coll = cljs.core.first(cljs.core.next(arglist__8238));
      var colls = cljs.core.rest(cljs.core.next(arglist__8238));
      return G__8237__delegate(f, coll, colls)
    };
    G__8237.cljs$lang$arity$variadic = G__8237__delegate;
    return G__8237
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____8248 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____8248) {
      var s__8249 = temp__3974__auto____8248;
      if(cljs.core.chunked_seq_QMARK_.call(null, s__8249)) {
        var c__8250 = cljs.core.chunk_first.call(null, s__8249);
        var size__8251 = cljs.core.count.call(null, c__8250);
        var b__8252 = cljs.core.chunk_buffer.call(null, size__8251);
        var n__2527__auto____8253 = size__8251;
        var i__8254 = 0;
        while(true) {
          if(i__8254 < n__2527__auto____8253) {
            if(cljs.core.truth_(pred.call(null, cljs.core._nth.call(null, c__8250, i__8254)))) {
              cljs.core.chunk_append.call(null, b__8252, cljs.core._nth.call(null, c__8250, i__8254))
            }else {
            }
            var G__8257 = i__8254 + 1;
            i__8254 = G__8257;
            continue
          }else {
          }
          break
        }
        return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__8252), filter.call(null, pred, cljs.core.chunk_rest.call(null, s__8249)))
      }else {
        var f__8255 = cljs.core.first.call(null, s__8249);
        var r__8256 = cljs.core.rest.call(null, s__8249);
        if(cljs.core.truth_(pred.call(null, f__8255))) {
          return cljs.core.cons.call(null, f__8255, filter.call(null, pred, r__8256))
        }else {
          return filter.call(null, pred, r__8256)
        }
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__8260 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    }, null)
  };
  return walk__8260.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__8258_SHARP_) {
    return!cljs.core.sequential_QMARK_.call(null, p1__8258_SHARP_)
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__8264__8265 = to;
    if(G__8264__8265) {
      if(function() {
        var or__3824__auto____8266 = G__8264__8265.cljs$lang$protocol_mask$partition1$ & 1;
        if(or__3824__auto____8266) {
          return or__3824__auto____8266
        }else {
          return G__8264__8265.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__8264__8265.cljs$lang$protocol_mask$partition1$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__8264__8265)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__8264__8265)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__8267__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__8267 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__8267__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__8267.cljs$lang$maxFixedArity = 4;
    G__8267.cljs$lang$applyTo = function(arglist__8268) {
      var f = cljs.core.first(arglist__8268);
      var c1 = cljs.core.first(cljs.core.next(arglist__8268));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8268)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8268))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8268))));
      return G__8267__delegate(f, c1, c2, c3, colls)
    };
    G__8267.cljs$lang$arity$variadic = G__8267__delegate;
    return G__8267
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____8275 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____8275) {
        var s__8276 = temp__3974__auto____8275;
        var p__8277 = cljs.core.take.call(null, n, s__8276);
        if(n === cljs.core.count.call(null, p__8277)) {
          return cljs.core.cons.call(null, p__8277, partition.call(null, n, step, cljs.core.drop.call(null, step, s__8276)))
        }else {
          return null
        }
      }else {
        return null
      }
    }, null)
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____8278 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____8278) {
        var s__8279 = temp__3974__auto____8278;
        var p__8280 = cljs.core.take.call(null, n, s__8279);
        if(n === cljs.core.count.call(null, p__8280)) {
          return cljs.core.cons.call(null, p__8280, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__8279)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__8280, pad)))
        }
      }else {
        return null
      }
    }, null)
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__8285 = cljs.core.lookup_sentinel;
    var m__8286 = m;
    var ks__8287 = cljs.core.seq.call(null, ks);
    while(true) {
      if(ks__8287) {
        var m__8288 = cljs.core._lookup.call(null, m__8286, cljs.core.first.call(null, ks__8287), sentinel__8285);
        if(sentinel__8285 === m__8288) {
          return not_found
        }else {
          var G__8289 = sentinel__8285;
          var G__8290 = m__8288;
          var G__8291 = cljs.core.next.call(null, ks__8287);
          sentinel__8285 = G__8289;
          m__8286 = G__8290;
          ks__8287 = G__8291;
          continue
        }
      }else {
        return m__8286
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__8292, v) {
  var vec__8297__8298 = p__8292;
  var k__8299 = cljs.core.nth.call(null, vec__8297__8298, 0, null);
  var ks__8300 = cljs.core.nthnext.call(null, vec__8297__8298, 1);
  if(cljs.core.truth_(ks__8300)) {
    return cljs.core.assoc.call(null, m, k__8299, assoc_in.call(null, cljs.core._lookup.call(null, m, k__8299, null), ks__8300, v))
  }else {
    return cljs.core.assoc.call(null, m, k__8299, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__8301, f, args) {
    var vec__8306__8307 = p__8301;
    var k__8308 = cljs.core.nth.call(null, vec__8306__8307, 0, null);
    var ks__8309 = cljs.core.nthnext.call(null, vec__8306__8307, 1);
    if(cljs.core.truth_(ks__8309)) {
      return cljs.core.assoc.call(null, m, k__8308, cljs.core.apply.call(null, update_in, cljs.core._lookup.call(null, m, k__8308, null), ks__8309, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__8308, cljs.core.apply.call(null, f, cljs.core._lookup.call(null, m, k__8308, null), args))
    }
  };
  var update_in = function(m, p__8301, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__8301, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__8310) {
    var m = cljs.core.first(arglist__8310);
    var p__8301 = cljs.core.first(cljs.core.next(arglist__8310));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8310)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8310)));
    return update_in__delegate(m, p__8301, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32400159
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__8313 = this;
  var h__2192__auto____8314 = this__8313.__hash;
  if(!(h__2192__auto____8314 == null)) {
    return h__2192__auto____8314
  }else {
    var h__2192__auto____8315 = cljs.core.hash_coll.call(null, coll);
    this__8313.__hash = h__2192__auto____8315;
    return h__2192__auto____8315
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__8316 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__8317 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__8318 = this;
  var new_array__8319 = this__8318.array.slice();
  new_array__8319[k] = v;
  return new cljs.core.Vector(this__8318.meta, new_array__8319, null)
};
cljs.core.Vector.prototype.call = function() {
  var G__8350 = null;
  var G__8350__2 = function(this_sym8320, k) {
    var this__8322 = this;
    var this_sym8320__8323 = this;
    var coll__8324 = this_sym8320__8323;
    return coll__8324.cljs$core$ILookup$_lookup$arity$2(coll__8324, k)
  };
  var G__8350__3 = function(this_sym8321, k, not_found) {
    var this__8322 = this;
    var this_sym8321__8325 = this;
    var coll__8326 = this_sym8321__8325;
    return coll__8326.cljs$core$ILookup$_lookup$arity$3(coll__8326, k, not_found)
  };
  G__8350 = function(this_sym8321, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8350__2.call(this, this_sym8321, k);
      case 3:
        return G__8350__3.call(this, this_sym8321, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__8350
}();
cljs.core.Vector.prototype.apply = function(this_sym8311, args8312) {
  var this__8327 = this;
  return this_sym8311.call.apply(this_sym8311, [this_sym8311].concat(args8312.slice()))
};
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__8328 = this;
  var new_array__8329 = this__8328.array.slice();
  new_array__8329.push(o);
  return new cljs.core.Vector(this__8328.meta, new_array__8329, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__8330 = this;
  var this__8331 = this;
  return cljs.core.pr_str.call(null, this__8331)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__8332 = this;
  return cljs.core.ci_reduce.call(null, this__8332.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__8333 = this;
  return cljs.core.ci_reduce.call(null, this__8333.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8334 = this;
  if(this__8334.array.length > 0) {
    var vector_seq__8335 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__8334.array.length) {
          return cljs.core.cons.call(null, this__8334.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      }, null)
    };
    return vector_seq__8335.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__8336 = this;
  return this__8336.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__8337 = this;
  var count__8338 = this__8337.array.length;
  if(count__8338 > 0) {
    return this__8337.array[count__8338 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__8339 = this;
  if(this__8339.array.length > 0) {
    var new_array__8340 = this__8339.array.slice();
    new_array__8340.pop();
    return new cljs.core.Vector(this__8339.meta, new_array__8340, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__8341 = this;
  return coll.cljs$core$IAssociative$_assoc$arity$3(coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8342 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__8343 = this;
  return new cljs.core.Vector(meta, this__8343.array, this__8343.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__8344 = this;
  return this__8344.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__8345 = this;
  if(function() {
    var and__3822__auto____8346 = 0 <= n;
    if(and__3822__auto____8346) {
      return n < this__8345.array.length
    }else {
      return and__3822__auto____8346
    }
  }()) {
    return this__8345.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__8347 = this;
  if(function() {
    var and__3822__auto____8348 = 0 <= n;
    if(and__3822__auto____8348) {
      return n < this__8347.array.length
    }else {
      return and__3822__auto____8348
    }
  }()) {
    return this__8347.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8349 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__8349.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__2310__auto__) {
  return cljs.core.list.call(null, "cljs.core/VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, node.arr.slice())
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__8352 = pv.cnt;
  if(cnt__8352 < 32) {
    return 0
  }else {
    return cnt__8352 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__8358 = level;
  var ret__8359 = node;
  while(true) {
    if(ll__8358 === 0) {
      return ret__8359
    }else {
      var embed__8360 = ret__8359;
      var r__8361 = cljs.core.pv_fresh_node.call(null, edit);
      var ___8362 = cljs.core.pv_aset.call(null, r__8361, 0, embed__8360);
      var G__8363 = ll__8358 - 5;
      var G__8364 = r__8361;
      ll__8358 = G__8363;
      ret__8359 = G__8364;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__8370 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__8371 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__8370, subidx__8371, tailnode);
    return ret__8370
  }else {
    var child__8372 = cljs.core.pv_aget.call(null, parent, subidx__8371);
    if(!(child__8372 == null)) {
      var node_to_insert__8373 = push_tail.call(null, pv, level - 5, child__8372, tailnode);
      cljs.core.pv_aset.call(null, ret__8370, subidx__8371, node_to_insert__8373);
      return ret__8370
    }else {
      var node_to_insert__8374 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__8370, subidx__8371, node_to_insert__8374);
      return ret__8370
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3822__auto____8378 = 0 <= i;
    if(and__3822__auto____8378) {
      return i < pv.cnt
    }else {
      return and__3822__auto____8378
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__8379 = pv.root;
      var level__8380 = pv.shift;
      while(true) {
        if(level__8380 > 0) {
          var G__8381 = cljs.core.pv_aget.call(null, node__8379, i >>> level__8380 & 31);
          var G__8382 = level__8380 - 5;
          node__8379 = G__8381;
          level__8380 = G__8382;
          continue
        }else {
          return node__8379.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__8385 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__8385, i & 31, val);
    return ret__8385
  }else {
    var subidx__8386 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__8385, subidx__8386, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__8386), i, val));
    return ret__8385
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__8392 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__8393 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__8392));
    if(function() {
      var and__3822__auto____8394 = new_child__8393 == null;
      if(and__3822__auto____8394) {
        return subidx__8392 === 0
      }else {
        return and__3822__auto____8394
      }
    }()) {
      return null
    }else {
      var ret__8395 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__8395, subidx__8392, new_child__8393);
      return ret__8395
    }
  }else {
    if(subidx__8392 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__8396 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__8396, subidx__8392, null);
        return ret__8396
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 167668511
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__8399 = this;
  return new cljs.core.TransientVector(this__8399.cnt, this__8399.shift, cljs.core.tv_editable_root.call(null, this__8399.root), cljs.core.tv_editable_tail.call(null, this__8399.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__8400 = this;
  var h__2192__auto____8401 = this__8400.__hash;
  if(!(h__2192__auto____8401 == null)) {
    return h__2192__auto____8401
  }else {
    var h__2192__auto____8402 = cljs.core.hash_coll.call(null, coll);
    this__8400.__hash = h__2192__auto____8402;
    return h__2192__auto____8402
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__8403 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__8404 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__8405 = this;
  if(function() {
    var and__3822__auto____8406 = 0 <= k;
    if(and__3822__auto____8406) {
      return k < this__8405.cnt
    }else {
      return and__3822__auto____8406
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__8407 = this__8405.tail.slice();
      new_tail__8407[k & 31] = v;
      return new cljs.core.PersistentVector(this__8405.meta, this__8405.cnt, this__8405.shift, this__8405.root, new_tail__8407, null)
    }else {
      return new cljs.core.PersistentVector(this__8405.meta, this__8405.cnt, this__8405.shift, cljs.core.do_assoc.call(null, coll, this__8405.shift, this__8405.root, k, v), this__8405.tail, null)
    }
  }else {
    if(k === this__8405.cnt) {
      return coll.cljs$core$ICollection$_conj$arity$2(coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__8405.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__8455 = null;
  var G__8455__2 = function(this_sym8408, k) {
    var this__8410 = this;
    var this_sym8408__8411 = this;
    var coll__8412 = this_sym8408__8411;
    return coll__8412.cljs$core$ILookup$_lookup$arity$2(coll__8412, k)
  };
  var G__8455__3 = function(this_sym8409, k, not_found) {
    var this__8410 = this;
    var this_sym8409__8413 = this;
    var coll__8414 = this_sym8409__8413;
    return coll__8414.cljs$core$ILookup$_lookup$arity$3(coll__8414, k, not_found)
  };
  G__8455 = function(this_sym8409, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8455__2.call(this, this_sym8409, k);
      case 3:
        return G__8455__3.call(this, this_sym8409, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__8455
}();
cljs.core.PersistentVector.prototype.apply = function(this_sym8397, args8398) {
  var this__8415 = this;
  return this_sym8397.call.apply(this_sym8397, [this_sym8397].concat(args8398.slice()))
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__8416 = this;
  var step_init__8417 = [0, init];
  var i__8418 = 0;
  while(true) {
    if(i__8418 < this__8416.cnt) {
      var arr__8419 = cljs.core.array_for.call(null, v, i__8418);
      var len__8420 = arr__8419.length;
      var init__8424 = function() {
        var j__8421 = 0;
        var init__8422 = step_init__8417[1];
        while(true) {
          if(j__8421 < len__8420) {
            var init__8423 = f.call(null, init__8422, j__8421 + i__8418, arr__8419[j__8421]);
            if(cljs.core.reduced_QMARK_.call(null, init__8423)) {
              return init__8423
            }else {
              var G__8456 = j__8421 + 1;
              var G__8457 = init__8423;
              j__8421 = G__8456;
              init__8422 = G__8457;
              continue
            }
          }else {
            step_init__8417[0] = len__8420;
            step_init__8417[1] = init__8422;
            return init__8422
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__8424)) {
        return cljs.core.deref.call(null, init__8424)
      }else {
        var G__8458 = i__8418 + step_init__8417[0];
        i__8418 = G__8458;
        continue
      }
    }else {
      return step_init__8417[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__8425 = this;
  if(this__8425.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__8426 = this__8425.tail.slice();
    new_tail__8426.push(o);
    return new cljs.core.PersistentVector(this__8425.meta, this__8425.cnt + 1, this__8425.shift, this__8425.root, new_tail__8426, null)
  }else {
    var root_overflow_QMARK___8427 = this__8425.cnt >>> 5 > 1 << this__8425.shift;
    var new_shift__8428 = root_overflow_QMARK___8427 ? this__8425.shift + 5 : this__8425.shift;
    var new_root__8430 = root_overflow_QMARK___8427 ? function() {
      var n_r__8429 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__8429, 0, this__8425.root);
      cljs.core.pv_aset.call(null, n_r__8429, 1, cljs.core.new_path.call(null, null, this__8425.shift, new cljs.core.VectorNode(null, this__8425.tail)));
      return n_r__8429
    }() : cljs.core.push_tail.call(null, coll, this__8425.shift, this__8425.root, new cljs.core.VectorNode(null, this__8425.tail));
    return new cljs.core.PersistentVector(this__8425.meta, this__8425.cnt + 1, new_shift__8428, new_root__8430, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__8431 = this;
  if(this__8431.cnt > 0) {
    return new cljs.core.RSeq(coll, this__8431.cnt - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__8432 = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__8433 = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__8434 = this;
  var this__8435 = this;
  return cljs.core.pr_str.call(null, this__8435)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__8436 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__8437 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8438 = this;
  if(this__8438.cnt === 0) {
    return null
  }else {
    return cljs.core.chunked_seq.call(null, coll, 0, 0)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__8439 = this;
  return this__8439.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__8440 = this;
  if(this__8440.cnt > 0) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, this__8440.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__8441 = this;
  if(this__8441.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__8441.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__8441.meta)
    }else {
      if(1 < this__8441.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__8441.meta, this__8441.cnt - 1, this__8441.shift, this__8441.root, this__8441.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__8442 = cljs.core.array_for.call(null, coll, this__8441.cnt - 2);
          var nr__8443 = cljs.core.pop_tail.call(null, coll, this__8441.shift, this__8441.root);
          var new_root__8444 = nr__8443 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__8443;
          var cnt_1__8445 = this__8441.cnt - 1;
          if(function() {
            var and__3822__auto____8446 = 5 < this__8441.shift;
            if(and__3822__auto____8446) {
              return cljs.core.pv_aget.call(null, new_root__8444, 1) == null
            }else {
              return and__3822__auto____8446
            }
          }()) {
            return new cljs.core.PersistentVector(this__8441.meta, cnt_1__8445, this__8441.shift - 5, cljs.core.pv_aget.call(null, new_root__8444, 0), new_tail__8442, null)
          }else {
            return new cljs.core.PersistentVector(this__8441.meta, cnt_1__8445, this__8441.shift, new_root__8444, new_tail__8442, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__8447 = this;
  return coll.cljs$core$IAssociative$_assoc$arity$3(coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8448 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__8449 = this;
  return new cljs.core.PersistentVector(meta, this__8449.cnt, this__8449.shift, this__8449.root, this__8449.tail, this__8449.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__8450 = this;
  return this__8450.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__8451 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__8452 = this;
  if(function() {
    var and__3822__auto____8453 = 0 <= n;
    if(and__3822__auto____8453) {
      return n < this__8452.cnt
    }else {
      return and__3822__auto____8453
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8454 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__8454.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l__8459 = xs.length;
  var xs__8460 = no_clone === true ? xs : xs.slice();
  if(l__8459 < 32) {
    return new cljs.core.PersistentVector(null, l__8459, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__8460, null)
  }else {
    var node__8461 = xs__8460.slice(0, 32);
    var v__8462 = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node__8461, null);
    var i__8463 = 32;
    var out__8464 = cljs.core._as_transient.call(null, v__8462);
    while(true) {
      if(i__8463 < l__8459) {
        var G__8465 = i__8463 + 1;
        var G__8466 = cljs.core.conj_BANG_.call(null, out__8464, xs__8460[i__8463]);
        i__8463 = G__8465;
        out__8464 = G__8466;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__8464)
      }
      break
    }
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core._persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core._as_transient.call(null, cljs.core.PersistentVector.EMPTY), coll))
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__8467) {
    var args = cljs.core.seq(arglist__8467);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.ChunkedSeq = function(vec, node, i, off, meta) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 27525356
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ChunkedSeq")
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__8468 = this;
  if(this__8468.off + 1 < this__8468.node.length) {
    var s__8469 = cljs.core.chunked_seq.call(null, this__8468.vec, this__8468.node, this__8468.i, this__8468.off + 1);
    if(s__8469 == null) {
      return null
    }else {
      return s__8469
    }
  }else {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll)
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__8470 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8471 = this;
  return coll
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__8472 = this;
  return this__8472.node[this__8472.off]
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__8473 = this;
  if(this__8473.off + 1 < this__8473.node.length) {
    var s__8474 = cljs.core.chunked_seq.call(null, this__8473.vec, this__8473.node, this__8473.i, this__8473.off + 1);
    if(s__8474 == null) {
      return cljs.core.List.EMPTY
    }else {
      return s__8474
    }
  }else {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll)
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var this__8475 = this;
  var l__8476 = this__8475.node.length;
  var s__8477 = this__8475.i + l__8476 < cljs.core._count.call(null, this__8475.vec) ? cljs.core.chunked_seq.call(null, this__8475.vec, this__8475.i + l__8476, 0) : null;
  if(s__8477 == null) {
    return null
  }else {
    return s__8477
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8478 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var this__8479 = this;
  return cljs.core.chunked_seq.call(null, this__8479.vec, this__8479.node, this__8479.i, this__8479.off, m)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_meta$arity$1 = function(coll) {
  var this__8480 = this;
  return this__8480.meta
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8481 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__8481.meta)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var this__8482 = this;
  return cljs.core.array_chunk.call(null, this__8482.node, this__8482.off)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var this__8483 = this;
  var l__8484 = this__8483.node.length;
  var s__8485 = this__8483.i + l__8484 < cljs.core._count.call(null, this__8483.vec) ? cljs.core.chunked_seq.call(null, this__8483.vec, this__8483.i + l__8484, 0) : null;
  if(s__8485 == null) {
    return cljs.core.List.EMPTY
  }else {
    return s__8485
  }
};
cljs.core.ChunkedSeq;
cljs.core.chunked_seq = function() {
  var chunked_seq = null;
  var chunked_seq__3 = function(vec, i, off) {
    return chunked_seq.call(null, vec, cljs.core.array_for.call(null, vec, i), i, off, null)
  };
  var chunked_seq__4 = function(vec, node, i, off) {
    return chunked_seq.call(null, vec, node, i, off, null)
  };
  var chunked_seq__5 = function(vec, node, i, off, meta) {
    return new cljs.core.ChunkedSeq(vec, node, i, off, meta)
  };
  chunked_seq = function(vec, node, i, off, meta) {
    switch(arguments.length) {
      case 3:
        return chunked_seq__3.call(this, vec, node, i);
      case 4:
        return chunked_seq__4.call(this, vec, node, i, off);
      case 5:
        return chunked_seq__5.call(this, vec, node, i, off, meta)
    }
    throw"Invalid arity: " + arguments.length;
  };
  chunked_seq.cljs$lang$arity$3 = chunked_seq__3;
  chunked_seq.cljs$lang$arity$4 = chunked_seq__4;
  chunked_seq.cljs$lang$arity$5 = chunked_seq__5;
  return chunked_seq
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32400159
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__8488 = this;
  var h__2192__auto____8489 = this__8488.__hash;
  if(!(h__2192__auto____8489 == null)) {
    return h__2192__auto____8489
  }else {
    var h__2192__auto____8490 = cljs.core.hash_coll.call(null, coll);
    this__8488.__hash = h__2192__auto____8490;
    return h__2192__auto____8490
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__8491 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__8492 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__8493 = this;
  var v_pos__8494 = this__8493.start + key;
  return new cljs.core.Subvec(this__8493.meta, cljs.core._assoc.call(null, this__8493.v, v_pos__8494, val), this__8493.start, this__8493.end > v_pos__8494 + 1 ? this__8493.end : v_pos__8494 + 1, null)
};
cljs.core.Subvec.prototype.call = function() {
  var G__8520 = null;
  var G__8520__2 = function(this_sym8495, k) {
    var this__8497 = this;
    var this_sym8495__8498 = this;
    var coll__8499 = this_sym8495__8498;
    return coll__8499.cljs$core$ILookup$_lookup$arity$2(coll__8499, k)
  };
  var G__8520__3 = function(this_sym8496, k, not_found) {
    var this__8497 = this;
    var this_sym8496__8500 = this;
    var coll__8501 = this_sym8496__8500;
    return coll__8501.cljs$core$ILookup$_lookup$arity$3(coll__8501, k, not_found)
  };
  G__8520 = function(this_sym8496, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8520__2.call(this, this_sym8496, k);
      case 3:
        return G__8520__3.call(this, this_sym8496, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__8520
}();
cljs.core.Subvec.prototype.apply = function(this_sym8486, args8487) {
  var this__8502 = this;
  return this_sym8486.call.apply(this_sym8486, [this_sym8486].concat(args8487.slice()))
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__8503 = this;
  return new cljs.core.Subvec(this__8503.meta, cljs.core._assoc_n.call(null, this__8503.v, this__8503.end, o), this__8503.start, this__8503.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__8504 = this;
  var this__8505 = this;
  return cljs.core.pr_str.call(null, this__8505)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__8506 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__8507 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8508 = this;
  var subvec_seq__8509 = function subvec_seq(i) {
    if(i === this__8508.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__8508.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }, null))
    }
  };
  return subvec_seq__8509.call(null, this__8508.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__8510 = this;
  return this__8510.end - this__8510.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__8511 = this;
  return cljs.core._nth.call(null, this__8511.v, this__8511.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__8512 = this;
  if(this__8512.start === this__8512.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__8512.meta, this__8512.v, this__8512.start, this__8512.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__8513 = this;
  return coll.cljs$core$IAssociative$_assoc$arity$3(coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8514 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__8515 = this;
  return new cljs.core.Subvec(meta, this__8515.v, this__8515.start, this__8515.end, this__8515.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__8516 = this;
  return this__8516.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__8517 = this;
  return cljs.core._nth.call(null, this__8517.v, this__8517.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__8518 = this;
  return cljs.core._nth.call(null, this__8518.v, this__8518.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8519 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__8519.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, node.arr.slice())
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, node.arr.slice())
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__8522 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__8522, 0, tl.length);
  return ret__8522
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__8526 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__8527 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__8526, subidx__8527, level === 5 ? tail_node : function() {
    var child__8528 = cljs.core.pv_aget.call(null, ret__8526, subidx__8527);
    if(!(child__8528 == null)) {
      return tv_push_tail.call(null, tv, level - 5, child__8528, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__8526
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__8533 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__8534 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__8535 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__8533, subidx__8534));
    if(function() {
      var and__3822__auto____8536 = new_child__8535 == null;
      if(and__3822__auto____8536) {
        return subidx__8534 === 0
      }else {
        return and__3822__auto____8536
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__8533, subidx__8534, new_child__8535);
      return node__8533
    }
  }else {
    if(subidx__8534 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__8533, subidx__8534, null);
        return node__8533
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3822__auto____8541 = 0 <= i;
    if(and__3822__auto____8541) {
      return i < tv.cnt
    }else {
      return and__3822__auto____8541
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__8542 = tv.root;
      var node__8543 = root__8542;
      var level__8544 = tv.shift;
      while(true) {
        if(level__8544 > 0) {
          var G__8545 = cljs.core.tv_ensure_editable.call(null, root__8542.edit, cljs.core.pv_aget.call(null, node__8543, i >>> level__8544 & 31));
          var G__8546 = level__8544 - 5;
          node__8543 = G__8545;
          level__8544 = G__8546;
          continue
        }else {
          return node__8543.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 275;
  this.cljs$lang$protocol_mask$partition1$ = 22
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientVector")
};
cljs.core.TransientVector.prototype.call = function() {
  var G__8586 = null;
  var G__8586__2 = function(this_sym8549, k) {
    var this__8551 = this;
    var this_sym8549__8552 = this;
    var coll__8553 = this_sym8549__8552;
    return coll__8553.cljs$core$ILookup$_lookup$arity$2(coll__8553, k)
  };
  var G__8586__3 = function(this_sym8550, k, not_found) {
    var this__8551 = this;
    var this_sym8550__8554 = this;
    var coll__8555 = this_sym8550__8554;
    return coll__8555.cljs$core$ILookup$_lookup$arity$3(coll__8555, k, not_found)
  };
  G__8586 = function(this_sym8550, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8586__2.call(this, this_sym8550, k);
      case 3:
        return G__8586__3.call(this, this_sym8550, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__8586
}();
cljs.core.TransientVector.prototype.apply = function(this_sym8547, args8548) {
  var this__8556 = this;
  return this_sym8547.call.apply(this_sym8547, [this_sym8547].concat(args8548.slice()))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__8557 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__8558 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__8559 = this;
  if(this__8559.root.edit) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__8560 = this;
  if(function() {
    var and__3822__auto____8561 = 0 <= n;
    if(and__3822__auto____8561) {
      return n < this__8560.cnt
    }else {
      return and__3822__auto____8561
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__8562 = this;
  if(this__8562.root.edit) {
    return this__8562.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__8563 = this;
  if(this__8563.root.edit) {
    if(function() {
      var and__3822__auto____8564 = 0 <= n;
      if(and__3822__auto____8564) {
        return n < this__8563.cnt
      }else {
        return and__3822__auto____8564
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__8563.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__8569 = function go(level, node) {
          var node__8567 = cljs.core.tv_ensure_editable.call(null, this__8563.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__8567, n & 31, val);
            return node__8567
          }else {
            var subidx__8568 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__8567, subidx__8568, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__8567, subidx__8568)));
            return node__8567
          }
        }.call(null, this__8563.shift, this__8563.root);
        this__8563.root = new_root__8569;
        return tcoll
      }
    }else {
      if(n === this__8563.cnt) {
        return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__8563.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__8570 = this;
  if(this__8570.root.edit) {
    if(this__8570.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__8570.cnt) {
        this__8570.cnt = 0;
        return tcoll
      }else {
        if((this__8570.cnt - 1 & 31) > 0) {
          this__8570.cnt = this__8570.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__8571 = cljs.core.editable_array_for.call(null, tcoll, this__8570.cnt - 2);
            var new_root__8573 = function() {
              var nr__8572 = cljs.core.tv_pop_tail.call(null, tcoll, this__8570.shift, this__8570.root);
              if(!(nr__8572 == null)) {
                return nr__8572
              }else {
                return new cljs.core.VectorNode(this__8570.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3822__auto____8574 = 5 < this__8570.shift;
              if(and__3822__auto____8574) {
                return cljs.core.pv_aget.call(null, new_root__8573, 1) == null
              }else {
                return and__3822__auto____8574
              }
            }()) {
              var new_root__8575 = cljs.core.tv_ensure_editable.call(null, this__8570.root.edit, cljs.core.pv_aget.call(null, new_root__8573, 0));
              this__8570.root = new_root__8575;
              this__8570.shift = this__8570.shift - 5;
              this__8570.cnt = this__8570.cnt - 1;
              this__8570.tail = new_tail__8571;
              return tcoll
            }else {
              this__8570.root = new_root__8573;
              this__8570.cnt = this__8570.cnt - 1;
              this__8570.tail = new_tail__8571;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__8576 = this;
  return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__8577 = this;
  if(this__8577.root.edit) {
    if(this__8577.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__8577.tail[this__8577.cnt & 31] = o;
      this__8577.cnt = this__8577.cnt + 1;
      return tcoll
    }else {
      var tail_node__8578 = new cljs.core.VectorNode(this__8577.root.edit, this__8577.tail);
      var new_tail__8579 = cljs.core.make_array.call(null, 32);
      new_tail__8579[0] = o;
      this__8577.tail = new_tail__8579;
      if(this__8577.cnt >>> 5 > 1 << this__8577.shift) {
        var new_root_array__8580 = cljs.core.make_array.call(null, 32);
        var new_shift__8581 = this__8577.shift + 5;
        new_root_array__8580[0] = this__8577.root;
        new_root_array__8580[1] = cljs.core.new_path.call(null, this__8577.root.edit, this__8577.shift, tail_node__8578);
        this__8577.root = new cljs.core.VectorNode(this__8577.root.edit, new_root_array__8580);
        this__8577.shift = new_shift__8581;
        this__8577.cnt = this__8577.cnt + 1;
        return tcoll
      }else {
        var new_root__8582 = cljs.core.tv_push_tail.call(null, tcoll, this__8577.shift, this__8577.root, tail_node__8578);
        this__8577.root = new_root__8582;
        this__8577.cnt = this__8577.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__8583 = this;
  if(this__8583.root.edit) {
    this__8583.root.edit = null;
    var len__8584 = this__8583.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__8585 = cljs.core.make_array.call(null, len__8584);
    cljs.core.array_copy.call(null, this__8583.tail, 0, trimmed_tail__8585, 0, len__8584);
    return new cljs.core.PersistentVector(null, this__8583.cnt, this__8583.shift, this__8583.root, trimmed_tail__8585, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850572
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__8587 = this;
  var h__2192__auto____8588 = this__8587.__hash;
  if(!(h__2192__auto____8588 == null)) {
    return h__2192__auto____8588
  }else {
    var h__2192__auto____8589 = cljs.core.hash_coll.call(null, coll);
    this__8587.__hash = h__2192__auto____8589;
    return h__2192__auto____8589
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__8590 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__8591 = this;
  var this__8592 = this;
  return cljs.core.pr_str.call(null, this__8592)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8593 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__8594 = this;
  return cljs.core._first.call(null, this__8594.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__8595 = this;
  var temp__3971__auto____8596 = cljs.core.next.call(null, this__8595.front);
  if(temp__3971__auto____8596) {
    var f1__8597 = temp__3971__auto____8596;
    return new cljs.core.PersistentQueueSeq(this__8595.meta, f1__8597, this__8595.rear, null)
  }else {
    if(this__8595.rear == null) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__8595.meta, this__8595.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8598 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__8599 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__8599.front, this__8599.rear, this__8599.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__8600 = this;
  return this__8600.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8601 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__8601.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31858766
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__8602 = this;
  var h__2192__auto____8603 = this__8602.__hash;
  if(!(h__2192__auto____8603 == null)) {
    return h__2192__auto____8603
  }else {
    var h__2192__auto____8604 = cljs.core.hash_coll.call(null, coll);
    this__8602.__hash = h__2192__auto____8604;
    return h__2192__auto____8604
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__8605 = this;
  if(cljs.core.truth_(this__8605.front)) {
    return new cljs.core.PersistentQueue(this__8605.meta, this__8605.count + 1, this__8605.front, cljs.core.conj.call(null, function() {
      var or__3824__auto____8606 = this__8605.rear;
      if(cljs.core.truth_(or__3824__auto____8606)) {
        return or__3824__auto____8606
      }else {
        return cljs.core.PersistentVector.EMPTY
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__8605.meta, this__8605.count + 1, cljs.core.conj.call(null, this__8605.front, o), cljs.core.PersistentVector.EMPTY, null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__8607 = this;
  var this__8608 = this;
  return cljs.core.pr_str.call(null, this__8608)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8609 = this;
  var rear__8610 = cljs.core.seq.call(null, this__8609.rear);
  if(cljs.core.truth_(function() {
    var or__3824__auto____8611 = this__8609.front;
    if(cljs.core.truth_(or__3824__auto____8611)) {
      return or__3824__auto____8611
    }else {
      return rear__8610
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__8609.front, cljs.core.seq.call(null, rear__8610), null)
  }else {
    return null
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__8612 = this;
  return this__8612.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__8613 = this;
  return cljs.core._first.call(null, this__8613.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__8614 = this;
  if(cljs.core.truth_(this__8614.front)) {
    var temp__3971__auto____8615 = cljs.core.next.call(null, this__8614.front);
    if(temp__3971__auto____8615) {
      var f1__8616 = temp__3971__auto____8615;
      return new cljs.core.PersistentQueue(this__8614.meta, this__8614.count - 1, f1__8616, this__8614.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__8614.meta, this__8614.count - 1, cljs.core.seq.call(null, this__8614.rear), cljs.core.PersistentVector.EMPTY, null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__8617 = this;
  return cljs.core.first.call(null, this__8617.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__8618 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8619 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__8620 = this;
  return new cljs.core.PersistentQueue(meta, this__8620.count, this__8620.front, this__8620.rear, this__8620.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__8621 = this;
  return this__8621.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8622 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2097152
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__8623 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core._lookup.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__8626 = array.length;
  var i__8627 = 0;
  while(true) {
    if(i__8627 < len__8626) {
      if(k === array[i__8627]) {
        return i__8627
      }else {
        var G__8628 = i__8627 + incr;
        i__8627 = G__8628;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__8631 = cljs.core.hash.call(null, a);
  var b__8632 = cljs.core.hash.call(null, b);
  if(a__8631 < b__8632) {
    return-1
  }else {
    if(a__8631 > b__8632) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__8640 = m.keys;
  var len__8641 = ks__8640.length;
  var so__8642 = m.strobj;
  var out__8643 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__8644 = 0;
  var out__8645 = cljs.core.transient$.call(null, out__8643);
  while(true) {
    if(i__8644 < len__8641) {
      var k__8646 = ks__8640[i__8644];
      var G__8647 = i__8644 + 1;
      var G__8648 = cljs.core.assoc_BANG_.call(null, out__8645, k__8646, so__8642[k__8646]);
      i__8644 = G__8647;
      out__8645 = G__8648;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__8645, k, v))
    }
    break
  }
};
cljs.core.obj_clone = function obj_clone(obj, ks) {
  var new_obj__8654 = {};
  var l__8655 = ks.length;
  var i__8656 = 0;
  while(true) {
    if(i__8656 < l__8655) {
      var k__8657 = ks[i__8656];
      new_obj__8654[k__8657] = obj[k__8657];
      var G__8658 = i__8656 + 1;
      i__8656 = G__8658;
      continue
    }else {
    }
    break
  }
  return new_obj__8654
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 15075087
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__8661 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__8662 = this;
  var h__2192__auto____8663 = this__8662.__hash;
  if(!(h__2192__auto____8663 == null)) {
    return h__2192__auto____8663
  }else {
    var h__2192__auto____8664 = cljs.core.hash_imap.call(null, coll);
    this__8662.__hash = h__2192__auto____8664;
    return h__2192__auto____8664
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__8665 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__8666 = this;
  if(function() {
    var and__3822__auto____8667 = goog.isString(k);
    if(and__3822__auto____8667) {
      return!(cljs.core.scan_array.call(null, 1, k, this__8666.keys) == null)
    }else {
      return and__3822__auto____8667
    }
  }()) {
    return this__8666.strobj[k]
  }else {
    return not_found
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__8668 = this;
  if(goog.isString(k)) {
    if(function() {
      var or__3824__auto____8669 = this__8668.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD;
      if(or__3824__auto____8669) {
        return or__3824__auto____8669
      }else {
        return this__8668.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD
      }
    }()) {
      return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
    }else {
      if(!(cljs.core.scan_array.call(null, 1, k, this__8668.keys) == null)) {
        var new_strobj__8670 = cljs.core.obj_clone.call(null, this__8668.strobj, this__8668.keys);
        new_strobj__8670[k] = v;
        return new cljs.core.ObjMap(this__8668.meta, this__8668.keys, new_strobj__8670, this__8668.update_count + 1, null)
      }else {
        var new_strobj__8671 = cljs.core.obj_clone.call(null, this__8668.strobj, this__8668.keys);
        var new_keys__8672 = this__8668.keys.slice();
        new_strobj__8671[k] = v;
        new_keys__8672.push(k);
        return new cljs.core.ObjMap(this__8668.meta, new_keys__8672, new_strobj__8671, this__8668.update_count + 1, null)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__8673 = this;
  if(function() {
    var and__3822__auto____8674 = goog.isString(k);
    if(and__3822__auto____8674) {
      return!(cljs.core.scan_array.call(null, 1, k, this__8673.keys) == null)
    }else {
      return and__3822__auto____8674
    }
  }()) {
    return true
  }else {
    return false
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__8696 = null;
  var G__8696__2 = function(this_sym8675, k) {
    var this__8677 = this;
    var this_sym8675__8678 = this;
    var coll__8679 = this_sym8675__8678;
    return coll__8679.cljs$core$ILookup$_lookup$arity$2(coll__8679, k)
  };
  var G__8696__3 = function(this_sym8676, k, not_found) {
    var this__8677 = this;
    var this_sym8676__8680 = this;
    var coll__8681 = this_sym8676__8680;
    return coll__8681.cljs$core$ILookup$_lookup$arity$3(coll__8681, k, not_found)
  };
  G__8696 = function(this_sym8676, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8696__2.call(this, this_sym8676, k);
      case 3:
        return G__8696__3.call(this, this_sym8676, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__8696
}();
cljs.core.ObjMap.prototype.apply = function(this_sym8659, args8660) {
  var this__8682 = this;
  return this_sym8659.call.apply(this_sym8659, [this_sym8659].concat(args8660.slice()))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__8683 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__8684 = this;
  var this__8685 = this;
  return cljs.core.pr_str.call(null, this__8685)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8686 = this;
  if(this__8686.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__8649_SHARP_) {
      return cljs.core.vector.call(null, p1__8649_SHARP_, this__8686.strobj[p1__8649_SHARP_])
    }, this__8686.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__8687 = this;
  return this__8687.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8688 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__8689 = this;
  return new cljs.core.ObjMap(meta, this__8689.keys, this__8689.strobj, this__8689.update_count, this__8689.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__8690 = this;
  return this__8690.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8691 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__8691.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__8692 = this;
  if(function() {
    var and__3822__auto____8693 = goog.isString(k);
    if(and__3822__auto____8693) {
      return!(cljs.core.scan_array.call(null, 1, k, this__8692.keys) == null)
    }else {
      return and__3822__auto____8693
    }
  }()) {
    var new_keys__8694 = this__8692.keys.slice();
    var new_strobj__8695 = cljs.core.obj_clone.call(null, this__8692.strobj, this__8692.keys);
    new_keys__8694.splice(cljs.core.scan_array.call(null, 1, k, new_keys__8694), 1);
    cljs.core.js_delete.call(null, new_strobj__8695, k);
    return new cljs.core.ObjMap(this__8692.meta, new_keys__8694, new_strobj__8695, this__8692.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15075087
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__8700 = this;
  var h__2192__auto____8701 = this__8700.__hash;
  if(!(h__2192__auto____8701 == null)) {
    return h__2192__auto____8701
  }else {
    var h__2192__auto____8702 = cljs.core.hash_imap.call(null, coll);
    this__8700.__hash = h__2192__auto____8702;
    return h__2192__auto____8702
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__8703 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__8704 = this;
  var bucket__8705 = this__8704.hashobj[cljs.core.hash.call(null, k)];
  var i__8706 = cljs.core.truth_(bucket__8705) ? cljs.core.scan_array.call(null, 2, k, bucket__8705) : null;
  if(cljs.core.truth_(i__8706)) {
    return bucket__8705[i__8706 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__8707 = this;
  var h__8708 = cljs.core.hash.call(null, k);
  var bucket__8709 = this__8707.hashobj[h__8708];
  if(cljs.core.truth_(bucket__8709)) {
    var new_bucket__8710 = bucket__8709.slice();
    var new_hashobj__8711 = goog.object.clone(this__8707.hashobj);
    new_hashobj__8711[h__8708] = new_bucket__8710;
    var temp__3971__auto____8712 = cljs.core.scan_array.call(null, 2, k, new_bucket__8710);
    if(cljs.core.truth_(temp__3971__auto____8712)) {
      var i__8713 = temp__3971__auto____8712;
      new_bucket__8710[i__8713 + 1] = v;
      return new cljs.core.HashMap(this__8707.meta, this__8707.count, new_hashobj__8711, null)
    }else {
      new_bucket__8710.push(k, v);
      return new cljs.core.HashMap(this__8707.meta, this__8707.count + 1, new_hashobj__8711, null)
    }
  }else {
    var new_hashobj__8714 = goog.object.clone(this__8707.hashobj);
    new_hashobj__8714[h__8708] = [k, v];
    return new cljs.core.HashMap(this__8707.meta, this__8707.count + 1, new_hashobj__8714, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__8715 = this;
  var bucket__8716 = this__8715.hashobj[cljs.core.hash.call(null, k)];
  var i__8717 = cljs.core.truth_(bucket__8716) ? cljs.core.scan_array.call(null, 2, k, bucket__8716) : null;
  if(cljs.core.truth_(i__8717)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.call = function() {
  var G__8742 = null;
  var G__8742__2 = function(this_sym8718, k) {
    var this__8720 = this;
    var this_sym8718__8721 = this;
    var coll__8722 = this_sym8718__8721;
    return coll__8722.cljs$core$ILookup$_lookup$arity$2(coll__8722, k)
  };
  var G__8742__3 = function(this_sym8719, k, not_found) {
    var this__8720 = this;
    var this_sym8719__8723 = this;
    var coll__8724 = this_sym8719__8723;
    return coll__8724.cljs$core$ILookup$_lookup$arity$3(coll__8724, k, not_found)
  };
  G__8742 = function(this_sym8719, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8742__2.call(this, this_sym8719, k);
      case 3:
        return G__8742__3.call(this, this_sym8719, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__8742
}();
cljs.core.HashMap.prototype.apply = function(this_sym8698, args8699) {
  var this__8725 = this;
  return this_sym8698.call.apply(this_sym8698, [this_sym8698].concat(args8699.slice()))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__8726 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__8727 = this;
  var this__8728 = this;
  return cljs.core.pr_str.call(null, this__8728)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8729 = this;
  if(this__8729.count > 0) {
    var hashes__8730 = cljs.core.js_keys.call(null, this__8729.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__8697_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__8729.hashobj[p1__8697_SHARP_]))
    }, hashes__8730)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__8731 = this;
  return this__8731.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8732 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__8733 = this;
  return new cljs.core.HashMap(meta, this__8733.count, this__8733.hashobj, this__8733.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__8734 = this;
  return this__8734.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8735 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__8735.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__8736 = this;
  var h__8737 = cljs.core.hash.call(null, k);
  var bucket__8738 = this__8736.hashobj[h__8737];
  var i__8739 = cljs.core.truth_(bucket__8738) ? cljs.core.scan_array.call(null, 2, k, bucket__8738) : null;
  if(cljs.core.not.call(null, i__8739)) {
    return coll
  }else {
    var new_hashobj__8740 = goog.object.clone(this__8736.hashobj);
    if(3 > bucket__8738.length) {
      cljs.core.js_delete.call(null, new_hashobj__8740, h__8737)
    }else {
      var new_bucket__8741 = bucket__8738.slice();
      new_bucket__8741.splice(i__8739, 2);
      new_hashobj__8740[h__8737] = new_bucket__8741
    }
    return new cljs.core.HashMap(this__8736.meta, this__8736.count - 1, new_hashobj__8740, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__8743 = ks.length;
  var i__8744 = 0;
  var out__8745 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__8744 < len__8743) {
      var G__8746 = i__8744 + 1;
      var G__8747 = cljs.core.assoc.call(null, out__8745, ks[i__8744], vs[i__8744]);
      i__8744 = G__8746;
      out__8745 = G__8747;
      continue
    }else {
      return out__8745
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__8751 = m.arr;
  var len__8752 = arr__8751.length;
  var i__8753 = 0;
  while(true) {
    if(len__8752 <= i__8753) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__8751[i__8753], k)) {
        return i__8753
      }else {
        if("\ufdd0'else") {
          var G__8754 = i__8753 + 2;
          i__8753 = G__8754;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 16123663
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__8757 = this;
  return new cljs.core.TransientArrayMap({}, this__8757.arr.length, this__8757.arr.slice())
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__8758 = this;
  var h__2192__auto____8759 = this__8758.__hash;
  if(!(h__2192__auto____8759 == null)) {
    return h__2192__auto____8759
  }else {
    var h__2192__auto____8760 = cljs.core.hash_imap.call(null, coll);
    this__8758.__hash = h__2192__auto____8760;
    return h__2192__auto____8760
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__8761 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__8762 = this;
  var idx__8763 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__8763 === -1) {
    return not_found
  }else {
    return this__8762.arr[idx__8763 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__8764 = this;
  var idx__8765 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__8765 === -1) {
    if(this__8764.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__8764.meta, this__8764.cnt + 1, function() {
        var G__8766__8767 = this__8764.arr.slice();
        G__8766__8767.push(k);
        G__8766__8767.push(v);
        return G__8766__8767
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__8764.arr[idx__8765 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__8764.meta, this__8764.cnt, function() {
          var G__8768__8769 = this__8764.arr.slice();
          G__8768__8769[idx__8765 + 1] = v;
          return G__8768__8769
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__8770 = this;
  return!(cljs.core.array_map_index_of.call(null, coll, k) === -1)
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__8802 = null;
  var G__8802__2 = function(this_sym8771, k) {
    var this__8773 = this;
    var this_sym8771__8774 = this;
    var coll__8775 = this_sym8771__8774;
    return coll__8775.cljs$core$ILookup$_lookup$arity$2(coll__8775, k)
  };
  var G__8802__3 = function(this_sym8772, k, not_found) {
    var this__8773 = this;
    var this_sym8772__8776 = this;
    var coll__8777 = this_sym8772__8776;
    return coll__8777.cljs$core$ILookup$_lookup$arity$3(coll__8777, k, not_found)
  };
  G__8802 = function(this_sym8772, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8802__2.call(this, this_sym8772, k);
      case 3:
        return G__8802__3.call(this, this_sym8772, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__8802
}();
cljs.core.PersistentArrayMap.prototype.apply = function(this_sym8755, args8756) {
  var this__8778 = this;
  return this_sym8755.call.apply(this_sym8755, [this_sym8755].concat(args8756.slice()))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__8779 = this;
  var len__8780 = this__8779.arr.length;
  var i__8781 = 0;
  var init__8782 = init;
  while(true) {
    if(i__8781 < len__8780) {
      var init__8783 = f.call(null, init__8782, this__8779.arr[i__8781], this__8779.arr[i__8781 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__8783)) {
        return cljs.core.deref.call(null, init__8783)
      }else {
        var G__8803 = i__8781 + 2;
        var G__8804 = init__8783;
        i__8781 = G__8803;
        init__8782 = G__8804;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__8784 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__8785 = this;
  var this__8786 = this;
  return cljs.core.pr_str.call(null, this__8786)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8787 = this;
  if(this__8787.cnt > 0) {
    var len__8788 = this__8787.arr.length;
    var array_map_seq__8789 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__8788) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__8787.arr[i], this__8787.arr[i + 1]], true), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      }, null)
    };
    return array_map_seq__8789.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__8790 = this;
  return this__8790.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8791 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__8792 = this;
  return new cljs.core.PersistentArrayMap(meta, this__8792.cnt, this__8792.arr, this__8792.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__8793 = this;
  return this__8793.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8794 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__8794.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__8795 = this;
  var idx__8796 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__8796 >= 0) {
    var len__8797 = this__8795.arr.length;
    var new_len__8798 = len__8797 - 2;
    if(new_len__8798 === 0) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
    }else {
      var new_arr__8799 = cljs.core.make_array.call(null, new_len__8798);
      var s__8800 = 0;
      var d__8801 = 0;
      while(true) {
        if(s__8800 >= len__8797) {
          return new cljs.core.PersistentArrayMap(this__8795.meta, this__8795.cnt - 1, new_arr__8799, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__8795.arr[s__8800])) {
            var G__8805 = s__8800 + 2;
            var G__8806 = d__8801;
            s__8800 = G__8805;
            d__8801 = G__8806;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__8799[d__8801] = this__8795.arr[s__8800];
              new_arr__8799[d__8801 + 1] = this__8795.arr[s__8800 + 1];
              var G__8807 = s__8800 + 2;
              var G__8808 = d__8801 + 2;
              s__8800 = G__8807;
              d__8801 = G__8808;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__8809 = cljs.core.count.call(null, ks);
  var i__8810 = 0;
  var out__8811 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__8810 < len__8809) {
      var G__8812 = i__8810 + 1;
      var G__8813 = cljs.core.assoc_BANG_.call(null, out__8811, ks[i__8810], vs[i__8810]);
      i__8810 = G__8812;
      out__8811 = G__8813;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__8811)
    }
    break
  }
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 14;
  this.cljs$lang$protocol_mask$partition0$ = 258
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__8814 = this;
  if(cljs.core.truth_(this__8814.editable_QMARK_)) {
    var idx__8815 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__8815 >= 0) {
      this__8814.arr[idx__8815] = this__8814.arr[this__8814.len - 2];
      this__8814.arr[idx__8815 + 1] = this__8814.arr[this__8814.len - 1];
      var G__8816__8817 = this__8814.arr;
      G__8816__8817.pop();
      G__8816__8817.pop();
      G__8816__8817;
      this__8814.len = this__8814.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__8818 = this;
  if(cljs.core.truth_(this__8818.editable_QMARK_)) {
    var idx__8819 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__8819 === -1) {
      if(this__8818.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__8818.len = this__8818.len + 2;
        this__8818.arr.push(key);
        this__8818.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__8818.len, this__8818.arr), key, val)
      }
    }else {
      if(val === this__8818.arr[idx__8819 + 1]) {
        return tcoll
      }else {
        this__8818.arr[idx__8819 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__8820 = this;
  if(cljs.core.truth_(this__8820.editable_QMARK_)) {
    if(function() {
      var G__8821__8822 = o;
      if(G__8821__8822) {
        if(function() {
          var or__3824__auto____8823 = G__8821__8822.cljs$lang$protocol_mask$partition0$ & 2048;
          if(or__3824__auto____8823) {
            return or__3824__auto____8823
          }else {
            return G__8821__8822.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__8821__8822.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__8821__8822)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__8821__8822)
      }
    }()) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__8824 = cljs.core.seq.call(null, o);
      var tcoll__8825 = tcoll;
      while(true) {
        var temp__3971__auto____8826 = cljs.core.first.call(null, es__8824);
        if(cljs.core.truth_(temp__3971__auto____8826)) {
          var e__8827 = temp__3971__auto____8826;
          var G__8833 = cljs.core.next.call(null, es__8824);
          var G__8834 = tcoll__8825.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll__8825, cljs.core.key.call(null, e__8827), cljs.core.val.call(null, e__8827));
          es__8824 = G__8833;
          tcoll__8825 = G__8834;
          continue
        }else {
          return tcoll__8825
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__8828 = this;
  if(cljs.core.truth_(this__8828.editable_QMARK_)) {
    this__8828.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__8828.len, 2), this__8828.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__8829 = this;
  return tcoll.cljs$core$ILookup$_lookup$arity$3(tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__8830 = this;
  if(cljs.core.truth_(this__8830.editable_QMARK_)) {
    var idx__8831 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__8831 === -1) {
      return not_found
    }else {
      return this__8830.arr[idx__8831 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__8832 = this;
  if(cljs.core.truth_(this__8832.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__8832.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__8837 = cljs.core.transient$.call(null, cljs.core.ObjMap.EMPTY);
  var i__8838 = 0;
  while(true) {
    if(i__8838 < len) {
      var G__8839 = cljs.core.assoc_BANG_.call(null, out__8837, arr[i__8838], arr[i__8838 + 1]);
      var G__8840 = i__8838 + 2;
      out__8837 = G__8839;
      i__8838 = G__8840;
      continue
    }else {
      return out__8837
    }
    break
  }
};
cljs.core.Box = function(val) {
  this.val = val
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorPrSeq = function(this__2310__auto__) {
  return cljs.core.list.call(null, "cljs.core/Box")
};
cljs.core.Box;
cljs.core.key_test = function key_test(key, other) {
  if(goog.isString(key)) {
    return key === other
  }else {
    return cljs.core._EQ_.call(null, key, other)
  }
};
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__8845__8846 = arr.slice();
    G__8845__8846[i] = a;
    return G__8845__8846
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__8847__8848 = arr.slice();
    G__8847__8848[i] = a;
    G__8847__8848[j] = b;
    return G__8847__8848
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__8850 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__8850, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__8850, 2 * i, new_arr__8850.length - 2 * i);
  return new_arr__8850
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__8853 = inode.ensure_editable(edit);
    editable__8853.arr[i] = a;
    return editable__8853
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__8854 = inode.ensure_editable(edit);
    editable__8854.arr[i] = a;
    editable__8854.arr[j] = b;
    return editable__8854
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__8861 = arr.length;
  var i__8862 = 0;
  var init__8863 = init;
  while(true) {
    if(i__8862 < len__8861) {
      var init__8866 = function() {
        var k__8864 = arr[i__8862];
        if(!(k__8864 == null)) {
          return f.call(null, init__8863, k__8864, arr[i__8862 + 1])
        }else {
          var node__8865 = arr[i__8862 + 1];
          if(!(node__8865 == null)) {
            return node__8865.kv_reduce(f, init__8863)
          }else {
            return init__8863
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__8866)) {
        return cljs.core.deref.call(null, init__8866)
      }else {
        var G__8867 = i__8862 + 2;
        var G__8868 = init__8866;
        i__8862 = G__8867;
        init__8863 = G__8868;
        continue
      }
    }else {
      return init__8863
    }
    break
  }
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__8869 = this;
  var inode__8870 = this;
  if(this__8869.bitmap === bit) {
    return null
  }else {
    var editable__8871 = inode__8870.ensure_editable(e);
    var earr__8872 = editable__8871.arr;
    var len__8873 = earr__8872.length;
    editable__8871.bitmap = bit ^ editable__8871.bitmap;
    cljs.core.array_copy.call(null, earr__8872, 2 * (i + 1), earr__8872, 2 * i, len__8873 - 2 * (i + 1));
    earr__8872[len__8873 - 2] = null;
    earr__8872[len__8873 - 1] = null;
    return editable__8871
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__8874 = this;
  var inode__8875 = this;
  var bit__8876 = 1 << (hash >>> shift & 31);
  var idx__8877 = cljs.core.bitmap_indexed_node_index.call(null, this__8874.bitmap, bit__8876);
  if((this__8874.bitmap & bit__8876) === 0) {
    var n__8878 = cljs.core.bit_count.call(null, this__8874.bitmap);
    if(2 * n__8878 < this__8874.arr.length) {
      var editable__8879 = inode__8875.ensure_editable(edit);
      var earr__8880 = editable__8879.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward.call(null, earr__8880, 2 * idx__8877, earr__8880, 2 * (idx__8877 + 1), 2 * (n__8878 - idx__8877));
      earr__8880[2 * idx__8877] = key;
      earr__8880[2 * idx__8877 + 1] = val;
      editable__8879.bitmap = editable__8879.bitmap | bit__8876;
      return editable__8879
    }else {
      if(n__8878 >= 16) {
        var nodes__8881 = cljs.core.make_array.call(null, 32);
        var jdx__8882 = hash >>> shift & 31;
        nodes__8881[jdx__8882] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__8883 = 0;
        var j__8884 = 0;
        while(true) {
          if(i__8883 < 32) {
            if((this__8874.bitmap >>> i__8883 & 1) === 0) {
              var G__8937 = i__8883 + 1;
              var G__8938 = j__8884;
              i__8883 = G__8937;
              j__8884 = G__8938;
              continue
            }else {
              nodes__8881[i__8883] = !(this__8874.arr[j__8884] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__8874.arr[j__8884]), this__8874.arr[j__8884], this__8874.arr[j__8884 + 1], added_leaf_QMARK_) : this__8874.arr[j__8884 + 1];
              var G__8939 = i__8883 + 1;
              var G__8940 = j__8884 + 2;
              i__8883 = G__8939;
              j__8884 = G__8940;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__8878 + 1, nodes__8881)
      }else {
        if("\ufdd0'else") {
          var new_arr__8885 = cljs.core.make_array.call(null, 2 * (n__8878 + 4));
          cljs.core.array_copy.call(null, this__8874.arr, 0, new_arr__8885, 0, 2 * idx__8877);
          new_arr__8885[2 * idx__8877] = key;
          new_arr__8885[2 * idx__8877 + 1] = val;
          cljs.core.array_copy.call(null, this__8874.arr, 2 * idx__8877, new_arr__8885, 2 * (idx__8877 + 1), 2 * (n__8878 - idx__8877));
          added_leaf_QMARK_.val = true;
          var editable__8886 = inode__8875.ensure_editable(edit);
          editable__8886.arr = new_arr__8885;
          editable__8886.bitmap = editable__8886.bitmap | bit__8876;
          return editable__8886
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__8887 = this__8874.arr[2 * idx__8877];
    var val_or_node__8888 = this__8874.arr[2 * idx__8877 + 1];
    if(key_or_nil__8887 == null) {
      var n__8889 = val_or_node__8888.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__8889 === val_or_node__8888) {
        return inode__8875
      }else {
        return cljs.core.edit_and_set.call(null, inode__8875, edit, 2 * idx__8877 + 1, n__8889)
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__8887)) {
        if(val === val_or_node__8888) {
          return inode__8875
        }else {
          return cljs.core.edit_and_set.call(null, inode__8875, edit, 2 * idx__8877 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_.val = true;
          return cljs.core.edit_and_set.call(null, inode__8875, edit, 2 * idx__8877, null, 2 * idx__8877 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__8887, val_or_node__8888, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__8890 = this;
  var inode__8891 = this;
  return cljs.core.create_inode_seq.call(null, this__8890.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__8892 = this;
  var inode__8893 = this;
  var bit__8894 = 1 << (hash >>> shift & 31);
  if((this__8892.bitmap & bit__8894) === 0) {
    return inode__8893
  }else {
    var idx__8895 = cljs.core.bitmap_indexed_node_index.call(null, this__8892.bitmap, bit__8894);
    var key_or_nil__8896 = this__8892.arr[2 * idx__8895];
    var val_or_node__8897 = this__8892.arr[2 * idx__8895 + 1];
    if(key_or_nil__8896 == null) {
      var n__8898 = val_or_node__8897.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__8898 === val_or_node__8897) {
        return inode__8893
      }else {
        if(!(n__8898 == null)) {
          return cljs.core.edit_and_set.call(null, inode__8893, edit, 2 * idx__8895 + 1, n__8898)
        }else {
          if(this__8892.bitmap === bit__8894) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__8893.edit_and_remove_pair(edit, bit__8894, idx__8895)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__8896)) {
        removed_leaf_QMARK_[0] = true;
        return inode__8893.edit_and_remove_pair(edit, bit__8894, idx__8895)
      }else {
        if("\ufdd0'else") {
          return inode__8893
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__8899 = this;
  var inode__8900 = this;
  if(e === this__8899.edit) {
    return inode__8900
  }else {
    var n__8901 = cljs.core.bit_count.call(null, this__8899.bitmap);
    var new_arr__8902 = cljs.core.make_array.call(null, n__8901 < 0 ? 4 : 2 * (n__8901 + 1));
    cljs.core.array_copy.call(null, this__8899.arr, 0, new_arr__8902, 0, 2 * n__8901);
    return new cljs.core.BitmapIndexedNode(e, this__8899.bitmap, new_arr__8902)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__8903 = this;
  var inode__8904 = this;
  return cljs.core.inode_kv_reduce.call(null, this__8903.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var this__8905 = this;
  var inode__8906 = this;
  var bit__8907 = 1 << (hash >>> shift & 31);
  if((this__8905.bitmap & bit__8907) === 0) {
    return not_found
  }else {
    var idx__8908 = cljs.core.bitmap_indexed_node_index.call(null, this__8905.bitmap, bit__8907);
    var key_or_nil__8909 = this__8905.arr[2 * idx__8908];
    var val_or_node__8910 = this__8905.arr[2 * idx__8908 + 1];
    if(key_or_nil__8909 == null) {
      return val_or_node__8910.inode_find(shift + 5, hash, key, not_found)
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__8909)) {
        return cljs.core.PersistentVector.fromArray([key_or_nil__8909, val_or_node__8910], true)
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__8911 = this;
  var inode__8912 = this;
  var bit__8913 = 1 << (hash >>> shift & 31);
  if((this__8911.bitmap & bit__8913) === 0) {
    return inode__8912
  }else {
    var idx__8914 = cljs.core.bitmap_indexed_node_index.call(null, this__8911.bitmap, bit__8913);
    var key_or_nil__8915 = this__8911.arr[2 * idx__8914];
    var val_or_node__8916 = this__8911.arr[2 * idx__8914 + 1];
    if(key_or_nil__8915 == null) {
      var n__8917 = val_or_node__8916.inode_without(shift + 5, hash, key);
      if(n__8917 === val_or_node__8916) {
        return inode__8912
      }else {
        if(!(n__8917 == null)) {
          return new cljs.core.BitmapIndexedNode(null, this__8911.bitmap, cljs.core.clone_and_set.call(null, this__8911.arr, 2 * idx__8914 + 1, n__8917))
        }else {
          if(this__8911.bitmap === bit__8913) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__8911.bitmap ^ bit__8913, cljs.core.remove_pair.call(null, this__8911.arr, idx__8914))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__8915)) {
        return new cljs.core.BitmapIndexedNode(null, this__8911.bitmap ^ bit__8913, cljs.core.remove_pair.call(null, this__8911.arr, idx__8914))
      }else {
        if("\ufdd0'else") {
          return inode__8912
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__8918 = this;
  var inode__8919 = this;
  var bit__8920 = 1 << (hash >>> shift & 31);
  var idx__8921 = cljs.core.bitmap_indexed_node_index.call(null, this__8918.bitmap, bit__8920);
  if((this__8918.bitmap & bit__8920) === 0) {
    var n__8922 = cljs.core.bit_count.call(null, this__8918.bitmap);
    if(n__8922 >= 16) {
      var nodes__8923 = cljs.core.make_array.call(null, 32);
      var jdx__8924 = hash >>> shift & 31;
      nodes__8923[jdx__8924] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__8925 = 0;
      var j__8926 = 0;
      while(true) {
        if(i__8925 < 32) {
          if((this__8918.bitmap >>> i__8925 & 1) === 0) {
            var G__8941 = i__8925 + 1;
            var G__8942 = j__8926;
            i__8925 = G__8941;
            j__8926 = G__8942;
            continue
          }else {
            nodes__8923[i__8925] = !(this__8918.arr[j__8926] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__8918.arr[j__8926]), this__8918.arr[j__8926], this__8918.arr[j__8926 + 1], added_leaf_QMARK_) : this__8918.arr[j__8926 + 1];
            var G__8943 = i__8925 + 1;
            var G__8944 = j__8926 + 2;
            i__8925 = G__8943;
            j__8926 = G__8944;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__8922 + 1, nodes__8923)
    }else {
      var new_arr__8927 = cljs.core.make_array.call(null, 2 * (n__8922 + 1));
      cljs.core.array_copy.call(null, this__8918.arr, 0, new_arr__8927, 0, 2 * idx__8921);
      new_arr__8927[2 * idx__8921] = key;
      new_arr__8927[2 * idx__8921 + 1] = val;
      cljs.core.array_copy.call(null, this__8918.arr, 2 * idx__8921, new_arr__8927, 2 * (idx__8921 + 1), 2 * (n__8922 - idx__8921));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, this__8918.bitmap | bit__8920, new_arr__8927)
    }
  }else {
    var key_or_nil__8928 = this__8918.arr[2 * idx__8921];
    var val_or_node__8929 = this__8918.arr[2 * idx__8921 + 1];
    if(key_or_nil__8928 == null) {
      var n__8930 = val_or_node__8929.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__8930 === val_or_node__8929) {
        return inode__8919
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__8918.bitmap, cljs.core.clone_and_set.call(null, this__8918.arr, 2 * idx__8921 + 1, n__8930))
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__8928)) {
        if(val === val_or_node__8929) {
          return inode__8919
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__8918.bitmap, cljs.core.clone_and_set.call(null, this__8918.arr, 2 * idx__8921 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_.val = true;
          return new cljs.core.BitmapIndexedNode(null, this__8918.bitmap, cljs.core.clone_and_set.call(null, this__8918.arr, 2 * idx__8921, null, 2 * idx__8921 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__8928, val_or_node__8929, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var this__8931 = this;
  var inode__8932 = this;
  var bit__8933 = 1 << (hash >>> shift & 31);
  if((this__8931.bitmap & bit__8933) === 0) {
    return not_found
  }else {
    var idx__8934 = cljs.core.bitmap_indexed_node_index.call(null, this__8931.bitmap, bit__8933);
    var key_or_nil__8935 = this__8931.arr[2 * idx__8934];
    var val_or_node__8936 = this__8931.arr[2 * idx__8934 + 1];
    if(key_or_nil__8935 == null) {
      return val_or_node__8936.inode_lookup(shift + 5, hash, key, not_found)
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__8935)) {
        return val_or_node__8936
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__8952 = array_node.arr;
  var len__8953 = 2 * (array_node.cnt - 1);
  var new_arr__8954 = cljs.core.make_array.call(null, len__8953);
  var i__8955 = 0;
  var j__8956 = 1;
  var bitmap__8957 = 0;
  while(true) {
    if(i__8955 < len__8953) {
      if(function() {
        var and__3822__auto____8958 = !(i__8955 === idx);
        if(and__3822__auto____8958) {
          return!(arr__8952[i__8955] == null)
        }else {
          return and__3822__auto____8958
        }
      }()) {
        new_arr__8954[j__8956] = arr__8952[i__8955];
        var G__8959 = i__8955 + 1;
        var G__8960 = j__8956 + 2;
        var G__8961 = bitmap__8957 | 1 << i__8955;
        i__8955 = G__8959;
        j__8956 = G__8960;
        bitmap__8957 = G__8961;
        continue
      }else {
        var G__8962 = i__8955 + 1;
        var G__8963 = j__8956;
        var G__8964 = bitmap__8957;
        i__8955 = G__8962;
        j__8956 = G__8963;
        bitmap__8957 = G__8964;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__8957, new_arr__8954)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__8965 = this;
  var inode__8966 = this;
  var idx__8967 = hash >>> shift & 31;
  var node__8968 = this__8965.arr[idx__8967];
  if(node__8968 == null) {
    var editable__8969 = cljs.core.edit_and_set.call(null, inode__8966, edit, idx__8967, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__8969.cnt = editable__8969.cnt + 1;
    return editable__8969
  }else {
    var n__8970 = node__8968.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__8970 === node__8968) {
      return inode__8966
    }else {
      return cljs.core.edit_and_set.call(null, inode__8966, edit, idx__8967, n__8970)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__8971 = this;
  var inode__8972 = this;
  return cljs.core.create_array_node_seq.call(null, this__8971.arr)
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__8973 = this;
  var inode__8974 = this;
  var idx__8975 = hash >>> shift & 31;
  var node__8976 = this__8973.arr[idx__8975];
  if(node__8976 == null) {
    return inode__8974
  }else {
    var n__8977 = node__8976.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__8977 === node__8976) {
      return inode__8974
    }else {
      if(n__8977 == null) {
        if(this__8973.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__8974, edit, idx__8975)
        }else {
          var editable__8978 = cljs.core.edit_and_set.call(null, inode__8974, edit, idx__8975, n__8977);
          editable__8978.cnt = editable__8978.cnt - 1;
          return editable__8978
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__8974, edit, idx__8975, n__8977)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__8979 = this;
  var inode__8980 = this;
  if(e === this__8979.edit) {
    return inode__8980
  }else {
    return new cljs.core.ArrayNode(e, this__8979.cnt, this__8979.arr.slice())
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__8981 = this;
  var inode__8982 = this;
  var len__8983 = this__8981.arr.length;
  var i__8984 = 0;
  var init__8985 = init;
  while(true) {
    if(i__8984 < len__8983) {
      var node__8986 = this__8981.arr[i__8984];
      if(!(node__8986 == null)) {
        var init__8987 = node__8986.kv_reduce(f, init__8985);
        if(cljs.core.reduced_QMARK_.call(null, init__8987)) {
          return cljs.core.deref.call(null, init__8987)
        }else {
          var G__9006 = i__8984 + 1;
          var G__9007 = init__8987;
          i__8984 = G__9006;
          init__8985 = G__9007;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__8985
    }
    break
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var this__8988 = this;
  var inode__8989 = this;
  var idx__8990 = hash >>> shift & 31;
  var node__8991 = this__8988.arr[idx__8990];
  if(!(node__8991 == null)) {
    return node__8991.inode_find(shift + 5, hash, key, not_found)
  }else {
    return not_found
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__8992 = this;
  var inode__8993 = this;
  var idx__8994 = hash >>> shift & 31;
  var node__8995 = this__8992.arr[idx__8994];
  if(!(node__8995 == null)) {
    var n__8996 = node__8995.inode_without(shift + 5, hash, key);
    if(n__8996 === node__8995) {
      return inode__8993
    }else {
      if(n__8996 == null) {
        if(this__8992.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__8993, null, idx__8994)
        }else {
          return new cljs.core.ArrayNode(null, this__8992.cnt - 1, cljs.core.clone_and_set.call(null, this__8992.arr, idx__8994, n__8996))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__8992.cnt, cljs.core.clone_and_set.call(null, this__8992.arr, idx__8994, n__8996))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__8993
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__8997 = this;
  var inode__8998 = this;
  var idx__8999 = hash >>> shift & 31;
  var node__9000 = this__8997.arr[idx__8999];
  if(node__9000 == null) {
    return new cljs.core.ArrayNode(null, this__8997.cnt + 1, cljs.core.clone_and_set.call(null, this__8997.arr, idx__8999, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__9001 = node__9000.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__9001 === node__9000) {
      return inode__8998
    }else {
      return new cljs.core.ArrayNode(null, this__8997.cnt, cljs.core.clone_and_set.call(null, this__8997.arr, idx__8999, n__9001))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var this__9002 = this;
  var inode__9003 = this;
  var idx__9004 = hash >>> shift & 31;
  var node__9005 = this__9002.arr[idx__9004];
  if(!(node__9005 == null)) {
    return node__9005.inode_lookup(shift + 5, hash, key, not_found)
  }else {
    return not_found
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__9010 = 2 * cnt;
  var i__9011 = 0;
  while(true) {
    if(i__9011 < lim__9010) {
      if(cljs.core.key_test.call(null, key, arr[i__9011])) {
        return i__9011
      }else {
        var G__9012 = i__9011 + 2;
        i__9011 = G__9012;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__9013 = this;
  var inode__9014 = this;
  if(hash === this__9013.collision_hash) {
    var idx__9015 = cljs.core.hash_collision_node_find_index.call(null, this__9013.arr, this__9013.cnt, key);
    if(idx__9015 === -1) {
      if(this__9013.arr.length > 2 * this__9013.cnt) {
        var editable__9016 = cljs.core.edit_and_set.call(null, inode__9014, edit, 2 * this__9013.cnt, key, 2 * this__9013.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable__9016.cnt = editable__9016.cnt + 1;
        return editable__9016
      }else {
        var len__9017 = this__9013.arr.length;
        var new_arr__9018 = cljs.core.make_array.call(null, len__9017 + 2);
        cljs.core.array_copy.call(null, this__9013.arr, 0, new_arr__9018, 0, len__9017);
        new_arr__9018[len__9017] = key;
        new_arr__9018[len__9017 + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode__9014.ensure_editable_array(edit, this__9013.cnt + 1, new_arr__9018)
      }
    }else {
      if(this__9013.arr[idx__9015 + 1] === val) {
        return inode__9014
      }else {
        return cljs.core.edit_and_set.call(null, inode__9014, edit, idx__9015 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__9013.collision_hash >>> shift & 31), [null, inode__9014, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__9019 = this;
  var inode__9020 = this;
  return cljs.core.create_inode_seq.call(null, this__9019.arr)
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__9021 = this;
  var inode__9022 = this;
  var idx__9023 = cljs.core.hash_collision_node_find_index.call(null, this__9021.arr, this__9021.cnt, key);
  if(idx__9023 === -1) {
    return inode__9022
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__9021.cnt === 1) {
      return null
    }else {
      var editable__9024 = inode__9022.ensure_editable(edit);
      var earr__9025 = editable__9024.arr;
      earr__9025[idx__9023] = earr__9025[2 * this__9021.cnt - 2];
      earr__9025[idx__9023 + 1] = earr__9025[2 * this__9021.cnt - 1];
      earr__9025[2 * this__9021.cnt - 1] = null;
      earr__9025[2 * this__9021.cnt - 2] = null;
      editable__9024.cnt = editable__9024.cnt - 1;
      return editable__9024
    }
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var this__9026 = this;
  var inode__9027 = this;
  if(e === this__9026.edit) {
    return inode__9027
  }else {
    var new_arr__9028 = cljs.core.make_array.call(null, 2 * (this__9026.cnt + 1));
    cljs.core.array_copy.call(null, this__9026.arr, 0, new_arr__9028, 0, 2 * this__9026.cnt);
    return new cljs.core.HashCollisionNode(e, this__9026.collision_hash, this__9026.cnt, new_arr__9028)
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__9029 = this;
  var inode__9030 = this;
  return cljs.core.inode_kv_reduce.call(null, this__9029.arr, f, init)
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var this__9031 = this;
  var inode__9032 = this;
  var idx__9033 = cljs.core.hash_collision_node_find_index.call(null, this__9031.arr, this__9031.cnt, key);
  if(idx__9033 < 0) {
    return not_found
  }else {
    if(cljs.core.key_test.call(null, key, this__9031.arr[idx__9033])) {
      return cljs.core.PersistentVector.fromArray([this__9031.arr[idx__9033], this__9031.arr[idx__9033 + 1]], true)
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__9034 = this;
  var inode__9035 = this;
  var idx__9036 = cljs.core.hash_collision_node_find_index.call(null, this__9034.arr, this__9034.cnt, key);
  if(idx__9036 === -1) {
    return inode__9035
  }else {
    if(this__9034.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__9034.collision_hash, this__9034.cnt - 1, cljs.core.remove_pair.call(null, this__9034.arr, cljs.core.quot.call(null, idx__9036, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__9037 = this;
  var inode__9038 = this;
  if(hash === this__9037.collision_hash) {
    var idx__9039 = cljs.core.hash_collision_node_find_index.call(null, this__9037.arr, this__9037.cnt, key);
    if(idx__9039 === -1) {
      var len__9040 = this__9037.arr.length;
      var new_arr__9041 = cljs.core.make_array.call(null, len__9040 + 2);
      cljs.core.array_copy.call(null, this__9037.arr, 0, new_arr__9041, 0, len__9040);
      new_arr__9041[len__9040] = key;
      new_arr__9041[len__9040 + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, this__9037.collision_hash, this__9037.cnt + 1, new_arr__9041)
    }else {
      if(cljs.core._EQ_.call(null, this__9037.arr[idx__9039], val)) {
        return inode__9038
      }else {
        return new cljs.core.HashCollisionNode(null, this__9037.collision_hash, this__9037.cnt, cljs.core.clone_and_set.call(null, this__9037.arr, idx__9039 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__9037.collision_hash >>> shift & 31), [null, inode__9038])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var this__9042 = this;
  var inode__9043 = this;
  var idx__9044 = cljs.core.hash_collision_node_find_index.call(null, this__9042.arr, this__9042.cnt, key);
  if(idx__9044 < 0) {
    return not_found
  }else {
    if(cljs.core.key_test.call(null, key, this__9042.arr[idx__9044])) {
      return this__9042.arr[idx__9044 + 1]
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var this__9045 = this;
  var inode__9046 = this;
  if(e === this__9045.edit) {
    this__9045.arr = array;
    this__9045.cnt = count;
    return inode__9046
  }else {
    return new cljs.core.HashCollisionNode(this__9045.edit, this__9045.collision_hash, count, array)
  }
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__9051 = cljs.core.hash.call(null, key1);
    if(key1hash__9051 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__9051, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___9052 = new cljs.core.Box(false);
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__9051, key1, val1, added_leaf_QMARK___9052).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___9052)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__9053 = cljs.core.hash.call(null, key1);
    if(key1hash__9053 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__9053, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___9054 = new cljs.core.Box(false);
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__9053, key1, val1, added_leaf_QMARK___9054).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___9054)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850572
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9055 = this;
  var h__2192__auto____9056 = this__9055.__hash;
  if(!(h__2192__auto____9056 == null)) {
    return h__2192__auto____9056
  }else {
    var h__2192__auto____9057 = cljs.core.hash_coll.call(null, coll);
    this__9055.__hash = h__2192__auto____9057;
    return h__2192__auto____9057
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9058 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__9059 = this;
  var this__9060 = this;
  return cljs.core.pr_str.call(null, this__9060)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__9061 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__9062 = this;
  if(this__9062.s == null) {
    return cljs.core.PersistentVector.fromArray([this__9062.nodes[this__9062.i], this__9062.nodes[this__9062.i + 1]], true)
  }else {
    return cljs.core.first.call(null, this__9062.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__9063 = this;
  if(this__9063.s == null) {
    return cljs.core.create_inode_seq.call(null, this__9063.nodes, this__9063.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__9063.nodes, this__9063.i, cljs.core.next.call(null, this__9063.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9064 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9065 = this;
  return new cljs.core.NodeSeq(meta, this__9065.nodes, this__9065.i, this__9065.s, this__9065.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9066 = this;
  return this__9066.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9067 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__9067.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__9074 = nodes.length;
      var j__9075 = i;
      while(true) {
        if(j__9075 < len__9074) {
          if(!(nodes[j__9075] == null)) {
            return new cljs.core.NodeSeq(null, nodes, j__9075, null, null)
          }else {
            var temp__3971__auto____9076 = nodes[j__9075 + 1];
            if(cljs.core.truth_(temp__3971__auto____9076)) {
              var node__9077 = temp__3971__auto____9076;
              var temp__3971__auto____9078 = node__9077.inode_seq();
              if(cljs.core.truth_(temp__3971__auto____9078)) {
                var node_seq__9079 = temp__3971__auto____9078;
                return new cljs.core.NodeSeq(null, nodes, j__9075 + 2, node_seq__9079, null)
              }else {
                var G__9080 = j__9075 + 2;
                j__9075 = G__9080;
                continue
              }
            }else {
              var G__9081 = j__9075 + 2;
              j__9075 = G__9081;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850572
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9082 = this;
  var h__2192__auto____9083 = this__9082.__hash;
  if(!(h__2192__auto____9083 == null)) {
    return h__2192__auto____9083
  }else {
    var h__2192__auto____9084 = cljs.core.hash_coll.call(null, coll);
    this__9082.__hash = h__2192__auto____9084;
    return h__2192__auto____9084
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9085 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__9086 = this;
  var this__9087 = this;
  return cljs.core.pr_str.call(null, this__9087)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__9088 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__9089 = this;
  return cljs.core.first.call(null, this__9089.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__9090 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__9090.nodes, this__9090.i, cljs.core.next.call(null, this__9090.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9091 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9092 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__9092.nodes, this__9092.i, this__9092.s, this__9092.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9093 = this;
  return this__9093.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9094 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__9094.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__9101 = nodes.length;
      var j__9102 = i;
      while(true) {
        if(j__9102 < len__9101) {
          var temp__3971__auto____9103 = nodes[j__9102];
          if(cljs.core.truth_(temp__3971__auto____9103)) {
            var nj__9104 = temp__3971__auto____9103;
            var temp__3971__auto____9105 = nj__9104.inode_seq();
            if(cljs.core.truth_(temp__3971__auto____9105)) {
              var ns__9106 = temp__3971__auto____9105;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__9102 + 1, ns__9106, null)
            }else {
              var G__9107 = j__9102 + 1;
              j__9102 = G__9107;
              continue
            }
          }else {
            var G__9108 = j__9102 + 1;
            j__9102 = G__9108;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 16123663
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__9111 = this;
  return new cljs.core.TransientHashMap({}, this__9111.root, this__9111.cnt, this__9111.has_nil_QMARK_, this__9111.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9112 = this;
  var h__2192__auto____9113 = this__9112.__hash;
  if(!(h__2192__auto____9113 == null)) {
    return h__2192__auto____9113
  }else {
    var h__2192__auto____9114 = cljs.core.hash_imap.call(null, coll);
    this__9112.__hash = h__2192__auto____9114;
    return h__2192__auto____9114
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__9115 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__9116 = this;
  if(k == null) {
    if(this__9116.has_nil_QMARK_) {
      return this__9116.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__9116.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return this__9116.root.inode_lookup(0, cljs.core.hash.call(null, k), k, not_found)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__9117 = this;
  if(k == null) {
    if(function() {
      var and__3822__auto____9118 = this__9117.has_nil_QMARK_;
      if(and__3822__auto____9118) {
        return v === this__9117.nil_val
      }else {
        return and__3822__auto____9118
      }
    }()) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__9117.meta, this__9117.has_nil_QMARK_ ? this__9117.cnt : this__9117.cnt + 1, this__9117.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___9119 = new cljs.core.Box(false);
    var new_root__9120 = (this__9117.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__9117.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___9119);
    if(new_root__9120 === this__9117.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__9117.meta, added_leaf_QMARK___9119.val ? this__9117.cnt + 1 : this__9117.cnt, new_root__9120, this__9117.has_nil_QMARK_, this__9117.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__9121 = this;
  if(k == null) {
    return this__9121.has_nil_QMARK_
  }else {
    if(this__9121.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return!(this__9121.root.inode_lookup(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__9144 = null;
  var G__9144__2 = function(this_sym9122, k) {
    var this__9124 = this;
    var this_sym9122__9125 = this;
    var coll__9126 = this_sym9122__9125;
    return coll__9126.cljs$core$ILookup$_lookup$arity$2(coll__9126, k)
  };
  var G__9144__3 = function(this_sym9123, k, not_found) {
    var this__9124 = this;
    var this_sym9123__9127 = this;
    var coll__9128 = this_sym9123__9127;
    return coll__9128.cljs$core$ILookup$_lookup$arity$3(coll__9128, k, not_found)
  };
  G__9144 = function(this_sym9123, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9144__2.call(this, this_sym9123, k);
      case 3:
        return G__9144__3.call(this, this_sym9123, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9144
}();
cljs.core.PersistentHashMap.prototype.apply = function(this_sym9109, args9110) {
  var this__9129 = this;
  return this_sym9109.call.apply(this_sym9109, [this_sym9109].concat(args9110.slice()))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__9130 = this;
  var init__9131 = this__9130.has_nil_QMARK_ ? f.call(null, init, null, this__9130.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__9131)) {
    return cljs.core.deref.call(null, init__9131)
  }else {
    if(!(this__9130.root == null)) {
      return this__9130.root.kv_reduce(f, init__9131)
    }else {
      if("\ufdd0'else") {
        return init__9131
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__9132 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__9133 = this;
  var this__9134 = this;
  return cljs.core.pr_str.call(null, this__9134)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9135 = this;
  if(this__9135.cnt > 0) {
    var s__9136 = !(this__9135.root == null) ? this__9135.root.inode_seq() : null;
    if(this__9135.has_nil_QMARK_) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__9135.nil_val], true), s__9136)
    }else {
      return s__9136
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9137 = this;
  return this__9137.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9138 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9139 = this;
  return new cljs.core.PersistentHashMap(meta, this__9139.cnt, this__9139.root, this__9139.has_nil_QMARK_, this__9139.nil_val, this__9139.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9140 = this;
  return this__9140.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9141 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__9141.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__9142 = this;
  if(k == null) {
    if(this__9142.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(this__9142.meta, this__9142.cnt - 1, this__9142.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__9142.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__9143 = this__9142.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__9143 === this__9142.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__9142.meta, this__9142.cnt - 1, new_root__9143, this__9142.has_nil_QMARK_, this__9142.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__9145 = ks.length;
  var i__9146 = 0;
  var out__9147 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__9146 < len__9145) {
      var G__9148 = i__9146 + 1;
      var G__9149 = cljs.core.assoc_BANG_.call(null, out__9147, ks[i__9146], vs[i__9146]);
      i__9146 = G__9148;
      out__9147 = G__9149;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__9147)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 14;
  this.cljs$lang$protocol_mask$partition0$ = 258
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__9150 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__9151 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__9152 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__9153 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__9154 = this;
  if(k == null) {
    if(this__9154.has_nil_QMARK_) {
      return this__9154.nil_val
    }else {
      return null
    }
  }else {
    if(this__9154.root == null) {
      return null
    }else {
      return this__9154.root.inode_lookup(0, cljs.core.hash.call(null, k), k)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__9155 = this;
  if(k == null) {
    if(this__9155.has_nil_QMARK_) {
      return this__9155.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__9155.root == null) {
      return not_found
    }else {
      return this__9155.root.inode_lookup(0, cljs.core.hash.call(null, k), k, not_found)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9156 = this;
  if(this__9156.edit) {
    return this__9156.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__9157 = this;
  var tcoll__9158 = this;
  if(this__9157.edit) {
    if(function() {
      var G__9159__9160 = o;
      if(G__9159__9160) {
        if(function() {
          var or__3824__auto____9161 = G__9159__9160.cljs$lang$protocol_mask$partition0$ & 2048;
          if(or__3824__auto____9161) {
            return or__3824__auto____9161
          }else {
            return G__9159__9160.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__9159__9160.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__9159__9160)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__9159__9160)
      }
    }()) {
      return tcoll__9158.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__9162 = cljs.core.seq.call(null, o);
      var tcoll__9163 = tcoll__9158;
      while(true) {
        var temp__3971__auto____9164 = cljs.core.first.call(null, es__9162);
        if(cljs.core.truth_(temp__3971__auto____9164)) {
          var e__9165 = temp__3971__auto____9164;
          var G__9176 = cljs.core.next.call(null, es__9162);
          var G__9177 = tcoll__9163.assoc_BANG_(cljs.core.key.call(null, e__9165), cljs.core.val.call(null, e__9165));
          es__9162 = G__9176;
          tcoll__9163 = G__9177;
          continue
        }else {
          return tcoll__9163
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__9166 = this;
  var tcoll__9167 = this;
  if(this__9166.edit) {
    if(k == null) {
      if(this__9166.nil_val === v) {
      }else {
        this__9166.nil_val = v
      }
      if(this__9166.has_nil_QMARK_) {
      }else {
        this__9166.count = this__9166.count + 1;
        this__9166.has_nil_QMARK_ = true
      }
      return tcoll__9167
    }else {
      var added_leaf_QMARK___9168 = new cljs.core.Box(false);
      var node__9169 = (this__9166.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__9166.root).inode_assoc_BANG_(this__9166.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___9168);
      if(node__9169 === this__9166.root) {
      }else {
        this__9166.root = node__9169
      }
      if(added_leaf_QMARK___9168.val) {
        this__9166.count = this__9166.count + 1
      }else {
      }
      return tcoll__9167
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__9170 = this;
  var tcoll__9171 = this;
  if(this__9170.edit) {
    if(k == null) {
      if(this__9170.has_nil_QMARK_) {
        this__9170.has_nil_QMARK_ = false;
        this__9170.nil_val = null;
        this__9170.count = this__9170.count - 1;
        return tcoll__9171
      }else {
        return tcoll__9171
      }
    }else {
      if(this__9170.root == null) {
        return tcoll__9171
      }else {
        var removed_leaf_QMARK___9172 = new cljs.core.Box(false);
        var node__9173 = this__9170.root.inode_without_BANG_(this__9170.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___9172);
        if(node__9173 === this__9170.root) {
        }else {
          this__9170.root = node__9173
        }
        if(cljs.core.truth_(removed_leaf_QMARK___9172[0])) {
          this__9170.count = this__9170.count - 1
        }else {
        }
        return tcoll__9171
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__9174 = this;
  var tcoll__9175 = this;
  if(this__9174.edit) {
    this__9174.edit = null;
    return new cljs.core.PersistentHashMap(null, this__9174.count, this__9174.root, this__9174.has_nil_QMARK_, this__9174.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__9180 = node;
  var stack__9181 = stack;
  while(true) {
    if(!(t__9180 == null)) {
      var G__9182 = ascending_QMARK_ ? t__9180.left : t__9180.right;
      var G__9183 = cljs.core.conj.call(null, stack__9181, t__9180);
      t__9180 = G__9182;
      stack__9181 = G__9183;
      continue
    }else {
      return stack__9181
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850570
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9184 = this;
  var h__2192__auto____9185 = this__9184.__hash;
  if(!(h__2192__auto____9185 == null)) {
    return h__2192__auto____9185
  }else {
    var h__2192__auto____9186 = cljs.core.hash_coll.call(null, coll);
    this__9184.__hash = h__2192__auto____9186;
    return h__2192__auto____9186
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9187 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__9188 = this;
  var this__9189 = this;
  return cljs.core.pr_str.call(null, this__9189)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__9190 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9191 = this;
  if(this__9191.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__9191.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__9192 = this;
  return cljs.core.peek.call(null, this__9192.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__9193 = this;
  var t__9194 = cljs.core.first.call(null, this__9193.stack);
  var next_stack__9195 = cljs.core.tree_map_seq_push.call(null, this__9193.ascending_QMARK_ ? t__9194.right : t__9194.left, cljs.core.next.call(null, this__9193.stack), this__9193.ascending_QMARK_);
  if(!(next_stack__9195 == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__9195, this__9193.ascending_QMARK_, this__9193.cnt - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9196 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9197 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__9197.stack, this__9197.ascending_QMARK_, this__9197.cnt, this__9197.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9198 = this;
  return this__9198.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3822__auto____9200 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3822__auto____9200) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3822__auto____9200
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3822__auto____9202 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3822__auto____9202) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3822__auto____9202
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__9206 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__9206)) {
    return cljs.core.deref.call(null, init__9206)
  }else {
    var init__9207 = !(node.left == null) ? tree_map_kv_reduce.call(null, node.left, f, init__9206) : init__9206;
    if(cljs.core.reduced_QMARK_.call(null, init__9207)) {
      return cljs.core.deref.call(null, init__9207)
    }else {
      var init__9208 = !(node.right == null) ? tree_map_kv_reduce.call(null, node.right, f, init__9207) : init__9207;
      if(cljs.core.reduced_QMARK_.call(null, init__9208)) {
        return cljs.core.deref.call(null, init__9208)
      }else {
        return init__9208
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32402207
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9211 = this;
  var h__2192__auto____9212 = this__9211.__hash;
  if(!(h__2192__auto____9212 == null)) {
    return h__2192__auto____9212
  }else {
    var h__2192__auto____9213 = cljs.core.hash_coll.call(null, coll);
    this__9211.__hash = h__2192__auto____9213;
    return h__2192__auto____9213
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__9214 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__9215 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__9216 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__9216.key, this__9216.val], true), k, v)
};
cljs.core.BlackNode.prototype.call = function() {
  var G__9264 = null;
  var G__9264__2 = function(this_sym9217, k) {
    var this__9219 = this;
    var this_sym9217__9220 = this;
    var node__9221 = this_sym9217__9220;
    return node__9221.cljs$core$ILookup$_lookup$arity$2(node__9221, k)
  };
  var G__9264__3 = function(this_sym9218, k, not_found) {
    var this__9219 = this;
    var this_sym9218__9222 = this;
    var node__9223 = this_sym9218__9222;
    return node__9223.cljs$core$ILookup$_lookup$arity$3(node__9223, k, not_found)
  };
  G__9264 = function(this_sym9218, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9264__2.call(this, this_sym9218, k);
      case 3:
        return G__9264__3.call(this, this_sym9218, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9264
}();
cljs.core.BlackNode.prototype.apply = function(this_sym9209, args9210) {
  var this__9224 = this;
  return this_sym9209.call.apply(this_sym9209, [this_sym9209].concat(args9210.slice()))
};
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__9225 = this;
  return cljs.core.PersistentVector.fromArray([this__9225.key, this__9225.val, o], true)
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__9226 = this;
  return this__9226.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__9227 = this;
  return this__9227.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__9228 = this;
  var node__9229 = this;
  return ins.balance_right(node__9229)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__9230 = this;
  var node__9231 = this;
  return new cljs.core.RedNode(this__9230.key, this__9230.val, this__9230.left, this__9230.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__9232 = this;
  var node__9233 = this;
  return cljs.core.balance_right_del.call(null, this__9232.key, this__9232.val, this__9232.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__9234 = this;
  var node__9235 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__9236 = this;
  var node__9237 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__9237, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__9238 = this;
  var node__9239 = this;
  return cljs.core.balance_left_del.call(null, this__9238.key, this__9238.val, del, this__9238.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__9240 = this;
  var node__9241 = this;
  return ins.balance_left(node__9241)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__9242 = this;
  var node__9243 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__9243, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__9265 = null;
  var G__9265__0 = function() {
    var this__9244 = this;
    var this__9246 = this;
    return cljs.core.pr_str.call(null, this__9246)
  };
  G__9265 = function() {
    switch(arguments.length) {
      case 0:
        return G__9265__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9265
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__9247 = this;
  var node__9248 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__9248, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__9249 = this;
  var node__9250 = this;
  return node__9250
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__9251 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__9252 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__9253 = this;
  return cljs.core.list.call(null, this__9253.key, this__9253.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__9254 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__9255 = this;
  return this__9255.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__9256 = this;
  return cljs.core.PersistentVector.fromArray([this__9256.key], true)
};
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__9257 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__9257.key, this__9257.val], true), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9258 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__9259 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__9259.key, this__9259.val], true), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__9260 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__9261 = this;
  if(n === 0) {
    return this__9261.key
  }else {
    if(n === 1) {
      return this__9261.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__9262 = this;
  if(n === 0) {
    return this__9262.key
  }else {
    if(n === 1) {
      return this__9262.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__9263 = this;
  return cljs.core.PersistentVector.EMPTY
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32402207
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9268 = this;
  var h__2192__auto____9269 = this__9268.__hash;
  if(!(h__2192__auto____9269 == null)) {
    return h__2192__auto____9269
  }else {
    var h__2192__auto____9270 = cljs.core.hash_coll.call(null, coll);
    this__9268.__hash = h__2192__auto____9270;
    return h__2192__auto____9270
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__9271 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__9272 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__9273 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__9273.key, this__9273.val], true), k, v)
};
cljs.core.RedNode.prototype.call = function() {
  var G__9321 = null;
  var G__9321__2 = function(this_sym9274, k) {
    var this__9276 = this;
    var this_sym9274__9277 = this;
    var node__9278 = this_sym9274__9277;
    return node__9278.cljs$core$ILookup$_lookup$arity$2(node__9278, k)
  };
  var G__9321__3 = function(this_sym9275, k, not_found) {
    var this__9276 = this;
    var this_sym9275__9279 = this;
    var node__9280 = this_sym9275__9279;
    return node__9280.cljs$core$ILookup$_lookup$arity$3(node__9280, k, not_found)
  };
  G__9321 = function(this_sym9275, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9321__2.call(this, this_sym9275, k);
      case 3:
        return G__9321__3.call(this, this_sym9275, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9321
}();
cljs.core.RedNode.prototype.apply = function(this_sym9266, args9267) {
  var this__9281 = this;
  return this_sym9266.call.apply(this_sym9266, [this_sym9266].concat(args9267.slice()))
};
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__9282 = this;
  return cljs.core.PersistentVector.fromArray([this__9282.key, this__9282.val, o], true)
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__9283 = this;
  return this__9283.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__9284 = this;
  return this__9284.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__9285 = this;
  var node__9286 = this;
  return new cljs.core.RedNode(this__9285.key, this__9285.val, this__9285.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__9287 = this;
  var node__9288 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__9289 = this;
  var node__9290 = this;
  return new cljs.core.RedNode(this__9289.key, this__9289.val, this__9289.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__9291 = this;
  var node__9292 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__9293 = this;
  var node__9294 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__9294, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__9295 = this;
  var node__9296 = this;
  return new cljs.core.RedNode(this__9295.key, this__9295.val, del, this__9295.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__9297 = this;
  var node__9298 = this;
  return new cljs.core.RedNode(this__9297.key, this__9297.val, ins, this__9297.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__9299 = this;
  var node__9300 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__9299.left)) {
    return new cljs.core.RedNode(this__9299.key, this__9299.val, this__9299.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__9299.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__9299.right)) {
      return new cljs.core.RedNode(this__9299.right.key, this__9299.right.val, new cljs.core.BlackNode(this__9299.key, this__9299.val, this__9299.left, this__9299.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__9299.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__9300, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__9322 = null;
  var G__9322__0 = function() {
    var this__9301 = this;
    var this__9303 = this;
    return cljs.core.pr_str.call(null, this__9303)
  };
  G__9322 = function() {
    switch(arguments.length) {
      case 0:
        return G__9322__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9322
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__9304 = this;
  var node__9305 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__9304.right)) {
    return new cljs.core.RedNode(this__9304.key, this__9304.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__9304.left, null), this__9304.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__9304.left)) {
      return new cljs.core.RedNode(this__9304.left.key, this__9304.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__9304.left.left, null), new cljs.core.BlackNode(this__9304.key, this__9304.val, this__9304.left.right, this__9304.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__9305, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__9306 = this;
  var node__9307 = this;
  return new cljs.core.BlackNode(this__9306.key, this__9306.val, this__9306.left, this__9306.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__9308 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__9309 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__9310 = this;
  return cljs.core.list.call(null, this__9310.key, this__9310.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__9311 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__9312 = this;
  return this__9312.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__9313 = this;
  return cljs.core.PersistentVector.fromArray([this__9313.key], true)
};
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__9314 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__9314.key, this__9314.val], true), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9315 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__9316 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__9316.key, this__9316.val], true), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__9317 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__9318 = this;
  if(n === 0) {
    return this__9318.key
  }else {
    if(n === 1) {
      return this__9318.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__9319 = this;
  if(n === 0) {
    return this__9319.key
  }else {
    if(n === 1) {
      return this__9319.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__9320 = this;
  return cljs.core.PersistentVector.EMPTY
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__9326 = comp.call(null, k, tree.key);
    if(c__9326 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__9326 < 0) {
        var ins__9327 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(!(ins__9327 == null)) {
          return tree.add_left(ins__9327)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__9328 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(!(ins__9328 == null)) {
            return tree.add_right(ins__9328)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__9331 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__9331)) {
            return new cljs.core.RedNode(app__9331.key, app__9331.val, new cljs.core.RedNode(left.key, left.val, left.left, app__9331.left, null), new cljs.core.RedNode(right.key, right.val, app__9331.right, right.right, null), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__9331, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__9332 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__9332)) {
              return new cljs.core.RedNode(app__9332.key, app__9332.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__9332.left, null), new cljs.core.BlackNode(right.key, right.val, app__9332.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__9332, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(!(tree == null)) {
    var c__9338 = comp.call(null, k, tree.key);
    if(c__9338 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__9338 < 0) {
        var del__9339 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3824__auto____9340 = !(del__9339 == null);
          if(or__3824__auto____9340) {
            return or__3824__auto____9340
          }else {
            return!(found[0] == null)
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__9339, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__9339, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__9341 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3824__auto____9342 = !(del__9341 == null);
            if(or__3824__auto____9342) {
              return or__3824__auto____9342
            }else {
              return!(found[0] == null)
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__9341)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__9341, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__9345 = tree.key;
  var c__9346 = comp.call(null, k, tk__9345);
  if(c__9346 === 0) {
    return tree.replace(tk__9345, v, tree.left, tree.right)
  }else {
    if(c__9346 < 0) {
      return tree.replace(tk__9345, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__9345, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 418776847
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9349 = this;
  var h__2192__auto____9350 = this__9349.__hash;
  if(!(h__2192__auto____9350 == null)) {
    return h__2192__auto____9350
  }else {
    var h__2192__auto____9351 = cljs.core.hash_imap.call(null, coll);
    this__9349.__hash = h__2192__auto____9351;
    return h__2192__auto____9351
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__9352 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__9353 = this;
  var n__9354 = coll.entry_at(k);
  if(!(n__9354 == null)) {
    return n__9354.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__9355 = this;
  var found__9356 = [null];
  var t__9357 = cljs.core.tree_map_add.call(null, this__9355.comp, this__9355.tree, k, v, found__9356);
  if(t__9357 == null) {
    var found_node__9358 = cljs.core.nth.call(null, found__9356, 0);
    if(cljs.core._EQ_.call(null, v, found_node__9358.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__9355.comp, cljs.core.tree_map_replace.call(null, this__9355.comp, this__9355.tree, k, v), this__9355.cnt, this__9355.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__9355.comp, t__9357.blacken(), this__9355.cnt + 1, this__9355.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__9359 = this;
  return!(coll.entry_at(k) == null)
};
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__9393 = null;
  var G__9393__2 = function(this_sym9360, k) {
    var this__9362 = this;
    var this_sym9360__9363 = this;
    var coll__9364 = this_sym9360__9363;
    return coll__9364.cljs$core$ILookup$_lookup$arity$2(coll__9364, k)
  };
  var G__9393__3 = function(this_sym9361, k, not_found) {
    var this__9362 = this;
    var this_sym9361__9365 = this;
    var coll__9366 = this_sym9361__9365;
    return coll__9366.cljs$core$ILookup$_lookup$arity$3(coll__9366, k, not_found)
  };
  G__9393 = function(this_sym9361, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9393__2.call(this, this_sym9361, k);
      case 3:
        return G__9393__3.call(this, this_sym9361, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9393
}();
cljs.core.PersistentTreeMap.prototype.apply = function(this_sym9347, args9348) {
  var this__9367 = this;
  return this_sym9347.call.apply(this_sym9347, [this_sym9347].concat(args9348.slice()))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__9368 = this;
  if(!(this__9368.tree == null)) {
    return cljs.core.tree_map_kv_reduce.call(null, this__9368.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__9369 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__9370 = this;
  if(this__9370.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__9370.tree, false, this__9370.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__9371 = this;
  var this__9372 = this;
  return cljs.core.pr_str.call(null, this__9372)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__9373 = this;
  var coll__9374 = this;
  var t__9375 = this__9373.tree;
  while(true) {
    if(!(t__9375 == null)) {
      var c__9376 = this__9373.comp.call(null, k, t__9375.key);
      if(c__9376 === 0) {
        return t__9375
      }else {
        if(c__9376 < 0) {
          var G__9394 = t__9375.left;
          t__9375 = G__9394;
          continue
        }else {
          if("\ufdd0'else") {
            var G__9395 = t__9375.right;
            t__9375 = G__9395;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__9377 = this;
  if(this__9377.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__9377.tree, ascending_QMARK_, this__9377.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__9378 = this;
  if(this__9378.cnt > 0) {
    var stack__9379 = null;
    var t__9380 = this__9378.tree;
    while(true) {
      if(!(t__9380 == null)) {
        var c__9381 = this__9378.comp.call(null, k, t__9380.key);
        if(c__9381 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__9379, t__9380), ascending_QMARK_, -1, null)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__9381 < 0) {
              var G__9396 = cljs.core.conj.call(null, stack__9379, t__9380);
              var G__9397 = t__9380.left;
              stack__9379 = G__9396;
              t__9380 = G__9397;
              continue
            }else {
              var G__9398 = stack__9379;
              var G__9399 = t__9380.right;
              stack__9379 = G__9398;
              t__9380 = G__9399;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__9381 > 0) {
                var G__9400 = cljs.core.conj.call(null, stack__9379, t__9380);
                var G__9401 = t__9380.right;
                stack__9379 = G__9400;
                t__9380 = G__9401;
                continue
              }else {
                var G__9402 = stack__9379;
                var G__9403 = t__9380.left;
                stack__9379 = G__9402;
                t__9380 = G__9403;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__9379 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__9379, ascending_QMARK_, -1, null)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__9382 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__9383 = this;
  return this__9383.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9384 = this;
  if(this__9384.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__9384.tree, true, this__9384.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9385 = this;
  return this__9385.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9386 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9387 = this;
  return new cljs.core.PersistentTreeMap(this__9387.comp, this__9387.tree, this__9387.cnt, meta, this__9387.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9388 = this;
  return this__9388.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9389 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__9389.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__9390 = this;
  var found__9391 = [null];
  var t__9392 = cljs.core.tree_map_remove.call(null, this__9390.comp, this__9390.tree, k, found__9391);
  if(t__9392 == null) {
    if(cljs.core.nth.call(null, found__9391, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__9390.comp, null, 0, this__9390.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__9390.comp, t__9392.blacken(), this__9390.cnt - 1, this__9390.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in__9406 = cljs.core.seq.call(null, keyvals);
    var out__9407 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(in__9406) {
        var G__9408 = cljs.core.nnext.call(null, in__9406);
        var G__9409 = cljs.core.assoc_BANG_.call(null, out__9407, cljs.core.first.call(null, in__9406), cljs.core.second.call(null, in__9406));
        in__9406 = G__9408;
        out__9407 = G__9409;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__9407)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__9410) {
    var keyvals = cljs.core.seq(arglist__9410);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__9411) {
    var keyvals = cljs.core.seq(arglist__9411);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.obj_map = function() {
  var obj_map__delegate = function(keyvals) {
    var ks__9415 = [];
    var obj__9416 = {};
    var kvs__9417 = cljs.core.seq.call(null, keyvals);
    while(true) {
      if(kvs__9417) {
        ks__9415.push(cljs.core.first.call(null, kvs__9417));
        obj__9416[cljs.core.first.call(null, kvs__9417)] = cljs.core.second.call(null, kvs__9417);
        var G__9418 = cljs.core.nnext.call(null, kvs__9417);
        kvs__9417 = G__9418;
        continue
      }else {
        return cljs.core.ObjMap.fromObject.call(null, ks__9415, obj__9416)
      }
      break
    }
  };
  var obj_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return obj_map__delegate.call(this, keyvals)
  };
  obj_map.cljs$lang$maxFixedArity = 0;
  obj_map.cljs$lang$applyTo = function(arglist__9419) {
    var keyvals = cljs.core.seq(arglist__9419);
    return obj_map__delegate(keyvals)
  };
  obj_map.cljs$lang$arity$variadic = obj_map__delegate;
  return obj_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in__9422 = cljs.core.seq.call(null, keyvals);
    var out__9423 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(in__9422) {
        var G__9424 = cljs.core.nnext.call(null, in__9422);
        var G__9425 = cljs.core.assoc.call(null, out__9423, cljs.core.first.call(null, in__9422), cljs.core.second.call(null, in__9422));
        in__9422 = G__9424;
        out__9423 = G__9425;
        continue
      }else {
        return out__9423
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__9426) {
    var keyvals = cljs.core.seq(arglist__9426);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in__9429 = cljs.core.seq.call(null, keyvals);
    var out__9430 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(in__9429) {
        var G__9431 = cljs.core.nnext.call(null, in__9429);
        var G__9432 = cljs.core.assoc.call(null, out__9430, cljs.core.first.call(null, in__9429), cljs.core.second.call(null, in__9429));
        in__9429 = G__9431;
        out__9430 = G__9432;
        continue
      }else {
        return out__9430
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__9433) {
    var comparator = cljs.core.first(arglist__9433);
    var keyvals = cljs.core.rest(arglist__9433);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__9434_SHARP_, p2__9435_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3824__auto____9437 = p1__9434_SHARP_;
          if(cljs.core.truth_(or__3824__auto____9437)) {
            return or__3824__auto____9437
          }else {
            return cljs.core.ObjMap.EMPTY
          }
        }(), p2__9435_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__9438) {
    var maps = cljs.core.seq(arglist__9438);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__9446 = function(m, e) {
        var k__9444 = cljs.core.first.call(null, e);
        var v__9445 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__9444)) {
          return cljs.core.assoc.call(null, m, k__9444, f.call(null, cljs.core._lookup.call(null, m, k__9444, null), v__9445))
        }else {
          return cljs.core.assoc.call(null, m, k__9444, v__9445)
        }
      };
      var merge2__9448 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__9446, function() {
          var or__3824__auto____9447 = m1;
          if(cljs.core.truth_(or__3824__auto____9447)) {
            return or__3824__auto____9447
          }else {
            return cljs.core.ObjMap.EMPTY
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__9448, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__9449) {
    var f = cljs.core.first(arglist__9449);
    var maps = cljs.core.rest(arglist__9449);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__9454 = cljs.core.ObjMap.EMPTY;
  var keys__9455 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(keys__9455) {
      var key__9456 = cljs.core.first.call(null, keys__9455);
      var entry__9457 = cljs.core._lookup.call(null, map, key__9456, "\ufdd0'cljs.core/not-found");
      var G__9458 = cljs.core.not_EQ_.call(null, entry__9457, "\ufdd0'cljs.core/not-found") ? cljs.core.assoc.call(null, ret__9454, key__9456, entry__9457) : ret__9454;
      var G__9459 = cljs.core.next.call(null, keys__9455);
      ret__9454 = G__9458;
      keys__9455 = G__9459;
      continue
    }else {
      return ret__9454
    }
    break
  }
};
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 15077647
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__9463 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__9463.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9464 = this;
  var h__2192__auto____9465 = this__9464.__hash;
  if(!(h__2192__auto____9465 == null)) {
    return h__2192__auto____9465
  }else {
    var h__2192__auto____9466 = cljs.core.hash_iset.call(null, coll);
    this__9464.__hash = h__2192__auto____9466;
    return h__2192__auto____9466
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__9467 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__9468 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__9468.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__9489 = null;
  var G__9489__2 = function(this_sym9469, k) {
    var this__9471 = this;
    var this_sym9469__9472 = this;
    var coll__9473 = this_sym9469__9472;
    return coll__9473.cljs$core$ILookup$_lookup$arity$2(coll__9473, k)
  };
  var G__9489__3 = function(this_sym9470, k, not_found) {
    var this__9471 = this;
    var this_sym9470__9474 = this;
    var coll__9475 = this_sym9470__9474;
    return coll__9475.cljs$core$ILookup$_lookup$arity$3(coll__9475, k, not_found)
  };
  G__9489 = function(this_sym9470, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9489__2.call(this, this_sym9470, k);
      case 3:
        return G__9489__3.call(this, this_sym9470, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9489
}();
cljs.core.PersistentHashSet.prototype.apply = function(this_sym9461, args9462) {
  var this__9476 = this;
  return this_sym9461.call.apply(this_sym9461, [this_sym9461].concat(args9462.slice()))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9477 = this;
  return new cljs.core.PersistentHashSet(this__9477.meta, cljs.core.assoc.call(null, this__9477.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__9478 = this;
  var this__9479 = this;
  return cljs.core.pr_str.call(null, this__9479)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9480 = this;
  return cljs.core.keys.call(null, this__9480.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__9481 = this;
  return new cljs.core.PersistentHashSet(this__9481.meta, cljs.core.dissoc.call(null, this__9481.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9482 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9483 = this;
  var and__3822__auto____9484 = cljs.core.set_QMARK_.call(null, other);
  if(and__3822__auto____9484) {
    var and__3822__auto____9485 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3822__auto____9485) {
      return cljs.core.every_QMARK_.call(null, function(p1__9460_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__9460_SHARP_)
      }, other)
    }else {
      return and__3822__auto____9485
    }
  }else {
    return and__3822__auto____9484
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9486 = this;
  return new cljs.core.PersistentHashSet(meta, this__9486.hash_map, this__9486.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9487 = this;
  return this__9487.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9488 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__9488.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.PersistentHashSet.fromArray = function(items) {
  var len__9490 = cljs.core.count.call(null, items);
  var i__9491 = 0;
  var out__9492 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(i__9491 < len__9490) {
      var G__9493 = i__9491 + 1;
      var G__9494 = cljs.core.conj_BANG_.call(null, out__9492, items[i__9491]);
      i__9491 = G__9493;
      out__9492 = G__9494;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__9492)
    }
    break
  }
};
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 259;
  this.cljs$lang$protocol_mask$partition1$ = 34
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientHashSet")
};
cljs.core.TransientHashSet.prototype.call = function() {
  var G__9512 = null;
  var G__9512__2 = function(this_sym9498, k) {
    var this__9500 = this;
    var this_sym9498__9501 = this;
    var tcoll__9502 = this_sym9498__9501;
    if(cljs.core._lookup.call(null, this__9500.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__9512__3 = function(this_sym9499, k, not_found) {
    var this__9500 = this;
    var this_sym9499__9503 = this;
    var tcoll__9504 = this_sym9499__9503;
    if(cljs.core._lookup.call(null, this__9500.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__9512 = function(this_sym9499, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9512__2.call(this, this_sym9499, k);
      case 3:
        return G__9512__3.call(this, this_sym9499, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9512
}();
cljs.core.TransientHashSet.prototype.apply = function(this_sym9496, args9497) {
  var this__9505 = this;
  return this_sym9496.call.apply(this_sym9496, [this_sym9496].concat(args9497.slice()))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__9506 = this;
  return tcoll.cljs$core$ILookup$_lookup$arity$3(tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__9507 = this;
  if(cljs.core._lookup.call(null, this__9507.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__9508 = this;
  return cljs.core.count.call(null, this__9508.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__9509 = this;
  this__9509.transient_map = cljs.core.dissoc_BANG_.call(null, this__9509.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__9510 = this;
  this__9510.transient_map = cljs.core.assoc_BANG_.call(null, this__9510.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__9511 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__9511.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 417730831
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9515 = this;
  var h__2192__auto____9516 = this__9515.__hash;
  if(!(h__2192__auto____9516 == null)) {
    return h__2192__auto____9516
  }else {
    var h__2192__auto____9517 = cljs.core.hash_iset.call(null, coll);
    this__9515.__hash = h__2192__auto____9517;
    return h__2192__auto____9517
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__9518 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__9519 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__9519.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__9545 = null;
  var G__9545__2 = function(this_sym9520, k) {
    var this__9522 = this;
    var this_sym9520__9523 = this;
    var coll__9524 = this_sym9520__9523;
    return coll__9524.cljs$core$ILookup$_lookup$arity$2(coll__9524, k)
  };
  var G__9545__3 = function(this_sym9521, k, not_found) {
    var this__9522 = this;
    var this_sym9521__9525 = this;
    var coll__9526 = this_sym9521__9525;
    return coll__9526.cljs$core$ILookup$_lookup$arity$3(coll__9526, k, not_found)
  };
  G__9545 = function(this_sym9521, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9545__2.call(this, this_sym9521, k);
      case 3:
        return G__9545__3.call(this, this_sym9521, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9545
}();
cljs.core.PersistentTreeSet.prototype.apply = function(this_sym9513, args9514) {
  var this__9527 = this;
  return this_sym9513.call.apply(this_sym9513, [this_sym9513].concat(args9514.slice()))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9528 = this;
  return new cljs.core.PersistentTreeSet(this__9528.meta, cljs.core.assoc.call(null, this__9528.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__9529 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__9529.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__9530 = this;
  var this__9531 = this;
  return cljs.core.pr_str.call(null, this__9531)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__9532 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__9532.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__9533 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__9533.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__9534 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__9535 = this;
  return cljs.core._comparator.call(null, this__9535.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9536 = this;
  return cljs.core.keys.call(null, this__9536.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__9537 = this;
  return new cljs.core.PersistentTreeSet(this__9537.meta, cljs.core.dissoc.call(null, this__9537.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9538 = this;
  return cljs.core.count.call(null, this__9538.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9539 = this;
  var and__3822__auto____9540 = cljs.core.set_QMARK_.call(null, other);
  if(and__3822__auto____9540) {
    var and__3822__auto____9541 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3822__auto____9541) {
      return cljs.core.every_QMARK_.call(null, function(p1__9495_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__9495_SHARP_)
      }, other)
    }else {
      return and__3822__auto____9541
    }
  }else {
    return and__3822__auto____9540
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9542 = this;
  return new cljs.core.PersistentTreeSet(meta, this__9542.tree_map, this__9542.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9543 = this;
  return this__9543.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9544 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__9544.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.hash_set = function() {
  var hash_set = null;
  var hash_set__0 = function() {
    return cljs.core.PersistentHashSet.EMPTY
  };
  var hash_set__1 = function() {
    var G__9550__delegate = function(keys) {
      var in__9548 = cljs.core.seq.call(null, keys);
      var out__9549 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
      while(true) {
        if(cljs.core.seq.call(null, in__9548)) {
          var G__9551 = cljs.core.next.call(null, in__9548);
          var G__9552 = cljs.core.conj_BANG_.call(null, out__9549, cljs.core.first.call(null, in__9548));
          in__9548 = G__9551;
          out__9549 = G__9552;
          continue
        }else {
          return cljs.core.persistent_BANG_.call(null, out__9549)
        }
        break
      }
    };
    var G__9550 = function(var_args) {
      var keys = null;
      if(goog.isDef(var_args)) {
        keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__9550__delegate.call(this, keys)
    };
    G__9550.cljs$lang$maxFixedArity = 0;
    G__9550.cljs$lang$applyTo = function(arglist__9553) {
      var keys = cljs.core.seq(arglist__9553);
      return G__9550__delegate(keys)
    };
    G__9550.cljs$lang$arity$variadic = G__9550__delegate;
    return G__9550
  }();
  hash_set = function(var_args) {
    var keys = var_args;
    switch(arguments.length) {
      case 0:
        return hash_set__0.call(this);
      default:
        return hash_set__1.cljs$lang$arity$variadic(cljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  hash_set.cljs$lang$maxFixedArity = 0;
  hash_set.cljs$lang$applyTo = hash_set__1.cljs$lang$applyTo;
  hash_set.cljs$lang$arity$0 = hash_set__0;
  hash_set.cljs$lang$arity$variadic = hash_set__1.cljs$lang$arity$variadic;
  return hash_set
}();
cljs.core.set = function set(coll) {
  return cljs.core.apply.call(null, cljs.core.hash_set, coll)
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__9554) {
    var keys = cljs.core.seq(arglist__9554);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__9556) {
    var comparator = cljs.core.first(arglist__9556);
    var keys = cljs.core.rest(arglist__9556);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__9562 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3971__auto____9563 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3971__auto____9563)) {
        var e__9564 = temp__3971__auto____9563;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__9564))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__9562, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__9555_SHARP_) {
      var temp__3971__auto____9565 = cljs.core.find.call(null, smap, p1__9555_SHARP_);
      if(cljs.core.truth_(temp__3971__auto____9565)) {
        var e__9566 = temp__3971__auto____9565;
        return cljs.core.second.call(null, e__9566)
      }else {
        return p1__9555_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__9596 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__9589, seen) {
        while(true) {
          var vec__9590__9591 = p__9589;
          var f__9592 = cljs.core.nth.call(null, vec__9590__9591, 0, null);
          var xs__9593 = vec__9590__9591;
          var temp__3974__auto____9594 = cljs.core.seq.call(null, xs__9593);
          if(temp__3974__auto____9594) {
            var s__9595 = temp__3974__auto____9594;
            if(cljs.core.contains_QMARK_.call(null, seen, f__9592)) {
              var G__9597 = cljs.core.rest.call(null, s__9595);
              var G__9598 = seen;
              p__9589 = G__9597;
              seen = G__9598;
              continue
            }else {
              return cljs.core.cons.call(null, f__9592, step.call(null, cljs.core.rest.call(null, s__9595), cljs.core.conj.call(null, seen, f__9592)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    }, null)
  };
  return step__9596.call(null, coll, cljs.core.PersistentHashSet.EMPTY)
};
cljs.core.butlast = function butlast(s) {
  var ret__9601 = cljs.core.PersistentVector.EMPTY;
  var s__9602 = s;
  while(true) {
    if(cljs.core.next.call(null, s__9602)) {
      var G__9603 = cljs.core.conj.call(null, ret__9601, cljs.core.first.call(null, s__9602));
      var G__9604 = cljs.core.next.call(null, s__9602);
      ret__9601 = G__9603;
      s__9602 = G__9604;
      continue
    }else {
      return cljs.core.seq.call(null, ret__9601)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3824__auto____9607 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3824__auto____9607) {
        return or__3824__auto____9607
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__9608 = x.lastIndexOf("/");
      if(i__9608 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__9608 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3824__auto____9611 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3824__auto____9611) {
      return or__3824__auto____9611
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__9612 = x.lastIndexOf("/");
    if(i__9612 > -1) {
      return cljs.core.subs.call(null, x, 2, i__9612)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__9619 = cljs.core.ObjMap.EMPTY;
  var ks__9620 = cljs.core.seq.call(null, keys);
  var vs__9621 = cljs.core.seq.call(null, vals);
  while(true) {
    if(function() {
      var and__3822__auto____9622 = ks__9620;
      if(and__3822__auto____9622) {
        return vs__9621
      }else {
        return and__3822__auto____9622
      }
    }()) {
      var G__9623 = cljs.core.assoc.call(null, map__9619, cljs.core.first.call(null, ks__9620), cljs.core.first.call(null, vs__9621));
      var G__9624 = cljs.core.next.call(null, ks__9620);
      var G__9625 = cljs.core.next.call(null, vs__9621);
      map__9619 = G__9623;
      ks__9620 = G__9624;
      vs__9621 = G__9625;
      continue
    }else {
      return map__9619
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__9628__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__9613_SHARP_, p2__9614_SHARP_) {
        return max_key.call(null, k, p1__9613_SHARP_, p2__9614_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__9628 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__9628__delegate.call(this, k, x, y, more)
    };
    G__9628.cljs$lang$maxFixedArity = 3;
    G__9628.cljs$lang$applyTo = function(arglist__9629) {
      var k = cljs.core.first(arglist__9629);
      var x = cljs.core.first(cljs.core.next(arglist__9629));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__9629)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__9629)));
      return G__9628__delegate(k, x, y, more)
    };
    G__9628.cljs$lang$arity$variadic = G__9628__delegate;
    return G__9628
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__9630__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__9626_SHARP_, p2__9627_SHARP_) {
        return min_key.call(null, k, p1__9626_SHARP_, p2__9627_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__9630 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__9630__delegate.call(this, k, x, y, more)
    };
    G__9630.cljs$lang$maxFixedArity = 3;
    G__9630.cljs$lang$applyTo = function(arglist__9631) {
      var k = cljs.core.first(arglist__9631);
      var x = cljs.core.first(cljs.core.next(arglist__9631));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__9631)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__9631)));
      return G__9630__delegate(k, x, y, more)
    };
    G__9630.cljs$lang$arity$variadic = G__9630__delegate;
    return G__9630
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____9634 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____9634) {
        var s__9635 = temp__3974__auto____9634;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__9635), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__9635)))
      }else {
        return null
      }
    }, null)
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____9638 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____9638) {
      var s__9639 = temp__3974__auto____9638;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__9639)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__9639), take_while.call(null, pred, cljs.core.rest.call(null, s__9639)))
      }else {
        return null
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__9641 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__9641.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__9653 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3974__auto____9654 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3974__auto____9654)) {
        var vec__9655__9656 = temp__3974__auto____9654;
        var e__9657 = cljs.core.nth.call(null, vec__9655__9656, 0, null);
        var s__9658 = vec__9655__9656;
        if(cljs.core.truth_(include__9653.call(null, e__9657))) {
          return s__9658
        }else {
          return cljs.core.next.call(null, s__9658)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__9653, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3974__auto____9659 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3974__auto____9659)) {
      var vec__9660__9661 = temp__3974__auto____9659;
      var e__9662 = cljs.core.nth.call(null, vec__9660__9661, 0, null);
      var s__9663 = vec__9660__9661;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__9662)) ? s__9663 : cljs.core.next.call(null, s__9663))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__9675 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3974__auto____9676 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3974__auto____9676)) {
        var vec__9677__9678 = temp__3974__auto____9676;
        var e__9679 = cljs.core.nth.call(null, vec__9677__9678, 0, null);
        var s__9680 = vec__9677__9678;
        if(cljs.core.truth_(include__9675.call(null, e__9679))) {
          return s__9680
        }else {
          return cljs.core.next.call(null, s__9680)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__9675, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3974__auto____9681 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3974__auto____9681)) {
      var vec__9682__9683 = temp__3974__auto____9681;
      var e__9684 = cljs.core.nth.call(null, vec__9682__9683, 0, null);
      var s__9685 = vec__9682__9683;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__9684)) ? s__9685 : cljs.core.next.call(null, s__9685))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32375006
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Range")
};
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__9686 = this;
  var h__2192__auto____9687 = this__9686.__hash;
  if(!(h__2192__auto____9687 == null)) {
    return h__2192__auto____9687
  }else {
    var h__2192__auto____9688 = cljs.core.hash_coll.call(null, rng);
    this__9686.__hash = h__2192__auto____9688;
    return h__2192__auto____9688
  }
};
cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = function(rng) {
  var this__9689 = this;
  if(this__9689.step > 0) {
    if(this__9689.start + this__9689.step < this__9689.end) {
      return new cljs.core.Range(this__9689.meta, this__9689.start + this__9689.step, this__9689.end, this__9689.step, null)
    }else {
      return null
    }
  }else {
    if(this__9689.start + this__9689.step > this__9689.end) {
      return new cljs.core.Range(this__9689.meta, this__9689.start + this__9689.step, this__9689.end, this__9689.step, null)
    }else {
      return null
    }
  }
};
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__9690 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__9691 = this;
  var this__9692 = this;
  return cljs.core.pr_str.call(null, this__9692)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__9693 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__9694 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__9695 = this;
  if(this__9695.step > 0) {
    if(this__9695.start < this__9695.end) {
      return rng
    }else {
      return null
    }
  }else {
    if(this__9695.start > this__9695.end) {
      return rng
    }else {
      return null
    }
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__9696 = this;
  if(cljs.core.not.call(null, rng.cljs$core$ISeqable$_seq$arity$1(rng))) {
    return 0
  }else {
    return Math.ceil((this__9696.end - this__9696.start) / this__9696.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__9697 = this;
  return this__9697.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__9698 = this;
  if(!(rng.cljs$core$ISeqable$_seq$arity$1(rng) == null)) {
    return new cljs.core.Range(this__9698.meta, this__9698.start + this__9698.step, this__9698.end, this__9698.step, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__9699 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__9700 = this;
  return new cljs.core.Range(meta, this__9700.start, this__9700.end, this__9700.step, this__9700.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__9701 = this;
  return this__9701.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__9702 = this;
  if(n < rng.cljs$core$ICounted$_count$arity$1(rng)) {
    return this__9702.start + n * this__9702.step
  }else {
    if(function() {
      var and__3822__auto____9703 = this__9702.start > this__9702.end;
      if(and__3822__auto____9703) {
        return this__9702.step === 0
      }else {
        return and__3822__auto____9703
      }
    }()) {
      return this__9702.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__9704 = this;
  if(n < rng.cljs$core$ICounted$_count$arity$1(rng)) {
    return this__9704.start + n * this__9704.step
  }else {
    if(function() {
      var and__3822__auto____9705 = this__9704.start > this__9704.end;
      if(and__3822__auto____9705) {
        return this__9704.step === 0
      }else {
        return and__3822__auto____9705
      }
    }()) {
      return this__9704.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__9706 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__9706.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number.MAX_VALUE, 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____9709 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____9709) {
      var s__9710 = temp__3974__auto____9709;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__9710), take_nth.call(null, n, cljs.core.drop.call(null, n, s__9710)))
    }else {
      return null
    }
  }, null)
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)], true)
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____9717 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____9717) {
      var s__9718 = temp__3974__auto____9717;
      var fst__9719 = cljs.core.first.call(null, s__9718);
      var fv__9720 = f.call(null, fst__9719);
      var run__9721 = cljs.core.cons.call(null, fst__9719, cljs.core.take_while.call(null, function(p1__9711_SHARP_) {
        return cljs.core._EQ_.call(null, fv__9720, f.call(null, p1__9711_SHARP_))
      }, cljs.core.next.call(null, s__9718)));
      return cljs.core.cons.call(null, run__9721, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__9721), s__9718))))
    }else {
      return null
    }
  }, null)
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core._lookup.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.EMPTY), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3971__auto____9736 = cljs.core.seq.call(null, coll);
      if(temp__3971__auto____9736) {
        var s__9737 = temp__3971__auto____9736;
        return reductions.call(null, f, cljs.core.first.call(null, s__9737), cljs.core.rest.call(null, s__9737))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    }, null)
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____9738 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____9738) {
        var s__9739 = temp__3974__auto____9738;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__9739)), cljs.core.rest.call(null, s__9739))
      }else {
        return null
      }
    }, null))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__9742 = null;
      var G__9742__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__9742__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__9742__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__9742__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__9742__4 = function() {
        var G__9743__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__9743 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__9743__delegate.call(this, x, y, z, args)
        };
        G__9743.cljs$lang$maxFixedArity = 3;
        G__9743.cljs$lang$applyTo = function(arglist__9744) {
          var x = cljs.core.first(arglist__9744);
          var y = cljs.core.first(cljs.core.next(arglist__9744));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__9744)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__9744)));
          return G__9743__delegate(x, y, z, args)
        };
        G__9743.cljs$lang$arity$variadic = G__9743__delegate;
        return G__9743
      }();
      G__9742 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__9742__0.call(this);
          case 1:
            return G__9742__1.call(this, x);
          case 2:
            return G__9742__2.call(this, x, y);
          case 3:
            return G__9742__3.call(this, x, y, z);
          default:
            return G__9742__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__9742.cljs$lang$maxFixedArity = 3;
      G__9742.cljs$lang$applyTo = G__9742__4.cljs$lang$applyTo;
      return G__9742
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__9745 = null;
      var G__9745__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__9745__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__9745__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__9745__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__9745__4 = function() {
        var G__9746__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__9746 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__9746__delegate.call(this, x, y, z, args)
        };
        G__9746.cljs$lang$maxFixedArity = 3;
        G__9746.cljs$lang$applyTo = function(arglist__9747) {
          var x = cljs.core.first(arglist__9747);
          var y = cljs.core.first(cljs.core.next(arglist__9747));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__9747)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__9747)));
          return G__9746__delegate(x, y, z, args)
        };
        G__9746.cljs$lang$arity$variadic = G__9746__delegate;
        return G__9746
      }();
      G__9745 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__9745__0.call(this);
          case 1:
            return G__9745__1.call(this, x);
          case 2:
            return G__9745__2.call(this, x, y);
          case 3:
            return G__9745__3.call(this, x, y, z);
          default:
            return G__9745__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__9745.cljs$lang$maxFixedArity = 3;
      G__9745.cljs$lang$applyTo = G__9745__4.cljs$lang$applyTo;
      return G__9745
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__9748 = null;
      var G__9748__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__9748__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__9748__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__9748__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__9748__4 = function() {
        var G__9749__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__9749 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__9749__delegate.call(this, x, y, z, args)
        };
        G__9749.cljs$lang$maxFixedArity = 3;
        G__9749.cljs$lang$applyTo = function(arglist__9750) {
          var x = cljs.core.first(arglist__9750);
          var y = cljs.core.first(cljs.core.next(arglist__9750));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__9750)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__9750)));
          return G__9749__delegate(x, y, z, args)
        };
        G__9749.cljs$lang$arity$variadic = G__9749__delegate;
        return G__9749
      }();
      G__9748 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__9748__0.call(this);
          case 1:
            return G__9748__1.call(this, x);
          case 2:
            return G__9748__2.call(this, x, y);
          case 3:
            return G__9748__3.call(this, x, y, z);
          default:
            return G__9748__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__9748.cljs$lang$maxFixedArity = 3;
      G__9748.cljs$lang$applyTo = G__9748__4.cljs$lang$applyTo;
      return G__9748
    }()
  };
  var juxt__4 = function() {
    var G__9751__delegate = function(f, g, h, fs) {
      var fs__9741 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__9752 = null;
        var G__9752__0 = function() {
          return cljs.core.reduce.call(null, function(p1__9722_SHARP_, p2__9723_SHARP_) {
            return cljs.core.conj.call(null, p1__9722_SHARP_, p2__9723_SHARP_.call(null))
          }, cljs.core.PersistentVector.EMPTY, fs__9741)
        };
        var G__9752__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__9724_SHARP_, p2__9725_SHARP_) {
            return cljs.core.conj.call(null, p1__9724_SHARP_, p2__9725_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.EMPTY, fs__9741)
        };
        var G__9752__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__9726_SHARP_, p2__9727_SHARP_) {
            return cljs.core.conj.call(null, p1__9726_SHARP_, p2__9727_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.EMPTY, fs__9741)
        };
        var G__9752__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__9728_SHARP_, p2__9729_SHARP_) {
            return cljs.core.conj.call(null, p1__9728_SHARP_, p2__9729_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.EMPTY, fs__9741)
        };
        var G__9752__4 = function() {
          var G__9753__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__9730_SHARP_, p2__9731_SHARP_) {
              return cljs.core.conj.call(null, p1__9730_SHARP_, cljs.core.apply.call(null, p2__9731_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.EMPTY, fs__9741)
          };
          var G__9753 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__9753__delegate.call(this, x, y, z, args)
          };
          G__9753.cljs$lang$maxFixedArity = 3;
          G__9753.cljs$lang$applyTo = function(arglist__9754) {
            var x = cljs.core.first(arglist__9754);
            var y = cljs.core.first(cljs.core.next(arglist__9754));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__9754)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__9754)));
            return G__9753__delegate(x, y, z, args)
          };
          G__9753.cljs$lang$arity$variadic = G__9753__delegate;
          return G__9753
        }();
        G__9752 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__9752__0.call(this);
            case 1:
              return G__9752__1.call(this, x);
            case 2:
              return G__9752__2.call(this, x, y);
            case 3:
              return G__9752__3.call(this, x, y, z);
            default:
              return G__9752__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__9752.cljs$lang$maxFixedArity = 3;
        G__9752.cljs$lang$applyTo = G__9752__4.cljs$lang$applyTo;
        return G__9752
      }()
    };
    var G__9751 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__9751__delegate.call(this, f, g, h, fs)
    };
    G__9751.cljs$lang$maxFixedArity = 3;
    G__9751.cljs$lang$applyTo = function(arglist__9755) {
      var f = cljs.core.first(arglist__9755);
      var g = cljs.core.first(cljs.core.next(arglist__9755));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__9755)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__9755)));
      return G__9751__delegate(f, g, h, fs)
    };
    G__9751.cljs$lang$arity$variadic = G__9751__delegate;
    return G__9751
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.seq.call(null, coll)) {
        var G__9758 = cljs.core.next.call(null, coll);
        coll = G__9758;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3822__auto____9757 = cljs.core.seq.call(null, coll);
        if(and__3822__auto____9757) {
          return n > 0
        }else {
          return and__3822__auto____9757
        }
      }())) {
        var G__9759 = n - 1;
        var G__9760 = cljs.core.next.call(null, coll);
        n = G__9759;
        coll = G__9760;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.regexp_QMARK_ = function regexp_QMARK_(o) {
  return o instanceof RegExp
};
cljs.core.re_matches = function re_matches(re, s) {
  var matches__9762 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__9762), s)) {
    if(cljs.core.count.call(null, matches__9762) === 1) {
      return cljs.core.first.call(null, matches__9762)
    }else {
      return cljs.core.vec.call(null, matches__9762)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__9764 = re.exec(s);
  if(matches__9764 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__9764) === 1) {
      return cljs.core.first.call(null, matches__9764)
    }else {
      return cljs.core.vec.call(null, matches__9764)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__9769 = cljs.core.re_find.call(null, re, s);
  var match_idx__9770 = s.search(re);
  var match_str__9771 = cljs.core.coll_QMARK_.call(null, match_data__9769) ? cljs.core.first.call(null, match_data__9769) : match_data__9769;
  var post_match__9772 = cljs.core.subs.call(null, s, match_idx__9770 + cljs.core.count.call(null, match_str__9771));
  if(cljs.core.truth_(match_data__9769)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__9769, re_seq.call(null, re, post_match__9772))
    }, null)
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__9779__9780 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___9781 = cljs.core.nth.call(null, vec__9779__9780, 0, null);
  var flags__9782 = cljs.core.nth.call(null, vec__9779__9780, 1, null);
  var pattern__9783 = cljs.core.nth.call(null, vec__9779__9780, 2, null);
  return new RegExp(pattern__9783, flags__9782)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin], true), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep], true), cljs.core.map.call(null, function(p1__9773_SHARP_) {
    return print_one.call(null, p1__9773_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end], true))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3822__auto____9793 = cljs.core._lookup.call(null, opts, "\ufdd0'meta", null);
          if(cljs.core.truth_(and__3822__auto____9793)) {
            var and__3822__auto____9797 = function() {
              var G__9794__9795 = obj;
              if(G__9794__9795) {
                if(function() {
                  var or__3824__auto____9796 = G__9794__9795.cljs$lang$protocol_mask$partition0$ & 131072;
                  if(or__3824__auto____9796) {
                    return or__3824__auto____9796
                  }else {
                    return G__9794__9795.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__9794__9795.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__9794__9795)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__9794__9795)
              }
            }();
            if(cljs.core.truth_(and__3822__auto____9797)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3822__auto____9797
            }
          }else {
            return and__3822__auto____9793
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"], true), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "], true)) : null, function() {
          var and__3822__auto____9798 = !(obj == null);
          if(and__3822__auto____9798) {
            return obj.cljs$lang$type
          }else {
            return and__3822__auto____9798
          }
        }() ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__9799__9800 = obj;
          if(G__9799__9800) {
            if(function() {
              var or__3824__auto____9801 = G__9799__9800.cljs$lang$protocol_mask$partition0$ & 536870912;
              if(or__3824__auto____9801) {
                return or__3824__auto____9801
              }else {
                return G__9799__9800.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__9799__9800.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__9799__9800)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__9799__9800)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : cljs.core.truth_(cljs.core.regexp_QMARK_.call(null, obj)) ? cljs.core.list.call(null, '#"', obj.source, '"') : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var sb__9821 = new goog.string.StringBuffer;
  var G__9822__9823 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, cljs.core.first.call(null, objs), opts));
  if(G__9822__9823) {
    var string__9824 = cljs.core.first.call(null, G__9822__9823);
    var G__9822__9825 = G__9822__9823;
    while(true) {
      sb__9821.append(string__9824);
      var temp__3974__auto____9826 = cljs.core.next.call(null, G__9822__9825);
      if(temp__3974__auto____9826) {
        var G__9822__9827 = temp__3974__auto____9826;
        var G__9840 = cljs.core.first.call(null, G__9822__9827);
        var G__9841 = G__9822__9827;
        string__9824 = G__9840;
        G__9822__9825 = G__9841;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__9828__9829 = cljs.core.seq.call(null, cljs.core.next.call(null, objs));
  if(G__9828__9829) {
    var obj__9830 = cljs.core.first.call(null, G__9828__9829);
    var G__9828__9831 = G__9828__9829;
    while(true) {
      sb__9821.append(" ");
      var G__9832__9833 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__9830, opts));
      if(G__9832__9833) {
        var string__9834 = cljs.core.first.call(null, G__9832__9833);
        var G__9832__9835 = G__9832__9833;
        while(true) {
          sb__9821.append(string__9834);
          var temp__3974__auto____9836 = cljs.core.next.call(null, G__9832__9835);
          if(temp__3974__auto____9836) {
            var G__9832__9837 = temp__3974__auto____9836;
            var G__9842 = cljs.core.first.call(null, G__9832__9837);
            var G__9843 = G__9832__9837;
            string__9834 = G__9842;
            G__9832__9835 = G__9843;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3974__auto____9838 = cljs.core.next.call(null, G__9828__9831);
      if(temp__3974__auto____9838) {
        var G__9828__9839 = temp__3974__auto____9838;
        var G__9844 = cljs.core.first.call(null, G__9828__9839);
        var G__9845 = G__9828__9839;
        obj__9830 = G__9844;
        G__9828__9831 = G__9845;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__9821
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__9847 = cljs.core.pr_sb.call(null, objs, opts);
  sb__9847.append("\n");
  return[cljs.core.str(sb__9847)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var G__9866__9867 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, cljs.core.first.call(null, objs), opts));
  if(G__9866__9867) {
    var string__9868 = cljs.core.first.call(null, G__9866__9867);
    var G__9866__9869 = G__9866__9867;
    while(true) {
      cljs.core.string_print.call(null, string__9868);
      var temp__3974__auto____9870 = cljs.core.next.call(null, G__9866__9869);
      if(temp__3974__auto____9870) {
        var G__9866__9871 = temp__3974__auto____9870;
        var G__9884 = cljs.core.first.call(null, G__9866__9871);
        var G__9885 = G__9866__9871;
        string__9868 = G__9884;
        G__9866__9869 = G__9885;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__9872__9873 = cljs.core.seq.call(null, cljs.core.next.call(null, objs));
  if(G__9872__9873) {
    var obj__9874 = cljs.core.first.call(null, G__9872__9873);
    var G__9872__9875 = G__9872__9873;
    while(true) {
      cljs.core.string_print.call(null, " ");
      var G__9876__9877 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__9874, opts));
      if(G__9876__9877) {
        var string__9878 = cljs.core.first.call(null, G__9876__9877);
        var G__9876__9879 = G__9876__9877;
        while(true) {
          cljs.core.string_print.call(null, string__9878);
          var temp__3974__auto____9880 = cljs.core.next.call(null, G__9876__9879);
          if(temp__3974__auto____9880) {
            var G__9876__9881 = temp__3974__auto____9880;
            var G__9886 = cljs.core.first.call(null, G__9876__9881);
            var G__9887 = G__9876__9881;
            string__9878 = G__9886;
            G__9876__9879 = G__9887;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3974__auto____9882 = cljs.core.next.call(null, G__9872__9875);
      if(temp__3974__auto____9882) {
        var G__9872__9883 = temp__3974__auto____9882;
        var G__9888 = cljs.core.first.call(null, G__9872__9883);
        var G__9889 = G__9872__9883;
        obj__9874 = G__9888;
        G__9872__9875 = G__9889;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core._lookup.call(null, opts, "\ufdd0'flush-on-newline", null))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__9890) {
    var objs = cljs.core.seq(arglist__9890);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__9891) {
    var objs = cljs.core.seq(arglist__9891);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__9892) {
    var objs = cljs.core.seq(arglist__9892);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__9893) {
    var objs = cljs.core.seq(arglist__9893);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__9894) {
    var objs = cljs.core.seq(arglist__9894);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__9895) {
    var objs = cljs.core.seq(arglist__9895);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__9896) {
    var objs = cljs.core.seq(arglist__9896);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__9897) {
    var objs = cljs.core.seq(arglist__9897);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.printf = function() {
  var printf__delegate = function(fmt, args) {
    return cljs.core.print.call(null, cljs.core.apply.call(null, cljs.core.format, fmt, args))
  };
  var printf = function(fmt, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return printf__delegate.call(this, fmt, args)
  };
  printf.cljs$lang$maxFixedArity = 1;
  printf.cljs$lang$applyTo = function(arglist__9898) {
    var fmt = cljs.core.first(arglist__9898);
    var args = cljs.core.rest(arglist__9898);
    return printf__delegate(fmt, args)
  };
  printf.cljs$lang$arity$variadic = printf__delegate;
  return printf
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__9899 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__9899, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.ChunkedCons.prototype.cljs$core$IPrintable$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__9900 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__9900, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__9901 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__9901, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.RSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3974__auto____9902 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3974__auto____9902)) {
        var nspc__9903 = temp__3974__auto____9902;
        return[cljs.core.str(nspc__9903), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3974__auto____9904 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3974__auto____9904)) {
          var nspc__9905 = temp__3974__auto____9904;
          return[cljs.core.str(nspc__9905), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_((new cljs.core.Keyword("\ufdd0'readably")).call(null, opts)) ? goog.string.quote(obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__9906 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__9906, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
Date.prototype.cljs$core$IPrintable$ = true;
Date.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(d, _) {
  var normalize__9908 = function(n, len) {
    var ns__9907 = [cljs.core.str(n)].join("");
    while(true) {
      if(cljs.core.count.call(null, ns__9907) < len) {
        var G__9910 = [cljs.core.str("0"), cljs.core.str(ns__9907)].join("");
        ns__9907 = G__9910;
        continue
      }else {
        return ns__9907
      }
      break
    }
  };
  return cljs.core.list.call(null, [cljs.core.str('#inst "'), cljs.core.str(d.getUTCFullYear()), cljs.core.str("-"), cljs.core.str(normalize__9908.call(null, d.getUTCMonth() + 1, 2)), cljs.core.str("-"), cljs.core.str(normalize__9908.call(null, d.getUTCDate(), 2)), cljs.core.str("T"), cljs.core.str(normalize__9908.call(null, d.getUTCHours(), 2)), cljs.core.str(":"), cljs.core.str(normalize__9908.call(null, d.getUTCMinutes(), 2)), cljs.core.str(":"), cljs.core.str(normalize__9908.call(null, d.getUTCSeconds(), 
  2)), cljs.core.str("."), cljs.core.str(normalize__9908.call(null, d.getUTCMilliseconds(), 3)), cljs.core.str("-"), cljs.core.str('00:00"')].join(""))
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__9909 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__9909, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = function(x, y) {
  return cljs.core.compare_indexed.call(null, x, y)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2690809856
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__9911 = this;
  return goog.getUid(this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__9912 = this;
  var G__9913__9914 = cljs.core.seq.call(null, this__9912.watches);
  if(G__9913__9914) {
    var G__9916__9918 = cljs.core.first.call(null, G__9913__9914);
    var vec__9917__9919 = G__9916__9918;
    var key__9920 = cljs.core.nth.call(null, vec__9917__9919, 0, null);
    var f__9921 = cljs.core.nth.call(null, vec__9917__9919, 1, null);
    var G__9913__9922 = G__9913__9914;
    var G__9916__9923 = G__9916__9918;
    var G__9913__9924 = G__9913__9922;
    while(true) {
      var vec__9925__9926 = G__9916__9923;
      var key__9927 = cljs.core.nth.call(null, vec__9925__9926, 0, null);
      var f__9928 = cljs.core.nth.call(null, vec__9925__9926, 1, null);
      var G__9913__9929 = G__9913__9924;
      f__9928.call(null, key__9927, this$, oldval, newval);
      var temp__3974__auto____9930 = cljs.core.next.call(null, G__9913__9929);
      if(temp__3974__auto____9930) {
        var G__9913__9931 = temp__3974__auto____9930;
        var G__9938 = cljs.core.first.call(null, G__9913__9931);
        var G__9939 = G__9913__9931;
        G__9916__9923 = G__9938;
        G__9913__9924 = G__9939;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__9932 = this;
  return this$.watches = cljs.core.assoc.call(null, this__9932.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__9933 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__9933.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__9934 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "], true), cljs.core._pr_seq.call(null, this__9934.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__9935 = this;
  return this__9935.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__9936 = this;
  return this__9936.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__9937 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__9951__delegate = function(x, p__9940) {
      var map__9946__9947 = p__9940;
      var map__9946__9948 = cljs.core.seq_QMARK_.call(null, map__9946__9947) ? cljs.core.apply.call(null, cljs.core.hash_map, map__9946__9947) : map__9946__9947;
      var validator__9949 = cljs.core._lookup.call(null, map__9946__9948, "\ufdd0'validator", null);
      var meta__9950 = cljs.core._lookup.call(null, map__9946__9948, "\ufdd0'meta", null);
      return new cljs.core.Atom(x, meta__9950, validator__9949, null)
    };
    var G__9951 = function(x, var_args) {
      var p__9940 = null;
      if(goog.isDef(var_args)) {
        p__9940 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__9951__delegate.call(this, x, p__9940)
    };
    G__9951.cljs$lang$maxFixedArity = 1;
    G__9951.cljs$lang$applyTo = function(arglist__9952) {
      var x = cljs.core.first(arglist__9952);
      var p__9940 = cljs.core.rest(arglist__9952);
      return G__9951__delegate(x, p__9940)
    };
    G__9951.cljs$lang$arity$variadic = G__9951__delegate;
    return G__9951
  }();
  atom = function(x, var_args) {
    var p__9940 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3974__auto____9956 = a.validator;
  if(cljs.core.truth_(temp__3974__auto____9956)) {
    var validate__9957 = temp__3974__auto____9956;
    if(cljs.core.truth_(validate__9957.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 6440))))].join(""));
    }
  }else {
  }
  var old_value__9958 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__9958, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__9959__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__9959 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__9959__delegate.call(this, a, f, x, y, z, more)
    };
    G__9959.cljs$lang$maxFixedArity = 5;
    G__9959.cljs$lang$applyTo = function(arglist__9960) {
      var a = cljs.core.first(arglist__9960);
      var f = cljs.core.first(cljs.core.next(arglist__9960));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__9960)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__9960))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__9960)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__9960)))));
      return G__9959__delegate(a, f, x, y, z, more)
    };
    G__9959.cljs$lang$arity$variadic = G__9959__delegate;
    return G__9959
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__9961) {
    var iref = cljs.core.first(arglist__9961);
    var f = cljs.core.first(cljs.core.next(arglist__9961));
    var args = cljs.core.rest(cljs.core.next(arglist__9961));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1073774592
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__9962 = this;
  return(new cljs.core.Keyword("\ufdd0'done")).call(null, cljs.core.deref.call(null, this__9962.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__9963 = this;
  return(new cljs.core.Keyword("\ufdd0'value")).call(null, cljs.core.swap_BANG_.call(null, this__9963.state, function(p__9964) {
    var map__9965__9966 = p__9964;
    var map__9965__9967 = cljs.core.seq_QMARK_.call(null, map__9965__9966) ? cljs.core.apply.call(null, cljs.core.hash_map, map__9965__9966) : map__9965__9966;
    var curr_state__9968 = map__9965__9967;
    var done__9969 = cljs.core._lookup.call(null, map__9965__9967, "\ufdd0'done", null);
    if(cljs.core.truth_(done__9969)) {
      return curr_state__9968
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__9963.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__9990__9991 = options;
    var map__9990__9992 = cljs.core.seq_QMARK_.call(null, map__9990__9991) ? cljs.core.apply.call(null, cljs.core.hash_map, map__9990__9991) : map__9990__9991;
    var keywordize_keys__9993 = cljs.core._lookup.call(null, map__9990__9992, "\ufdd0'keywordize-keys", null);
    var keyfn__9994 = cljs.core.truth_(keywordize_keys__9993) ? cljs.core.keyword : cljs.core.str;
    var f__10009 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray(x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.EMPTY, function() {
                var iter__2462__auto____10008 = function iter__10002(s__10003) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__10003__10006 = s__10003;
                    while(true) {
                      if(cljs.core.seq.call(null, s__10003__10006)) {
                        var k__10007 = cljs.core.first.call(null, s__10003__10006);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__9994.call(null, k__10007), thisfn.call(null, x[k__10007])], true), iter__10002.call(null, cljs.core.rest.call(null, s__10003__10006)))
                      }else {
                        return null
                      }
                      break
                    }
                  }, null)
                };
                return iter__2462__auto____10008.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__10009.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__10010) {
    var x = cljs.core.first(arglist__10010);
    var options = cljs.core.rest(arglist__10010);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__10015 = cljs.core.atom.call(null, cljs.core.ObjMap.EMPTY);
  return function() {
    var G__10019__delegate = function(args) {
      var temp__3971__auto____10016 = cljs.core._lookup.call(null, cljs.core.deref.call(null, mem__10015), args, null);
      if(cljs.core.truth_(temp__3971__auto____10016)) {
        var v__10017 = temp__3971__auto____10016;
        return v__10017
      }else {
        var ret__10018 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__10015, cljs.core.assoc, args, ret__10018);
        return ret__10018
      }
    };
    var G__10019 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__10019__delegate.call(this, args)
    };
    G__10019.cljs$lang$maxFixedArity = 0;
    G__10019.cljs$lang$applyTo = function(arglist__10020) {
      var args = cljs.core.seq(arglist__10020);
      return G__10019__delegate(args)
    };
    G__10019.cljs$lang$arity$variadic = G__10019__delegate;
    return G__10019
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__10022 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__10022)) {
        var G__10023 = ret__10022;
        f = G__10023;
        continue
      }else {
        return ret__10022
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__10024__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__10024 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__10024__delegate.call(this, f, args)
    };
    G__10024.cljs$lang$maxFixedArity = 1;
    G__10024.cljs$lang$applyTo = function(arglist__10025) {
      var f = cljs.core.first(arglist__10025);
      var args = cljs.core.rest(arglist__10025);
      return G__10024__delegate(f, args)
    };
    G__10024.cljs$lang$arity$variadic = G__10024__delegate;
    return G__10024
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random.call(null) * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor.call(null, Math.random.call(null) * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__10027 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__10027, cljs.core.conj.call(null, cljs.core._lookup.call(null, ret, k__10027, cljs.core.PersistentVector.EMPTY), x))
  }, cljs.core.ObjMap.EMPTY, coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.EMPTY, "\ufdd0'descendants":cljs.core.ObjMap.EMPTY, "\ufdd0'ancestors":cljs.core.ObjMap.EMPTY})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3824__auto____10036 = cljs.core._EQ_.call(null, child, parent);
    if(or__3824__auto____10036) {
      return or__3824__auto____10036
    }else {
      var or__3824__auto____10037 = cljs.core.contains_QMARK_.call(null, (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h).call(null, child), parent);
      if(or__3824__auto____10037) {
        return or__3824__auto____10037
      }else {
        var and__3822__auto____10038 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3822__auto____10038) {
          var and__3822__auto____10039 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3822__auto____10039) {
            var and__3822__auto____10040 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3822__auto____10040) {
              var ret__10041 = true;
              var i__10042 = 0;
              while(true) {
                if(function() {
                  var or__3824__auto____10043 = cljs.core.not.call(null, ret__10041);
                  if(or__3824__auto____10043) {
                    return or__3824__auto____10043
                  }else {
                    return i__10042 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__10041
                }else {
                  var G__10044 = isa_QMARK_.call(null, h, child.call(null, i__10042), parent.call(null, i__10042));
                  var G__10045 = i__10042 + 1;
                  ret__10041 = G__10044;
                  i__10042 = G__10045;
                  continue
                }
                break
              }
            }else {
              return and__3822__auto____10040
            }
          }else {
            return and__3822__auto____10039
          }
        }else {
          return and__3822__auto____10038
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core._lookup.call(null, (new cljs.core.Keyword("\ufdd0'parents")).call(null, h), tag, null))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core._lookup.call(null, (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h), tag, null))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core._lookup.call(null, (new cljs.core.Keyword("\ufdd0'descendants")).call(null, h), tag, null))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6724))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6728))))].join(""));
    }
    var tp__10054 = (new cljs.core.Keyword("\ufdd0'parents")).call(null, h);
    var td__10055 = (new cljs.core.Keyword("\ufdd0'descendants")).call(null, h);
    var ta__10056 = (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h);
    var tf__10057 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core._lookup.call(null, targets, k, cljs.core.PersistentHashSet.EMPTY), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3824__auto____10058 = cljs.core.contains_QMARK_.call(null, tp__10054.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__10056.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__10056.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, (new cljs.core.Keyword("\ufdd0'parents")).call(null, h), tag, cljs.core.conj.call(null, cljs.core._lookup.call(null, tp__10054, tag, cljs.core.PersistentHashSet.EMPTY), parent)), "\ufdd0'ancestors":tf__10057.call(null, (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h), tag, td__10055, parent, ta__10056), "\ufdd0'descendants":tf__10057.call(null, 
      (new cljs.core.Keyword("\ufdd0'descendants")).call(null, h), parent, ta__10056, tag, td__10055)})
    }();
    if(cljs.core.truth_(or__3824__auto____10058)) {
      return or__3824__auto____10058
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__10063 = (new cljs.core.Keyword("\ufdd0'parents")).call(null, h);
    var childsParents__10064 = cljs.core.truth_(parentMap__10063.call(null, tag)) ? cljs.core.disj.call(null, parentMap__10063.call(null, tag), parent) : cljs.core.PersistentHashSet.EMPTY;
    var newParents__10065 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__10064)) ? cljs.core.assoc.call(null, parentMap__10063, tag, childsParents__10064) : cljs.core.dissoc.call(null, parentMap__10063, tag);
    var deriv_seq__10066 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__10046_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__10046_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__10046_SHARP_), cljs.core.second.call(null, p1__10046_SHARP_)))
    }, cljs.core.seq.call(null, newParents__10065)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__10063.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__10047_SHARP_, p2__10048_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__10047_SHARP_, p2__10048_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__10066))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__10074 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3824__auto____10076 = cljs.core.truth_(function() {
    var and__3822__auto____10075 = xprefs__10074;
    if(cljs.core.truth_(and__3822__auto____10075)) {
      return xprefs__10074.call(null, y)
    }else {
      return and__3822__auto____10075
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3824__auto____10076)) {
    return or__3824__auto____10076
  }else {
    var or__3824__auto____10078 = function() {
      var ps__10077 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__10077) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__10077), prefer_table))) {
          }else {
          }
          var G__10081 = cljs.core.rest.call(null, ps__10077);
          ps__10077 = G__10081;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3824__auto____10078)) {
      return or__3824__auto____10078
    }else {
      var or__3824__auto____10080 = function() {
        var ps__10079 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__10079) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__10079), y, prefer_table))) {
            }else {
            }
            var G__10082 = cljs.core.rest.call(null, ps__10079);
            ps__10079 = G__10082;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3824__auto____10080)) {
        return or__3824__auto____10080
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3824__auto____10084 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3824__auto____10084)) {
    return or__3824__auto____10084
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__10102 = cljs.core.reduce.call(null, function(be, p__10094) {
    var vec__10095__10096 = p__10094;
    var k__10097 = cljs.core.nth.call(null, vec__10095__10096, 0, null);
    var ___10098 = cljs.core.nth.call(null, vec__10095__10096, 1, null);
    var e__10099 = vec__10095__10096;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__10097)) {
      var be2__10101 = cljs.core.truth_(function() {
        var or__3824__auto____10100 = be == null;
        if(or__3824__auto____10100) {
          return or__3824__auto____10100
        }else {
          return cljs.core.dominates.call(null, k__10097, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__10099 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__10101), k__10097, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__10097), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__10101)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__10101
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__10102)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__10102));
      return cljs.core.second.call(null, best_entry__10102)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3822__auto____10107 = mf;
    if(and__3822__auto____10107) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3822__auto____10107
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    var x__2363__auto____10108 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10109 = cljs.core._reset[goog.typeOf(x__2363__auto____10108)];
      if(or__3824__auto____10109) {
        return or__3824__auto____10109
      }else {
        var or__3824__auto____10110 = cljs.core._reset["_"];
        if(or__3824__auto____10110) {
          return or__3824__auto____10110
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3822__auto____10115 = mf;
    if(and__3822__auto____10115) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3822__auto____10115
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    var x__2363__auto____10116 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10117 = cljs.core._add_method[goog.typeOf(x__2363__auto____10116)];
      if(or__3824__auto____10117) {
        return or__3824__auto____10117
      }else {
        var or__3824__auto____10118 = cljs.core._add_method["_"];
        if(or__3824__auto____10118) {
          return or__3824__auto____10118
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3822__auto____10123 = mf;
    if(and__3822__auto____10123) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3822__auto____10123
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    var x__2363__auto____10124 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10125 = cljs.core._remove_method[goog.typeOf(x__2363__auto____10124)];
      if(or__3824__auto____10125) {
        return or__3824__auto____10125
      }else {
        var or__3824__auto____10126 = cljs.core._remove_method["_"];
        if(or__3824__auto____10126) {
          return or__3824__auto____10126
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3822__auto____10131 = mf;
    if(and__3822__auto____10131) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3822__auto____10131
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    var x__2363__auto____10132 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10133 = cljs.core._prefer_method[goog.typeOf(x__2363__auto____10132)];
      if(or__3824__auto____10133) {
        return or__3824__auto____10133
      }else {
        var or__3824__auto____10134 = cljs.core._prefer_method["_"];
        if(or__3824__auto____10134) {
          return or__3824__auto____10134
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3822__auto____10139 = mf;
    if(and__3822__auto____10139) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3822__auto____10139
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    var x__2363__auto____10140 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10141 = cljs.core._get_method[goog.typeOf(x__2363__auto____10140)];
      if(or__3824__auto____10141) {
        return or__3824__auto____10141
      }else {
        var or__3824__auto____10142 = cljs.core._get_method["_"];
        if(or__3824__auto____10142) {
          return or__3824__auto____10142
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3822__auto____10147 = mf;
    if(and__3822__auto____10147) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3822__auto____10147
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    var x__2363__auto____10148 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10149 = cljs.core._methods[goog.typeOf(x__2363__auto____10148)];
      if(or__3824__auto____10149) {
        return or__3824__auto____10149
      }else {
        var or__3824__auto____10150 = cljs.core._methods["_"];
        if(or__3824__auto____10150) {
          return or__3824__auto____10150
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3822__auto____10155 = mf;
    if(and__3822__auto____10155) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3822__auto____10155
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    var x__2363__auto____10156 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10157 = cljs.core._prefers[goog.typeOf(x__2363__auto____10156)];
      if(or__3824__auto____10157) {
        return or__3824__auto____10157
      }else {
        var or__3824__auto____10158 = cljs.core._prefers["_"];
        if(or__3824__auto____10158) {
          return or__3824__auto____10158
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3822__auto____10163 = mf;
    if(and__3822__auto____10163) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3822__auto____10163
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    var x__2363__auto____10164 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10165 = cljs.core._dispatch[goog.typeOf(x__2363__auto____10164)];
      if(or__3824__auto____10165) {
        return or__3824__auto____10165
      }else {
        var or__3824__auto____10166 = cljs.core._dispatch["_"];
        if(or__3824__auto____10166) {
          return or__3824__auto____10166
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__10169 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__10170 = cljs.core._get_method.call(null, mf, dispatch_val__10169);
  if(cljs.core.truth_(target_fn__10170)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__10169)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__10170, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 4194304;
  this.cljs$lang$protocol_mask$partition1$ = 64
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__10171 = this;
  return goog.getUid(this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__10172 = this;
  cljs.core.swap_BANG_.call(null, this__10172.method_table, function(mf) {
    return cljs.core.ObjMap.EMPTY
  });
  cljs.core.swap_BANG_.call(null, this__10172.method_cache, function(mf) {
    return cljs.core.ObjMap.EMPTY
  });
  cljs.core.swap_BANG_.call(null, this__10172.prefer_table, function(mf) {
    return cljs.core.ObjMap.EMPTY
  });
  cljs.core.swap_BANG_.call(null, this__10172.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__10173 = this;
  cljs.core.swap_BANG_.call(null, this__10173.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__10173.method_cache, this__10173.method_table, this__10173.cached_hierarchy, this__10173.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__10174 = this;
  cljs.core.swap_BANG_.call(null, this__10174.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__10174.method_cache, this__10174.method_table, this__10174.cached_hierarchy, this__10174.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__10175 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__10175.cached_hierarchy), cljs.core.deref.call(null, this__10175.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__10175.method_cache, this__10175.method_table, this__10175.cached_hierarchy, this__10175.hierarchy)
  }
  var temp__3971__auto____10176 = cljs.core.deref.call(null, this__10175.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3971__auto____10176)) {
    var target_fn__10177 = temp__3971__auto____10176;
    return target_fn__10177
  }else {
    var temp__3971__auto____10178 = cljs.core.find_and_cache_best_method.call(null, this__10175.name, dispatch_val, this__10175.hierarchy, this__10175.method_table, this__10175.prefer_table, this__10175.method_cache, this__10175.cached_hierarchy);
    if(cljs.core.truth_(temp__3971__auto____10178)) {
      var target_fn__10179 = temp__3971__auto____10178;
      return target_fn__10179
    }else {
      return cljs.core.deref.call(null, this__10175.method_table).call(null, this__10175.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__10180 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__10180.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__10180.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__10180.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core._lookup.call(null, old, dispatch_val_x, cljs.core.PersistentHashSet.EMPTY), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__10180.method_cache, this__10180.method_table, this__10180.cached_hierarchy, this__10180.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__10181 = this;
  return cljs.core.deref.call(null, this__10181.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__10182 = this;
  return cljs.core.deref.call(null, this__10182.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__10183 = this;
  return cljs.core.do_dispatch.call(null, mf, this__10183.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__10185__delegate = function(_, args) {
    var self__10184 = this;
    return cljs.core._dispatch.call(null, self__10184, args)
  };
  var G__10185 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__10185__delegate.call(this, _, args)
  };
  G__10185.cljs$lang$maxFixedArity = 1;
  G__10185.cljs$lang$applyTo = function(arglist__10186) {
    var _ = cljs.core.first(arglist__10186);
    var args = cljs.core.rest(arglist__10186);
    return G__10185__delegate(_, args)
  };
  G__10185.cljs$lang$arity$variadic = G__10185__delegate;
  return G__10185
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  var self__10187 = this;
  return cljs.core._dispatch.call(null, self__10187, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
cljs.core.UUID = function(uuid) {
  this.uuid = uuid;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 543162368
};
cljs.core.UUID.cljs$lang$type = true;
cljs.core.UUID.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/UUID")
};
cljs.core.UUID.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__10188 = this;
  return goog.string.hashCode(cljs.core.pr_str.call(null, this$))
};
cljs.core.UUID.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(_10190, _) {
  var this__10189 = this;
  return cljs.core.list.call(null, [cljs.core.str('#uuid "'), cljs.core.str(this__10189.uuid), cljs.core.str('"')].join(""))
};
cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var this__10191 = this;
  var and__3822__auto____10192 = cljs.core.instance_QMARK_.call(null, cljs.core.UUID, other);
  if(and__3822__auto____10192) {
    return this__10191.uuid === other.uuid
  }else {
    return and__3822__auto____10192
  }
};
cljs.core.UUID.prototype.toString = function() {
  var this__10193 = this;
  var this__10194 = this;
  return cljs.core.pr_str.call(null, this__10194)
};
cljs.core.UUID;
// Input 10
goog.provide("goog.structs");
goog.require("goog.array");
goog.require("goog.object");
goog.structs.getCount = function(col) {
  if(typeof col.getCount == "function") {
    return col.getCount()
  }
  if(goog.isArrayLike(col) || goog.isString(col)) {
    return col.length
  }
  return goog.object.getCount(col)
};
goog.structs.getValues = function(col) {
  if(typeof col.getValues == "function") {
    return col.getValues()
  }
  if(goog.isString(col)) {
    return col.split("")
  }
  if(goog.isArrayLike(col)) {
    var rv = [];
    var l = col.length;
    for(var i = 0;i < l;i++) {
      rv.push(col[i])
    }
    return rv
  }
  return goog.object.getValues(col)
};
goog.structs.getKeys = function(col) {
  if(typeof col.getKeys == "function") {
    return col.getKeys()
  }
  if(typeof col.getValues == "function") {
    return undefined
  }
  if(goog.isArrayLike(col) || goog.isString(col)) {
    var rv = [];
    var l = col.length;
    for(var i = 0;i < l;i++) {
      rv.push(i)
    }
    return rv
  }
  return goog.object.getKeys(col)
};
goog.structs.contains = function(col, val) {
  if(typeof col.contains == "function") {
    return col.contains(val)
  }
  if(typeof col.containsValue == "function") {
    return col.containsValue(val)
  }
  if(goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.contains(col, val)
  }
  return goog.object.containsValue(col, val)
};
goog.structs.isEmpty = function(col) {
  if(typeof col.isEmpty == "function") {
    return col.isEmpty()
  }
  if(goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.isEmpty(col)
  }
  return goog.object.isEmpty(col)
};
goog.structs.clear = function(col) {
  if(typeof col.clear == "function") {
    col.clear()
  }else {
    if(goog.isArrayLike(col)) {
      goog.array.clear(col)
    }else {
      goog.object.clear(col)
    }
  }
};
goog.structs.forEach = function(col, f, opt_obj) {
  if(typeof col.forEach == "function") {
    col.forEach(f, opt_obj)
  }else {
    if(goog.isArrayLike(col) || goog.isString(col)) {
      goog.array.forEach(col, f, opt_obj)
    }else {
      var keys = goog.structs.getKeys(col);
      var values = goog.structs.getValues(col);
      var l = values.length;
      for(var i = 0;i < l;i++) {
        f.call(opt_obj, values[i], keys && keys[i], col)
      }
    }
  }
};
goog.structs.filter = function(col, f, opt_obj) {
  if(typeof col.filter == "function") {
    return col.filter(f, opt_obj)
  }
  if(goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.filter(col, f, opt_obj)
  }
  var rv;
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  if(keys) {
    rv = {};
    for(var i = 0;i < l;i++) {
      if(f.call(opt_obj, values[i], keys[i], col)) {
        rv[keys[i]] = values[i]
      }
    }
  }else {
    rv = [];
    for(var i = 0;i < l;i++) {
      if(f.call(opt_obj, values[i], undefined, col)) {
        rv.push(values[i])
      }
    }
  }
  return rv
};
goog.structs.map = function(col, f, opt_obj) {
  if(typeof col.map == "function") {
    return col.map(f, opt_obj)
  }
  if(goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.map(col, f, opt_obj)
  }
  var rv;
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  if(keys) {
    rv = {};
    for(var i = 0;i < l;i++) {
      rv[keys[i]] = f.call(opt_obj, values[i], keys[i], col)
    }
  }else {
    rv = [];
    for(var i = 0;i < l;i++) {
      rv[i] = f.call(opt_obj, values[i], undefined, col)
    }
  }
  return rv
};
goog.structs.some = function(col, f, opt_obj) {
  if(typeof col.some == "function") {
    return col.some(f, opt_obj)
  }
  if(goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.some(col, f, opt_obj)
  }
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  for(var i = 0;i < l;i++) {
    if(f.call(opt_obj, values[i], keys && keys[i], col)) {
      return true
    }
  }
  return false
};
goog.structs.every = function(col, f, opt_obj) {
  if(typeof col.every == "function") {
    return col.every(f, opt_obj)
  }
  if(goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.every(col, f, opt_obj)
  }
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  for(var i = 0;i < l;i++) {
    if(!f.call(opt_obj, values[i], keys && keys[i], col)) {
      return false
    }
  }
  return true
};
// Input 11
goog.provide("goog.iter");
goog.provide("goog.iter.Iterator");
goog.provide("goog.iter.StopIteration");
goog.require("goog.array");
goog.require("goog.asserts");
goog.iter.Iterable;
if("StopIteration" in goog.global) {
  goog.iter.StopIteration = goog.global["StopIteration"]
}else {
  goog.iter.StopIteration = Error("StopIteration")
}
goog.iter.Iterator = function() {
};
goog.iter.Iterator.prototype.next = function() {
  throw goog.iter.StopIteration;
};
goog.iter.Iterator.prototype.__iterator__ = function(opt_keys) {
  return this
};
goog.iter.toIterator = function(iterable) {
  if(iterable instanceof goog.iter.Iterator) {
    return iterable
  }
  if(typeof iterable.__iterator__ == "function") {
    return iterable.__iterator__(false)
  }
  if(goog.isArrayLike(iterable)) {
    var i = 0;
    var newIter = new goog.iter.Iterator;
    newIter.next = function() {
      while(true) {
        if(i >= iterable.length) {
          throw goog.iter.StopIteration;
        }
        if(!(i in iterable)) {
          i++;
          continue
        }
        return iterable[i++]
      }
    };
    return newIter
  }
  throw Error("Not implemented");
};
goog.iter.forEach = function(iterable, f, opt_obj) {
  if(goog.isArrayLike(iterable)) {
    try {
      goog.array.forEach(iterable, f, opt_obj)
    }catch(ex) {
      if(ex !== goog.iter.StopIteration) {
        throw ex;
      }
    }
  }else {
    iterable = goog.iter.toIterator(iterable);
    try {
      while(true) {
        f.call(opt_obj, iterable.next(), undefined, iterable)
      }
    }catch(ex) {
      if(ex !== goog.iter.StopIteration) {
        throw ex;
      }
    }
  }
};
goog.iter.filter = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    while(true) {
      var val = iterable.next();
      if(f.call(opt_obj, val, undefined, iterable)) {
        return val
      }
    }
  };
  return newIter
};
goog.iter.range = function(startOrStop, opt_stop, opt_step) {
  var start = 0;
  var stop = startOrStop;
  var step = opt_step || 1;
  if(arguments.length > 1) {
    start = startOrStop;
    stop = opt_stop
  }
  if(step == 0) {
    throw Error("Range step argument must not be zero");
  }
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    if(step > 0 && start >= stop || step < 0 && start <= stop) {
      throw goog.iter.StopIteration;
    }
    var rv = start;
    start += step;
    return rv
  };
  return newIter
};
goog.iter.join = function(iterable, deliminator) {
  return goog.iter.toArray(iterable).join(deliminator)
};
goog.iter.map = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    while(true) {
      var val = iterable.next();
      return f.call(opt_obj, val, undefined, iterable)
    }
  };
  return newIter
};
goog.iter.reduce = function(iterable, f, val, opt_obj) {
  var rval = val;
  goog.iter.forEach(iterable, function(val) {
    rval = f.call(opt_obj, rval, val)
  });
  return rval
};
goog.iter.some = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  try {
    while(true) {
      if(f.call(opt_obj, iterable.next(), undefined, iterable)) {
        return true
      }
    }
  }catch(ex) {
    if(ex !== goog.iter.StopIteration) {
      throw ex;
    }
  }
  return false
};
goog.iter.every = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  try {
    while(true) {
      if(!f.call(opt_obj, iterable.next(), undefined, iterable)) {
        return false
      }
    }
  }catch(ex) {
    if(ex !== goog.iter.StopIteration) {
      throw ex;
    }
  }
  return true
};
goog.iter.chain = function(var_args) {
  var args = arguments;
  var length = args.length;
  var i = 0;
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    try {
      if(i >= length) {
        throw goog.iter.StopIteration;
      }
      var current = goog.iter.toIterator(args[i]);
      return current.next()
    }catch(ex) {
      if(ex !== goog.iter.StopIteration || i >= length) {
        throw ex;
      }else {
        i++;
        return this.next()
      }
    }
  };
  return newIter
};
goog.iter.dropWhile = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  var newIter = new goog.iter.Iterator;
  var dropping = true;
  newIter.next = function() {
    while(true) {
      var val = iterable.next();
      if(dropping && f.call(opt_obj, val, undefined, iterable)) {
        continue
      }else {
        dropping = false
      }
      return val
    }
  };
  return newIter
};
goog.iter.takeWhile = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  var newIter = new goog.iter.Iterator;
  var taking = true;
  newIter.next = function() {
    while(true) {
      if(taking) {
        var val = iterable.next();
        if(f.call(opt_obj, val, undefined, iterable)) {
          return val
        }else {
          taking = false
        }
      }else {
        throw goog.iter.StopIteration;
      }
    }
  };
  return newIter
};
goog.iter.toArray = function(iterable) {
  if(goog.isArrayLike(iterable)) {
    return goog.array.toArray(iterable)
  }
  iterable = goog.iter.toIterator(iterable);
  var array = [];
  goog.iter.forEach(iterable, function(val) {
    array.push(val)
  });
  return array
};
goog.iter.equals = function(iterable1, iterable2) {
  iterable1 = goog.iter.toIterator(iterable1);
  iterable2 = goog.iter.toIterator(iterable2);
  var b1, b2;
  try {
    while(true) {
      b1 = b2 = false;
      var val1 = iterable1.next();
      b1 = true;
      var val2 = iterable2.next();
      b2 = true;
      if(val1 != val2) {
        return false
      }
    }
  }catch(ex) {
    if(ex !== goog.iter.StopIteration) {
      throw ex;
    }else {
      if(b1 && !b2) {
        return false
      }
      if(!b2) {
        try {
          val2 = iterable2.next();
          return false
        }catch(ex1) {
          if(ex1 !== goog.iter.StopIteration) {
            throw ex1;
          }
          return true
        }
      }
    }
  }
  return false
};
goog.iter.nextOrValue = function(iterable, defaultValue) {
  try {
    return goog.iter.toIterator(iterable).next()
  }catch(e) {
    if(e != goog.iter.StopIteration) {
      throw e;
    }
    return defaultValue
  }
};
goog.iter.product = function(var_args) {
  var someArrayEmpty = goog.array.some(arguments, function(arr) {
    return!arr.length
  });
  if(someArrayEmpty || !arguments.length) {
    return new goog.iter.Iterator
  }
  var iter = new goog.iter.Iterator;
  var arrays = arguments;
  var indicies = goog.array.repeat(0, arrays.length);
  iter.next = function() {
    if(indicies) {
      var retVal = goog.array.map(indicies, function(valueIndex, arrayIndex) {
        return arrays[arrayIndex][valueIndex]
      });
      for(var i = indicies.length - 1;i >= 0;i--) {
        goog.asserts.assert(indicies);
        if(indicies[i] < arrays[i].length - 1) {
          indicies[i]++;
          break
        }
        if(i == 0) {
          indicies = null;
          break
        }
        indicies[i] = 0
      }
      return retVal
    }
    throw goog.iter.StopIteration;
  };
  return iter
};
goog.iter.cycle = function(iterable) {
  var baseIterator = goog.iter.toIterator(iterable);
  var cache = [];
  var cacheIndex = 0;
  var iter = new goog.iter.Iterator;
  var useCache = false;
  iter.next = function() {
    var returnElement = null;
    if(!useCache) {
      try {
        returnElement = baseIterator.next();
        cache.push(returnElement);
        return returnElement
      }catch(e) {
        if(e != goog.iter.StopIteration || goog.array.isEmpty(cache)) {
          throw e;
        }
        useCache = true
      }
    }
    returnElement = cache[cacheIndex];
    cacheIndex = (cacheIndex + 1) % cache.length;
    return returnElement
  };
  return iter
};
// Input 12
goog.provide("goog.structs.Map");
goog.require("goog.iter.Iterator");
goog.require("goog.iter.StopIteration");
goog.require("goog.object");
goog.require("goog.structs");
goog.structs.Map = function(opt_map, var_args) {
  this.map_ = {};
  this.keys_ = [];
  var argLength = arguments.length;
  if(argLength > 1) {
    if(argLength % 2) {
      throw Error("Uneven number of arguments");
    }
    for(var i = 0;i < argLength;i += 2) {
      this.set(arguments[i], arguments[i + 1])
    }
  }else {
    if(opt_map) {
      this.addAll(opt_map)
    }
  }
};
goog.structs.Map.prototype.count_ = 0;
goog.structs.Map.prototype.version_ = 0;
goog.structs.Map.prototype.getCount = function() {
  return this.count_
};
goog.structs.Map.prototype.getValues = function() {
  this.cleanupKeysArray_();
  var rv = [];
  for(var i = 0;i < this.keys_.length;i++) {
    var key = this.keys_[i];
    rv.push(this.map_[key])
  }
  return rv
};
goog.structs.Map.prototype.getKeys = function() {
  this.cleanupKeysArray_();
  return this.keys_.concat()
};
goog.structs.Map.prototype.containsKey = function(key) {
  return goog.structs.Map.hasKey_(this.map_, key)
};
goog.structs.Map.prototype.containsValue = function(val) {
  for(var i = 0;i < this.keys_.length;i++) {
    var key = this.keys_[i];
    if(goog.structs.Map.hasKey_(this.map_, key) && this.map_[key] == val) {
      return true
    }
  }
  return false
};
goog.structs.Map.prototype.equals = function(otherMap, opt_equalityFn) {
  if(this === otherMap) {
    return true
  }
  if(this.count_ != otherMap.getCount()) {
    return false
  }
  var equalityFn = opt_equalityFn || goog.structs.Map.defaultEquals;
  this.cleanupKeysArray_();
  for(var key, i = 0;key = this.keys_[i];i++) {
    if(!equalityFn(this.get(key), otherMap.get(key))) {
      return false
    }
  }
  return true
};
goog.structs.Map.defaultEquals = function(a, b) {
  return a === b
};
goog.structs.Map.prototype.isEmpty = function() {
  return this.count_ == 0
};
goog.structs.Map.prototype.clear = function() {
  this.map_ = {};
  this.keys_.length = 0;
  this.count_ = 0;
  this.version_ = 0
};
goog.structs.Map.prototype.remove = function(key) {
  if(goog.structs.Map.hasKey_(this.map_, key)) {
    delete this.map_[key];
    this.count_--;
    this.version_++;
    if(this.keys_.length > 2 * this.count_) {
      this.cleanupKeysArray_()
    }
    return true
  }
  return false
};
goog.structs.Map.prototype.cleanupKeysArray_ = function() {
  if(this.count_ != this.keys_.length) {
    var srcIndex = 0;
    var destIndex = 0;
    while(srcIndex < this.keys_.length) {
      var key = this.keys_[srcIndex];
      if(goog.structs.Map.hasKey_(this.map_, key)) {
        this.keys_[destIndex++] = key
      }
      srcIndex++
    }
    this.keys_.length = destIndex
  }
  if(this.count_ != this.keys_.length) {
    var seen = {};
    var srcIndex = 0;
    var destIndex = 0;
    while(srcIndex < this.keys_.length) {
      var key = this.keys_[srcIndex];
      if(!goog.structs.Map.hasKey_(seen, key)) {
        this.keys_[destIndex++] = key;
        seen[key] = 1
      }
      srcIndex++
    }
    this.keys_.length = destIndex
  }
};
goog.structs.Map.prototype.get = function(key, opt_val) {
  if(goog.structs.Map.hasKey_(this.map_, key)) {
    return this.map_[key]
  }
  return opt_val
};
goog.structs.Map.prototype.set = function(key, value) {
  if(!goog.structs.Map.hasKey_(this.map_, key)) {
    this.count_++;
    this.keys_.push(key);
    this.version_++
  }
  this.map_[key] = value
};
goog.structs.Map.prototype.addAll = function(map) {
  var keys, values;
  if(map instanceof goog.structs.Map) {
    keys = map.getKeys();
    values = map.getValues()
  }else {
    keys = goog.object.getKeys(map);
    values = goog.object.getValues(map)
  }
  for(var i = 0;i < keys.length;i++) {
    this.set(keys[i], values[i])
  }
};
goog.structs.Map.prototype.clone = function() {
  return new goog.structs.Map(this)
};
goog.structs.Map.prototype.transpose = function() {
  var transposed = new goog.structs.Map;
  for(var i = 0;i < this.keys_.length;i++) {
    var key = this.keys_[i];
    var value = this.map_[key];
    transposed.set(value, key)
  }
  return transposed
};
goog.structs.Map.prototype.toObject = function() {
  this.cleanupKeysArray_();
  var obj = {};
  for(var i = 0;i < this.keys_.length;i++) {
    var key = this.keys_[i];
    obj[key] = this.map_[key]
  }
  return obj
};
goog.structs.Map.prototype.getKeyIterator = function() {
  return this.__iterator__(true)
};
goog.structs.Map.prototype.getValueIterator = function() {
  return this.__iterator__(false)
};
goog.structs.Map.prototype.__iterator__ = function(opt_keys) {
  this.cleanupKeysArray_();
  var i = 0;
  var keys = this.keys_;
  var map = this.map_;
  var version = this.version_;
  var selfObj = this;
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    while(true) {
      if(version != selfObj.version_) {
        throw Error("The map has changed since the iterator was created");
      }
      if(i >= keys.length) {
        throw goog.iter.StopIteration;
      }
      var key = keys[i++];
      return opt_keys ? key : map[key]
    }
  };
  return newIter
};
goog.structs.Map.hasKey_ = function(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key)
};
// Input 13
goog.provide("goog.uri.utils");
goog.provide("goog.uri.utils.ComponentIndex");
goog.provide("goog.uri.utils.QueryArray");
goog.provide("goog.uri.utils.QueryValue");
goog.provide("goog.uri.utils.StandardQueryParam");
goog.require("goog.asserts");
goog.require("goog.string");
goog.uri.utils.CharCode_ = {AMPERSAND:38, EQUAL:61, HASH:35, QUESTION:63};
goog.uri.utils.buildFromEncodedParts = function(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_queryData, opt_fragment) {
  var out = [];
  if(opt_scheme) {
    out.push(opt_scheme, ":")
  }
  if(opt_domain) {
    out.push("//");
    if(opt_userInfo) {
      out.push(opt_userInfo, "@")
    }
    out.push(opt_domain);
    if(opt_port) {
      out.push(":", opt_port)
    }
  }
  if(opt_path) {
    out.push(opt_path)
  }
  if(opt_queryData) {
    out.push("?", opt_queryData)
  }
  if(opt_fragment) {
    out.push("#", opt_fragment)
  }
  return out.join("")
};
goog.uri.utils.splitRe_ = new RegExp("^" + "(?:" + "([^:/?#.]+)" + ":)?" + "(?://" + "(?:([^/?#]*)@)?" + "([\\w\\d\\-\\u0100-\\uffff.%]*)" + "(?::([0-9]+))?" + ")?" + "([^?#]+)?" + "(?:\\?([^#]*))?" + "(?:#(.*))?" + "$");
goog.uri.utils.ComponentIndex = {SCHEME:1, USER_INFO:2, DOMAIN:3, PORT:4, PATH:5, QUERY_DATA:6, FRAGMENT:7};
goog.uri.utils.split = function(uri) {
  return uri.match(goog.uri.utils.splitRe_)
};
goog.uri.utils.decodeIfPossible_ = function(uri) {
  return uri && decodeURIComponent(uri)
};
goog.uri.utils.getComponentByIndex_ = function(componentIndex, uri) {
  return goog.uri.utils.split(uri)[componentIndex] || null
};
goog.uri.utils.getScheme = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.SCHEME, uri)
};
goog.uri.utils.getUserInfoEncoded = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.USER_INFO, uri)
};
goog.uri.utils.getUserInfo = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getUserInfoEncoded(uri))
};
goog.uri.utils.getDomainEncoded = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.DOMAIN, uri)
};
goog.uri.utils.getDomain = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getDomainEncoded(uri))
};
goog.uri.utils.getPort = function(uri) {
  return Number(goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.PORT, uri)) || null
};
goog.uri.utils.getPathEncoded = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.PATH, uri)
};
goog.uri.utils.getPath = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getPathEncoded(uri))
};
goog.uri.utils.getQueryData = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.QUERY_DATA, uri)
};
goog.uri.utils.getFragmentEncoded = function(uri) {
  var hashIndex = uri.indexOf("#");
  return hashIndex < 0 ? null : uri.substr(hashIndex + 1)
};
goog.uri.utils.setFragmentEncoded = function(uri, fragment) {
  return goog.uri.utils.removeFragment(uri) + (fragment ? "#" + fragment : "")
};
goog.uri.utils.getFragment = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getFragmentEncoded(uri))
};
goog.uri.utils.getHost = function(uri) {
  var pieces = goog.uri.utils.split(uri);
  return goog.uri.utils.buildFromEncodedParts(pieces[goog.uri.utils.ComponentIndex.SCHEME], pieces[goog.uri.utils.ComponentIndex.USER_INFO], pieces[goog.uri.utils.ComponentIndex.DOMAIN], pieces[goog.uri.utils.ComponentIndex.PORT])
};
goog.uri.utils.getPathAndAfter = function(uri) {
  var pieces = goog.uri.utils.split(uri);
  return goog.uri.utils.buildFromEncodedParts(null, null, null, null, pieces[goog.uri.utils.ComponentIndex.PATH], pieces[goog.uri.utils.ComponentIndex.QUERY_DATA], pieces[goog.uri.utils.ComponentIndex.FRAGMENT])
};
goog.uri.utils.removeFragment = function(uri) {
  var hashIndex = uri.indexOf("#");
  return hashIndex < 0 ? uri : uri.substr(0, hashIndex)
};
goog.uri.utils.haveSameDomain = function(uri1, uri2) {
  var pieces1 = goog.uri.utils.split(uri1);
  var pieces2 = goog.uri.utils.split(uri2);
  return pieces1[goog.uri.utils.ComponentIndex.DOMAIN] == pieces2[goog.uri.utils.ComponentIndex.DOMAIN] && pieces1[goog.uri.utils.ComponentIndex.SCHEME] == pieces2[goog.uri.utils.ComponentIndex.SCHEME] && pieces1[goog.uri.utils.ComponentIndex.PORT] == pieces2[goog.uri.utils.ComponentIndex.PORT]
};
goog.uri.utils.assertNoFragmentsOrQueries_ = function(uri) {
  if(goog.DEBUG && (uri.indexOf("#") >= 0 || uri.indexOf("?") >= 0)) {
    throw Error("goog.uri.utils: Fragment or query identifiers are not " + "supported: [" + uri + "]");
  }
};
goog.uri.utils.QueryValue;
goog.uri.utils.QueryArray;
goog.uri.utils.appendQueryData_ = function(buffer) {
  if(buffer[1]) {
    var baseUri = buffer[0];
    var hashIndex = baseUri.indexOf("#");
    if(hashIndex >= 0) {
      buffer.push(baseUri.substr(hashIndex));
      buffer[0] = baseUri = baseUri.substr(0, hashIndex)
    }
    var questionIndex = baseUri.indexOf("?");
    if(questionIndex < 0) {
      buffer[1] = "?"
    }else {
      if(questionIndex == baseUri.length - 1) {
        buffer[1] = undefined
      }
    }
  }
  return buffer.join("")
};
goog.uri.utils.appendKeyValuePairs_ = function(key, value, pairs) {
  if(goog.isArray(value)) {
    value = value;
    for(var j = 0;j < value.length;j++) {
      pairs.push("&", key);
      if(value[j] !== "") {
        pairs.push("=", goog.string.urlEncode(value[j]))
      }
    }
  }else {
    if(value != null) {
      pairs.push("&", key);
      if(value !== "") {
        pairs.push("=", goog.string.urlEncode(value))
      }
    }
  }
};
goog.uri.utils.buildQueryDataBuffer_ = function(buffer, keysAndValues, opt_startIndex) {
  goog.asserts.assert(Math.max(keysAndValues.length - (opt_startIndex || 0), 0) % 2 == 0, "goog.uri.utils: Key/value lists must be even in length.");
  for(var i = opt_startIndex || 0;i < keysAndValues.length;i += 2) {
    goog.uri.utils.appendKeyValuePairs_(keysAndValues[i], keysAndValues[i + 1], buffer)
  }
  return buffer
};
goog.uri.utils.buildQueryData = function(keysAndValues, opt_startIndex) {
  var buffer = goog.uri.utils.buildQueryDataBuffer_([], keysAndValues, opt_startIndex);
  buffer[0] = "";
  return buffer.join("")
};
goog.uri.utils.buildQueryDataBufferFromMap_ = function(buffer, map) {
  for(var key in map) {
    goog.uri.utils.appendKeyValuePairs_(key, map[key], buffer)
  }
  return buffer
};
goog.uri.utils.buildQueryDataFromMap = function(map) {
  var buffer = goog.uri.utils.buildQueryDataBufferFromMap_([], map);
  buffer[0] = "";
  return buffer.join("")
};
goog.uri.utils.appendParams = function(uri, var_args) {
  return goog.uri.utils.appendQueryData_(arguments.length == 2 ? goog.uri.utils.buildQueryDataBuffer_([uri], arguments[1], 0) : goog.uri.utils.buildQueryDataBuffer_([uri], arguments, 1))
};
goog.uri.utils.appendParamsFromMap = function(uri, map) {
  return goog.uri.utils.appendQueryData_(goog.uri.utils.buildQueryDataBufferFromMap_([uri], map))
};
goog.uri.utils.appendParam = function(uri, key, value) {
  return goog.uri.utils.appendQueryData_([uri, "&", key, "=", goog.string.urlEncode(value)])
};
goog.uri.utils.findParam_ = function(uri, startIndex, keyEncoded, hashOrEndIndex) {
  var index = startIndex;
  var keyLength = keyEncoded.length;
  while((index = uri.indexOf(keyEncoded, index)) >= 0 && index < hashOrEndIndex) {
    var precedingChar = uri.charCodeAt(index - 1);
    if(precedingChar == goog.uri.utils.CharCode_.AMPERSAND || precedingChar == goog.uri.utils.CharCode_.QUESTION) {
      var followingChar = uri.charCodeAt(index + keyLength);
      if(!followingChar || followingChar == goog.uri.utils.CharCode_.EQUAL || followingChar == goog.uri.utils.CharCode_.AMPERSAND || followingChar == goog.uri.utils.CharCode_.HASH) {
        return index
      }
    }
    index += keyLength + 1
  }
  return-1
};
goog.uri.utils.hashOrEndRe_ = /#|$/;
goog.uri.utils.hasParam = function(uri, keyEncoded) {
  return goog.uri.utils.findParam_(uri, 0, keyEncoded, uri.search(goog.uri.utils.hashOrEndRe_)) >= 0
};
goog.uri.utils.getParamValue = function(uri, keyEncoded) {
  var hashOrEndIndex = uri.search(goog.uri.utils.hashOrEndRe_);
  var foundIndex = goog.uri.utils.findParam_(uri, 0, keyEncoded, hashOrEndIndex);
  if(foundIndex < 0) {
    return null
  }else {
    var endPosition = uri.indexOf("&", foundIndex);
    if(endPosition < 0 || endPosition > hashOrEndIndex) {
      endPosition = hashOrEndIndex
    }
    foundIndex += keyEncoded.length + 1;
    return goog.string.urlDecode(uri.substr(foundIndex, endPosition - foundIndex))
  }
};
goog.uri.utils.getParamValues = function(uri, keyEncoded) {
  var hashOrEndIndex = uri.search(goog.uri.utils.hashOrEndRe_);
  var position = 0;
  var foundIndex;
  var result = [];
  while((foundIndex = goog.uri.utils.findParam_(uri, position, keyEncoded, hashOrEndIndex)) >= 0) {
    position = uri.indexOf("&", foundIndex);
    if(position < 0 || position > hashOrEndIndex) {
      position = hashOrEndIndex
    }
    foundIndex += keyEncoded.length + 1;
    result.push(goog.string.urlDecode(uri.substr(foundIndex, position - foundIndex)))
  }
  return result
};
goog.uri.utils.trailingQueryPunctuationRe_ = /[?&]($|#)/;
goog.uri.utils.removeParam = function(uri, keyEncoded) {
  var hashOrEndIndex = uri.search(goog.uri.utils.hashOrEndRe_);
  var position = 0;
  var foundIndex;
  var buffer = [];
  while((foundIndex = goog.uri.utils.findParam_(uri, position, keyEncoded, hashOrEndIndex)) >= 0) {
    buffer.push(uri.substring(position, foundIndex));
    position = Math.min(uri.indexOf("&", foundIndex) + 1 || hashOrEndIndex, hashOrEndIndex)
  }
  buffer.push(uri.substr(position));
  return buffer.join("").replace(goog.uri.utils.trailingQueryPunctuationRe_, "$1")
};
goog.uri.utils.setParam = function(uri, keyEncoded, value) {
  return goog.uri.utils.appendParam(goog.uri.utils.removeParam(uri, keyEncoded), keyEncoded, value)
};
goog.uri.utils.appendPath = function(baseUri, path) {
  goog.uri.utils.assertNoFragmentsOrQueries_(baseUri);
  if(goog.string.endsWith(baseUri, "/")) {
    baseUri = baseUri.substr(0, baseUri.length - 1)
  }
  if(goog.string.startsWith(path, "/")) {
    path = path.substr(1)
  }
  return goog.string.buildString(baseUri, "/", path)
};
goog.uri.utils.StandardQueryParam = {RANDOM:"zx"};
goog.uri.utils.makeUnique = function(uri) {
  return goog.uri.utils.setParam(uri, goog.uri.utils.StandardQueryParam.RANDOM, goog.string.getRandomString())
};
// Input 14
goog.provide("goog.Uri");
goog.provide("goog.Uri.QueryData");
goog.require("goog.array");
goog.require("goog.string");
goog.require("goog.structs");
goog.require("goog.structs.Map");
goog.require("goog.uri.utils");
goog.require("goog.uri.utils.ComponentIndex");
goog.Uri = function(opt_uri, opt_ignoreCase) {
  var m;
  if(opt_uri instanceof goog.Uri) {
    this.setIgnoreCase(opt_ignoreCase == null ? opt_uri.getIgnoreCase() : opt_ignoreCase);
    this.setScheme(opt_uri.getScheme());
    this.setUserInfo(opt_uri.getUserInfo());
    this.setDomain(opt_uri.getDomain());
    this.setPort(opt_uri.getPort());
    this.setPath(opt_uri.getPath());
    this.setQueryData(opt_uri.getQueryData().clone());
    this.setFragment(opt_uri.getFragment())
  }else {
    if(opt_uri && (m = goog.uri.utils.split(String(opt_uri)))) {
      this.setIgnoreCase(!!opt_ignoreCase);
      this.setScheme(m[goog.uri.utils.ComponentIndex.SCHEME] || "", true);
      this.setUserInfo(m[goog.uri.utils.ComponentIndex.USER_INFO] || "", true);
      this.setDomain(m[goog.uri.utils.ComponentIndex.DOMAIN] || "", true);
      this.setPort(m[goog.uri.utils.ComponentIndex.PORT]);
      this.setPath(m[goog.uri.utils.ComponentIndex.PATH] || "", true);
      this.setQuery(m[goog.uri.utils.ComponentIndex.QUERY_DATA] || "", true);
      this.setFragment(m[goog.uri.utils.ComponentIndex.FRAGMENT] || "", true)
    }else {
      this.setIgnoreCase(!!opt_ignoreCase);
      this.queryData_ = new goog.Uri.QueryData(null, this, this.ignoreCase_)
    }
  }
};
goog.Uri.RANDOM_PARAM = goog.uri.utils.StandardQueryParam.RANDOM;
goog.Uri.prototype.scheme_ = "";
goog.Uri.prototype.userInfo_ = "";
goog.Uri.prototype.domain_ = "";
goog.Uri.prototype.port_ = null;
goog.Uri.prototype.path_ = "";
goog.Uri.prototype.queryData_;
goog.Uri.prototype.fragment_ = "";
goog.Uri.prototype.isReadOnly_ = false;
goog.Uri.prototype.ignoreCase_ = false;
goog.Uri.prototype.toString = function() {
  if(this.cachedToString_) {
    return this.cachedToString_
  }
  var out = [];
  if(this.scheme_) {
    out.push(goog.Uri.encodeSpecialChars_(this.scheme_, goog.Uri.reDisallowedInSchemeOrUserInfo_), ":")
  }
  if(this.domain_) {
    out.push("//");
    if(this.userInfo_) {
      out.push(goog.Uri.encodeSpecialChars_(this.userInfo_, goog.Uri.reDisallowedInSchemeOrUserInfo_), "@")
    }
    out.push(goog.Uri.encodeString_(this.domain_));
    if(this.port_ != null) {
      out.push(":", String(this.getPort()))
    }
  }
  if(this.path_) {
    if(this.hasDomain() && this.path_.charAt(0) != "/") {
      out.push("/")
    }
    out.push(goog.Uri.encodeSpecialChars_(this.path_, this.path_.charAt(0) == "/" ? goog.Uri.reDisallowedInAbsolutePath_ : goog.Uri.reDisallowedInRelativePath_))
  }
  var query = String(this.queryData_);
  if(query) {
    out.push("?", query)
  }
  if(this.fragment_) {
    out.push("#", goog.Uri.encodeSpecialChars_(this.fragment_, goog.Uri.reDisallowedInFragment_))
  }
  return this.cachedToString_ = out.join("")
};
goog.Uri.prototype.resolve = function(relativeUri) {
  var absoluteUri = this.clone();
  var overridden = relativeUri.hasScheme();
  if(overridden) {
    absoluteUri.setScheme(relativeUri.getScheme())
  }else {
    overridden = relativeUri.hasUserInfo()
  }
  if(overridden) {
    absoluteUri.setUserInfo(relativeUri.getUserInfo())
  }else {
    overridden = relativeUri.hasDomain()
  }
  if(overridden) {
    absoluteUri.setDomain(relativeUri.getDomain())
  }else {
    overridden = relativeUri.hasPort()
  }
  var path = relativeUri.getPath();
  if(overridden) {
    absoluteUri.setPort(relativeUri.getPort())
  }else {
    overridden = relativeUri.hasPath();
    if(overridden) {
      if(path.charAt(0) != "/") {
        if(this.hasDomain() && !this.hasPath()) {
          path = "/" + path
        }else {
          var lastSlashIndex = absoluteUri.getPath().lastIndexOf("/");
          if(lastSlashIndex != -1) {
            path = absoluteUri.getPath().substr(0, lastSlashIndex + 1) + path
          }
        }
      }
      path = goog.Uri.removeDotSegments(path)
    }
  }
  if(overridden) {
    absoluteUri.setPath(path)
  }else {
    overridden = relativeUri.hasQuery()
  }
  if(overridden) {
    absoluteUri.setQuery(relativeUri.getDecodedQuery())
  }else {
    overridden = relativeUri.hasFragment()
  }
  if(overridden) {
    absoluteUri.setFragment(relativeUri.getFragment())
  }
  return absoluteUri
};
goog.Uri.prototype.clone = function() {
  return goog.Uri.create(this.scheme_, this.userInfo_, this.domain_, this.port_, this.path_, this.queryData_.clone(), this.fragment_, this.ignoreCase_)
};
goog.Uri.prototype.getScheme = function() {
  return this.scheme_
};
goog.Uri.prototype.setScheme = function(newScheme, opt_decode) {
  this.enforceReadOnly();
  delete this.cachedToString_;
  this.scheme_ = opt_decode ? goog.Uri.decodeOrEmpty_(newScheme) : newScheme;
  if(this.scheme_) {
    this.scheme_ = this.scheme_.replace(/:$/, "")
  }
  return this
};
goog.Uri.prototype.hasScheme = function() {
  return!!this.scheme_
};
goog.Uri.prototype.getUserInfo = function() {
  return this.userInfo_
};
goog.Uri.prototype.setUserInfo = function(newUserInfo, opt_decode) {
  this.enforceReadOnly();
  delete this.cachedToString_;
  this.userInfo_ = opt_decode ? goog.Uri.decodeOrEmpty_(newUserInfo) : newUserInfo;
  return this
};
goog.Uri.prototype.hasUserInfo = function() {
  return!!this.userInfo_
};
goog.Uri.prototype.getDomain = function() {
  return this.domain_
};
goog.Uri.prototype.setDomain = function(newDomain, opt_decode) {
  this.enforceReadOnly();
  delete this.cachedToString_;
  this.domain_ = opt_decode ? goog.Uri.decodeOrEmpty_(newDomain) : newDomain;
  return this
};
goog.Uri.prototype.hasDomain = function() {
  return!!this.domain_
};
goog.Uri.prototype.getPort = function() {
  return this.port_
};
goog.Uri.prototype.setPort = function(newPort) {
  this.enforceReadOnly();
  delete this.cachedToString_;
  if(newPort) {
    newPort = Number(newPort);
    if(isNaN(newPort) || newPort < 0) {
      throw Error("Bad port number " + newPort);
    }
    this.port_ = newPort
  }else {
    this.port_ = null
  }
  return this
};
goog.Uri.prototype.hasPort = function() {
  return this.port_ != null
};
goog.Uri.prototype.getPath = function() {
  return this.path_
};
goog.Uri.prototype.setPath = function(newPath, opt_decode) {
  this.enforceReadOnly();
  delete this.cachedToString_;
  this.path_ = opt_decode ? goog.Uri.decodeOrEmpty_(newPath) : newPath;
  return this
};
goog.Uri.prototype.hasPath = function() {
  return!!this.path_
};
goog.Uri.prototype.hasQuery = function() {
  return this.queryData_.toString() !== ""
};
goog.Uri.prototype.setQueryData = function(queryData, opt_decode) {
  this.enforceReadOnly();
  delete this.cachedToString_;
  if(queryData instanceof goog.Uri.QueryData) {
    this.queryData_ = queryData;
    this.queryData_.uri_ = this;
    this.queryData_.setIgnoreCase(this.ignoreCase_)
  }else {
    if(!opt_decode) {
      queryData = goog.Uri.encodeSpecialChars_(queryData, goog.Uri.reDisallowedInQuery_)
    }
    this.queryData_ = new goog.Uri.QueryData(queryData, this, this.ignoreCase_)
  }
  return this
};
goog.Uri.prototype.setQuery = function(newQuery, opt_decode) {
  return this.setQueryData(newQuery, opt_decode)
};
goog.Uri.prototype.getEncodedQuery = function() {
  return this.queryData_.toString()
};
goog.Uri.prototype.getDecodedQuery = function() {
  return this.queryData_.toDecodedString()
};
goog.Uri.prototype.getQueryData = function() {
  return this.queryData_
};
goog.Uri.prototype.getQuery = function() {
  return this.getEncodedQuery()
};
goog.Uri.prototype.setParameterValue = function(key, value) {
  this.enforceReadOnly();
  delete this.cachedToString_;
  this.queryData_.set(key, value);
  return this
};
goog.Uri.prototype.setParameterValues = function(key, values) {
  this.enforceReadOnly();
  delete this.cachedToString_;
  if(!goog.isArray(values)) {
    values = [String(values)]
  }
  this.queryData_.setValues(key, values);
  return this
};
goog.Uri.prototype.getParameterValues = function(name) {
  return this.queryData_.getValues(name)
};
goog.Uri.prototype.getParameterValue = function(paramName) {
  return this.queryData_.get(paramName)
};
goog.Uri.prototype.getFragment = function() {
  return this.fragment_
};
goog.Uri.prototype.setFragment = function(newFragment, opt_decode) {
  this.enforceReadOnly();
  delete this.cachedToString_;
  this.fragment_ = opt_decode ? goog.Uri.decodeOrEmpty_(newFragment) : newFragment;
  return this
};
goog.Uri.prototype.hasFragment = function() {
  return!!this.fragment_
};
goog.Uri.prototype.hasSameDomainAs = function(uri2) {
  return(!this.hasDomain() && !uri2.hasDomain() || this.getDomain() == uri2.getDomain()) && (!this.hasPort() && !uri2.hasPort() || this.getPort() == uri2.getPort())
};
goog.Uri.prototype.makeUnique = function() {
  this.enforceReadOnly();
  this.setParameterValue(goog.Uri.RANDOM_PARAM, goog.string.getRandomString());
  return this
};
goog.Uri.prototype.removeParameter = function(key) {
  this.enforceReadOnly();
  this.queryData_.remove(key);
  return this
};
goog.Uri.prototype.setReadOnly = function(isReadOnly) {
  this.isReadOnly_ = isReadOnly;
  return this
};
goog.Uri.prototype.isReadOnly = function() {
  return this.isReadOnly_
};
goog.Uri.prototype.enforceReadOnly = function() {
  if(this.isReadOnly_) {
    throw Error("Tried to modify a read-only Uri");
  }
};
goog.Uri.prototype.setIgnoreCase = function(ignoreCase) {
  this.ignoreCase_ = ignoreCase;
  if(this.queryData_) {
    this.queryData_.setIgnoreCase(ignoreCase)
  }
  return this
};
goog.Uri.prototype.getIgnoreCase = function() {
  return this.ignoreCase_
};
goog.Uri.parse = function(uri, opt_ignoreCase) {
  return uri instanceof goog.Uri ? uri.clone() : new goog.Uri(uri, opt_ignoreCase)
};
goog.Uri.create = function(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_query, opt_fragment, opt_ignoreCase) {
  var uri = new goog.Uri(null, opt_ignoreCase);
  opt_scheme && uri.setScheme(opt_scheme);
  opt_userInfo && uri.setUserInfo(opt_userInfo);
  opt_domain && uri.setDomain(opt_domain);
  opt_port && uri.setPort(opt_port);
  opt_path && uri.setPath(opt_path);
  opt_query && uri.setQueryData(opt_query);
  opt_fragment && uri.setFragment(opt_fragment);
  return uri
};
goog.Uri.resolve = function(base, rel) {
  if(!(base instanceof goog.Uri)) {
    base = goog.Uri.parse(base)
  }
  if(!(rel instanceof goog.Uri)) {
    rel = goog.Uri.parse(rel)
  }
  return base.resolve(rel)
};
goog.Uri.removeDotSegments = function(path) {
  if(path == ".." || path == ".") {
    return""
  }else {
    if(!goog.string.contains(path, "./") && !goog.string.contains(path, "/.")) {
      return path
    }else {
      var leadingSlash = goog.string.startsWith(path, "/");
      var segments = path.split("/");
      var out = [];
      for(var pos = 0;pos < segments.length;) {
        var segment = segments[pos++];
        if(segment == ".") {
          if(leadingSlash && pos == segments.length) {
            out.push("")
          }
        }else {
          if(segment == "..") {
            if(out.length > 1 || out.length == 1 && out[0] != "") {
              out.pop()
            }
            if(leadingSlash && pos == segments.length) {
              out.push("")
            }
          }else {
            out.push(segment);
            leadingSlash = true
          }
        }
      }
      return out.join("/")
    }
  }
};
goog.Uri.decodeOrEmpty_ = function(val) {
  return val ? decodeURIComponent(val) : ""
};
goog.Uri.encodeString_ = function(unescapedPart) {
  if(goog.isString(unescapedPart)) {
    return encodeURIComponent(unescapedPart)
  }
  return null
};
goog.Uri.encodeSpecialRegExp_ = /^[a-zA-Z0-9\-_.!~*'():\/;?]*$/;
goog.Uri.encodeSpecialChars_ = function(unescapedPart, extra) {
  var ret = null;
  if(goog.isString(unescapedPart)) {
    ret = unescapedPart;
    if(!goog.Uri.encodeSpecialRegExp_.test(ret)) {
      ret = encodeURI(unescapedPart)
    }
    if(ret.search(extra) >= 0) {
      ret = ret.replace(extra, goog.Uri.encodeChar_)
    }
  }
  return ret
};
goog.Uri.encodeChar_ = function(ch) {
  var n = ch.charCodeAt(0);
  return"%" + (n >> 4 & 15).toString(16) + (n & 15).toString(16)
};
goog.Uri.reDisallowedInSchemeOrUserInfo_ = /[#\/\?@]/g;
goog.Uri.reDisallowedInRelativePath_ = /[\#\?:]/g;
goog.Uri.reDisallowedInAbsolutePath_ = /[\#\?]/g;
goog.Uri.reDisallowedInQuery_ = /[\#\?@]/g;
goog.Uri.reDisallowedInFragment_ = /#/g;
goog.Uri.haveSameDomain = function(uri1String, uri2String) {
  var pieces1 = goog.uri.utils.split(uri1String);
  var pieces2 = goog.uri.utils.split(uri2String);
  return pieces1[goog.uri.utils.ComponentIndex.DOMAIN] == pieces2[goog.uri.utils.ComponentIndex.DOMAIN] && pieces1[goog.uri.utils.ComponentIndex.PORT] == pieces2[goog.uri.utils.ComponentIndex.PORT]
};
goog.Uri.QueryData = function(opt_query, opt_uri, opt_ignoreCase) {
  this.encodedQuery_ = opt_query || null;
  this.uri_ = opt_uri || null;
  this.ignoreCase_ = !!opt_ignoreCase
};
goog.Uri.QueryData.prototype.ensureKeyMapInitialized_ = function() {
  if(!this.keyMap_) {
    this.keyMap_ = new goog.structs.Map;
    this.count_ = 0;
    if(this.encodedQuery_) {
      var pairs = this.encodedQuery_.split("&");
      for(var i = 0;i < pairs.length;i++) {
        var indexOfEquals = pairs[i].indexOf("=");
        var name = null;
        var value = null;
        if(indexOfEquals >= 0) {
          name = pairs[i].substring(0, indexOfEquals);
          value = pairs[i].substring(indexOfEquals + 1)
        }else {
          name = pairs[i]
        }
        name = goog.string.urlDecode(name);
        name = this.getKeyName_(name);
        this.add(name, value ? goog.string.urlDecode(value) : "")
      }
    }
  }
};
goog.Uri.QueryData.createFromMap = function(map, opt_uri, opt_ignoreCase) {
  var keys = goog.structs.getKeys(map);
  if(typeof keys == "undefined") {
    throw Error("Keys are undefined");
  }
  return goog.Uri.QueryData.createFromKeysValues(keys, goog.structs.getValues(map), opt_uri, opt_ignoreCase)
};
goog.Uri.QueryData.createFromKeysValues = function(keys, values, opt_uri, opt_ignoreCase) {
  if(keys.length != values.length) {
    throw Error("Mismatched lengths for keys/values");
  }
  var queryData = new goog.Uri.QueryData(null, opt_uri, opt_ignoreCase);
  for(var i = 0;i < keys.length;i++) {
    queryData.add(keys[i], values[i])
  }
  return queryData
};
goog.Uri.QueryData.prototype.keyMap_ = null;
goog.Uri.QueryData.prototype.count_ = null;
goog.Uri.QueryData.decodedQuery_ = null;
goog.Uri.QueryData.prototype.getCount = function() {
  this.ensureKeyMapInitialized_();
  return this.count_
};
goog.Uri.QueryData.prototype.add = function(key, value) {
  this.ensureKeyMapInitialized_();
  this.invalidateCache_();
  key = this.getKeyName_(key);
  if(!this.containsKey(key)) {
    this.keyMap_.set(key, value)
  }else {
    var current = this.keyMap_.get(key);
    if(goog.isArray(current)) {
      current.push(value)
    }else {
      this.keyMap_.set(key, [current, value])
    }
  }
  this.count_++;
  return this
};
goog.Uri.QueryData.prototype.remove = function(key) {
  this.ensureKeyMapInitialized_();
  key = this.getKeyName_(key);
  if(this.keyMap_.containsKey(key)) {
    this.invalidateCache_();
    var old = this.keyMap_.get(key);
    if(goog.isArray(old)) {
      this.count_ -= old.length
    }else {
      this.count_--
    }
    return this.keyMap_.remove(key)
  }
  return false
};
goog.Uri.QueryData.prototype.clear = function() {
  this.invalidateCache_();
  if(this.keyMap_) {
    this.keyMap_.clear()
  }
  this.count_ = 0
};
goog.Uri.QueryData.prototype.isEmpty = function() {
  this.ensureKeyMapInitialized_();
  return this.count_ == 0
};
goog.Uri.QueryData.prototype.containsKey = function(key) {
  this.ensureKeyMapInitialized_();
  key = this.getKeyName_(key);
  return this.keyMap_.containsKey(key)
};
goog.Uri.QueryData.prototype.containsValue = function(value) {
  var vals = this.getValues();
  return goog.array.contains(vals, value)
};
goog.Uri.QueryData.prototype.getKeys = function() {
  this.ensureKeyMapInitialized_();
  var vals = this.keyMap_.getValues();
  var keys = this.keyMap_.getKeys();
  var rv = [];
  for(var i = 0;i < keys.length;i++) {
    var val = vals[i];
    if(goog.isArray(val)) {
      for(var j = 0;j < val.length;j++) {
        rv.push(keys[i])
      }
    }else {
      rv.push(keys[i])
    }
  }
  return rv
};
goog.Uri.QueryData.prototype.getValues = function(opt_key) {
  this.ensureKeyMapInitialized_();
  var rv;
  if(opt_key) {
    var key = this.getKeyName_(opt_key);
    if(this.containsKey(key)) {
      var value = this.keyMap_.get(key);
      if(goog.isArray(value)) {
        return value
      }else {
        rv = [];
        rv.push(value)
      }
    }else {
      rv = []
    }
  }else {
    var vals = this.keyMap_.getValues();
    rv = [];
    for(var i = 0;i < vals.length;i++) {
      var val = vals[i];
      if(goog.isArray(val)) {
        goog.array.extend(rv, val)
      }else {
        rv.push(val)
      }
    }
  }
  return rv
};
goog.Uri.QueryData.prototype.set = function(key, value) {
  this.ensureKeyMapInitialized_();
  this.invalidateCache_();
  key = this.getKeyName_(key);
  if(this.containsKey(key)) {
    var old = this.keyMap_.get(key);
    if(goog.isArray(old)) {
      this.count_ -= old.length
    }else {
      this.count_--
    }
  }
  this.keyMap_.set(key, value);
  this.count_++;
  return this
};
goog.Uri.QueryData.prototype.get = function(key, opt_default) {
  this.ensureKeyMapInitialized_();
  key = this.getKeyName_(key);
  if(this.containsKey(key)) {
    var val = this.keyMap_.get(key);
    if(goog.isArray(val)) {
      return val[0]
    }else {
      return val
    }
  }else {
    return opt_default
  }
};
goog.Uri.QueryData.prototype.setValues = function(key, values) {
  this.ensureKeyMapInitialized_();
  this.invalidateCache_();
  key = this.getKeyName_(key);
  if(this.containsKey(key)) {
    var old = this.keyMap_.get(key);
    if(goog.isArray(old)) {
      this.count_ -= old.length
    }else {
      this.count_--
    }
  }
  if(values.length > 0) {
    this.keyMap_.set(key, values);
    this.count_ += values.length
  }
};
goog.Uri.QueryData.prototype.toString = function() {
  if(this.encodedQuery_) {
    return this.encodedQuery_
  }
  if(!this.keyMap_) {
    return""
  }
  var sb = [];
  var count = 0;
  var keys = this.keyMap_.getKeys();
  for(var i = 0;i < keys.length;i++) {
    var key = keys[i];
    var encodedKey = goog.string.urlEncode(key);
    var val = this.keyMap_.get(key);
    if(goog.isArray(val)) {
      for(var j = 0;j < val.length;j++) {
        if(count > 0) {
          sb.push("&")
        }
        sb.push(encodedKey);
        if(val[j] !== "") {
          sb.push("=", goog.string.urlEncode(val[j]))
        }
        count++
      }
    }else {
      if(count > 0) {
        sb.push("&")
      }
      sb.push(encodedKey);
      if(val !== "") {
        sb.push("=", goog.string.urlEncode(val))
      }
      count++
    }
  }
  return this.encodedQuery_ = sb.join("")
};
goog.Uri.QueryData.prototype.toDecodedString = function() {
  if(!this.decodedQuery_) {
    this.decodedQuery_ = goog.Uri.decodeOrEmpty_(this.toString())
  }
  return this.decodedQuery_
};
goog.Uri.QueryData.prototype.invalidateCache_ = function() {
  delete this.decodedQuery_;
  delete this.encodedQuery_;
  if(this.uri_) {
    delete this.uri_.cachedToString_
  }
};
goog.Uri.QueryData.prototype.filterKeys = function(keys) {
  this.ensureKeyMapInitialized_();
  goog.structs.forEach(this.keyMap_, function(value, key, map) {
    if(!goog.array.contains(keys, key)) {
      this.remove(key)
    }
  }, this);
  return this
};
goog.Uri.QueryData.prototype.clone = function() {
  var rv = new goog.Uri.QueryData;
  if(this.decodedQuery_) {
    rv.decodedQuery_ = this.decodedQuery_
  }
  if(this.encodedQuery_) {
    rv.encodedQuery_ = this.encodedQuery_
  }
  if(this.keyMap_) {
    rv.keyMap_ = this.keyMap_.clone()
  }
  return rv
};
goog.Uri.QueryData.prototype.getKeyName_ = function(arg) {
  var keyName = String(arg);
  if(this.ignoreCase_) {
    keyName = keyName.toLowerCase()
  }
  return keyName
};
goog.Uri.QueryData.prototype.setIgnoreCase = function(ignoreCase) {
  var resetKeys = ignoreCase && !this.ignoreCase_;
  if(resetKeys) {
    this.ensureKeyMapInitialized_();
    this.invalidateCache_();
    goog.structs.forEach(this.keyMap_, function(value, key, map) {
      var lowerCase = key.toLowerCase();
      if(key != lowerCase) {
        this.remove(key);
        this.add(lowerCase, value)
      }
    }, this)
  }
  this.ignoreCase_ = ignoreCase
};
goog.Uri.QueryData.prototype.extend = function(var_args) {
  for(var i = 0;i < arguments.length;i++) {
    var data = arguments[i];
    goog.structs.forEach(data, function(value, key) {
      this.add(key, value)
    }, this)
  }
};
// Input 15
goog.provide("rdfa.utils");
goog.require("cljs.core");
goog.require("goog.Uri");
goog.Uri.reDisallowedInRelativePath_ = /[\#\?]/;
rdfa.utils.resolve_iri = function resolve_iri(iref, base) {
  if(cljs.core.truth_(cljs.core.not_empty.call(null, iref))) {
    return(new goog.Uri(base)).resolve(new goog.Uri(iref)).toString()
  }else {
    return base
  }
};
// Input 16
goog.provide("rdfa.dom");
goog.require("cljs.core");
rdfa.dom.DomAccess = {};
rdfa.dom.get_name = function get_name(this$) {
  if(function() {
    var and__3822__auto____10199 = this$;
    if(and__3822__auto____10199) {
      return this$.rdfa$dom$DomAccess$get_name$arity$1
    }else {
      return and__3822__auto____10199
    }
  }()) {
    return this$.rdfa$dom$DomAccess$get_name$arity$1(this$)
  }else {
    var x__2363__auto____10200 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____10201 = rdfa.dom.get_name[goog.typeOf(x__2363__auto____10200)];
      if(or__3824__auto____10201) {
        return or__3824__auto____10201
      }else {
        var or__3824__auto____10202 = rdfa.dom.get_name["_"];
        if(or__3824__auto____10202) {
          return or__3824__auto____10202
        }else {
          throw cljs.core.missing_protocol.call(null, "DomAccess.get-name", this$);
        }
      }
    }().call(null, this$)
  }
};
rdfa.dom.get_attr = function get_attr(this$, attr_name) {
  if(function() {
    var and__3822__auto____10207 = this$;
    if(and__3822__auto____10207) {
      return this$.rdfa$dom$DomAccess$get_attr$arity$2
    }else {
      return and__3822__auto____10207
    }
  }()) {
    return this$.rdfa$dom$DomAccess$get_attr$arity$2(this$, attr_name)
  }else {
    var x__2363__auto____10208 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____10209 = rdfa.dom.get_attr[goog.typeOf(x__2363__auto____10208)];
      if(or__3824__auto____10209) {
        return or__3824__auto____10209
      }else {
        var or__3824__auto____10210 = rdfa.dom.get_attr["_"];
        if(or__3824__auto____10210) {
          return or__3824__auto____10210
        }else {
          throw cljs.core.missing_protocol.call(null, "DomAccess.get-attr", this$);
        }
      }
    }().call(null, this$, attr_name)
  }
};
rdfa.dom.get_ns_map = function get_ns_map(this$) {
  if(function() {
    var and__3822__auto____10215 = this$;
    if(and__3822__auto____10215) {
      return this$.rdfa$dom$DomAccess$get_ns_map$arity$1
    }else {
      return and__3822__auto____10215
    }
  }()) {
    return this$.rdfa$dom$DomAccess$get_ns_map$arity$1(this$)
  }else {
    var x__2363__auto____10216 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____10217 = rdfa.dom.get_ns_map[goog.typeOf(x__2363__auto____10216)];
      if(or__3824__auto____10217) {
        return or__3824__auto____10217
      }else {
        var or__3824__auto____10218 = rdfa.dom.get_ns_map["_"];
        if(or__3824__auto____10218) {
          return or__3824__auto____10218
        }else {
          throw cljs.core.missing_protocol.call(null, "DomAccess.get-ns-map", this$);
        }
      }
    }().call(null, this$)
  }
};
rdfa.dom.is_root_QMARK_ = function is_root_QMARK_(this$) {
  if(function() {
    var and__3822__auto____10223 = this$;
    if(and__3822__auto____10223) {
      return this$.rdfa$dom$DomAccess$is_root_QMARK_$arity$1
    }else {
      return and__3822__auto____10223
    }
  }()) {
    return this$.rdfa$dom$DomAccess$is_root_QMARK_$arity$1(this$)
  }else {
    var x__2363__auto____10224 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____10225 = rdfa.dom.is_root_QMARK_[goog.typeOf(x__2363__auto____10224)];
      if(or__3824__auto____10225) {
        return or__3824__auto____10225
      }else {
        var or__3824__auto____10226 = rdfa.dom.is_root_QMARK_["_"];
        if(or__3824__auto____10226) {
          return or__3824__auto____10226
        }else {
          throw cljs.core.missing_protocol.call(null, "DomAccess.is-root?", this$);
        }
      }
    }().call(null, this$)
  }
};
rdfa.dom.find_by_tag = function find_by_tag(this$, tag) {
  if(function() {
    var and__3822__auto____10231 = this$;
    if(and__3822__auto____10231) {
      return this$.rdfa$dom$DomAccess$find_by_tag$arity$2
    }else {
      return and__3822__auto____10231
    }
  }()) {
    return this$.rdfa$dom$DomAccess$find_by_tag$arity$2(this$, tag)
  }else {
    var x__2363__auto____10232 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____10233 = rdfa.dom.find_by_tag[goog.typeOf(x__2363__auto____10232)];
      if(or__3824__auto____10233) {
        return or__3824__auto____10233
      }else {
        var or__3824__auto____10234 = rdfa.dom.find_by_tag["_"];
        if(or__3824__auto____10234) {
          return or__3824__auto____10234
        }else {
          throw cljs.core.missing_protocol.call(null, "DomAccess.find-by-tag", this$);
        }
      }
    }().call(null, this$, tag)
  }
};
rdfa.dom.get_child_elements = function get_child_elements(this$) {
  if(function() {
    var and__3822__auto____10239 = this$;
    if(and__3822__auto____10239) {
      return this$.rdfa$dom$DomAccess$get_child_elements$arity$1
    }else {
      return and__3822__auto____10239
    }
  }()) {
    return this$.rdfa$dom$DomAccess$get_child_elements$arity$1(this$)
  }else {
    var x__2363__auto____10240 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____10241 = rdfa.dom.get_child_elements[goog.typeOf(x__2363__auto____10240)];
      if(or__3824__auto____10241) {
        return or__3824__auto____10241
      }else {
        var or__3824__auto____10242 = rdfa.dom.get_child_elements["_"];
        if(or__3824__auto____10242) {
          return or__3824__auto____10242
        }else {
          throw cljs.core.missing_protocol.call(null, "DomAccess.get-child-elements", this$);
        }
      }
    }().call(null, this$)
  }
};
rdfa.dom.get_text = function get_text(this$) {
  if(function() {
    var and__3822__auto____10247 = this$;
    if(and__3822__auto____10247) {
      return this$.rdfa$dom$DomAccess$get_text$arity$1
    }else {
      return and__3822__auto____10247
    }
  }()) {
    return this$.rdfa$dom$DomAccess$get_text$arity$1(this$)
  }else {
    var x__2363__auto____10248 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____10249 = rdfa.dom.get_text[goog.typeOf(x__2363__auto____10248)];
      if(or__3824__auto____10249) {
        return or__3824__auto____10249
      }else {
        var or__3824__auto____10250 = rdfa.dom.get_text["_"];
        if(or__3824__auto____10250) {
          return or__3824__auto____10250
        }else {
          throw cljs.core.missing_protocol.call(null, "DomAccess.get-text", this$);
        }
      }
    }().call(null, this$)
  }
};
rdfa.dom.get_inner_xml = function get_inner_xml(this$, xmlns_map, lang) {
  if(function() {
    var and__3822__auto____10255 = this$;
    if(and__3822__auto____10255) {
      return this$.rdfa$dom$DomAccess$get_inner_xml$arity$3
    }else {
      return and__3822__auto____10255
    }
  }()) {
    return this$.rdfa$dom$DomAccess$get_inner_xml$arity$3(this$, xmlns_map, lang)
  }else {
    var x__2363__auto____10256 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____10257 = rdfa.dom.get_inner_xml[goog.typeOf(x__2363__auto____10256)];
      if(or__3824__auto____10257) {
        return or__3824__auto____10257
      }else {
        var or__3824__auto____10258 = rdfa.dom.get_inner_xml["_"];
        if(or__3824__auto____10258) {
          return or__3824__auto____10258
        }else {
          throw cljs.core.missing_protocol.call(null, "DomAccess.get-inner-xml", this$);
        }
      }
    }().call(null, this$, xmlns_map, lang)
  }
};
// Input 17
goog.provide("goog.userAgent");
goog.require("goog.string");
goog.userAgent.ASSUME_IE = false;
goog.userAgent.ASSUME_GECKO = false;
goog.userAgent.ASSUME_WEBKIT = false;
goog.userAgent.ASSUME_MOBILE_WEBKIT = false;
goog.userAgent.ASSUME_OPERA = false;
goog.userAgent.BROWSER_KNOWN_ = goog.userAgent.ASSUME_IE || goog.userAgent.ASSUME_GECKO || goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_OPERA;
goog.userAgent.getUserAgentString = function() {
  return goog.global["navigator"] ? goog.global["navigator"].userAgent : null
};
goog.userAgent.getNavigator = function() {
  return goog.global["navigator"]
};
goog.userAgent.init_ = function() {
  goog.userAgent.detectedOpera_ = false;
  goog.userAgent.detectedIe_ = false;
  goog.userAgent.detectedWebkit_ = false;
  goog.userAgent.detectedMobile_ = false;
  goog.userAgent.detectedGecko_ = false;
  var ua;
  if(!goog.userAgent.BROWSER_KNOWN_ && (ua = goog.userAgent.getUserAgentString())) {
    var navigator = goog.userAgent.getNavigator();
    goog.userAgent.detectedOpera_ = ua.indexOf("Opera") == 0;
    goog.userAgent.detectedIe_ = !goog.userAgent.detectedOpera_ && ua.indexOf("MSIE") != -1;
    goog.userAgent.detectedWebkit_ = !goog.userAgent.detectedOpera_ && ua.indexOf("WebKit") != -1;
    goog.userAgent.detectedMobile_ = goog.userAgent.detectedWebkit_ && ua.indexOf("Mobile") != -1;
    goog.userAgent.detectedGecko_ = !goog.userAgent.detectedOpera_ && !goog.userAgent.detectedWebkit_ && navigator.product == "Gecko"
  }
};
if(!goog.userAgent.BROWSER_KNOWN_) {
  goog.userAgent.init_()
}
goog.userAgent.OPERA = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_OPERA : goog.userAgent.detectedOpera_;
goog.userAgent.IE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_IE : goog.userAgent.detectedIe_;
goog.userAgent.GECKO = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_GECKO : goog.userAgent.detectedGecko_;
goog.userAgent.WEBKIT = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_MOBILE_WEBKIT : goog.userAgent.detectedWebkit_;
goog.userAgent.MOBILE = goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.detectedMobile_;
goog.userAgent.SAFARI = goog.userAgent.WEBKIT;
goog.userAgent.determinePlatform_ = function() {
  var navigator = goog.userAgent.getNavigator();
  return navigator && navigator.platform || ""
};
goog.userAgent.PLATFORM = goog.userAgent.determinePlatform_();
goog.userAgent.ASSUME_MAC = false;
goog.userAgent.ASSUME_WINDOWS = false;
goog.userAgent.ASSUME_LINUX = false;
goog.userAgent.ASSUME_X11 = false;
goog.userAgent.PLATFORM_KNOWN_ = goog.userAgent.ASSUME_MAC || goog.userAgent.ASSUME_WINDOWS || goog.userAgent.ASSUME_LINUX || goog.userAgent.ASSUME_X11;
goog.userAgent.initPlatform_ = function() {
  goog.userAgent.detectedMac_ = goog.string.contains(goog.userAgent.PLATFORM, "Mac");
  goog.userAgent.detectedWindows_ = goog.string.contains(goog.userAgent.PLATFORM, "Win");
  goog.userAgent.detectedLinux_ = goog.string.contains(goog.userAgent.PLATFORM, "Linux");
  goog.userAgent.detectedX11_ = !!goog.userAgent.getNavigator() && goog.string.contains(goog.userAgent.getNavigator()["appVersion"] || "", "X11")
};
if(!goog.userAgent.PLATFORM_KNOWN_) {
  goog.userAgent.initPlatform_()
}
goog.userAgent.MAC = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_MAC : goog.userAgent.detectedMac_;
goog.userAgent.WINDOWS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_WINDOWS : goog.userAgent.detectedWindows_;
goog.userAgent.LINUX = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_LINUX : goog.userAgent.detectedLinux_;
goog.userAgent.X11 = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_X11 : goog.userAgent.detectedX11_;
goog.userAgent.determineVersion_ = function() {
  var version = "", re;
  if(goog.userAgent.OPERA && goog.global["opera"]) {
    var operaVersion = goog.global["opera"].version;
    version = typeof operaVersion == "function" ? operaVersion() : operaVersion
  }else {
    if(goog.userAgent.GECKO) {
      re = /rv\:([^\);]+)(\)|;)/
    }else {
      if(goog.userAgent.IE) {
        re = /MSIE\s+([^\);]+)(\)|;)/
      }else {
        if(goog.userAgent.WEBKIT) {
          re = /WebKit\/(\S+)/
        }
      }
    }
    if(re) {
      var arr = re.exec(goog.userAgent.getUserAgentString());
      version = arr ? arr[1] : ""
    }
  }
  if(goog.userAgent.IE) {
    var docMode = goog.userAgent.getDocumentMode_();
    if(docMode > parseFloat(version)) {
      return String(docMode)
    }
  }
  return version
};
goog.userAgent.getDocumentMode_ = function() {
  var doc = goog.global["document"];
  return doc ? doc["documentMode"] : undefined
};
goog.userAgent.VERSION = goog.userAgent.determineVersion_();
goog.userAgent.compare = function(v1, v2) {
  return goog.string.compareVersions(v1, v2)
};
goog.userAgent.isVersionCache_ = {};
goog.userAgent.isVersion = function(version) {
  return goog.userAgent.isVersionCache_[version] || (goog.userAgent.isVersionCache_[version] = goog.string.compareVersions(goog.userAgent.VERSION, version) >= 0)
};
goog.userAgent.isDocumentModeCache_ = {};
goog.userAgent.isDocumentMode = function(documentMode) {
  return goog.userAgent.isDocumentModeCache_[documentMode] || (goog.userAgent.isDocumentModeCache_[documentMode] = goog.userAgent.IE && document.documentMode && document.documentMode >= documentMode)
};
// Input 18
goog.provide("goog.dom.BrowserFeature");
goog.require("goog.userAgent");
goog.dom.BrowserFeature = {CAN_ADD_NAME_OR_TYPE_ATTRIBUTES:!goog.userAgent.IE || goog.userAgent.isDocumentMode(9), CAN_USE_CHILDREN_ATTRIBUTE:!goog.userAgent.GECKO && !goog.userAgent.IE || goog.userAgent.IE && goog.userAgent.isDocumentMode(9) || goog.userAgent.GECKO && goog.userAgent.isVersion("1.9.1"), CAN_USE_INNER_TEXT:goog.userAgent.IE && !goog.userAgent.isVersion("9"), INNER_HTML_NEEDS_SCOPED_ELEMENT:goog.userAgent.IE};
// Input 19
goog.provide("goog.dom.TagName");
goog.dom.TagName = {A:"A", ABBR:"ABBR", ACRONYM:"ACRONYM", ADDRESS:"ADDRESS", APPLET:"APPLET", AREA:"AREA", B:"B", BASE:"BASE", BASEFONT:"BASEFONT", BDO:"BDO", BIG:"BIG", BLOCKQUOTE:"BLOCKQUOTE", BODY:"BODY", BR:"BR", BUTTON:"BUTTON", CANVAS:"CANVAS", CAPTION:"CAPTION", CENTER:"CENTER", CITE:"CITE", CODE:"CODE", COL:"COL", COLGROUP:"COLGROUP", DD:"DD", DEL:"DEL", DFN:"DFN", DIR:"DIR", DIV:"DIV", DL:"DL", DT:"DT", EM:"EM", FIELDSET:"FIELDSET", FONT:"FONT", FORM:"FORM", FRAME:"FRAME", FRAMESET:"FRAMESET", 
H1:"H1", H2:"H2", H3:"H3", H4:"H4", H5:"H5", H6:"H6", HEAD:"HEAD", HR:"HR", HTML:"HTML", I:"I", IFRAME:"IFRAME", IMG:"IMG", INPUT:"INPUT", INS:"INS", ISINDEX:"ISINDEX", KBD:"KBD", LABEL:"LABEL", LEGEND:"LEGEND", LI:"LI", LINK:"LINK", MAP:"MAP", MENU:"MENU", META:"META", NOFRAMES:"NOFRAMES", NOSCRIPT:"NOSCRIPT", OBJECT:"OBJECT", OL:"OL", OPTGROUP:"OPTGROUP", OPTION:"OPTION", P:"P", PARAM:"PARAM", PRE:"PRE", Q:"Q", S:"S", SAMP:"SAMP", SCRIPT:"SCRIPT", SELECT:"SELECT", SMALL:"SMALL", SPAN:"SPAN", STRIKE:"STRIKE", 
STRONG:"STRONG", STYLE:"STYLE", SUB:"SUB", SUP:"SUP", TABLE:"TABLE", TBODY:"TBODY", TD:"TD", TEXTAREA:"TEXTAREA", TFOOT:"TFOOT", TH:"TH", THEAD:"THEAD", TITLE:"TITLE", TR:"TR", TT:"TT", U:"U", UL:"UL", VAR:"VAR"};
// Input 20
goog.provide("goog.dom.classes");
goog.require("goog.array");
goog.dom.classes.set = function(element, className) {
  element.className = className
};
goog.dom.classes.get = function(element) {
  var className = element.className;
  return className && typeof className.split == "function" ? className.split(/\s+/) : []
};
goog.dom.classes.add = function(element, var_args) {
  var classes = goog.dom.classes.get(element);
  var args = goog.array.slice(arguments, 1);
  var b = goog.dom.classes.add_(classes, args);
  element.className = classes.join(" ");
  return b
};
goog.dom.classes.remove = function(element, var_args) {
  var classes = goog.dom.classes.get(element);
  var args = goog.array.slice(arguments, 1);
  var b = goog.dom.classes.remove_(classes, args);
  element.className = classes.join(" ");
  return b
};
goog.dom.classes.add_ = function(classes, args) {
  var rv = 0;
  for(var i = 0;i < args.length;i++) {
    if(!goog.array.contains(classes, args[i])) {
      classes.push(args[i]);
      rv++
    }
  }
  return rv == args.length
};
goog.dom.classes.remove_ = function(classes, args) {
  var rv = 0;
  for(var i = 0;i < classes.length;i++) {
    if(goog.array.contains(args, classes[i])) {
      goog.array.splice(classes, i--, 1);
      rv++
    }
  }
  return rv == args.length
};
goog.dom.classes.swap = function(element, fromClass, toClass) {
  var classes = goog.dom.classes.get(element);
  var removed = false;
  for(var i = 0;i < classes.length;i++) {
    if(classes[i] == fromClass) {
      goog.array.splice(classes, i--, 1);
      removed = true
    }
  }
  if(removed) {
    classes.push(toClass);
    element.className = classes.join(" ")
  }
  return removed
};
goog.dom.classes.addRemove = function(element, classesToRemove, classesToAdd) {
  var classes = goog.dom.classes.get(element);
  if(goog.isString(classesToRemove)) {
    goog.array.remove(classes, classesToRemove)
  }else {
    if(goog.isArray(classesToRemove)) {
      goog.dom.classes.remove_(classes, classesToRemove)
    }
  }
  if(goog.isString(classesToAdd) && !goog.array.contains(classes, classesToAdd)) {
    classes.push(classesToAdd)
  }else {
    if(goog.isArray(classesToAdd)) {
      goog.dom.classes.add_(classes, classesToAdd)
    }
  }
  element.className = classes.join(" ")
};
goog.dom.classes.has = function(element, className) {
  return goog.array.contains(goog.dom.classes.get(element), className)
};
goog.dom.classes.enable = function(element, className, enabled) {
  if(enabled) {
    goog.dom.classes.add(element, className)
  }else {
    goog.dom.classes.remove(element, className)
  }
};
goog.dom.classes.toggle = function(element, className) {
  var add = !goog.dom.classes.has(element, className);
  goog.dom.classes.enable(element, className, add);
  return add
};
// Input 21
goog.provide("goog.math.Coordinate");
goog.math.Coordinate = function(opt_x, opt_y) {
  this.x = goog.isDef(opt_x) ? opt_x : 0;
  this.y = goog.isDef(opt_y) ? opt_y : 0
};
goog.math.Coordinate.prototype.clone = function() {
  return new goog.math.Coordinate(this.x, this.y)
};
if(goog.DEBUG) {
  goog.math.Coordinate.prototype.toString = function() {
    return"(" + this.x + ", " + this.y + ")"
  }
}
goog.math.Coordinate.equals = function(a, b) {
  if(a == b) {
    return true
  }
  if(!a || !b) {
    return false
  }
  return a.x == b.x && a.y == b.y
};
goog.math.Coordinate.distance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  return Math.sqrt(dx * dx + dy * dy)
};
goog.math.Coordinate.squaredDistance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  return dx * dx + dy * dy
};
goog.math.Coordinate.difference = function(a, b) {
  return new goog.math.Coordinate(a.x - b.x, a.y - b.y)
};
goog.math.Coordinate.sum = function(a, b) {
  return new goog.math.Coordinate(a.x + b.x, a.y + b.y)
};
// Input 22
goog.provide("goog.math.Size");
goog.math.Size = function(width, height) {
  this.width = width;
  this.height = height
};
goog.math.Size.equals = function(a, b) {
  if(a == b) {
    return true
  }
  if(!a || !b) {
    return false
  }
  return a.width == b.width && a.height == b.height
};
goog.math.Size.prototype.clone = function() {
  return new goog.math.Size(this.width, this.height)
};
if(goog.DEBUG) {
  goog.math.Size.prototype.toString = function() {
    return"(" + this.width + " x " + this.height + ")"
  }
}
goog.math.Size.prototype.getLongest = function() {
  return Math.max(this.width, this.height)
};
goog.math.Size.prototype.getShortest = function() {
  return Math.min(this.width, this.height)
};
goog.math.Size.prototype.area = function() {
  return this.width * this.height
};
goog.math.Size.prototype.perimeter = function() {
  return(this.width + this.height) * 2
};
goog.math.Size.prototype.aspectRatio = function() {
  return this.width / this.height
};
goog.math.Size.prototype.isEmpty = function() {
  return!this.area()
};
goog.math.Size.prototype.ceil = function() {
  this.width = Math.ceil(this.width);
  this.height = Math.ceil(this.height);
  return this
};
goog.math.Size.prototype.fitsInside = function(target) {
  return this.width <= target.width && this.height <= target.height
};
goog.math.Size.prototype.floor = function() {
  this.width = Math.floor(this.width);
  this.height = Math.floor(this.height);
  return this
};
goog.math.Size.prototype.round = function() {
  this.width = Math.round(this.width);
  this.height = Math.round(this.height);
  return this
};
goog.math.Size.prototype.scale = function(s) {
  this.width *= s;
  this.height *= s;
  return this
};
goog.math.Size.prototype.scaleToFit = function(target) {
  var s = this.aspectRatio() > target.aspectRatio() ? target.width / this.width : target.height / this.height;
  return this.scale(s)
};
// Input 23
goog.provide("goog.dom");
goog.provide("goog.dom.DomHelper");
goog.provide("goog.dom.NodeType");
goog.require("goog.array");
goog.require("goog.dom.BrowserFeature");
goog.require("goog.dom.TagName");
goog.require("goog.dom.classes");
goog.require("goog.math.Coordinate");
goog.require("goog.math.Size");
goog.require("goog.object");
goog.require("goog.string");
goog.require("goog.userAgent");
goog.dom.ASSUME_QUIRKS_MODE = false;
goog.dom.ASSUME_STANDARDS_MODE = false;
goog.dom.COMPAT_MODE_KNOWN_ = goog.dom.ASSUME_QUIRKS_MODE || goog.dom.ASSUME_STANDARDS_MODE;
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.dom.getDomHelper = function(opt_element) {
  return opt_element ? new goog.dom.DomHelper(goog.dom.getOwnerDocument(opt_element)) : goog.dom.defaultDomHelper_ || (goog.dom.defaultDomHelper_ = new goog.dom.DomHelper)
};
goog.dom.defaultDomHelper_;
goog.dom.getDocument = function() {
  return document
};
goog.dom.getElement = function(element) {
  return goog.isString(element) ? document.getElementById(element) : element
};
goog.dom.$ = goog.dom.getElement;
goog.dom.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(document, opt_tag, opt_class, opt_el)
};
goog.dom.getElementsByClass = function(className, opt_el) {
  var parent = opt_el || document;
  if(goog.dom.canUseQuerySelector_(parent)) {
    return parent.querySelectorAll("." + className)
  }else {
    if(parent.getElementsByClassName) {
      return parent.getElementsByClassName(className)
    }
  }
  return goog.dom.getElementsByTagNameAndClass_(document, "*", className, opt_el)
};
goog.dom.getElementByClass = function(className, opt_el) {
  var parent = opt_el || document;
  var retVal = null;
  if(goog.dom.canUseQuerySelector_(parent)) {
    retVal = parent.querySelector("." + className)
  }else {
    retVal = goog.dom.getElementsByClass(className, opt_el)[0]
  }
  return retVal || null
};
goog.dom.canUseQuerySelector_ = function(parent) {
  return parent.querySelectorAll && parent.querySelector && (!goog.userAgent.WEBKIT || goog.dom.isCss1CompatMode_(document) || goog.userAgent.isVersion("528"))
};
goog.dom.getElementsByTagNameAndClass_ = function(doc, opt_tag, opt_class, opt_el) {
  var parent = opt_el || doc;
  var tagName = opt_tag && opt_tag != "*" ? opt_tag.toUpperCase() : "";
  if(goog.dom.canUseQuerySelector_(parent) && (tagName || opt_class)) {
    var query = tagName + (opt_class ? "." + opt_class : "");
    return parent.querySelectorAll(query)
  }
  if(opt_class && parent.getElementsByClassName) {
    var els = parent.getElementsByClassName(opt_class);
    if(tagName) {
      var arrayLike = {};
      var len = 0;
      for(var i = 0, el;el = els[i];i++) {
        if(tagName == el.nodeName) {
          arrayLike[len++] = el
        }
      }
      arrayLike.length = len;
      return arrayLike
    }else {
      return els
    }
  }
  var els = parent.getElementsByTagName(tagName || "*");
  if(opt_class) {
    var arrayLike = {};
    var len = 0;
    for(var i = 0, el;el = els[i];i++) {
      var className = el.className;
      if(typeof className.split == "function" && goog.array.contains(className.split(/\s+/), opt_class)) {
        arrayLike[len++] = el
      }
    }
    arrayLike.length = len;
    return arrayLike
  }else {
    return els
  }
};
goog.dom.$$ = goog.dom.getElementsByTagNameAndClass;
goog.dom.setProperties = function(element, properties) {
  goog.object.forEach(properties, function(val, key) {
    if(key == "style") {
      element.style.cssText = val
    }else {
      if(key == "class") {
        element.className = val
      }else {
        if(key == "for") {
          element.htmlFor = val
        }else {
          if(key in goog.dom.DIRECT_ATTRIBUTE_MAP_) {
            element.setAttribute(goog.dom.DIRECT_ATTRIBUTE_MAP_[key], val)
          }else {
            if(goog.string.startsWith(key, "aria-")) {
              element.setAttribute(key, val)
            }else {
              element[key] = val
            }
          }
        }
      }
    }
  })
};
goog.dom.DIRECT_ATTRIBUTE_MAP_ = {"cellpadding":"cellPadding", "cellspacing":"cellSpacing", "colspan":"colSpan", "rowspan":"rowSpan", "valign":"vAlign", "height":"height", "width":"width", "usemap":"useMap", "frameborder":"frameBorder", "maxlength":"maxLength", "type":"type"};
goog.dom.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize_(opt_window || window)
};
goog.dom.getViewportSize_ = function(win) {
  var doc = win.document;
  if(goog.userAgent.WEBKIT && !goog.userAgent.isVersion("500") && !goog.userAgent.MOBILE) {
    if(typeof win.innerHeight == "undefined") {
      win = window
    }
    var innerHeight = win.innerHeight;
    var scrollHeight = win.document.documentElement.scrollHeight;
    if(win == win.top) {
      if(scrollHeight < innerHeight) {
        innerHeight -= 15
      }
    }
    return new goog.math.Size(win.innerWidth, innerHeight)
  }
  var el = goog.dom.isCss1CompatMode_(doc) ? doc.documentElement : doc.body;
  return new goog.math.Size(el.clientWidth, el.clientHeight)
};
goog.dom.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(window)
};
goog.dom.getDocumentHeight_ = function(win) {
  var doc = win.document;
  var height = 0;
  if(doc) {
    var vh = goog.dom.getViewportSize_(win).height;
    var body = doc.body;
    var docEl = doc.documentElement;
    if(goog.dom.isCss1CompatMode_(doc) && docEl.scrollHeight) {
      height = docEl.scrollHeight != vh ? docEl.scrollHeight : docEl.offsetHeight
    }else {
      var sh = docEl.scrollHeight;
      var oh = docEl.offsetHeight;
      if(docEl.clientHeight != oh) {
        sh = body.scrollHeight;
        oh = body.offsetHeight
      }
      if(sh > vh) {
        height = sh > oh ? sh : oh
      }else {
        height = sh < oh ? sh : oh
      }
    }
  }
  return height
};
goog.dom.getPageScroll = function(opt_window) {
  var win = opt_window || goog.global || window;
  return goog.dom.getDomHelper(win.document).getDocumentScroll()
};
goog.dom.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(document)
};
goog.dom.getDocumentScroll_ = function(doc) {
  var el = goog.dom.getDocumentScrollElement_(doc);
  var win = goog.dom.getWindow_(doc);
  return new goog.math.Coordinate(win.pageXOffset || el.scrollLeft, win.pageYOffset || el.scrollTop)
};
goog.dom.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(document)
};
goog.dom.getDocumentScrollElement_ = function(doc) {
  return!goog.userAgent.WEBKIT && goog.dom.isCss1CompatMode_(doc) ? doc.documentElement : doc.body
};
goog.dom.getWindow = function(opt_doc) {
  return opt_doc ? goog.dom.getWindow_(opt_doc) : window
};
goog.dom.getWindow_ = function(doc) {
  return doc.parentWindow || doc.defaultView
};
goog.dom.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(document, arguments)
};
goog.dom.createDom_ = function(doc, args) {
  var tagName = args[0];
  var attributes = args[1];
  if(!goog.dom.BrowserFeature.CAN_ADD_NAME_OR_TYPE_ATTRIBUTES && attributes && (attributes.name || attributes.type)) {
    var tagNameArr = ["<", tagName];
    if(attributes.name) {
      tagNameArr.push(' name="', goog.string.htmlEscape(attributes.name), '"')
    }
    if(attributes.type) {
      tagNameArr.push(' type="', goog.string.htmlEscape(attributes.type), '"');
      var clone = {};
      goog.object.extend(clone, attributes);
      attributes = clone;
      delete attributes.type
    }
    tagNameArr.push(">");
    tagName = tagNameArr.join("")
  }
  var element = doc.createElement(tagName);
  if(attributes) {
    if(goog.isString(attributes)) {
      element.className = attributes
    }else {
      if(goog.isArray(attributes)) {
        goog.dom.classes.add.apply(null, [element].concat(attributes))
      }else {
        goog.dom.setProperties(element, attributes)
      }
    }
  }
  if(args.length > 2) {
    goog.dom.append_(doc, element, args, 2)
  }
  return element
};
goog.dom.append_ = function(doc, parent, args, startIndex) {
  function childHandler(child) {
    if(child) {
      parent.appendChild(goog.isString(child) ? doc.createTextNode(child) : child)
    }
  }
  for(var i = startIndex;i < args.length;i++) {
    var arg = args[i];
    if(goog.isArrayLike(arg) && !goog.dom.isNodeLike(arg)) {
      goog.array.forEach(goog.dom.isNodeList(arg) ? goog.array.clone(arg) : arg, childHandler)
    }else {
      childHandler(arg)
    }
  }
};
goog.dom.$dom = goog.dom.createDom;
goog.dom.createElement = function(name) {
  return document.createElement(name)
};
goog.dom.createTextNode = function(content) {
  return document.createTextNode(content)
};
goog.dom.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(document, rows, columns, !!opt_fillWithNbsp)
};
goog.dom.createTable_ = function(doc, rows, columns, fillWithNbsp) {
  var rowHtml = ["<tr>"];
  for(var i = 0;i < columns;i++) {
    rowHtml.push(fillWithNbsp ? "<td>&nbsp;</td>" : "<td></td>")
  }
  rowHtml.push("</tr>");
  rowHtml = rowHtml.join("");
  var totalHtml = ["<table>"];
  for(i = 0;i < rows;i++) {
    totalHtml.push(rowHtml)
  }
  totalHtml.push("</table>");
  var elem = doc.createElement(goog.dom.TagName.DIV);
  elem.innerHTML = totalHtml.join("");
  return elem.removeChild(elem.firstChild)
};
goog.dom.htmlToDocumentFragment = function(htmlString) {
  return goog.dom.htmlToDocumentFragment_(document, htmlString)
};
goog.dom.htmlToDocumentFragment_ = function(doc, htmlString) {
  var tempDiv = doc.createElement("div");
  if(goog.dom.BrowserFeature.INNER_HTML_NEEDS_SCOPED_ELEMENT) {
    tempDiv.innerHTML = "<br>" + htmlString;
    tempDiv.removeChild(tempDiv.firstChild)
  }else {
    tempDiv.innerHTML = htmlString
  }
  if(tempDiv.childNodes.length == 1) {
    return tempDiv.removeChild(tempDiv.firstChild)
  }else {
    var fragment = doc.createDocumentFragment();
    while(tempDiv.firstChild) {
      fragment.appendChild(tempDiv.firstChild)
    }
    return fragment
  }
};
goog.dom.getCompatMode = function() {
  return goog.dom.isCss1CompatMode() ? "CSS1Compat" : "BackCompat"
};
goog.dom.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(document)
};
goog.dom.isCss1CompatMode_ = function(doc) {
  if(goog.dom.COMPAT_MODE_KNOWN_) {
    return goog.dom.ASSUME_STANDARDS_MODE
  }
  return doc.compatMode == "CSS1Compat"
};
goog.dom.canHaveChildren = function(node) {
  if(node.nodeType != goog.dom.NodeType.ELEMENT) {
    return false
  }
  switch(node.tagName) {
    case goog.dom.TagName.APPLET:
    ;
    case goog.dom.TagName.AREA:
    ;
    case goog.dom.TagName.BASE:
    ;
    case goog.dom.TagName.BR:
    ;
    case goog.dom.TagName.COL:
    ;
    case goog.dom.TagName.FRAME:
    ;
    case goog.dom.TagName.HR:
    ;
    case goog.dom.TagName.IMG:
    ;
    case goog.dom.TagName.INPUT:
    ;
    case goog.dom.TagName.IFRAME:
    ;
    case goog.dom.TagName.ISINDEX:
    ;
    case goog.dom.TagName.LINK:
    ;
    case goog.dom.TagName.NOFRAMES:
    ;
    case goog.dom.TagName.NOSCRIPT:
    ;
    case goog.dom.TagName.META:
    ;
    case goog.dom.TagName.OBJECT:
    ;
    case goog.dom.TagName.PARAM:
    ;
    case goog.dom.TagName.SCRIPT:
    ;
    case goog.dom.TagName.STYLE:
      return false
  }
  return true
};
goog.dom.appendChild = function(parent, child) {
  parent.appendChild(child)
};
goog.dom.append = function(parent, var_args) {
  goog.dom.append_(goog.dom.getOwnerDocument(parent), parent, arguments, 1)
};
goog.dom.removeChildren = function(node) {
  var child;
  while(child = node.firstChild) {
    node.removeChild(child)
  }
};
goog.dom.insertSiblingBefore = function(newNode, refNode) {
  if(refNode.parentNode) {
    refNode.parentNode.insertBefore(newNode, refNode)
  }
};
goog.dom.insertSiblingAfter = function(newNode, refNode) {
  if(refNode.parentNode) {
    refNode.parentNode.insertBefore(newNode, refNode.nextSibling)
  }
};
goog.dom.insertChildAt = function(parent, child, index) {
  parent.insertBefore(child, parent.childNodes[index] || null)
};
goog.dom.removeNode = function(node) {
  return node && node.parentNode ? node.parentNode.removeChild(node) : null
};
goog.dom.replaceNode = function(newNode, oldNode) {
  var parent = oldNode.parentNode;
  if(parent) {
    parent.replaceChild(newNode, oldNode)
  }
};
goog.dom.flattenElement = function(element) {
  var child, parent = element.parentNode;
  if(parent && parent.nodeType != goog.dom.NodeType.DOCUMENT_FRAGMENT) {
    if(element.removeNode) {
      return element.removeNode(false)
    }else {
      while(child = element.firstChild) {
        parent.insertBefore(child, element)
      }
      return goog.dom.removeNode(element)
    }
  }
};
goog.dom.getChildren = function(element) {
  if(goog.dom.BrowserFeature.CAN_USE_CHILDREN_ATTRIBUTE && element.children != undefined) {
    return element.children
  }
  return goog.array.filter(element.childNodes, function(node) {
    return node.nodeType == goog.dom.NodeType.ELEMENT
  })
};
goog.dom.getFirstElementChild = function(node) {
  if(node.firstElementChild != undefined) {
    return node.firstElementChild
  }
  return goog.dom.getNextElementNode_(node.firstChild, true)
};
goog.dom.getLastElementChild = function(node) {
  if(node.lastElementChild != undefined) {
    return node.lastElementChild
  }
  return goog.dom.getNextElementNode_(node.lastChild, false)
};
goog.dom.getNextElementSibling = function(node) {
  if(node.nextElementSibling != undefined) {
    return node.nextElementSibling
  }
  return goog.dom.getNextElementNode_(node.nextSibling, true)
};
goog.dom.getPreviousElementSibling = function(node) {
  if(node.previousElementSibling != undefined) {
    return node.previousElementSibling
  }
  return goog.dom.getNextElementNode_(node.previousSibling, false)
};
goog.dom.getNextElementNode_ = function(node, forward) {
  while(node && node.nodeType != goog.dom.NodeType.ELEMENT) {
    node = forward ? node.nextSibling : node.previousSibling
  }
  return node
};
goog.dom.getNextNode = function(node) {
  if(!node) {
    return null
  }
  if(node.firstChild) {
    return node.firstChild
  }
  while(node && !node.nextSibling) {
    node = node.parentNode
  }
  return node ? node.nextSibling : null
};
goog.dom.getPreviousNode = function(node) {
  if(!node) {
    return null
  }
  if(!node.previousSibling) {
    return node.parentNode
  }
  node = node.previousSibling;
  while(node && node.lastChild) {
    node = node.lastChild
  }
  return node
};
goog.dom.isNodeLike = function(obj) {
  return goog.isObject(obj) && obj.nodeType > 0
};
goog.dom.isElement = function(obj) {
  return goog.isObject(obj) && obj.nodeType == goog.dom.NodeType.ELEMENT
};
goog.dom.isWindow = function(obj) {
  return goog.isObject(obj) && obj["window"] == obj
};
goog.dom.contains = function(parent, descendant) {
  if(parent.contains && descendant.nodeType == goog.dom.NodeType.ELEMENT) {
    return parent == descendant || parent.contains(descendant)
  }
  if(typeof parent.compareDocumentPosition != "undefined") {
    return parent == descendant || Boolean(parent.compareDocumentPosition(descendant) & 16)
  }
  while(descendant && parent != descendant) {
    descendant = descendant.parentNode
  }
  return descendant == parent
};
goog.dom.compareNodeOrder = function(node1, node2) {
  if(node1 == node2) {
    return 0
  }
  if(node1.compareDocumentPosition) {
    return node1.compareDocumentPosition(node2) & 2 ? 1 : -1
  }
  if("sourceIndex" in node1 || node1.parentNode && "sourceIndex" in node1.parentNode) {
    var isElement1 = node1.nodeType == goog.dom.NodeType.ELEMENT;
    var isElement2 = node2.nodeType == goog.dom.NodeType.ELEMENT;
    if(isElement1 && isElement2) {
      return node1.sourceIndex - node2.sourceIndex
    }else {
      var parent1 = node1.parentNode;
      var parent2 = node2.parentNode;
      if(parent1 == parent2) {
        return goog.dom.compareSiblingOrder_(node1, node2)
      }
      if(!isElement1 && goog.dom.contains(parent1, node2)) {
        return-1 * goog.dom.compareParentsDescendantNodeIe_(node1, node2)
      }
      if(!isElement2 && goog.dom.contains(parent2, node1)) {
        return goog.dom.compareParentsDescendantNodeIe_(node2, node1)
      }
      return(isElement1 ? node1.sourceIndex : parent1.sourceIndex) - (isElement2 ? node2.sourceIndex : parent2.sourceIndex)
    }
  }
  var doc = goog.dom.getOwnerDocument(node1);
  var range1, range2;
  range1 = doc.createRange();
  range1.selectNode(node1);
  range1.collapse(true);
  range2 = doc.createRange();
  range2.selectNode(node2);
  range2.collapse(true);
  return range1.compareBoundaryPoints(goog.global["Range"].START_TO_END, range2)
};
goog.dom.compareParentsDescendantNodeIe_ = function(textNode, node) {
  var parent = textNode.parentNode;
  if(parent == node) {
    return-1
  }
  var sibling = node;
  while(sibling.parentNode != parent) {
    sibling = sibling.parentNode
  }
  return goog.dom.compareSiblingOrder_(sibling, textNode)
};
goog.dom.compareSiblingOrder_ = function(node1, node2) {
  var s = node2;
  while(s = s.previousSibling) {
    if(s == node1) {
      return-1
    }
  }
  return 1
};
goog.dom.findCommonAncestor = function(var_args) {
  var i, count = arguments.length;
  if(!count) {
    return null
  }else {
    if(count == 1) {
      return arguments[0]
    }
  }
  var paths = [];
  var minLength = Infinity;
  for(i = 0;i < count;i++) {
    var ancestors = [];
    var node = arguments[i];
    while(node) {
      ancestors.unshift(node);
      node = node.parentNode
    }
    paths.push(ancestors);
    minLength = Math.min(minLength, ancestors.length)
  }
  var output = null;
  for(i = 0;i < minLength;i++) {
    var first = paths[0][i];
    for(var j = 1;j < count;j++) {
      if(first != paths[j][i]) {
        return output
      }
    }
    output = first
  }
  return output
};
goog.dom.getOwnerDocument = function(node) {
  return node.nodeType == goog.dom.NodeType.DOCUMENT ? node : node.ownerDocument || node.document
};
goog.dom.getFrameContentDocument = function(frame) {
  var doc = frame.contentDocument || frame.contentWindow.document;
  return doc
};
goog.dom.getFrameContentWindow = function(frame) {
  return frame.contentWindow || goog.dom.getWindow_(goog.dom.getFrameContentDocument(frame))
};
goog.dom.setTextContent = function(element, text) {
  if("textContent" in element) {
    element.textContent = text
  }else {
    if(element.firstChild && element.firstChild.nodeType == goog.dom.NodeType.TEXT) {
      while(element.lastChild != element.firstChild) {
        element.removeChild(element.lastChild)
      }
      element.firstChild.data = text
    }else {
      goog.dom.removeChildren(element);
      var doc = goog.dom.getOwnerDocument(element);
      element.appendChild(doc.createTextNode(text))
    }
  }
};
goog.dom.getOuterHtml = function(element) {
  if("outerHTML" in element) {
    return element.outerHTML
  }else {
    var doc = goog.dom.getOwnerDocument(element);
    var div = doc.createElement("div");
    div.appendChild(element.cloneNode(true));
    return div.innerHTML
  }
};
goog.dom.findNode = function(root, p) {
  var rv = [];
  var found = goog.dom.findNodes_(root, p, rv, true);
  return found ? rv[0] : undefined
};
goog.dom.findNodes = function(root, p) {
  var rv = [];
  goog.dom.findNodes_(root, p, rv, false);
  return rv
};
goog.dom.findNodes_ = function(root, p, rv, findOne) {
  if(root != null) {
    var child = root.firstChild;
    while(child) {
      if(p(child)) {
        rv.push(child);
        if(findOne) {
          return true
        }
      }
      if(goog.dom.findNodes_(child, p, rv, findOne)) {
        return true
      }
      child = child.nextSibling
    }
  }
  return false
};
goog.dom.TAGS_TO_IGNORE_ = {"SCRIPT":1, "STYLE":1, "HEAD":1, "IFRAME":1, "OBJECT":1};
goog.dom.PREDEFINED_TAG_VALUES_ = {"IMG":" ", "BR":"\n"};
goog.dom.isFocusableTabIndex = function(element) {
  var attrNode = element.getAttributeNode("tabindex");
  if(attrNode && attrNode.specified) {
    var index = element.tabIndex;
    return goog.isNumber(index) && index >= 0 && index < 32768
  }
  return false
};
goog.dom.setFocusableTabIndex = function(element, enable) {
  if(enable) {
    element.tabIndex = 0
  }else {
    element.tabIndex = -1;
    element.removeAttribute("tabIndex")
  }
};
goog.dom.getTextContent = function(node) {
  var textContent;
  if(goog.dom.BrowserFeature.CAN_USE_INNER_TEXT && "innerText" in node) {
    textContent = goog.string.canonicalizeNewlines(node.innerText)
  }else {
    var buf = [];
    goog.dom.getTextContent_(node, buf, true);
    textContent = buf.join("")
  }
  textContent = textContent.replace(/ \xAD /g, " ").replace(/\xAD/g, "");
  textContent = textContent.replace(/\u200B/g, "");
  if(!goog.dom.BrowserFeature.CAN_USE_INNER_TEXT) {
    textContent = textContent.replace(/ +/g, " ")
  }
  if(textContent != " ") {
    textContent = textContent.replace(/^\s*/, "")
  }
  return textContent
};
goog.dom.getRawTextContent = function(node) {
  var buf = [];
  goog.dom.getTextContent_(node, buf, false);
  return buf.join("")
};
goog.dom.getTextContent_ = function(node, buf, normalizeWhitespace) {
  if(node.nodeName in goog.dom.TAGS_TO_IGNORE_) {
  }else {
    if(node.nodeType == goog.dom.NodeType.TEXT) {
      if(normalizeWhitespace) {
        buf.push(String(node.nodeValue).replace(/(\r\n|\r|\n)/g, ""))
      }else {
        buf.push(node.nodeValue)
      }
    }else {
      if(node.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
        buf.push(goog.dom.PREDEFINED_TAG_VALUES_[node.nodeName])
      }else {
        var child = node.firstChild;
        while(child) {
          goog.dom.getTextContent_(child, buf, normalizeWhitespace);
          child = child.nextSibling
        }
      }
    }
  }
};
goog.dom.getNodeTextLength = function(node) {
  return goog.dom.getTextContent(node).length
};
goog.dom.getNodeTextOffset = function(node, opt_offsetParent) {
  var root = opt_offsetParent || goog.dom.getOwnerDocument(node).body;
  var buf = [];
  while(node && node != root) {
    var cur = node;
    while(cur = cur.previousSibling) {
      buf.unshift(goog.dom.getTextContent(cur))
    }
    node = node.parentNode
  }
  return goog.string.trimLeft(buf.join("")).replace(/ +/g, " ").length
};
goog.dom.getNodeAtOffset = function(parent, offset, opt_result) {
  var stack = [parent], pos = 0, cur;
  while(stack.length > 0 && pos < offset) {
    cur = stack.pop();
    if(cur.nodeName in goog.dom.TAGS_TO_IGNORE_) {
    }else {
      if(cur.nodeType == goog.dom.NodeType.TEXT) {
        var text = cur.nodeValue.replace(/(\r\n|\r|\n)/g, "").replace(/ +/g, " ");
        pos += text.length
      }else {
        if(cur.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
          pos += goog.dom.PREDEFINED_TAG_VALUES_[cur.nodeName].length
        }else {
          for(var i = cur.childNodes.length - 1;i >= 0;i--) {
            stack.push(cur.childNodes[i])
          }
        }
      }
    }
  }
  if(goog.isObject(opt_result)) {
    opt_result.remainder = cur ? cur.nodeValue.length + offset - pos - 1 : 0;
    opt_result.node = cur
  }
  return cur
};
goog.dom.isNodeList = function(val) {
  if(val && typeof val.length == "number") {
    if(goog.isObject(val)) {
      return typeof val.item == "function" || typeof val.item == "string"
    }else {
      if(goog.isFunction(val)) {
        return typeof val.item == "function"
      }
    }
  }
  return false
};
goog.dom.getAncestorByTagNameAndClass = function(element, opt_tag, opt_class) {
  var tagName = opt_tag ? opt_tag.toUpperCase() : null;
  return goog.dom.getAncestor(element, function(node) {
    return(!tagName || node.nodeName == tagName) && (!opt_class || goog.dom.classes.has(node, opt_class))
  }, true)
};
goog.dom.getAncestorByClass = function(element, opt_class) {
  return goog.dom.getAncestorByTagNameAndClass(element, null, opt_class)
};
goog.dom.getAncestor = function(element, matcher, opt_includeNode, opt_maxSearchSteps) {
  if(!opt_includeNode) {
    element = element.parentNode
  }
  var ignoreSearchSteps = opt_maxSearchSteps == null;
  var steps = 0;
  while(element && (ignoreSearchSteps || steps <= opt_maxSearchSteps)) {
    if(matcher(element)) {
      return element
    }
    element = element.parentNode;
    steps++
  }
  return null
};
goog.dom.getActiveElement = function(doc) {
  try {
    return doc && doc.activeElement
  }catch(e) {
  }
  return null
};
goog.dom.DomHelper = function(opt_document) {
  this.document_ = opt_document || goog.global.document || document
};
goog.dom.DomHelper.prototype.getDomHelper = goog.dom.getDomHelper;
goog.dom.DomHelper.prototype.setDocument = function(document) {
  this.document_ = document
};
goog.dom.DomHelper.prototype.getDocument = function() {
  return this.document_
};
goog.dom.DomHelper.prototype.getElement = function(element) {
  if(goog.isString(element)) {
    return this.document_.getElementById(element)
  }else {
    return element
  }
};
goog.dom.DomHelper.prototype.$ = goog.dom.DomHelper.prototype.getElement;
goog.dom.DomHelper.prototype.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(this.document_, opt_tag, opt_class, opt_el)
};
goog.dom.DomHelper.prototype.getElementsByClass = function(className, opt_el) {
  var doc = opt_el || this.document_;
  return goog.dom.getElementsByClass(className, doc)
};
goog.dom.DomHelper.prototype.getElementByClass = function(className, opt_el) {
  var doc = opt_el || this.document_;
  return goog.dom.getElementByClass(className, doc)
};
goog.dom.DomHelper.prototype.$$ = goog.dom.DomHelper.prototype.getElementsByTagNameAndClass;
goog.dom.DomHelper.prototype.setProperties = goog.dom.setProperties;
goog.dom.DomHelper.prototype.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize(opt_window || this.getWindow())
};
goog.dom.DomHelper.prototype.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(this.getWindow())
};
goog.dom.Appendable;
goog.dom.DomHelper.prototype.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(this.document_, arguments)
};
goog.dom.DomHelper.prototype.$dom = goog.dom.DomHelper.prototype.createDom;
goog.dom.DomHelper.prototype.createElement = function(name) {
  return this.document_.createElement(name)
};
goog.dom.DomHelper.prototype.createTextNode = function(content) {
  return this.document_.createTextNode(content)
};
goog.dom.DomHelper.prototype.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(this.document_, rows, columns, !!opt_fillWithNbsp)
};
goog.dom.DomHelper.prototype.htmlToDocumentFragment = function(htmlString) {
  return goog.dom.htmlToDocumentFragment_(this.document_, htmlString)
};
goog.dom.DomHelper.prototype.getCompatMode = function() {
  return this.isCss1CompatMode() ? "CSS1Compat" : "BackCompat"
};
goog.dom.DomHelper.prototype.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(this.document_)
};
goog.dom.DomHelper.prototype.getWindow = function() {
  return goog.dom.getWindow_(this.document_)
};
goog.dom.DomHelper.prototype.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(this.document_)
};
goog.dom.DomHelper.prototype.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(this.document_)
};
goog.dom.DomHelper.prototype.appendChild = goog.dom.appendChild;
goog.dom.DomHelper.prototype.append = goog.dom.append;
goog.dom.DomHelper.prototype.removeChildren = goog.dom.removeChildren;
goog.dom.DomHelper.prototype.insertSiblingBefore = goog.dom.insertSiblingBefore;
goog.dom.DomHelper.prototype.insertSiblingAfter = goog.dom.insertSiblingAfter;
goog.dom.DomHelper.prototype.removeNode = goog.dom.removeNode;
goog.dom.DomHelper.prototype.replaceNode = goog.dom.replaceNode;
goog.dom.DomHelper.prototype.flattenElement = goog.dom.flattenElement;
goog.dom.DomHelper.prototype.getFirstElementChild = goog.dom.getFirstElementChild;
goog.dom.DomHelper.prototype.getLastElementChild = goog.dom.getLastElementChild;
goog.dom.DomHelper.prototype.getNextElementSibling = goog.dom.getNextElementSibling;
goog.dom.DomHelper.prototype.getPreviousElementSibling = goog.dom.getPreviousElementSibling;
goog.dom.DomHelper.prototype.getNextNode = goog.dom.getNextNode;
goog.dom.DomHelper.prototype.getPreviousNode = goog.dom.getPreviousNode;
goog.dom.DomHelper.prototype.isNodeLike = goog.dom.isNodeLike;
goog.dom.DomHelper.prototype.contains = goog.dom.contains;
goog.dom.DomHelper.prototype.getOwnerDocument = goog.dom.getOwnerDocument;
goog.dom.DomHelper.prototype.getFrameContentDocument = goog.dom.getFrameContentDocument;
goog.dom.DomHelper.prototype.getFrameContentWindow = goog.dom.getFrameContentWindow;
goog.dom.DomHelper.prototype.setTextContent = goog.dom.setTextContent;
goog.dom.DomHelper.prototype.findNode = goog.dom.findNode;
goog.dom.DomHelper.prototype.findNodes = goog.dom.findNodes;
goog.dom.DomHelper.prototype.getTextContent = goog.dom.getTextContent;
goog.dom.DomHelper.prototype.getNodeTextLength = goog.dom.getNodeTextLength;
goog.dom.DomHelper.prototype.getNodeTextOffset = goog.dom.getNodeTextOffset;
goog.dom.DomHelper.prototype.getAncestorByTagNameAndClass = goog.dom.getAncestorByTagNameAndClass;
goog.dom.DomHelper.prototype.getAncestorByClass = goog.dom.getAncestorByClass;
goog.dom.DomHelper.prototype.getAncestor = goog.dom.getAncestor;
// Input 24
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string.StringBuffer");
goog.require("goog.string");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape(match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__10265 = s;
      var limit__10266 = limit;
      var parts__10267 = cljs.core.PersistentVector.EMPTY;
      while(true) {
        if(cljs.core._EQ_.call(null, limit__10266, 1)) {
          return cljs.core.conj.call(null, parts__10267, s__10265)
        }else {
          var temp__3971__auto____10268 = cljs.core.re_find.call(null, re, s__10265);
          if(cljs.core.truth_(temp__3971__auto____10268)) {
            var m__10269 = temp__3971__auto____10268;
            var index__10270 = s__10265.indexOf(m__10269);
            var G__10271 = s__10265.substring(index__10270 + cljs.core.count.call(null, m__10269));
            var G__10272 = limit__10266 - 1;
            var G__10273 = cljs.core.conj.call(null, parts__10267, s__10265.substring(0, index__10270));
            s__10265 = G__10271;
            limit__10266 = G__10272;
            parts__10267 = G__10273;
            continue
          }else {
            return cljs.core.conj.call(null, parts__10267, s__10265)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim(s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft(s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight(s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__10277 = s.length;
  while(true) {
    if(index__10277 === 0) {
      return""
    }else {
      var ch__10278 = cljs.core._lookup.call(null, s, index__10277 - 1, null);
      if(function() {
        var or__3824__auto____10279 = cljs.core._EQ_.call(null, ch__10278, "\n");
        if(or__3824__auto____10279) {
          return or__3824__auto____10279
        }else {
          return cljs.core._EQ_.call(null, ch__10278, "\r")
        }
      }()) {
        var G__10280 = index__10277 - 1;
        index__10277 = G__10280;
        continue
      }else {
        return s.substring(0, index__10277)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__10284 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3824__auto____10285 = cljs.core.not.call(null, s__10284);
    if(or__3824__auto____10285) {
      return or__3824__auto____10285
    }else {
      var or__3824__auto____10286 = cljs.core._EQ_.call(null, "", s__10284);
      if(or__3824__auto____10286) {
        return or__3824__auto____10286
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__10284)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__10293 = new goog.string.StringBuffer;
  var length__10294 = s.length;
  var index__10295 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__10294, index__10295)) {
      return buffer__10293.toString()
    }else {
      var ch__10296 = s.charAt(index__10295);
      var temp__3971__auto____10297 = cljs.core._lookup.call(null, cmap, ch__10296, null);
      if(cljs.core.truth_(temp__3971__auto____10297)) {
        var replacement__10298 = temp__3971__auto____10297;
        buffer__10293.append([cljs.core.str(replacement__10298)].join(""))
      }else {
        buffer__10293.append(ch__10296)
      }
      var G__10299 = index__10295 + 1;
      index__10295 = G__10299;
      continue
    }
    break
  }
};
// Input 25
goog.provide("rdfa.stddom");
goog.require("cljs.core");
goog.require("rdfa.dom");
goog.require("goog.dom");
goog.require("clojure.string");
rdfa.stddom.node_list = function node_list(nl) {
  if(!(nl == null)) {
    var index__6203 = nl.length - 1;
    var nodes__6204 = null;
    while(true) {
      if(cljs.core._EQ_.call(null, index__6203, -1)) {
        return nodes__6204
      }else {
        var G__6205 = index__6203 - 1;
        var G__6206 = cljs.core.cons.call(null, nl.item(index__6203), nodes__6204);
        index__6203 = G__6205;
        nodes__6204 = G__6206;
        continue
      }
      break
    }
  }else {
    return null
  }
};
rdfa.stddom.serialize_to_xml = function serialize_to_xml(node) {
  try {
    return(new XMLSerializer).serializeToString(node)
  }catch(e6212) {
    if(cljs.core.instance_QMARK_.call(null, Exception, e6212)) {
      var e__6213 = e6212;
      try {
        return node.xml
      }catch(e6214) {
        if(cljs.core.instance_QMARK_.call(null, Exception, e6214)) {
          var e__6215 = e6214;
          return null
        }else {
          if("\ufdd0'else") {
            throw e6214;
          }else {
            return null
          }
        }
      }
    }else {
      if("\ufdd0'else") {
        throw e6212;
      }else {
        return null
      }
    }
  }
};
Node.prototype.rdfa$dom$DomAccess$ = true;
Node.prototype.rdfa$dom$DomAccess$get_name$arity$1 = function(this$) {
  return this$.nodeName
};
Node.prototype.rdfa$dom$DomAccess$get_attr$arity$2 = function(this$, attr_name) {
  if(cljs.core.truth_(function() {
    var and__3822__auto____6216 = this$.hasAttribute;
    if(cljs.core.truth_(and__3822__auto____6216)) {
      return this$.hasAttribute(attr_name)
    }else {
      return and__3822__auto____6216
    }
  }())) {
    return this$.getAttribute(attr_name)
  }else {
    return null
  }
};
Node.prototype.rdfa$dom$DomAccess$get_ns_map$arity$1 = function(this$) {
  return cljs.core.into.call(null, cljs.core.ObjMap.EMPTY, function() {
    var iter__2462__auto____6223 = function iter__6217(s__6218) {
      return new cljs.core.LazySeq(null, false, function() {
        var s__6218__6221 = s__6218;
        while(true) {
          if(cljs.core.seq.call(null, s__6218__6221)) {
            var attr__6222 = cljs.core.first.call(null, s__6218__6221);
            if(cljs.core._EQ_.call(null, cljs.core.subs.call(null, rdfa.dom.get_name.call(null, attr__6222), 0, 6), "xmlns:")) {
              return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([cljs.core.subs.call(null, rdfa.dom.get_name.call(null, attr__6222), 6), attr__6222.value], true), iter__6217.call(null, cljs.core.rest.call(null, s__6218__6221)))
            }else {
              var G__6250 = cljs.core.rest.call(null, s__6218__6221);
              s__6218__6221 = G__6250;
              continue
            }
          }else {
            return null
          }
          break
        }
      }, null)
    };
    return iter__2462__auto____6223.call(null, rdfa.stddom.node_list.call(null, this$.attributes))
  }())
};
Node.prototype.rdfa$dom$DomAccess$is_root_QMARK_$arity$1 = function(this$) {
  var temp__3971__auto____6224 = this$.ownerDocument;
  if(cljs.core.truth_(temp__3971__auto____6224)) {
    var owner_document__6225 = temp__3971__auto____6224;
    return cljs.core._EQ_.call(null, this$, owner_document__6225.documentElement)
  }else {
    return null
  }
};
Node.prototype.rdfa$dom$DomAccess$find_by_tag$arity$2 = function(this$, tag) {
  return rdfa.stddom.node_list.call(null, this$.getElementsByTagName(tag))
};
Node.prototype.rdfa$dom$DomAccess$get_child_elements$arity$1 = function(this$) {
  return cljs.core.filter.call(null, function(p1__6207_SHARP_) {
    return cljs.core._EQ_.call(null, p1__6207_SHARP_.nodeType, Node.ELEMENT_NODE)
  }, rdfa.stddom.node_list.call(null, this$.childNodes))
};
Node.prototype.rdfa$dom$DomAccess$get_text$arity$1 = function(this$) {
  var get_values__6226 = function get_values(node) {
    return cljs.core.cons.call(null, cljs.core._EQ_.call(null, node.nodeType, Node.TEXT_NODE) ? node.nodeValue : null, cljs.core.map.call(null, get_values, rdfa.stddom.node_list.call(null, node.childNodes)))
  };
  return clojure.string.join.call(null, cljs.core.flatten.call(null, get_values__6226.call(null, this$)))
};
Node.prototype.rdfa$dom$DomAccess$get_inner_xml$arity$3 = function(this$, xmlns_map, lang) {
  var nodes__6227 = rdfa.stddom.node_list.call(null, this$.childNodes);
  var frag__6228 = goog.dom.htmlToDocumentFragment("");
  while(true) {
    if(cljs.core.seq.call(null, nodes__6227)) {
      var G__6251 = cljs.core.rest.call(null, nodes__6227);
      var G__6252 = function() {
        var node__6229 = cljs.core.first.call(null, nodes__6227);
        if(cljs.core._EQ_.call(null, node__6229.nodeType, Node.ELEMENT_NODE)) {
          if(cljs.core.truth_(cljs.core.not_empty.call(null, lang))) {
            node__6229.setAttribute("xml:lang", lang)
          }else {
          }
          var G__6230__6231 = cljs.core.seq.call(null, xmlns_map);
          if(G__6230__6231) {
            var G__6233__6235 = cljs.core.first.call(null, G__6230__6231);
            var vec__6234__6236 = G__6233__6235;
            var pfx__6237 = cljs.core.nth.call(null, vec__6234__6236, 0, null);
            var iri__6238 = cljs.core.nth.call(null, vec__6234__6236, 1, null);
            var G__6230__6239 = G__6230__6231;
            var G__6233__6240 = G__6233__6235;
            var G__6230__6241 = G__6230__6239;
            while(true) {
              var vec__6242__6243 = G__6233__6240;
              var pfx__6244 = cljs.core.nth.call(null, vec__6242__6243, 0, null);
              var iri__6245 = cljs.core.nth.call(null, vec__6242__6243, 1, null);
              var G__6230__6246 = G__6230__6241;
              var qname__6247 = [cljs.core.str("xmlns"), cljs.core.str(cljs.core.truth_(pfx__6244) ? ":" : null), cljs.core.str(pfx__6244)].join("");
              node__6229.setAttribute(qname__6247, iri__6245);
              var temp__3974__auto____6248 = cljs.core.next.call(null, G__6230__6246);
              if(temp__3974__auto____6248) {
                var G__6230__6249 = temp__3974__auto____6248;
                var G__6253 = cljs.core.first.call(null, G__6230__6249);
                var G__6254 = G__6230__6249;
                G__6233__6240 = G__6253;
                G__6230__6241 = G__6254;
                continue
              }else {
              }
              break
            }
          }else {
          }
          frag__6228.appendChild(node__6229)
        }else {
        }
        return frag__6228
      }();
      nodes__6227 = G__6251;
      frag__6228 = G__6252;
      continue
    }else {
      return rdfa.stddom.serialize_to_xml.call(null, frag__6228)
    }
    break
  }
};
