/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.javafx;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jpedal.color.PdfPaint;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.render.ShapeFactory;
import org.jpedal.render.output.OutputShape;

public class JavaFXShape
extends OutputShape
implements ShapeFactory {
    public JavaFXShape(int n, int n2, int n3, float f, Shape shape, GraphicsState graphicsState, AffineTransform affineTransform, Point2D point2D, Rectangle rectangle, int n4, int n5, int n6, PdfPageData pdfPageData, int n7, boolean bl) {
        super(n, n2, f, shape, graphicsState, affineTransform, point2D, rectangle, n4, n5, n6, pdfPageData, n7, bl);
        this.shapeCount = n3;
        this.generateShapeFromG2Data(graphicsState, affineTransform, rectangle);
    }

    @Override
    protected void beginShape() {
        this.pathCommands.add("\n\t\t/**");
        this.pathCommands.add("\t* Shape Properties for path_" + this.shapeCount);
        this.pathCommands.add("\t*/ ");
        this.pathCommands.add("\tPath path_" + this.shapeCount + " = new Path();");
        this.pathCommands.add("\tObservableList<PathElement> shape_" + this.shapeCount + " = path_" + this.shapeCount + ".getElements();");
        this.pathCommands.add("\taddToGroup.add(path_" + this.shapeCount + ");");
    }

    @Override
    protected void lineTo(double[] dArray) {
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new LineTo(" + this.coordsToStringParam(dArray, 2) + "));");
    }

    @Override
    protected void bezierCurveTo(double[] dArray) {
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new CubicCurveTo(" + this.coordsToStringParam(dArray, 6) + "));");
    }

    @Override
    protected void quadraticCurveTo(double[] dArray) {
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new QuadCurveTo(" + this.coordsToStringParam(dArray, 4) + "));");
    }

    @Override
    protected void moveTo(double[] dArray) {
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new MoveTo(" + this.coordsToStringParam(dArray, 2) + "));");
    }

    @Override
    protected void drawCropBox() {
        this.pathCommands.clear();
        this.pathCommands.add("\n\t\t/**");
        this.pathCommands.add("\t* Crop Box properties");
        this.pathCommands.add("\t*/ ");
        this.pathCommands.add("\tPath path_" + this.shapeCount + " = new Path();");
        this.pathCommands.add("\tObservableList<PathElement> shape_" + this.shapeCount + " = path_" + this.shapeCount + ".getElements();");
        this.pathCommands.add("\taddToGroup.add(path_" + this.shapeCount + ");");
        double[] dArray = new double[]{this.cropBox.x, this.cropBox.y};
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new MoveTo(" + this.convertCoords(dArray, 2) + "));");
        dArray[0] = dArray[0] + (double)this.cropBox.width;
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new LineTo(" + this.convertCoords(dArray, 2) + "));");
        dArray[1] = dArray[1] + (double)this.cropBox.height;
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new LineTo(" + this.convertCoords(dArray, 2) + "));");
        dArray[0] = dArray[0] - (double)this.cropBox.width;
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new LineTo(" + this.convertCoords(dArray, 2) + "));");
    }

    @Override
    protected void applyGraphicsStateToPath(GraphicsState graphicsState) {
        Object object;
        int n = graphicsState.getFillType();
        if (n == 2 || n == 3) {
            object = graphicsState.getNonstrokeColor();
            this.pathCommands.add("\tpath_" + this.shapeCount + ".setStroke(Color." + JavaFXShape.rgbToCSSColor(object.getRGB()) + ");");
            this.pathCommands.add("\tpath_" + this.shapeCount + ".setFill(Color." + JavaFXShape.rgbToCSSColor(object.getRGB()) + ");");
            this.currentColor = object.getRGB();
        }
        if (n == 1 || n == 3) {
            object = (BasicStroke)graphicsState.getStroke();
            if (((BasicStroke)object).getLineWidth() != 1.0f) {
                this.pathCommands.add("\tpath_" + this.shapeCount + ".setStrokeWidth(" + (double)((BasicStroke)object).getLineWidth() * (double)this.scaling + ");");
            }
            if (((BasicStroke)object).getMiterLimit() != 10.0f) {
                this.pathCommands.add("\tpath_" + this.shapeCount + ".setStrokeMiterLimit(" + (double)((BasicStroke)object).getLineWidth() * (double)this.scaling + ");");
            }
            this.pathCommands.add("\tpath_" + this.shapeCount + ".setStrokeLineCap(StrokeLineCap." + JavaFXShape.determineLineCap((BasicStroke)object) + ");");
            this.pathCommands.add("\tpath_" + this.shapeCount + ".setStrokeLineJoin(StrokeLineJoin." + JavaFXShape.determineLineJoin((BasicStroke)object) + ");");
            PdfPaint pdfPaint = graphicsState.getStrokeColor();
            this.pathCommands.add("\tpath_" + this.shapeCount + ".setStroke(Color." + JavaFXShape.rgbToCSSColor(pdfPaint.getRGB()) + ");");
        }
    }

    protected static String determineLineCap(BasicStroke basicStroke) {
        String string;
        switch (basicStroke.getEndCap()) {
            case 1: {
                string = "ROUND";
                break;
            }
            case 2: {
                string = "SQUARE";
                break;
            }
            default: {
                string = "BUTT";
            }
        }
        return string;
    }

    protected static String determineLineJoin(BasicStroke basicStroke) {
        String string;
        switch (basicStroke.getLineJoin()) {
            case 1: {
                string = "ROUND";
                break;
            }
            case 2: {
                string = "BEVEL";
                break;
            }
            default: {
                string = "MITER";
            }
        }
        return string;
    }

    @Override
    public void setShapeNumber(int n) {
        this.shapeCount = n;
    }
}

