/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.JPedalCustomDrawObject;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.ImageObject;
import org.jpedal.render.RenderUtils;
import org.jpedal.render.TextObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;

public class SwingDisplay
extends BaseDisplay
implements DynamicVectorRenderer {
    private static boolean drawPDFShapes = true;
    boolean ignoreHighlight = false;
    private boolean noRepaint = false;
    private int lastItemPainted = -1;
    private boolean optimsePainting = false;
    private boolean needsHorizontalInvert = false;
    private boolean needsVerticalInvert = false;
    private int pageX1 = 9999;
    private int pageX2 = -9999;
    private int pageY1 = -9999;
    private int pageY2 = 9999;
    private boolean highlightsNeedToBeGenerated = false;
    private BufferedImage singleImage = null;
    private int imageCount = 0;
    private static final int defaultSize = 5000;
    int endItem = -1;
    private static RenderingHints hints = null;
    private final Map cachedWidths = new HashMap(10);
    private final Map cachedHeights = new HashMap(10);
    private Map fonts = new HashMap(50);
    private Map fontsUsed = new HashMap(50);
    protected GlyphFactory factory = null;
    private PdfGlyphs glyphs;
    boolean isType3Font = false;
    private Map imageID = new HashMap(10);
    private final Map imageIDtoName = new HashMap(10);
    private Map storedImageValues = new HashMap(10);
    private int[] textHighlightsX;
    private int[] textHighlightsWidth;
    private int[] textHighlightsHeight;
    boolean stopG2setting;
    private float[] x_coord;
    private float[] y_coord;
    private Map largeImages = new WeakHashMap(10);
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    private Vector_Object pageObjects;
    private Vector_Int shapeType;
    private Vector_Rectangle fontBounds;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Int imageOptions;
    private Vector_Int TRvalues;
    private Vector_Int fs;
    private Vector_Int lw;
    private Vector_Shape clips;
    private Vector_Int objectType;
    private Vector_Object javaObjects;
    private Vector_Int textFillType;
    private Vector_Float opacity;
    private int currentItem = 0;
    private int lastFillTextCol;
    private int lastFillCol;
    private int lastStrokeCol;
    private Stroke lastStroke = null;
    private double[] lastAf = new double[4];
    private int lastTR = 2;
    private int lastFS = -1;
    private int lastLW = -1;
    private boolean resetTextColors = true;
    private boolean fillSet = false;
    private boolean strokeSet = false;
    private boolean needsHighlights = true;
    private int paintThreadCount = 0;
    private int paintThreadID = 0;
    private boolean[] drawnHighlights;
    private boolean hasOCR = false;
    protected int type = 1;
    private double minX = -1.0;
    private double minY = -1.0;
    private double maxX = -1.0;
    private double maxY = -1.0;
    private boolean renderFailed;
    private Container frame = null;
    private static boolean userAlerted;

    public SwingDisplay() {
    }

    void setupArrays(int n) {
        this.x_coord = new float[n];
        this.y_coord = new float[n];
        this.text_color = new Vector_Object(n);
        this.textFillType = new Vector_Int(n);
        this.stroke_color = new Vector_Object(n);
        this.fill_color = new Vector_Object(n);
        this.stroke = new Vector_Object(n);
        this.pageObjects = new Vector_Object(n);
        this.javaObjects = new Vector_Object(n);
        this.shapeType = new Vector_Int(n);
        this.areas = new Vector_Rectangle(n);
        this.af1 = new Vector_Double(n);
        this.af2 = new Vector_Double(n);
        this.af3 = new Vector_Double(n);
        this.af4 = new Vector_Double(n);
        this.fontBounds = new Vector_Rectangle(n);
        this.clips = new Vector_Shape(n);
        this.objectType = new Vector_Int(n);
    }

    public SwingDisplay(int n, boolean bl, int n2, ObjectStore objectStore) {
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.addBackground = bl;
        this.setupArrays(n2);
    }

    public SwingDisplay(int n, ObjectStore objectStore, boolean bl) {
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.isPrinting = bl;
        this.setupArrays(5000);
    }

    @Override
    public void setOptimsePainting(boolean bl) {
        this.optimsePainting = bl;
        this.lastItemPainted = -1;
    }

    private void renderHighlight(Rectangle rectangle, Graphics2D graphics2D) {
        if (rectangle != null && !this.ignoreHighlight) {
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(null);
            Composite composite = graphics2D.getComposite();
            Paint paint = graphics2D.getPaint();
            graphics2D.setComposite(AlphaComposite.getInstance(3, PdfDecoder.highlightComposite));
            if (invertHighlight) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.setXORMode(Color.BLACK);
            } else {
                graphics2D.setPaint(DecoderOptions.highlightColor);
            }
            graphics2D.fill(rectangle);
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
            this.needsHighlights = false;
            graphics2D.setClip(shape);
        }
    }

    @Override
    public void stopG2HintSetting(boolean bl) {
        this.stopG2setting = bl;
    }

    @Override
    public void flush() {
        this.singleImage = null;
        this.imageCount = 0;
        this.lastFS = -1;
        if (this.shapeType != null) {
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord = new float[5000];
            this.y_coord = new float[5000];
            this.textFillType.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            if (this.TRvalues != null) {
                this.TRvalues = null;
            }
            if (this.imageOptions != null) {
                this.imageOptions = null;
            }
            if (this.fs != null) {
                this.fs = null;
            }
            if (this.lw != null) {
                this.lw = null;
            }
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
            this.fontBounds.clear();
            if (this.opacity != null) {
                this.opacity = null;
            }
            if (this.isPrinting) {
                this.largeImages.clear();
            }
            this.endItem = -1;
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
        this.fillSet = false;
        this.strokeSet = false;
        this.fonts.clear();
        this.fontsUsed.clear();
        this.imageID.clear();
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.lastScaling = 0.0f;
    }

    @Override
    public void dispose() {
        this.singleImage = null;
        this.shapeType = null;
        this.pageObjects = null;
        this.objectType = null;
        this.areas = null;
        this.clips = null;
        this.x_coord = null;
        this.y_coord = null;
        this.textFillType = null;
        this.text_color = null;
        this.fill_color = null;
        this.stroke_color = null;
        this.stroke = null;
        this.TRvalues = null;
        this.imageOptions = null;
        this.fs = null;
        this.lw = null;
        this.af1 = null;
        this.af2 = null;
        this.af3 = null;
        this.af4 = null;
        this.fontBounds = null;
        this.opacity = null;
        this.largeImages = null;
        this.lastClip = null;
        this.lastStroke = null;
        this.lastAf = null;
        this.fonts = null;
        this.fontsUsed = null;
        this.imageID = null;
        this.storedImageValues = null;
    }

    @Override
    public Rectangle paint(Rectangle[] rectangleArray, AffineTransform affineTransform, Rectangle rectangle) {
        Object object;
        int n;
        Shape shape;
        Vector_Rectangle vector_Rectangle = null;
        HashMap<Object, String> hashMap = null;
        if (this.hasOCR) {
            vector_Rectangle = new Vector_Rectangle(4000);
            hashMap = new HashMap<Object, String>(10);
        }
        int n2 = ++this.paintThreadID;
        ++this.paintThreadCount;
        if (rectangleArray != null) {
            this.drawnHighlights = new boolean[rectangleArray.length];
            for (int i = 0; i != this.drawnHighlights.length; ++i) {
                this.drawnHighlights[i] = false;
            }
        }
        if (this.paintThreadCount > 1) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (n2 != this.paintThreadID) {
                --this.paintThreadCount;
                return null;
            }
        }
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Rectangle rectangle2 = null;
        int[] nArray = this.objectType.get();
        int[] nArray2 = this.textFillType.get();
        int n4 = this.currentItem;
        Area[] areaArray = this.clips.get();
        double[] dArray = this.af1.get();
        int[] nArray3 = null;
        if (this.fs != null) {
            nArray3 = this.fs.get();
        }
        Rectangle[] rectangleArray2 = this.fontBounds.get();
        int[] nArray4 = null;
        if (this.lw != null) {
            nArray4 = this.lw.get();
        }
        double[] dArray2 = this.af2.get();
        double[] dArray3 = this.af3.get();
        double[] dArray4 = this.af4.get();
        Object[] objectArray = this.text_color.get();
        Object[] objectArray2 = this.fill_color.get();
        Object[] objectArray3 = this.stroke_color.get();
        Object[] objectArray4 = this.pageObjects.get();
        Object[] objectArray5 = this.javaObjects.get();
        Object[] objectArray6 = this.stroke.get();
        int[] nArray5 = this.shapeType.get();
        float[] fArray = null;
        if (this.opacity != null) {
            fArray = this.opacity.get();
        }
        int[] nArray6 = null;
        if (this.TRvalues != null) {
            nArray6 = this.TRvalues.get();
        }
        Rectangle[] rectangleArray3 = null;
        if (this.areas != null) {
            rectangleArray3 = this.areas.get();
        }
        int[] nArray7 = null;
        if (this.imageOptions != null) {
            nArray7 = this.imageOptions.get();
        }
        if ((shape = this.g2.getClip()) != null) {
            rectangle2 = shape.getBounds();
        }
        boolean bl = false;
        Shape shape2 = this.g2.getClip();
        Area area = null;
        boolean bl2 = false;
        if (this.noRepaint) {
            this.noRepaint = false;
        } else if (this.lastItemPainted == -1) {
            this.paintBackground(rectangle2);
        }
        AffineTransform affineTransform2 = this.g2.getTransform();
        if (affineTransform != null) {
            this.g2.transform(affineTransform);
            shape2 = this.g2.getClip();
        }
        this.minX = -1.0;
        this.minY = -1.0;
        this.maxX = -1.0;
        this.maxY = -1.0;
        int n5 = 2;
        int n6 = 0;
        float f5 = 1.0f;
        float f6 = 1.0f;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = -1;
        int n11 = 0;
        int n12 = -1;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        PdfPaint pdfPaint = null;
        PdfPaint pdfPaint2 = null;
        PdfPaint pdfPaint3 = null;
        PdfPaint pdfPaint4 = null;
        Stroke stroke = null;
        if (this.colorsLocked) {
            pdfPaint4 = this.strokeCol;
            pdfPaint3 = this.fillCol;
        }
        if (this.highlightsNeedToBeGenerated && rectangleArray3 != null && rectangleArray != null) {
            this.generateHighlights(this.g2, n4, nArray, objectArray4, f, f2, f3, f4, dArray, dArray2, dArray3, dArray4, nArray3, rectangleArray2);
        }
        block38: for (n = 0; drawPDFShapes && n < n4; ++n) {
            int n20;
            boolean bl3 = false;
            int n21 = nArray[n];
            if (n21 == 27) continue;
            object = null;
            if (n2 != this.paintThreadID) {
                --this.paintThreadCount;
                return null;
            }
            if (n21 <= 0) continue;
            float f7 = this.x_coord[n];
            float f8 = this.y_coord[n];
            Object object2 = objectArray4[n];
            if (n21 == 29) {
                n21 = 3;
                n20 = (Integer)object2;
                object2 = objectArray4[n20];
            } else {
                n20 = -1;
            }
            if (object == null) {
                object = SwingDisplay.getObjectArea(dArray, nArray3, dArray2, dArray3, dArray4, objectArray4, rectangleArray3, n21, f7, f8, n10, n12, n);
            }
            bl3 = false;
            if (object != null && n21 < 7 && rectangle != null && !rectangle.intersects((Rectangle)object) && ((Rectangle)object).width > 0) {
                bl3 = true;
            }
            if (bl3 || this.lastItemPainted != -1 && n < this.lastItemPainted) {
                switch (n21) {
                    case 2: {
                        ++n9;
                        break;
                    }
                    case 3: {
                        ++n7;
                        break;
                    }
                    case 29: {
                        ++n7;
                        break;
                    }
                    case 7: {
                        ++n8;
                        break;
                    }
                    case 21: {
                        ++n10;
                        break;
                    }
                    case 22: {
                        ++n11;
                        break;
                    }
                    case 10: {
                        ++n13;
                        break;
                    }
                    case 11: {
                        ++n15;
                        break;
                    }
                    case 12: {
                        ++n16;
                        break;
                    }
                    case 14: {
                        ++n14;
                        break;
                    }
                    case 15: {
                        ++n17;
                    }
                }
                continue;
            }
            if (!bl && !this.stopG2setting) {
                this.g2.setRenderingHints(hints);
                bl = true;
            }
            ++n3;
            if (n5 == 4) {
                this.needsHighlights = true;
            }
            Rectangle rectangle3 = null;
            switch (n21) {
                case 2: {
                    if (bl2) {
                        RenderUtils.renderClip(area, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    Shape shape3 = null;
                    if (this.endItem != -1 && this.endItem < n) {
                        shape3 = this.g2.getClip();
                        this.g2.setClip(shape2);
                    }
                    this.renderShape(shape2, nArray5[n9], pdfPaint4, pdfPaint3, stroke, (Shape)object2, f6, f5);
                    if (this.endItem != -1 && this.endItem < n) {
                        this.g2.setClip(shape3);
                    }
                    ++n9;
                    continue block38;
                }
                case 1: {
                    Object object3;
                    if (bl2) {
                        RenderUtils.renderClip(area, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    if (!invertHighlight) {
                        rectangle3 = this.setHighlightForGlyph((Rectangle)object, rectangleArray);
                    }
                    if (this.hasOCR && rectangle3 != null && hashMap.get(object3 = rectangle3.x + " " + rectangle3.y) == null) {
                        hashMap.put(object3, "x");
                        vector_Rectangle.addElement(rectangle3);
                    }
                    object3 = this.g2.getTransform();
                    this.renderHighlight(rectangle3, this.g2);
                    this.g2.transform(new AffineTransform(dArray[n12], dArray2[n12], -dArray3[n12], -dArray4[n12], (double)f7, (double)f8));
                    this.renderText(f7, f8, n5, (Area)object2, rectangle3, pdfPaint, pdfPaint2, f6, f5);
                    this.g2.setTransform((AffineTransform)object3);
                    continue block38;
                }
                case 4: {
                    Object object4;
                    if (bl2) {
                        RenderUtils.renderClip(area, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    if (n12 == -1) continue block38;
                    AffineTransform affineTransform3 = new AffineTransform(dArray[n12], dArray2[n12], dArray3[n12], dArray4[n12], (double)f7, (double)f8);
                    if (!invertHighlight) {
                        rectangle3 = this.setHighlightForGlyph((Rectangle)object, rectangleArray);
                    }
                    if (this.hasOCR && rectangle3 != null && hashMap.get(object4 = rectangle3.x + " " + rectangle3.y) == null) {
                        hashMap.put(object4, "x");
                        vector_Rectangle.addElement(rectangle3);
                    }
                    this.renderHighlight(rectangle3, this.g2);
                    this.renderEmbeddedText(n5, object2, 4, affineTransform3, rectangle3, pdfPaint, pdfPaint2, f6, f5, n6);
                    continue block38;
                }
                case 5: {
                    Object object4;
                    if (bl2) {
                        RenderUtils.renderClip(area, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    AffineTransform affineTransform3 = new AffineTransform(dArray[n12], dArray2[n12], dArray3[n12], dArray4[n12], (double)f7, (double)f8);
                    if (!invertHighlight) {
                        rectangle3 = this.setHighlightForGlyph((Rectangle)object, rectangleArray);
                    }
                    if (this.hasOCR && rectangle3 != null && hashMap.get(object4 = rectangle3.x + " " + rectangle3.y) == null) {
                        hashMap.put(object4, "x");
                        vector_Rectangle.addElement(rectangle3);
                    }
                    this.renderHighlight(rectangle3, this.g2);
                    this.renderEmbeddedText(n5, object2, 5, affineTransform3, rectangle3, pdfPaint, pdfPaint2, f6, f5, n6);
                    continue block38;
                }
                case 6: {
                    Object object4;
                    if (bl2) {
                        RenderUtils.renderClip(area, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    AffineTransform affineTransform3 = new AffineTransform(dArray[n12], dArray2[n12], dArray3[n12], dArray4[n12], (double)f7, (double)f8);
                    if (!invertHighlight) {
                        rectangle3 = this.setHighlightForGlyph((Rectangle)object, rectangleArray);
                    }
                    if (this.hasOCR && rectangle3 != null && hashMap.get(object4 = rectangle3.x + " " + rectangle3.y) == null) {
                        hashMap.put(object4, "x");
                        vector_Rectangle.addElement(rectangle3);
                    }
                    this.renderHighlight(rectangle3, this.g2);
                    this.renderEmbeddedText(n5, object2, 6, affineTransform3, rectangle3, pdfPaint, pdfPaint2, f6, f5, n6);
                    continue block38;
                }
                case 3: {
                    if (bl2) {
                        RenderUtils.renderClip(area, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    this.renderImage(dArray, dArray2, dArray3, dArray4, objectArray4, nArray7, object2, f5, f7, f8, n7, n12, n20, n);
                    ++n7;
                    continue block38;
                }
                case 7: {
                    area = areaArray[n8];
                    bl2 = true;
                    ++n8;
                    continue block38;
                }
                case 9: {
                    ++n12;
                    continue block38;
                }
                case 21: {
                    ++n10;
                    continue block38;
                }
                case 22: {
                    n6 = nArray4[n11];
                    ++n11;
                    continue block38;
                }
                case 10: {
                    int n22 = nArray2[n13];
                    if (n22 == 1) {
                        pdfPaint = (PdfPaint)objectArray[n13];
                    } else {
                        pdfPaint2 = (PdfPaint)objectArray[n13];
                    }
                    ++n13;
                    continue block38;
                }
                case 11: {
                    if (!this.colorsLocked) {
                        pdfPaint3 = (PdfPaint)objectArray2[n15];
                    }
                    ++n15;
                    continue block38;
                }
                case 12: {
                    if (!this.colorsLocked && (pdfPaint4 = (PdfPaint)objectArray3[n16]) != null) {
                        pdfPaint4.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                    }
                    ++n16;
                    continue block38;
                }
                case 14: {
                    stroke = (Stroke)objectArray6[n14];
                    ++n14;
                    continue block38;
                }
                case 15: {
                    n5 = nArray6[n17];
                    ++n17;
                    continue block38;
                }
                case 17: {
                    f6 = fArray[n18];
                    ++n18;
                    continue block38;
                }
                case 18: {
                    f5 = fArray[n18];
                    ++n18;
                    continue block38;
                }
                case 16: {
                    Object object4 = this.g2.getClip();
                    this.g2.setClip(shape2);
                    AffineTransform affineTransform4 = this.g2.getTransform();
                    String string = (String)object2;
                    double[] dArray5 = new double[6];
                    this.g2.getTransform().getMatrix(dArray5);
                    if (dArray5[2] != 0.0) {
                        dArray5[2] = -dArray5[2];
                    }
                    if (dArray5[3] != 0.0) {
                        dArray5[3] = -dArray5[3];
                    }
                    this.g2.setTransform(new AffineTransform(dArray5));
                    Font font = (Font)objectArray5[n19];
                    this.g2.setFont(font);
                    if ((n5 & 2) == 2) {
                        if (pdfPaint2 != null) {
                            pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                        }
                        if (this.customColorHandler != null) {
                            this.customColorHandler.setPaint(this.g2, pdfPaint2, this.pageNumber, this.isPrinting);
                        } else if (PdfDecoder.Helper != null) {
                            PdfDecoder.Helper.setPaint(this.g2, pdfPaint2, this.pageNumber, this.isPrinting);
                        } else {
                            this.g2.setPaint(pdfPaint2);
                        }
                    }
                    if ((n5 & 1) == 1) {
                        if (pdfPaint != null) {
                            pdfPaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                        }
                        if (this.customColorHandler != null) {
                            this.customColorHandler.setPaint(this.g2, pdfPaint2, this.pageNumber, this.isPrinting);
                        } else if (PdfDecoder.Helper != null) {
                            PdfDecoder.Helper.setPaint(this.g2, pdfPaint2, this.pageNumber, this.isPrinting);
                        } else {
                            this.g2.setPaint(pdfPaint2);
                        }
                    }
                    this.g2.drawString(string, f7, f8);
                    this.g2.setTransform(affineTransform4);
                    this.g2.setClip((Shape)object4);
                    ++n19;
                    continue block38;
                }
                case 25: {
                    this.renderXForm((DynamicVectorRenderer)object2, f5);
                    continue block38;
                }
                case 23: {
                    Shape shape4 = this.g2.getClip();
                    this.g2.setClip(shape2);
                    AffineTransform affineTransform5 = this.g2.getTransform();
                    JPedalCustomDrawObject jPedalCustomDrawObject = (JPedalCustomDrawObject)object2;
                    if (this.isPrinting) {
                        jPedalCustomDrawObject.print(this.g2, this.pageNumber);
                    } else {
                        jPedalCustomDrawObject.paint(this.g2);
                    }
                    this.g2.setTransform(affineTransform5);
                    this.g2.setClip(shape4);
                }
            }
        }
        if (this.needsHighlights && rectangleArray != null) {
            for (n = 0; n != rectangleArray.length; ++n) {
                this.ignoreHighlight = false;
                this.renderHighlight(rectangleArray[n], this.g2);
            }
        }
        if (vector_Rectangle != null) {
            Rectangle[] rectangleArray4 = vector_Rectangle.get();
            Composite composite = this.g2.getComposite();
            object = this.g2.getPaint();
            for (int i = 0; i != rectangleArray4.length; ++i) {
                if (rectangleArray4[i] != null) {
                    this.g2.setComposite(AlphaComposite.getInstance(3, PdfDecoder.highlightComposite));
                    this.g2.setPaint(DecoderOptions.highlightColor);
                    this.g2.fill(rectangleArray4[i]);
                }
                this.g2.setComposite(composite);
                this.g2.setPaint((Paint)object);
            }
        }
        this.g2.setClip(shape2);
        this.g2.setTransform(affineTransform2);
        if (this.frame != null && this.renderFailed && !userAlerted) {
            userAlerted = true;
            if (PdfDecoder.showErrorMessages) {
                String string = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                JOptionPane.showMessageDialog(this.frame, string);
                this.frame.invalidate();
                this.frame.repaint();
            }
        }
        --this.paintThreadCount;
        this.lastItemPainted = this.optimsePainting ? n4 : -1;
        this.lastScaling = this.scaling;
        if (this.minX == -1.0) {
            return null;
        }
        return new Rectangle((int)this.minX, (int)this.minY, (int)(this.maxX - this.minX), (int)(this.maxY - this.minY));
    }

    private static Rectangle getObjectArea(double[] dArray, int[] nArray, double[] dArray2, double[] dArray3, double[] dArray4, Object[] objectArray, Rectangle[] rectangleArray, int n, float f, float f2, int n2, int n3, int n4) {
        Rectangle rectangle = null;
        if (dArray != null && n == 3) {
            if (rectangleArray != null) {
                rectangle = rectangleArray[n4];
            }
        } else if (dArray != null && n == 2) {
            rectangle = ((Shape)objectArray[n4]).getBounds();
        } else if (n == 1 && n3 > -1) {
            rectangle = RenderUtils.getAreaForGlyph(new float[][]{{(float)dArray[n3], (float)dArray2[n3], 0.0f}, {(float)dArray3[n3], (float)dArray4[n3], 0.0f}, {f, f2, 1.0f}});
        } else if (n2 != -1 && dArray != null) {
            int n5 = nArray[n2];
            rectangle = n5 < 0 ? new Rectangle((int)f + n5, (int)f2, -n5, -n5) : new Rectangle((int)f, (int)f2, n5, n5);
        }
        return rectangle;
    }

    private void renderImage(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, Object[] objectArray, int[] nArray, Object object, float f, float f2, float f3, int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (nArray != null) {
            n5 = nArray[n];
        }
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        String string = Integer.toString(this.pageNumber) + Integer.toString(n);
        if (this.useHiResImageForDisplay && !this.isType3Font && this.objectStoreRef.isRawImageDataSaved(string)) {
            float f4 = this.scaling;
            if (this.useHiResImageForDisplay && this.scaling < 1.0f) {
                f4 = 1.0f;
            }
            int n10 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_pX);
            int n11 = (int)((float)n10 * f4);
            int n12 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_pY);
            n8 = (int)((float)n12 * f4);
            n7 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_WIDTH);
            int n13 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_HEIGHT);
            byte[] byArray = (byte[])this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_MASKCOL);
            int n14 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_COLORSPACE);
            BufferedImage bufferedImage = null;
            if (n11 > 0) {
                int n15;
                int n16;
                int n17;
                int n18 = n7;
                int n19 = n8 << 2;
                int n20 = n11 << 2;
                for (n17 = n13; n18 > n20 && n17 > n19; n18 >>= 1, n17 >>= 1) {
                    n6 <<= 1;
                }
                int n21 = n7 / n11;
                if (n21 < 1) {
                    n21 = 1;
                }
                if ((n16 = n13 / n8) < 1) {
                    n16 = 1;
                }
                if ((n6 = n21) > n16) {
                    n6 = n16;
                }
                int n22 = n7;
                int n23 = n8 << 2;
                int n24 = n11 << 2;
                for (int i = n13; n22 > n24 && i > n23; n22 >>= 1, i >>= 1) {
                    n9 <<= 1;
                }
                int n25 = n7 / n10;
                if (n25 < 1) {
                    n25 = 1;
                }
                if ((n15 = n13 / n12) < 1) {
                    n15 = 1;
                }
                if ((n9 = n25) > n15) {
                    n9 = n15;
                }
                if ((this.scaling > 1.0f || this.lastScaling > 1.0f) && n6 >= 1 && this.lastScaling != this.scaling) {
                    n18 = n7 / n6;
                    n17 = n13 / n6;
                    bufferedImage = this.resampleImageData(n6, n7, n13, byArray, n18, n17, string, n14);
                }
            }
            if (bufferedImage != null) {
                if (this.singleImage != null) {
                    this.singleImage = bufferedImage;
                }
                objectArray[n4] = bufferedImage;
                object = bufferedImage;
            }
        }
        if (!this.useHiResImageForDisplay) {
            AffineTransform affineTransform = this.g2.getTransform();
            this.extraRot = false;
            if (n8 > 0) {
                double d;
                double[] dArray5 = new double[6];
                this.g2.getTransform().getMatrix(dArray5);
                dArray5[0] = d = (double)((float)n8 / (float)((BufferedImage)object).getHeight());
                dArray5[1] = 0.0;
                dArray5[2] = 0.0;
                dArray5[3] = -d;
                this.g2.scale(1.0f / this.scaling, 1.0f / this.scaling);
                this.g2.setTransform(new AffineTransform(dArray5));
            } else {
                this.extraRot = true;
            }
            this.renderImage(null, (BufferedImage)object, f, null, f2, f3, n5);
            this.g2.setTransform(affineTransform);
        }
    }

    private BufferedImage resampleImageData(int n, int n2, int n3, byte[] byArray, int n4, int n5, String string, int n6) {
        int n7;
        int n8;
        byte[] byArray2 = this.objectStoreRef.getRawImageData(string);
        byte[] byArray3 = null;
        if (byArray != null && n6 != 1785221209) {
            byArray3 = byArray;
        }
        int n9 = n4 * n5;
        if (byArray3 != null) {
            n9 *= 3;
        }
        byte[] byArray4 = new byte[n9];
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int n10 = n2 + 7 >> 3;
        int n11 = 0;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n12;
                n8 = 0;
                int n13 = 0;
                int n14 = n;
                n7 = n;
                int n15 = n2 - j;
                int n16 = n3 - i;
                if (n14 > n15) {
                    n14 = n15;
                }
                if (n7 > n16) {
                    n7 = n16;
                }
                for (n12 = 0; n12 < n7; ++n12) {
                    for (int k = 0; k < n14; ++k) {
                        byte by = byArray2[(n12 + i * n) * n10 + (j * n + k >> 3)];
                        int n17 = by & nArray[7 - (j * n + k & 7)];
                        if (n17 != 0) {
                            ++n8;
                        }
                        ++n13;
                    }
                }
                if (n13 > 0) {
                    if (byArray3 == null) {
                        byArray4[j + n4 * i] = (byte)(255 * n8 / n13);
                        continue;
                    }
                    for (n12 = 0; n12 < 3; ++n12) {
                        byArray4[n11] = (float)(n8 / n13) < 0.5f ? (int)(byArray[n12] & 0xFF) : -1;
                        ++n11;
                    }
                    continue;
                }
                if (byArray3 == null) {
                    byArray4[j + n4 * i] = -1;
                    continue;
                }
                for (n12 = 0; n12 < 3; ++n12) {
                    byArray4[n11] = -1;
                    ++n11;
                }
            }
        }
        BufferedImage bufferedImage = null;
        n8 = 10;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray4, byArray4.length);
        int[] nArray2 = new int[]{0};
        n7 = 1;
        if (byArray == null && n2 * n3 * 3 == byArray2.length) {
            n8 = 1;
            nArray2 = new int[]{0, 1, 2};
            n7 = 3;
        }
        bufferedImage = new BufferedImage(n4, n5, n8);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n4, n5, n4 * n7, n7, nArray2, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private BufferedImage reloadCachedImage(int n, int n2, BufferedImage bufferedImage) {
        try {
            BufferedImage bufferedImage2 = this.singleImage != null ? this.singleImage.getSubimage(0, 0, this.singleImage.getWidth(), this.singleImage.getHeight()) : (this.rawKey == null ? this.largeImages.get("HIRES_" + n2) : this.largeImages.get("HIRES_" + n2 + '_' + this.rawKey));
            if (bufferedImage2 == null) {
                int n3 = n2;
                if (n != -1) {
                    n3 = n;
                }
                if ((bufferedImage2 = this.rawKey == null ? this.objectStoreRef.loadStoredImage(this.pageNumber + "_HIRES_" + n3) : this.objectStoreRef.loadStoredImage(this.pageNumber + "_HIRES_" + n3 + '_' + this.rawKey)) == null) {
                    this.renderFailed = true;
                }
                if (!this.isPrinting) {
                    if (this.rawKey == null) {
                        this.largeImages.put("HIRES_" + n2, bufferedImage2);
                    } else {
                        this.largeImages.put("HIRES_" + n2, bufferedImage2 + "_" + this.rawKey);
                    }
                }
            }
            bufferedImage = bufferedImage2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    @Override
    public void setMessageFrame(Container container) {
        this.frame = container;
    }

    private Rectangle setHighlightForGlyph(Rectangle rectangle, Rectangle[] rectangleArray) {
        if (rectangleArray == null || this.textHighlightsX == null) {
            return null;
        }
        this.ignoreHighlight = false;
        for (int i = 0; i != rectangleArray.length; ++i) {
            if (rectangleArray[i] == null || rectangle == null || !rectangleArray[i].intersects(rectangle)) continue;
            Rectangle rectangle2 = rectangleArray[i].intersection(rectangle);
            float f = rectangle2.width * rectangle2.height;
            float f2 = (float)(rectangle.width * rectangle.height) / 4.0f;
            if (!(rectangleArray[i].contains(rectangle.x, rectangle.y) && f > f2) && !(f > (float)(rectangle.width * rectangle.height) / 1.667f)) continue;
            if (!this.drawnHighlights[i]) {
                this.ignoreHighlight = false;
                this.drawnHighlights[i] = true;
                return rectangleArray[i];
            }
            this.ignoreHighlight = true;
            return rectangleArray[i];
        }
        return null;
    }

    @Override
    public void drawText(float[][] fArray, String string, GraphicsState graphicsState, float f, float f2, Font font) {
        int n;
        int n2;
        double[] dArray;
        PdfPaint pdfPaint = null;
        if (fArray != null && (this.lastAf[0] != (dArray = new double[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]})[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3])) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        if (((n2 = graphicsState.getTextRenderType()) & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n) {
                    this.lastFillTextCol = n;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n2 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        this.pageObjects.addElement(string);
        this.javaObjects.addElement(font);
        this.objectType.addElement(16);
        n = font.getSize();
        if (n > 100) {
            this.areas.addElement(new Rectangle((int)f, (int)f2, n, n));
        } else {
            this.areas.addElement(null);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    @Override
    public Rectangle getCombinedAreas(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = null;
        if (this.areas != null) {
            Rectangle rectangle3 = rectangle.getBounds();
            int n = rectangle3.x;
            int n2 = rectangle3.y;
            int n3 = n + rectangle3.width;
            int n4 = n2 + rectangle3.height;
            boolean bl2 = false;
            Rectangle[] rectangleArray = this.areas.get();
            int n5 = rectangleArray.length;
            for (int i = 0; i < n5; ++i) {
                int n6;
                if (rectangleArray[i] == null || !rectangle.contains(rectangleArray[i])) continue;
                bl2 = true;
                int n7 = rectangleArray[i].x;
                if (n3 > n7) {
                    n3 = n7;
                }
                if (n < (n7 = rectangleArray[i].x + rectangleArray[i].width)) {
                    n = n7;
                }
                if (n4 > (n6 = rectangleArray[i].y)) {
                    n4 = n6;
                }
                if (n2 >= (n6 = rectangleArray[i].y + rectangleArray[i].height)) continue;
                n2 = n6;
            }
            if (bl2) {
                rectangle2 = new Rectangle(n3 - 1, n4 + 1, n - n3 + 2, n2 - n4 + 2);
            }
        }
        return rectangle2;
    }

    @Override
    public int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        boolean bl2;
        if (n3 != -1) {
            return this.redrawImage(n, graphicsState, string, n3);
        }
        this.pageNumber = n;
        float[][] fArray = graphicsState.CTM;
        float f = graphicsState.x;
        float f2 = graphicsState.y;
        double[] dArray = new double[6];
        boolean bl3 = bufferedImage.getWidth() < 100 && bufferedImage.getHeight() < 100 || bufferedImage.getHeight() == 1;
        String string2 = this.rawKey == null ? n + "_" + (this.currentItem + 1) : this.rawKey + '_' + (this.currentItem + 1);
        if (this.imageOptions == null) {
            this.imageOptions = new Vector_Int(5000);
            this.imageOptions.setCheckpoint();
        }
        boolean bl4 = bl2 = n2 == 0 && fArray[0][0] < 0.0f && fArray[0][1] > 0.0f && fArray[1][0] < 0.0f && fArray[1][1] < 0.0f && this.pageRotation == 0 && this.type == 1;
        if (!bl && bufferedImage.getHeight() > 1 && (n2 & 1) != 1) {
            boolean bl5;
            boolean bl6 = bl5 = this.optimisedTurnCode && fArray[0][0] * fArray[0][1] == 0.0f && fArray[1][1] * fArray[1][0] == 0.0f && !RenderUtils.isRotated(fArray);
            if (!(this.optimisedTurnCode && bl5 || this.pageRotation == 90 || this.pageRotation == 270 || this.type != 3 && !bl2)) {
                bufferedImage = RenderUtils.invertImage(fArray, bufferedImage);
            }
            if (bl5) {
                n2 += 4;
            }
        }
        this.imageOptions.addElement(n2);
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        this.objectType.addElement(3);
        float f3 = 1.0f;
        float f4 = 1.0f;
        if (this.useHiResImageForDisplay) {
            if (!bl) {
                f3 = bufferedImage.getWidth();
                f4 = bufferedImage.getHeight();
            } else {
                f3 = ((Integer)this.cachedWidths.get(string2)).intValue();
                f4 = ((Integer)this.cachedHeights.get(string2)).intValue();
            }
        }
        if (fArray[0][0] > 0.0f && (double)fArray[0][0] < 0.05 && fArray[0][1] != 0.0f && fArray[1][0] != 0.0f && fArray[1][1] != 0.0f) {
            this.areas.addElement(null);
        } else {
            int n4;
            this.w = (int)(fArray[0][0] * f3);
            if (this.w == 0) {
                this.w = (int)(fArray[0][1] * f3);
            }
            this.h = (int)(fArray[1][1] * f4);
            if (this.h == 0) {
                this.h = (int)(fArray[1][0] * f4);
            }
            if (!this.useHiResImageForDisplay && fArray[1][0] < 0.0f && fArray[0][1] > 0.0f && fArray[0][0] == 0.0f && fArray[1][1] == 0.0f) {
                n4 = this.w;
                this.w = -this.h;
                this.h = n4;
            }
            if (this.h < 0 && !this.useHiResImageForDisplay) {
                this.h = -this.h;
            }
            n4 = (int)graphicsState.x;
            int n5 = (int)graphicsState.y;
            int n6 = this.w;
            int n7 = this.h;
            if (n7 < 0) {
                n5 += n7;
                n7 = -n7;
            }
            if (n7 == 0) {
                n7 = 1;
            }
            Rectangle rectangle = new Rectangle(n4, n5, n6, n7);
            this.areas.addElement(rectangle);
            this.checkWidth(rectangle);
        }
        if (this.useHiResImageForDisplay && !bl3) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        this.imageID.put(string, new Integer(this.currentItem));
        this.storedImageValues.put("imageOptions-" + this.currentItem, new Integer(n2));
        this.storedImageValues.put("imageAff-" + this.currentItem, dArray);
        ++this.currentItem;
        return this.currentItem - 1;
    }

    private int redrawImage(int n, GraphicsState graphicsState, String string, int n2) {
        this.pageNumber = n;
        float f = graphicsState.x;
        float f2 = graphicsState.y;
        this.imageOptions.addElement((Integer)this.storedImageValues.get("imageOptions-" + n2));
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        this.objectType.addElement(29);
        Rectangle rectangle = this.areas.elementAt(n2);
        Rectangle rectangle2 = null;
        if (rectangle != null) {
            rectangle2 = new Rectangle((int)f, (int)f2, rectangle.width, rectangle.height);
        }
        this.areas.addElement(rectangle2);
        if (rectangle != null) {
            this.checkWidth(rectangle2);
        }
        this.pageObjects.addElement(new Integer(n2));
        this.imageID.put(string, new Integer(n2));
        ++this.currentItem;
        return this.currentItem - 1;
    }

    private void checkWidth(Rectangle rectangle) {
        int n = rectangle.getBounds().x;
        int n2 = rectangle.getBounds().y;
        int n3 = n2 + rectangle.getBounds().height;
        int n4 = n + rectangle.getBounds().width;
        if (n < this.pageX1) {
            this.pageX1 = n;
        }
        if (n4 > this.pageX2) {
            this.pageX2 = n4;
        }
        if (n3 > this.pageY1) {
            this.pageY1 = n3;
        }
        if (n2 < this.pageY2) {
            this.pageY2 = n2;
        }
    }

    @Override
    public Rectangle getOccupiedArea() {
        return new Rectangle(this.pageX1, this.pageY1, this.pageX2 - this.pageX1, this.pageY1 - this.pageY2);
    }

    @Override
    public void drawShape(Shape shape, GraphicsState graphicsState, int n) {
        int n2;
        PdfPaint pdfPaint;
        int n3 = graphicsState.getFillType();
        if (shape.getBounds().getWidth() == 1.0 && shape.getBounds().getHeight() == 1.0 && graphicsState.getLineWidth() < 1.0f) {
            shape = new Rectangle(shape.getBounds().x, shape.getBounds().y, 1, 1);
        }
        if (n3 == 2 || n3 == 3) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawFillColor(pdfPaint);
                this.fillSet = true;
            } else {
                n2 = pdfPaint.getRGB();
                if (!this.fillSet || this.lastFillCol != n2) {
                    this.lastFillCol = n2;
                    this.drawFillColor(pdfPaint);
                    this.fillSet = true;
                }
            }
        }
        if (n3 == 1 || n3 == 3) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint instanceof Color) {
                n2 = pdfPaint.getRGB();
                if (!this.strokeSet || this.lastStrokeCol != n2) {
                    this.lastStrokeCol = n2;
                    this.drawStrokeColor(pdfPaint);
                    this.strokeSet = true;
                }
            } else {
                this.drawStrokeColor(pdfPaint);
                this.strokeSet = true;
            }
        }
        Stroke stroke = graphicsState.getStroke();
        if (this.lastStroke == null || !this.lastStroke.equals(stroke)) {
            this.lastStroke = stroke;
            this.drawStroke(stroke);
        }
        this.pageObjects.addElement(shape);
        this.objectType.addElement(2);
        this.areas.addElement(shape.getBounds());
        this.checkWidth(shape.getBounds());
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = graphicsState.x;
        this.y_coord[this.currentItem] = graphicsState.y;
        this.shapeType.addElement(n3);
        ++this.currentItem;
        this.resetTextColors = true;
    }

    @Override
    public void drawColor(PdfPaint pdfPaint, int n) {
        this.areas.addElement(null);
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.textFillType.addElement(n);
        this.text_color.addElement(pdfPaint);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
    }

    @Override
    public void drawXForm(DynamicVectorRenderer dynamicVectorRenderer, GraphicsState graphicsState) {
        this.areas.addElement(null);
        this.pageObjects.addElement(dynamicVectorRenderer);
        this.objectType.addElement(25);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void resetOnColorspaceChange() {
        this.fillSet = false;
        this.strokeSet = false;
    }

    @Override
    public void drawFillColor(PdfPaint pdfPaint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.areas.addElement(null);
        this.fill_color.addElement(pdfPaint);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastFillCol = pdfPaint.getRGB();
    }

    @Override
    public void setGraphicsState(int n, float f) {
        if (f != 1.0f || this.opacity != null) {
            if (this.opacity == null) {
                this.opacity = new Vector_Float(5000);
                this.opacity.setCheckpoint();
            }
            this.pageObjects.addElement(null);
            this.areas.addElement(null);
            if (n == 1) {
                this.objectType.addElement(17);
            } else {
                this.objectType.addElement(18);
            }
            this.opacity.addElement(f);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    @Override
    public void drawAdditionalObjectsOverPage(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        if (objectArray == null) {
            return;
        }
        if (this.endItem == -1) {
            this.endItem = this.currentItem;
            this.objectType.setCheckpoint();
            this.shapeType.setCheckpoint();
            this.pageObjects.setCheckpoint();
            this.areas.setCheckpoint();
            this.clips.setCheckpoint();
            this.textFillType.setCheckpoint();
            this.text_color.setCheckpoint();
            this.fill_color.setCheckpoint();
            this.stroke_color.setCheckpoint();
            this.stroke.setCheckpoint();
            if (this.imageOptions != null) {
                this.imageOptions.setCheckpoint();
            }
            if (this.TRvalues != null) {
                this.TRvalues.setCheckpoint();
            }
            if (this.fs != null) {
                this.fs.setCheckpoint();
            }
            if (this.lw != null) {
                this.lw.setCheckpoint();
            }
            this.af1.setCheckpoint();
            this.af2.setCheckpoint();
            this.af3.setCheckpoint();
            this.af4.setCheckpoint();
            this.fontBounds.setCheckpoint();
            if (this.opacity != null) {
                this.opacity.setCheckpoint();
            }
        }
        int n = nArray.length;
        block10: for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            switch (n2) {
                case 18: {
                    this.setGraphicsState(2, ((Float)objectArray[i]).floatValue());
                    continue block10;
                }
                case 17: {
                    this.setGraphicsState(1, ((Float)objectArray[i]).floatValue());
                    continue block10;
                }
                case 19: {
                    GraphicsState graphicsState = new GraphicsState();
                    graphicsState.setFillType(1);
                    graphicsState.setStrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawShape((Shape)objectArray[i], graphicsState, 83);
                    continue block10;
                }
                case 20: {
                    GraphicsState graphicsState = new GraphicsState();
                    graphicsState.setFillType(2);
                    graphicsState.setNonstrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawShape((Shape)objectArray[i], graphicsState, 70);
                    continue block10;
                }
                case 23: {
                    this.drawCustom(objectArray[i]);
                    continue block10;
                }
                case 3: {
                    ImageObject imageObject = (ImageObject)objectArray[i];
                    GraphicsState graphicsState = new GraphicsState();
                    graphicsState.CTM = new float[][]{{imageObject.image.getWidth(), 0.0f, 1.0f}, {0.0f, imageObject.image.getHeight(), 1.0f}, {0.0f, 0.0f, 0.0f}};
                    graphicsState.x = imageObject.x;
                    graphicsState.y = imageObject.y;
                    this.drawImage(this.pageNumber, imageObject.image, graphicsState, false, "extImg" + i, 0, -1);
                    continue block10;
                }
                case 16: {
                    TextObject textObject = (TextObject)objectArray[i];
                    GraphicsState graphicsState = new GraphicsState();
                    float f = textObject.font.getSize();
                    double[] dArray = new double[]{f, 0.0, 0.0, f, 0.0, 0.0};
                    this.drawAffine(dArray);
                    this.drawTR(2);
                    graphicsState.setTextRenderType(2);
                    graphicsState.setNonstrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawText(null, textObject.text, graphicsState, textObject.x, -textObject.y, textObject.font);
                    continue block10;
                }
                case 0: {
                    continue block10;
                }
                default: {
                    throw new PdfException("Unrecognised type " + n2);
                }
            }
        }
    }

    @Override
    public void flushAdditionalObjOnPage() {
        if (this.endItem != -1) {
            this.currentItem = this.endItem;
        }
        this.endItem = -1;
        this.objectType.resetToCheckpoint();
        this.shapeType.resetToCheckpoint();
        this.pageObjects.resetToCheckpoint();
        this.areas.resetToCheckpoint();
        this.clips.resetToCheckpoint();
        this.textFillType.resetToCheckpoint();
        this.text_color.resetToCheckpoint();
        this.fill_color.resetToCheckpoint();
        this.stroke_color.resetToCheckpoint();
        this.stroke.resetToCheckpoint();
        if (this.imageOptions != null) {
            this.imageOptions.resetToCheckpoint();
        }
        if (this.TRvalues != null) {
            this.TRvalues.resetToCheckpoint();
        }
        if (this.fs != null) {
            this.fs.resetToCheckpoint();
        }
        if (this.lw != null) {
            this.lw.resetToCheckpoint();
        }
        this.af1.resetToCheckpoint();
        this.af2.resetToCheckpoint();
        this.af3.resetToCheckpoint();
        this.af4.resetToCheckpoint();
        this.fontBounds.resetToCheckpoint();
        if (this.opacity != null) {
            this.opacity.resetToCheckpoint();
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.fillSet = false;
        this.strokeSet = false;
    }

    @Override
    public void drawStrokeColor(Paint paint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.areas.addElement(null);
        this.stroke_color.addElement(paint);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
        this.resetTextColors = true;
    }

    @Override
    public void drawCustom(Object object) {
        this.pageObjects.addElement(object);
        this.objectType.addElement(23);
        this.areas.addElement(null);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawTR(int n) {
        if (n != this.lastTR) {
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(5000);
                this.TRvalues.setCheckpoint();
            }
            this.lastTR = n;
            this.pageObjects.addElement(null);
            this.objectType.addElement(15);
            this.areas.addElement(null);
            this.TRvalues.addElement(n);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    @Override
    public void drawStroke(Stroke stroke) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.areas.addElement(null);
        this.stroke.addElement(stroke);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawClip(GraphicsState graphicsState, Shape shape, boolean bl) {
        Area area = graphicsState.getClippingShape();
        if (!(bl && this.hasClips && this.lastClip == null && area == null || bl && this.lastClip != null && area != null && area.equals(this.lastClip))) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.areas.addElement(null);
            this.lastClip = area;
            if (area == null) {
                this.clips.addElement(null);
            } else {
                this.clips.addElement((Area)area.clone());
            }
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = graphicsState.x;
            this.y_coord[this.currentItem] = graphicsState.y;
            ++this.currentItem;
            this.hasClips = true;
        }
    }

    @Override
    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, AffineTransform affineTransform, String string, PdfFont pdfFont) {
        int n3;
        PdfPaint pdfPaint;
        int n4 = graphicsState.getTextRenderType();
        if ((n4 & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n3 = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n3) {
                    this.lastFillTextCol = n3;
                    this.drawColor(pdfPaint, 2);
                    this.resetTextColors = false;
                }
            }
        }
        if ((n4 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n3 = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n3) {
                    this.resetTextColors = false;
                    this.lastStrokeCol = n3;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        this.setLineWidth((int)graphicsState.getLineWidth());
        this.drawFontSize(n);
        if (object != null) {
            double[] dArray;
            if (fArray != null && (this.lastAf[0] != (dArray = new double[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]})[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3])) {
                this.drawAffine(dArray);
                this.lastAf[0] = dArray[0];
                this.lastAf[1] = dArray[1];
                this.lastAf[2] = dArray[2];
                this.lastAf[3] = dArray[3];
            }
            if (!(object instanceof Area)) {
                n2 = -n2;
            }
        } else {
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            if (this.lastAf[0] != dArray[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3]) {
                this.drawAffine(dArray);
                this.lastAf[0] = dArray[0];
                this.lastAf[1] = dArray[1];
                this.lastAf[2] = dArray[2];
                this.lastAf[3] = dArray[3];
            }
        }
        if (pdfGlyph == null) {
            this.pageObjects.addElement(object);
        } else {
            this.pageObjects.addElement(pdfGlyph);
        }
        this.objectType.addElement(n2);
        if (n2 < 0) {
            this.areas.addElement(null);
        } else if (object != null) {
            this.areas.addElement(new Rectangle((int)fArray[2][0], (int)fArray[2][1], n, n));
            this.checkWidth(new Rectangle((int)fArray[2][0], (int)fArray[2][1], n, n));
        } else {
            int n5 = n;
            if (n5 < 0) {
                n5 = -n5;
            }
            Rectangle rectangle = new Rectangle((int)fArray[2][0], (int)fArray[2][1], n5, n5);
            this.areas.addElement(rectangle);
            this.checkWidth(rectangle);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = fArray[2][0];
        this.y_coord[this.currentItem] = fArray[2][1];
        ++this.currentItem;
    }

    @Override
    public void drawFontBounds(Rectangle rectangle) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(24);
        this.areas.addElement(null);
        this.fontBounds.addElement(rectangle);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawAffine(double[] dArray) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.areas.addElement(null);
        this.af1.addElement(dArray[0]);
        this.af2.addElement(dArray[1]);
        this.af3.addElement(dArray[2]);
        this.af4.addElement(dArray[3]);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)dArray[4];
        this.y_coord[this.currentItem] = (float)dArray[5];
        ++this.currentItem;
    }

    @Override
    public void drawFontSize(int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n2 != this.lastFS) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(21);
            this.areas.addElement(null);
            if (this.fs == null) {
                this.fs = new Vector_Int(5000);
                this.fs.setCheckpoint();
            }
            this.fs.addElement(n);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastFS = n2;
        }
    }

    @Override
    public void setLineWidth(int n) {
        if (n != this.lastLW) {
            this.areas.addElement(null);
            this.pageObjects.addElement(null);
            this.objectType.addElement(22);
            if (this.lw == null) {
                this.lw = new Vector_Int(5000);
                this.lw.setCheckpoint();
            }
            this.lw.addElement(n);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastLW = n;
        }
    }

    public SwingDisplay(byte[] byArray, Map map) {
        try {
            Object object;
            int n;
            this.fonts = map;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n2 = byteArrayInputStream.read();
            if (n2 != 1) {
                throw new PdfException("Unknown version in serialised object " + n2);
            }
            int n3 = byteArrayInputStream.read();
            this.useHiResImageForDisplay = n3 == 1;
            this.pageNumber = byteArrayInputStream.read();
            this.x_coord = (float[])RenderUtils.restoreFromStream(byteArrayInputStream);
            this.y_coord = (float[])RenderUtils.restoreFromStream(byteArrayInputStream);
            this.text_color = (Vector_Object)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.textFillType = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.stroke_color = new Vector_Object();
            this.stroke_color.restoreFromStream(byteArrayInputStream);
            this.fill_color = new Vector_Object();
            this.fill_color.restoreFromStream(byteArrayInputStream);
            this.stroke = new Vector_Object();
            this.stroke.restoreFromStream(byteArrayInputStream);
            this.pageObjects = new Vector_Object();
            this.pageObjects.restoreFromStream(byteArrayInputStream);
            this.javaObjects = (Vector_Object)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.shapeType = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.af1 = (Vector_Double)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.af2 = (Vector_Double)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.af3 = (Vector_Double)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.af4 = (Vector_Double)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.fontBounds = new Vector_Rectangle();
            this.fontBounds.restoreFromStream(byteArrayInputStream);
            this.clips = new Vector_Shape();
            this.clips.restoreFromStream(byteArrayInputStream);
            this.objectType = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.opacity = (Vector_Float)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.imageOptions = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.TRvalues = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.fs = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
            this.lw = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
            int n4 = (Integer)RenderUtils.restoreFromStream(byteArrayInputStream);
            for (n = 0; n < n4; ++n) {
                Object object2 = RenderUtils.restoreFromStream(byteArrayInputStream);
                object = RenderUtils.restoreFromStream(byteArrayInputStream);
                map.put(object2, object);
            }
            n = (Integer)RenderUtils.restoreFromStream(byteArrayInputStream);
            for (int i = 0; i < n; ++i) {
                object = RenderUtils.restoreFromStream(byteArrayInputStream);
                PdfJavaGlyphs pdfJavaGlyphs = (PdfJavaGlyphs)map.get(object);
                pdfJavaGlyphs.setDisplayValues((Map)RenderUtils.restoreFromStream(byteArrayInputStream));
                pdfJavaGlyphs.setCharGlyphs((Map)RenderUtils.restoreFromStream(byteArrayInputStream));
                pdfJavaGlyphs.setEmbeddedEncs((Map)RenderUtils.restoreFromStream(byteArrayInputStream));
            }
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.currentItem = this.pageObjects.get().length;
    }

    @Override
    public void stopClearOnNextRepaint(boolean bl) {
        this.noRepaint = bl;
    }

    @Override
    public byte[] serializeToByteArray(Set set) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(1);
        if (this.useHiResImageForDisplay) {
            byteArrayOutputStream.write(1);
        } else {
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.write(this.pageNumber);
        this.text_color.trim();
        this.stroke_color.trim();
        this.fill_color.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.shapeType.trim();
        this.af1.trim();
        this.af2.trim();
        this.af3.trim();
        this.af4.trim();
        this.fontBounds.trim();
        this.clips.trim();
        this.objectType.trim();
        if (this.opacity != null) {
            this.opacity.trim();
        }
        if (this.imageOptions != null) {
            this.imageOptions.trim();
        }
        if (this.TRvalues != null) {
            this.TRvalues.trim();
        }
        if (this.fs != null) {
            this.fs.trim();
        }
        if (this.lw != null) {
            this.lw.trim();
        }
        RenderUtils.writeToStream(byteArrayOutputStream, this.x_coord, "x_coord");
        RenderUtils.writeToStream(byteArrayOutputStream, this.y_coord, "y_coord");
        RenderUtils.writeToStream(byteArrayOutputStream, this.text_color, "text_color");
        RenderUtils.writeToStream(byteArrayOutputStream, this.textFillType, "textFillType");
        this.stroke_color.writeToStream(byteArrayOutputStream);
        this.fill_color.writeToStream(byteArrayOutputStream);
        this.stroke.writeToStream(byteArrayOutputStream);
        this.pageObjects.writeToStream(byteArrayOutputStream);
        RenderUtils.writeToStream(byteArrayOutputStream, this.javaObjects, "javaObjects");
        RenderUtils.writeToStream(byteArrayOutputStream, this.shapeType, "shapeType");
        RenderUtils.writeToStream(byteArrayOutputStream, this.af1, "af1");
        RenderUtils.writeToStream(byteArrayOutputStream, this.af2, "af2");
        RenderUtils.writeToStream(byteArrayOutputStream, this.af3, "af3");
        RenderUtils.writeToStream(byteArrayOutputStream, this.af4, "af4");
        this.fontBounds.writeToStream(byteArrayOutputStream);
        this.clips.writeToStream(byteArrayOutputStream);
        RenderUtils.writeToStream(byteArrayOutputStream, this.objectType, "objectType");
        RenderUtils.writeToStream(byteArrayOutputStream, this.opacity, "opacity");
        RenderUtils.writeToStream(byteArrayOutputStream, this.imageOptions, "imageOptions");
        RenderUtils.writeToStream(byteArrayOutputStream, this.TRvalues, "TRvalues");
        RenderUtils.writeToStream(byteArrayOutputStream, this.fs, "fs");
        RenderUtils.writeToStream(byteArrayOutputStream, this.lw, "lw");
        int n = 0;
        int n2 = 0;
        HashMap hashMap = new HashMap(10);
        HashMap hashMap2 = new HashMap(10);
        for (Object k : this.fontsUsed.keySet()) {
            if (!set.contains(k)) {
                ++n;
                hashMap2.put(k, "x");
                continue;
            }
            ++n2;
            hashMap.put(k, "x");
        }
        RenderUtils.writeToStream(byteArrayOutputStream, new Integer(n), "new Integer(fontCount)");
        for (Object k : hashMap2.keySet()) {
            RenderUtils.writeToStream(byteArrayOutputStream, k, "key");
            RenderUtils.writeToStream(byteArrayOutputStream, this.fonts.get(k), "font");
            set.add(k);
        }
        RenderUtils.writeToStream(byteArrayOutputStream, new Integer(n2), "new Integer(existingfontCount)");
        for (Object k : hashMap.keySet()) {
            RenderUtils.writeToStream(byteArrayOutputStream, k, "key");
            PdfJavaGlyphs pdfJavaGlyphs = (PdfJavaGlyphs)this.fonts.get(k);
            RenderUtils.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getDisplayValues(), "display");
            RenderUtils.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getCharGlyphs(), "char");
            RenderUtils.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getEmbeddedEncs(), "emb");
        }
        byteArrayOutputStream.close();
        this.fontsUsed.clear();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void setneedsVerticalInvert(boolean bl) {
        this.needsVerticalInvert = bl;
    }

    @Override
    public void setneedsHorizontalInvert(boolean bl) {
        this.needsHorizontalInvert = bl;
    }

    @Override
    public void checkFontSaved(Object object, String string, PdfFont pdfFont) {
        this.pageObjects.addElement(object);
        this.objectType.addElement(200);
        this.areas.addElement(null);
        ++this.currentItem;
        if (this.fontsUsed.get(string) == null || pdfFont.isFontSubsetted()) {
            this.fonts.put(string, pdfFont.getGlyphData());
            this.fontsUsed.put(string, "x");
        }
    }

    @Override
    public boolean hasObjectsBehind(float[][] fArray) {
        double d;
        boolean bl = false;
        double d2 = fArray[2][0];
        double d3 = fArray[2][1];
        double d4 = fArray[0][0];
        if (d4 == 0.0) {
            d4 = fArray[0][1];
        }
        if ((d = (double)fArray[1][1]) == 0.0) {
            d = fArray[1][0];
        }
        Rectangle[] rectangleArray = this.areas.get();
        int n = rectangleArray.length;
        for (int i = 0; i < n; ++i) {
            if (rectangleArray[i] == null) continue;
            if (d < 0.0) {
                d = (d3 += d) - d;
            }
            if (d4 < 0.0) {
                d4 = (d2 += d4) - d4;
            }
            Rectangle rectangle = rectangleArray[i];
            Rectangle rectangle2 = new Rectangle((int)d2, (int)d3, (int)d4, (int)d);
            if (d4 * d > (double)(rectangleArray[i].width * rectangleArray[i].height)) {
                rectangle = new Rectangle((int)d2, (int)d3, (int)d4, (int)d);
                rectangle2 = rectangleArray[i];
            }
            if (!rectangle2.intersects(rectangle) && !rectangle.contains(rectangle2)) continue;
            i = n;
            bl = true;
        }
        return bl;
    }

    @Override
    public Rectangle getArea(int n) {
        return this.areas.elementAt(n);
    }

    @Override
    public int isInsideImage(int n, int n2) {
        int n3 = -1;
        Rectangle[] rectangleArray = this.areas.get();
        Rectangle rectangle = null;
        int n4 = rectangleArray.length;
        int[] nArray = this.objectType.get();
        for (int i = 0; i < n4; ++i) {
            if (rectangleArray[i] == null || !RenderUtils.rectangleContains(rectangleArray[i], n, n2, i) || nArray[i] != 3) continue;
            if (rectangle != null) {
                int n5 = rectangleArray[i].height * rectangleArray[i].width;
                int n6 = rectangle.height * rectangle.width;
                if (n5 < n6) {
                    rectangle = rectangleArray[i];
                }
                n3 = i;
                continue;
            }
            rectangle = rectangleArray[i];
            n3 = i;
        }
        return n3;
    }

    @Override
    public void saveImage(int n, String string, String string2) {
        String string3 = (String)this.imageIDtoName.get(new Integer(n));
        BufferedImage bufferedImage = null;
        if (this.useHiResImageForDisplay) {
            bufferedImage = this.objectStoreRef.loadStoredImage(string3);
            if (bufferedImage == null) {
                bufferedImage = (BufferedImage)this.pageObjects.elementAt(n);
            }
        } else {
            bufferedImage = (BufferedImage)this.pageObjects.elementAt(n);
        }
        if (bufferedImage != null) {
            if (!this.optimisedTurnCode) {
                bufferedImage = RenderUtils.invertImage(null, bufferedImage);
            }
            if ((bufferedImage.getType() == 0 || string2.equals("jpg") && bufferedImage.getType() == 2) && (bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage)).getType() == 0 && PdfDecoder.showErrorMessages) {
                JOptionPane.showMessageDialog(null, "This is a custom Image, Java's standard libraries may not be able to save the image as a jpg correctly.\nEnabling JAI will ensure correct output. \n\nFor information on how to do this please go to http://www.jpedal.org/flags.php");
            }
            if (this.needsHorizontalInvert) {
                bufferedImage = RenderUtils.invertImageBeforeSave(bufferedImage, true);
            }
            if (this.needsVerticalInvert) {
                bufferedImage = RenderUtils.invertImageBeforeSave(bufferedImage, false);
            }
            if (JAIHelper.isJAIused() && string2.toLowerCase().startsWith("tif")) {
                JAI.create((String)"filestore", (RenderedImage)bufferedImage, (Object)string, (Object)string2);
            } else if (string2.toLowerCase().startsWith("tif")) {
                if (PdfDecoder.showErrorMessages) {
                    JOptionPane.showMessageDialog(null, "Please setup JAI library for Tiffs");
                }
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Please setup JAI library for Tiffs");
                }
            } else {
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string)));
                    ImageIO.write((RenderedImage)bufferedImage, string2, bufferedOutputStream);
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    @Override
    public void flagDecodingFinished() {
        this.highlightsNeedToBeGenerated = true;
    }

    private void generateHighlights(Graphics2D graphics2D, int n, int[] nArray, Object[] objectArray, float f, float f2, float f3, float f4, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int[] nArray2, Rectangle[] rectangleArray) {
        int n2;
        this.highlightsNeedToBeGenerated = false;
        int[] nArray3 = new int[n];
        int n3 = -1;
        int n4 = 0;
        Rectangle rectangle = null;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        boolean[] blArray = new boolean[n];
        int[] nArray4 = new int[n];
        float[] fArray5 = new float[n];
        this.textHighlightsX = new int[n];
        int[] nArray5 = new int[n];
        this.textHighlightsWidth = new int[n];
        this.textHighlightsHeight = new int[n];
        int n5 = 0;
        int n6 = 1000;
        int n7 = 1000;
        int n8 = 1;
        int n9 = 1;
        double[] dArray5 = new double[6];
        graphics2D.getTransform().getMatrix(dArray5);
        int n10 = 0;
        if (dArray5[1] < 0.0 && dArray5[2] < 0.0) {
            n10 = 270;
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.type = nArray[n2];
            if (this.type <= 0) continue;
            float f5 = this.x_coord[n2];
            float f6 = this.y_coord[n2];
            if (n9 < 0) {
                f5 += (float)n9;
            }
            Object object = objectArray[n2];
            if (this.type == 24) {
                rectangle = rectangleArray[n4];
                n6 = rectangle.height;
                n5 = rectangle.y;
                n7 = rectangle.width;
                ++n4;
                continue;
            }
            if (this.type == 21) {
                if ((n9 = nArray2[++n3]) < 0) {
                    n8 = -n9;
                    continue;
                }
                n8 = n9;
                continue;
            }
            if (this.type != 4 && this.type != 5 && this.type != 1) continue;
            float f7 = 1.0f;
            if (this.type == 4 || this.type == 5) {
                PdfGlyph pdfGlyph = (PdfGlyph)object;
                f7 = (float)n8 / 1000.0f;
                this.textHighlightsX[n2] = pdfGlyph.getFontBB(1);
                nArray5[n2] = n5;
                this.textHighlightsWidth[n2] = pdfGlyph.getFontBB(3);
                this.textHighlightsHeight[n2] = n6;
                blArray[n2] = true;
                if (n10 == 90) {
                    fArray2[n2] = -((float)nArray5[n2] * f7) + f5;
                    fArray3[n2] = (float)this.textHighlightsX[n2] * f7 + f6;
                } else if (n10 == 270) {
                    fArray2[n2] = (float)nArray5[n2] * f7 + f5;
                    fArray3[n2] = -((float)this.textHighlightsX[n2] * f7 + f6);
                } else {
                    fArray2[n2] = (float)nArray5[n2] * f7 + f6;
                    fArray3[n2] = (float)this.textHighlightsX[n2] * f7 + f5;
                }
                fArray[n2] = fArray2[n2] + (float)this.textHighlightsHeight[n2] * f7;
                fArray4[n2] = fArray3[n2] + (float)this.textHighlightsWidth[n2] * f7;
                fArray5[n2] = 10.0f;
                nArray4[n2] = n8;
            } else {
                f7 = 1.0f;
                float f8 = 1000.0f / (float)n8;
                this.textHighlightsX[n2] = (int)f5;
                nArray5[n2] = (int)(f6 + (float)n5 / f8);
                this.textHighlightsWidth[n2] = (int)((float)n7 / f8);
                this.textHighlightsHeight[n2] = (int)((float)(n6 - n5) / f8);
                if (n10 == 90) {
                    fArray2[n2] = -nArray5[n2];
                    fArray3[n2] = this.textHighlightsX[n2];
                } else if (n10 == 270) {
                    fArray2[n2] = nArray5[n2];
                    fArray3[n2] = -this.textHighlightsX[n2];
                } else {
                    fArray2[n2] = nArray5[n2];
                    fArray3[n2] = this.textHighlightsX[n2];
                }
                fArray[n2] = fArray2[n2] + (float)this.textHighlightsHeight[n2];
                fArray4[n2] = fArray3[n2] + (float)this.textHighlightsWidth[n2];
                fArray5[n2] = ((Area)object).getBounds().width;
                nArray4[n2] = n8;
            }
            nArray3[n2] = n2;
        }
        n2 = -31;
        for (int i = 0; i < n - 1; ++i) {
            int n11 = nArray3[i];
            if (n11 == n2) {
                System.out.println("*" + n11 + " = " + " left=" + fArray3[n11] + " bottom=" + fArray2[n11] + " right=" + fArray4[n11] + " top=" + fArray[n11]);
            }
            int n12 = 0;
            for (int j = i + 1; j < n; ++j) {
                boolean bl;
                int n13 = nArray3[j];
                if (blArray[n13] != blArray[n11] || fArray5[n13] < 1.0f) continue;
                if (n11 == n2) {
                    System.out.println("compare with=" + n13 + " left=" + fArray3[n13] + " right=" + fArray4[n13] + ' ' + (fArray3[n13] > fArray3[n11] && fArray3[n13] < fArray4[n11]));
                }
                if (!(fArray3[n13] > fArray3[n11] && fArray3[n13] < fArray4[n11]) && (!(fArray3[n13] > (fArray3[n11] + fArray4[n11]) / 2.0f) || !(fArray4[n11] < fArray4[n13]))) continue;
                int n14 = this.textHighlightsWidth[n11];
                int n15 = this.textHighlightsX[n11];
                if (blArray[n13]) {
                    float f9 = fArray3[n13] - fArray4[n11];
                    f9 = f9 > 0.0f ? (f9 += 0.5f) : (f9 += 0.5f);
                    n12 = (int)(f9 * 1000.0f / (float)nArray4[n11]);
                    if (this.textHighlightsX[n13] > 0) {
                        n12 += this.textHighlightsX[n13];
                    }
                } else {
                    n12 = (int)(fArray3[n13] - fArray4[n11]);
                }
                if (n11 == n2) {
                    System.out.println(fArray3[n13] - fArray4[n11] + " gap=" + n12 + ' ' + (fArray3[n13] - fArray4[n11]) * 1000.0f / (float)nArray4[n11] + " currentX=" + n15 + " scaling=" + this.scaling + ' ' + n7);
                }
                boolean bl2 = bl = n12 > 0 || n12 < 0 && fArray3[n11] < fArray3[n13] && fArray4[n11] > fArray3[n13] && fArray4[n11] < fArray4[n13] && fArray3[n11] < fArray4[n11] && (-n12 < nArray4[n11] && !blArray[n11] || -n12 < n7 && blArray[n11]);
                if (!(fArray2[n11] < fArray[n13]) || !(fArray2[n13] < fArray[n11]) || n12 <= 0 && !bl) continue;
                if (bl && (!blArray[n11] && n12 < nArray4[n11] && n14 + n12 < nArray4[n11] || blArray[n11] && n12 < n7)) {
                    if (n11 == n2) {
                        System.out.println(n13 + " = " + " left=" + fArray3[n13] + " bottom=" + fArray2[n13] + " right=" + fArray4[n13] + " top=" + fArray[n13]);
                    }
                    this.textHighlightsWidth[n11] = blArray[n11] ? (n12 > 0 ? n14 + n12 : n14 - n12) : (n12 > 0 ? n12 : n14 + n12);
                    if (n11 == n2) {
                        System.out.println("new=" + this.textHighlightsWidth[n11]);
                    }
                    j = n;
                    continue;
                }
                if (n12 <= n7) continue;
            }
        }
    }

    @Override
    public void setPrintPage(int n) {
        this.pageNumber = n;
    }

    @Override
    public int getObjectUnderneath(int n, int n2) {
        int n3 = -1;
        Rectangle[] rectangleArray = this.areas.get();
        int n4 = rectangleArray.length;
        int[] nArray = this.objectType.get();
        boolean bl = true;
        for (int i = n4 - 1; i > -1; --i) {
            if (rectangleArray[i] == null || !RenderUtils.rectangleContains(rectangleArray[i], n, n2, i) || nArray[i] == 2 || nArray[i] == 7) continue;
            bl = false;
            n3 = nArray[i];
            i = -1;
        }
        if (bl) {
            return -1;
        }
        return n3;
    }

    @Override
    public void flagImageDeleted(int n) {
        this.objectType.setElementAt(27, n);
    }

    @Override
    public void setOCR(boolean bl) {
        this.hasOCR = bl;
    }

    static {
        hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        userAlerted = false;
    }
}

