/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Image;
import javax.swing.ImageIcon;

public class CustomImageIcon
extends ImageIcon {
    private static final long serialVersionUID = 5003778613900628453L;
    protected static float MAXSCALEFACTOR = 1.5f;
    protected int iconWidth = -1;
    protected int iconHeight = -1;
    protected int iconRotation = 0;
    protected int iconOpp = 180;
    protected int pageRotate = 0;
    protected boolean displaySingle = false;

    public static void setMaxScaleFactor(float f) {
        MAXSCALEFACTOR = f;
    }

    public CustomImageIcon(int n) {
        this.iconRotation = n;
        this.iconOpp = this.iconRotation - 180;
        if (this.iconOpp < 0) {
            this.iconOpp += 360;
        }
    }

    public void setAttributes(int n, int n2, int n3, boolean bl) {
        int n4 = CustomImageIcon.validateRotationValue(n3 - this.iconRotation);
        this.pageRotate = n3;
        if (n4 == this.iconRotation || n4 == this.iconOpp) {
            this.iconWidth = n;
            this.iconHeight = n2;
        } else {
            this.iconWidth = n2;
            this.iconHeight = n;
        }
        this.displaySingle = bl;
    }

    protected static int validateRotationValue(int n) {
        if ((n %= 360) < 0) {
            n += 360;
        }
        return n;
    }

    @Override
    public int getIconHeight() {
        if (this.iconHeight == -1) {
            Image image = this.getImage();
            if (image == null) {
                return -1;
            }
            return image.getHeight(null);
        }
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        if (this.iconWidth == -1) {
            Image image = this.getImage();
            if (image == null) {
                return -1;
            }
            return image.getWidth(null);
        }
        return this.iconWidth;
    }
}

