/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.linear;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jpedal.PdfDecoder;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.PdfReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;

public class LinearThread
extends Thread {
    public int percentageDone = 0;
    FileChannel fos;
    PdfObject linearObj;
    InputStream is;
    File tempURLFile;
    LinearizedHintTable linHintTable;
    final byte[] startObj = new byte[]{111, 98, 106};
    final byte[] endObj = new byte[]{101, 110, 100, 111, 98, 106};
    int startCharReached = 0;
    int endCharReached = 0;
    int startObjPtr = 0;
    int endObjPtr = 0;
    int bufSize = 8192;
    int lastBytes = 8192;
    int generation = 0;
    int ref = 0;
    int firstObjLength = 0;
    PdfDecoder decode_pdf;

    public LinearThread(InputStream inputStream, FileChannel fileChannel, File file, PdfObject pdfObject, byte[] byArray, LinearizedHintTable linearizedHintTable, PdfDecoder pdfDecoder) {
        this.fos = fileChannel;
        this.linearObj = pdfObject;
        this.is = inputStream;
        this.tempURLFile = file;
        this.linHintTable = linearizedHintTable;
        this.decode_pdf = pdfDecoder;
        this.firstObjLength = byArray.length;
        this.scanStreamForObjects(0, null, byArray);
    }

    public int getPercentageLoaded() {
        return this.percentageDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = this.linearObj.getInt(28);
        try {
            int n2;
            int n3 = 0;
            byte[] byArray = new byte[this.lastBytes];
            byte[] byArray2 = new byte[this.bufSize];
            while ((n2 = this.is.read(byArray2)) != -1 && !this.isInterrupted() && this.isAlive()) {
                if (n2 > 0) {
                    FileChannel fileChannel = this.fos;
                    synchronized (fileChannel) {
                        byte[] byArray3 = new byte[n2];
                        System.arraycopy(byArray2, 0, byArray3, 0, n2);
                        byArray2 = byArray3;
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
                        this.fos.write(byteBuffer);
                    }
                }
                if (n2 > 0) {
                    this.scanStreamForObjects(this.firstObjLength + n3, byArray, byArray2);
                    n3 += n2;
                    int n4 = 30;
                    int n5 = byArray2.length;
                    if (n4 > n5 - 1) {
                        n4 = n5 - 1;
                    }
                    byArray = new byte[n4];
                    System.arraycopy(byArray2, n5 - n4, byArray, 0, n4);
                }
                this.percentageDone = (int)(100.0f * ((float)n3 / (float)n));
            }
            this.linHintTable.setFinishedReading();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                this.is.close();
                this.decode_pdf.waitForDecodingToFinish();
                this.decode_pdf.currentPdfFile = new PdfReader();
                if (this.isAlive() && !this.isInterrupted()) {
                    this.decode_pdf.openPdfFile(this.tempURLFile.getAbsolutePath());
                    this.decode_pdf.objectStoreRef.storeFileName(this.tempURLFile.getName().substring(0, this.tempURLFile.getName().lastIndexOf(46)));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void scanStreamForObjects(int n, byte[] byArray, byte[] byArray2) {
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            if (this.startCharReached == 0) {
                if (byArray2[i] != 32 && byArray2[i] != 0 && byArray2[i] != 10 && byArray2[i] != 32) continue;
                ++this.startCharReached;
                continue;
            }
            if (this.startCharReached < 4) {
                if (byArray2[i] == this.startObj[this.startCharReached - 1]) {
                    if (this.startCharReached == 3) {
                        byte[] byArray3;
                        int n3;
                        this.startObjPtr = n + i - 4;
                        int n4 = i - 4;
                        if (byArray != null && n4 < 30) {
                            n3 = byArray.length;
                            int n5 = byArray2.length;
                            byArray3 = new byte[n3 + n5];
                            System.arraycopy(byArray, 0, byArray3, 0, n3);
                            System.arraycopy(byArray2, 0, byArray3, n3, n5);
                            n4 += n3;
                        } else {
                            byArray3 = byArray2;
                        }
                        n3 = n4;
                        while (byArray3[n4] != 10 && byArray3[n4] != 13 && byArray3[n4] != 32 && byArray3[n4] != 9) {
                            --n4;
                            --this.startObjPtr;
                        }
                        this.generation = NumberUtils.parseInt(n4 + 1, n3, byArray3);
                        while (byArray3[n4] == 10 || byArray3[n4] == 13 || byArray3[n4] == 32 || byArray3[n4] == 47 || byArray3[n4] == 60) {
                            --n4;
                            --this.startObjPtr;
                        }
                        n3 = n4 + 1;
                        while (byArray3[n4] != 10 && byArray3[n4] != 13 && byArray3[n4] != 32 && byArray3[n4] != 47 && byArray3[n4] != 60 && byArray3[n4] != 62) {
                            --n4;
                            --this.startObjPtr;
                        }
                        this.ref = NumberUtils.parseInt(n4 + 1, n3, byArray3);
                    }
                    ++this.startCharReached;
                    continue;
                }
                this.startCharReached = 0;
                continue;
            }
            if (byArray2[i] == this.endObj[this.endCharReached]) {
                ++this.endCharReached;
                if (this.endCharReached != 6) continue;
                this.endObjPtr = n + i;
                this.linHintTable.storeOffset(this.ref, this.startObjPtr, this.endObjPtr);
                this.startCharReached = 0;
                this.endCharReached = 0;
                continue;
            }
            this.endCharReached = 0;
        }
    }
}

