/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.Name;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.TTFontWriter;

public class NameWriter
extends Name
implements FontTableWriter {
    String[] strings = new String[7];

    public NameWriter(PdfFont pdfFont, PdfJavaGlyphs pdfJavaGlyphs, String string) {
        this.strings[0] = pdfFont.getCopyright() != null ? pdfFont.getCopyright() : "No copyright information found.";
        this.strings[1] = string;
        switch (pdfJavaGlyphs.style) {
            case 0: {
                this.strings[2] = "Roman";
                break;
            }
            case 1: {
                this.strings[2] = "Bold";
                break;
            }
            case 2: {
                this.strings[2] = "Italic";
                break;
            }
            default: {
                this.strings[2] = "Roman";
            }
        }
        this.strings[3] = "JPedal PDF2HTML " + string + " " + new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(Calendar.getInstance().getTime());
        this.strings[4] = string;
        this.strings[5] = "Version 1.0";
        this.strings[6] = string;
    }

    @Override
    public byte[] writeTable() throws IOException {
        int n;
        byte[] byArray;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(0));
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(14));
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(174));
        int n3 = 0;
        for (n2 = 0; n2 < 7; ++n2) {
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(1));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(0));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(n2));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.strings[n2].length()));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(n3));
            n3 += this.strings[n2].length();
        }
        for (n2 = 0; n2 < 7; ++n2) {
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(3));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(1));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(1033));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(n2));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.strings[n2].length() * 2));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(n3));
            n3 += this.strings[n2].length() * 2;
        }
        for (n2 = 0; n2 < 7; ++n2) {
            byArray = this.strings[n2].getBytes("US-ASCII");
            for (n = 0; n < byArray.length; ++n) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint8(byArray[n]));
            }
        }
        for (n2 = 0; n2 < 7; ++n2) {
            byArray = this.strings[n2].getBytes("UTF-16BE");
            for (n = 0; n < byArray.length; ++n) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint8(byArray[n]));
            }
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public int getIntValue(int n) {
        int n2 = 0;
        switch (n) {
            default: 
        }
        return n2;
    }
}

