/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.TTFontWriter;

public class HmtxWriter
extends Hmtx
implements FontTableWriter {
    int glyphCount;
    int[] advanceWidth;
    int[] leftSideBearing;

    public HmtxWriter(PdfFont pdfFont, PdfJavaGlyphs pdfJavaGlyphs, int[] nArray) {
        this.glyphCount = pdfJavaGlyphs.getGlyphCount();
        this.advanceWidth = nArray;
        this.leftSideBearing = new int[65535];
    }

    @Override
    public byte[] writeTable() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < this.glyphCount; ++i) {
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.advanceWidth[i]));
            byteArrayOutputStream.write(TTFontWriter.setNextInt16(this.leftSideBearing[i]));
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public int getIntValue(int n) {
        return 0;
    }
}

