/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.print.attribute.standard.PageRanges;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.gui.popups.Save;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class CropPDFPages
extends Save {
    JLabel OutputLabel = new JLabel();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    ButtonGroup buttonGroup2 = new ButtonGroup();
    JToggleButton jToggleButton3 = new JToggleButton();
    JToggleButton jToggleButton2 = new JToggleButton();
    JSpinner bottomMargin = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    JSpinner topMargin = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    JSpinner leftMargin = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    JSpinner rightMargin = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    JCheckBox applyToCurrent = new JCheckBox();
    JRadioButton printAll = new JRadioButton();
    JRadioButton printCurrent = new JRadioButton();
    JRadioButton printPages = new JRadioButton();
    JTextField pagesBox = new JTextField();

    public CropPDFPages(String string, int n, int n2) {
        super(string, n, n2);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int[] getPages() {
        int[] nArray = null;
        if (this.printAll.isSelected()) {
            nArray = new int[this.end_page];
            for (int i = 0; i < this.end_page; ++i) {
                nArray[i] = i + 1;
            }
            return nArray;
        } else if (this.printCurrent.isSelected()) {
            nArray = new int[]{this.currentPage};
            return nArray;
        } else {
            if (!this.printPages.isSelected()) return nArray;
            try {
                PageRanges pageRanges = new PageRanges(this.pagesBox.getText());
                int n = 0;
                int n2 = -1;
                while ((n2 = pageRanges.next(n2)) != -1) {
                    ++n;
                }
                nArray = new int[n];
                n = 0;
                n2 = -1;
                while ((n2 = pageRanges.next(n2)) != -1) {
                    if (n2 > this.end_page) {
                        if (!SimpleViewer.showMessages) return null;
                        JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerText.Page") + ' ' + n2 + ' ' + Messages.getMessage("PdfViewerError.OutOfBounds") + ' ' + Messages.getMessage("PdfViewerText.PageCount") + ' ' + this.end_page);
                        return null;
                    }
                    nArray[n] = n2;
                    ++n;
                }
                return nArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogWriter.writeLog("Exception " + illegalArgumentException + " in exporting pdfs");
                if (!SimpleViewer.showMessages) return nArray;
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.InvalidSyntax"));
            }
        }
        return nArray;
    }

    public boolean applyToCurrentCrop() {
        return this.applyToCurrent.isSelected();
    }

    public float[] getCrop() {
        float f = Float.parseFloat(this.leftMargin.getValue().toString());
        float f2 = Float.parseFloat(this.bottomMargin.getValue().toString());
        float f3 = Float.parseFloat(this.rightMargin.getValue().toString());
        float f4 = Float.parseFloat(this.topMargin.getValue().toString());
        return new float[]{f, f2, f3, f4};
    }

    private void jbInit() throws Exception {
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerLabel.CropMargins"));
        jLabel.setFont(new Font("Dialog", 1, 14));
        jLabel.setDisplayedMnemonic('0');
        jLabel.setBounds(new Rectangle(13, 13, 220, 26));
        JLabel jLabel2 = new JLabel(Messages.getMessage("PdfViewerLabel.Top"));
        jLabel2.setBounds(140, 50, 70, 15);
        this.topMargin.setBounds(200, 45, 60, 23);
        JLabel jLabel3 = new JLabel(Messages.getMessage("PdfViewerLabel.Left"));
        jLabel3.setBounds(25, 100, 50, 15);
        this.leftMargin.setBounds(70, 95, 60, 23);
        JLabel jLabel4 = new JLabel(Messages.getMessage("PdfViewerLabel.Right"));
        jLabel4.setBounds(295, 100, 70, 15);
        this.rightMargin.setBounds(340, 95, 60, 23);
        JLabel jLabel5 = new JLabel(Messages.getMessage("PdfViewerLabel.Bottom"));
        jLabel5.setBounds(140, 150, 110, 15);
        this.bottomMargin.setBounds(200, 145, 60, 23);
        this.applyToCurrent.setSelected(true);
        this.applyToCurrent.setText(Messages.getMessage("PdfViewerCheckBox.ApplyToPriorCroppingRectangle"));
        this.applyToCurrent.setBounds(5, 190, 305, 15);
        JButton jButton = new JButton(Messages.getMessage("PdfViewerButton.Set2Zero"));
        jButton.setBounds(310, 185, 130, 23);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CropPDFPages.this.leftMargin.setValue(new Integer(0));
                CropPDFPages.this.rightMargin.setValue(new Integer(0));
                CropPDFPages.this.topMargin.setValue(new Integer(0));
                CropPDFPages.this.bottomMargin.setValue(new Integer(0));
            }
        });
        this.pageRangeLabel.setText(Messages.getMessage("PdfViewerPageRange.text"));
        this.pageRangeLabel.setBounds(new Rectangle(13, 220, 199, 26));
        this.printAll.setText(Messages.getMessage("PdfViewerRadioButton.All"));
        this.printAll.setBounds(new Rectangle(23, 250, 75, 22));
        this.printCurrent.setText(Messages.getMessage("PdfViewerRadioButton.CurrentPage"));
        this.printCurrent.setBounds(new Rectangle(23, 270, 100, 22));
        this.printCurrent.setSelected(true);
        this.printPages.setText(Messages.getMessage("PdfViewerRadioButton.Pages"));
        this.printPages.setBounds(new Rectangle(23, 292, 70, 22));
        this.pagesBox.setBounds(new Rectangle(95, 292, 230, 22));
        this.pagesBox.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (CropPDFPages.this.pagesBox.getText().length() == 0) {
                    CropPDFPages.this.printCurrent.setSelected(true);
                } else {
                    CropPDFPages.this.printPages.setSelected(true);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        JTextArea jTextArea = new JTextArea(Messages.getMessage("PdfViewerMessage.PageNumberOrRange") + '\n' + Messages.getMessage("PdfViewerMessage.PageRangeExample"));
        jTextArea.setBounds(new Rectangle(23, 325, 400, 40));
        jTextArea.setOpaque(false);
        this.add(jLabel2);
        this.add(this.bottomMargin);
        this.add(jLabel3);
        this.add(this.topMargin);
        this.add(this.leftMargin);
        this.add(this.rightMargin);
        this.add(jLabel5);
        this.add(jLabel4);
        this.add(this.applyToCurrent);
        this.add(jButton);
        this.add((Component)this.printAll, null);
        this.add((Component)this.printCurrent, null);
        this.add((Component)this.printPages, null);
        this.add((Component)this.pagesBox, null);
        this.add((Component)jTextArea, null);
        this.add((Component)jLabel, null);
        this.add((Component)this.changeButton, null);
        this.add((Component)this.pageRangeLabel, null);
        this.add((Component)this.jToggleButton2, null);
        this.add((Component)this.jToggleButton3, null);
        this.buttonGroup1.add(this.printAll);
        this.buttonGroup1.add(this.printCurrent);
        this.buttonGroup1.add(this.printPages);
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(440, 400);
    }
}

