/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.BaseTransferHandler;
import org.jpedal.examples.simpleviewer.gui.MultiViewTransferHandler;
import org.jpedal.examples.simpleviewer.gui.SingleViewTransferHandler;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.popups.TipOfTheDay;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseListener;
import org.jpedal.examples.simpleviewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.simpleviewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class SimpleViewer {
    public static boolean showMessages = true;
    protected Values commonValues = new Values();
    protected Printer currentPrinter = new Printer();
    protected PdfDecoder decode_pdf = new PdfDecoder(true);
    protected GUIThumbnailPanel thumbnails = new SwingThumbnailPanel(this.commonValues, this.decode_pdf);
    private PropertiesFile properties = new PropertiesFile();
    public SwingGUI currentGUI = new SwingGUI(this.decode_pdf, this.commonValues, this.thumbnails, this.properties);
    private GUISearchWindow searchFrame = new SwingSearchWindow(this.currentGUI);
    protected Commands currentCommands = new Commands(this.commonValues, this.currentGUI, this.decode_pdf, this.thumbnails, this.properties, this.searchFrame, this.currentPrinter);
    protected GUIMouseHandler mouseHandler = new SwingMouseListener(this.decode_pdf, this.currentGUI, this.commonValues, this.currentCommands);
    protected String[] scalingValues;
    private boolean isSetup;
    public static final String PREFERENCES_DEFAULT = "jar:/org/jpedal/examples/simpleviewer/res/preferences/Default.xml";
    public static final String PREFERENCES_NO_GUI = "jar:/org/jpedal/examples/simpleviewer/res/preferences/NoGUI.xml";
    public static final String PREFERENCES_NO_SIDE_BAR = "jar:/org/jpedal/examples/simpleviewer/res/preferences/NoSideTabOrTopButtons.xml";
    public static final String PREFERENCES_OPEN_AND_NAV_ONLY = "jar:/org/jpedal/examples/simpleviewer/res/preferences/OpenAndNavOnly.xml";
    public static final String PREFERENCES_PDFHELP = "jar:/org/jpedal/examples/simpleviewer/res/preferences/PDFHelp.xml";
    public static final String PREFERENCES_BEAN = "jar:/org/jpedal/examples/simpleviewer/res/preferences/Bean.xml";
    public static boolean exitOnClose = true;
    private static String rawFile = "";
    public static String file = "";

    public SwingGUI getSwingGUI() {
        return this.currentGUI;
    }

    public void openDefaultFile(String string) {
        String string2;
        String string3 = System.getProperty("org.jpedal.hires");
        if (Commands.hires || string3 != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (string != null) {
            File file = new File(string);
            boolean bl = false;
            if (string.startsWith("http:") || string.startsWith("jar:") || string.startsWith("file:")) {
                LogWriter.writeLog("Opening http connection");
                bl = true;
            }
            if (!bl && !file.exists()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!bl && file.isDirectory()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setFileSize(file.length() >> 10);
                this.commonValues.setSelectedFile(string);
                this.currentGUI.setViewerTitle(null);
                String string4 = System.getProperty("org.jpedal.page");
                String string5 = System.getProperty("org.jpedal.bookmark");
                if (string4 != null && !bl) {
                    try {
                        int n = Integer.parseInt(string4);
                        if (n < 1) {
                            n = -1;
                            System.err.println(string4 + " must be 1 or larger. Opening on page 1");
                            LogWriter.writeLog(string4 + " must be 1 or larger. Opening on page 1");
                        }
                        if (n != -1) {
                            this.openFile(file, n);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(string4 + "is not a valid number for a page number. Opening on page 1");
                        LogWriter.writeLog(string4 + "is not a valid number for a page number. Opening on page 1");
                    }
                } else if (string5 != null) {
                    this.openFile(file, string5);
                } else {
                    try {
                        this.currentCommands.openFile(string);
                    }
                    catch (PdfException pdfException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void openDefaultFileAtPage(String string, int n) {
        String string2;
        String string3 = System.getProperty("org.jpedal.hires");
        if (Commands.hires || string3 != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (string != null) {
            File file = new File(string);
            boolean bl = false;
            if (string.startsWith("http:") || string.startsWith("jar:")) {
                LogWriter.writeLog("Opening http connection");
                bl = true;
            }
            if (!bl && !file.exists()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!bl && file.isDirectory()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setSelectedFile(string);
                this.commonValues.setFileSize(file.length() >> 10);
                this.currentGUI.setViewerTitle(null);
                this.openFile(file, n);
            }
        }
    }

    public SimpleViewer() {
        PdfDecoder.showErrorMessages = true;
        String string = System.getProperty("org.jpedal.SimpleViewer.Prefs");
        if (string != null) {
            this.properties.loadProperties(string);
        } else {
            this.properties.loadProperties();
        }
    }

    public SimpleViewer(int n) {
        PdfDecoder.showErrorMessages = true;
        String string = System.getProperty("org.jpedal.SimpleViewer.Prefs");
        if (string != null) {
            this.properties.loadProperties(string);
        } else {
            this.properties.loadProperties();
        }
        this.commonValues.setModeOfOperation(n);
    }

    public SimpleViewer(String string) {
        PdfDecoder.showErrorMessages = true;
        try {
            this.properties.loadProperties(string);
        }
        catch (Exception exception) {
            System.err.println("Specified Preferrences file not found at " + string + ". If this file is within a jar ensure filename has jar: at the begining.");
            System.exit(1);
        }
    }

    public SimpleViewer(Container container, String string) {
        PdfDecoder.showErrorMessages = true;
        if (string != null && string.length() > 0) {
            try {
                this.properties.loadProperties(string);
            }
            catch (Exception exception) {
                System.err.println("Specified Preferrences file not found at " + string + ". If this file is within a jar ensure filename has jar: at the begining.");
                System.exit(1);
            }
        } else {
            this.properties.loadProperties();
        }
        this.setRootContainer(container);
    }

    public void setRootContainer(Container container) {
        String string;
        Serializable serializable;
        if (container == null) {
            throw new RuntimeException("Null containers not allowed.");
        }
        Container container2 = container;
        if (container instanceof JTabbedPane) {
            serializable = new JPanel(new BorderLayout());
            container.add((Component)serializable);
            container2 = serializable;
        } else if (container instanceof JScrollPane) {
            serializable = new JPanel(new BorderLayout());
            ((JScrollPane)container).getViewport().add((Component)serializable);
            container2 = serializable;
        } else if (container instanceof JSplitPane) {
            throw new RuntimeException("To add the simpleViewer to a split pane please pass through either JSplitPane.getLeftComponent() or JSplitPane.getRightComponent()");
        }
        if (!(container instanceof JFrame)) {
            container2.setLayout(new BorderLayout());
        }
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        int n = ((Dimension)serializable).width / 2;
        int n2 = ((Dimension)serializable).height / 2;
        if (n < 700) {
            n = 700;
        }
        if ((string = System.getProperty("org.jpedal.startWindowSize")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "x");
            System.out.println(stringTokenizer.countTokens());
            if (stringTokenizer.countTokens() != 2) {
                throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + string + "\nValue should be in format org.jpedal.startWindowSize=200x300");
            }
            try {
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + string + "\nValue should be in format org.jpedal.startWindowSize=200x300");
            }
        }
        container2.setPreferredSize(new Dimension(n, n2));
        this.currentGUI.setFrame(container2);
    }

    public void loadProperties(String string) {
        this.properties.loadProperties(string);
    }

    public void loadProperties(InputStream inputStream) {
        this.properties.loadProperties(inputStream);
    }

    public void setupViewer() {
        BaseTransferHandler baseTransferHandler;
        boolean bl;
        Object object;
        String string;
        String string2 = System.getProperty("org.jpedal.suppressViewerPopups");
        boolean bl2 = false;
        if (string2 != null && string2.toLowerCase().equals("true")) {
            bl2 = true;
        }
        if ((string = this.properties.getValue("searchWindowType")) != null && string.length() != 0) {
            int n = Integer.parseInt(string);
            this.searchFrame.setStyle(n);
        } else {
            this.searchFrame.setStyle(SwingSearchWindow.SEARCH_MENU_BAR);
        }
        this.currentGUI.setSearchFrame(this.searchFrame);
        String string3 = System.getProperty("org.jpedal.thumbnail");
        if (string3 != null) {
            if (string3.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(true);
            } else if (string3.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(false);
            }
        } else {
            this.thumbnails.setThumbnailsEnabled(true);
        }
        String string4 = System.getProperty("org.jpedal.bundleLocation");
        if (string4 != null) {
            object = null;
            ClassLoader classLoader = Messages.class.getClassLoader();
            String string5 = string4.replaceAll("\\.", "/") + "_" + Locale.getDefault().getLanguage() + ".properties";
            try {
                object = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(string5)));
                ((BufferedReader)object).close();
            }
            catch (Exception exception) {
                Locale.setDefault(new Locale("en", "EN"));
                this.currentGUI.showMessageDialog("No locale file " + string5 + " has been defined for this Locale - using English as Default" + "\n Format is path, using '.' as break ie org.jpedal.international.messages");
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string4);
            this.init(resourceBundle);
        } else {
            this.init(null);
        }
        this.currentGUI.init(this.scalingValues, this.currentCommands, this.currentPrinter);
        this.mouseHandler.setupMouse();
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_TABBED_PANE) {
            this.currentGUI.searchInTab(this.searchFrame);
        }
        this.decode_pdf.getDynamicRenderer().setMessageFrame(this.currentGUI.getFrame());
        object = this.properties.getValue("showfirsttimepopup");
        boolean bl3 = bl = !bl2 && ((String)object).length() > 0 && ((String)object).equals("true");
        if (bl) {
            this.currentGUI.showFirstTimePopup();
            this.properties.setValue("showfirsttimepopup", "false");
        } else if (!bl2) {
            object = this.properties.getValue("showrhinomessage");
        }
        if (!bl2 && JAIHelper.isJAIused()) {
            object = this.properties.getValue("showddmessage");
            if (this.properties != null && ((String)object).length() > 0 && ((String)object).equals("true")) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.JAIWarning") + Messages.getMessage("PdfViewer.JAIWarning1") + Messages.getMessage("PdfViewer.JAIWarning2") + Messages.getMessage("PdfViewer.JAIWarning3") + Messages.getMessage("PdfViewer.JAIWarning4"));
                this.properties.setValue("showddmessage", "false");
            }
        }
        if (!bl2 && !this.commonValues.isContentExtractor()) {
            boolean bl4;
            object = this.properties.getValue("showitextmessage");
            boolean bl5 = bl4 = ((String)object).length() > 0 && ((String)object).equals("true");
            if (!this.commonValues.isItextOnClasspath() && bl4) {
                this.properties.setValue("showitextmessage", "false");
            }
        }
        if (this.currentGUI.isSingle()) {
            baseTransferHandler = new SingleViewTransferHandler(this.commonValues, this.thumbnails, this.currentGUI, this.currentCommands);
            this.decode_pdf.setTransferHandler(baseTransferHandler);
        } else {
            baseTransferHandler = new MultiViewTransferHandler(this.commonValues, this.thumbnails, this.currentGUI, this.currentCommands);
            this.currentGUI.getMultiViewerFrames().setTransferHandler(baseTransferHandler);
        }
        boolean bl6 = false;
        object = this.properties.getValue("displaytipsonstartup");
        if (!bl2 && !bl6 && ((String)object).length() > 0 && ((String)object).equals("true")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TipOfTheDay tipOfTheDay = new TipOfTheDay(SimpleViewer.this.currentGUI.getFrame(), "/org/jpedal/examples/simpleviewer/res/tips", SimpleViewer.this.properties);
                    tipOfTheDay.setVisible(true);
                }
            });
        }
        this.isSetup = true;
    }

    protected void init(ResourceBundle resourceBundle) {
        Runnable runnable;
        if (resourceBundle == null) {
            try {
                Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " loading resource bundle.\n" + "Also check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
            }
        } else {
            try {
                Messages.setBundle(resourceBundle);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception with bundle " + resourceBundle);
                exception.printStackTrace();
            }
        }
        this.scalingValues = new String[]{Messages.getMessage("PdfViewerScaleWindow.text"), Messages.getMessage("PdfViewerScaleHeight.text"), Messages.getMessage("PdfViewerScaleWidth.text"), "25%", "50%", "75%", "100%", "125%", "150%", "200%", "250%", "500%", "750%", "1000%"};
        if (this.commonValues.isContentExtractor()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.decode_pdf.setDisplayView(1, 1);
            } else {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        SimpleViewer.this.decode_pdf.setDisplayView(1, 1);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.decode_pdf.setDisplayView(1, 2);
        } else {
            runnable = new Runnable(){

                @Override
                public void run() {
                    SimpleViewer.this.decode_pdf.setDisplayView(1, 2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        this.decode_pdf.addExternalHandler(this.currentGUI, 4);
        PdfDecoder.init(true);
        this.decode_pdf.setExtractionMode(0, 72, 1.0f);
        FontMappings.setFontReplacements();
    }

    protected void createSwingMenu(boolean bl) {
        this.currentGUI.createMainMenu(bl);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " setting look and feel");
        }
        SimpleViewer simpleViewer = new SimpleViewer();
        simpleViewer.setupViewer();
        if (stringArray.length > 0) {
            simpleViewer.openDefaultFile(stringArray[0]);
        } else if (simpleViewer.properties.getValue("openLastDocument").toLowerCase().equals("true") && simpleViewer.properties.getRecentDocuments() != null && simpleViewer.properties.getRecentDocuments().length > 1) {
            int n = Integer.parseInt(simpleViewer.properties.getValue("lastDocumentPage"));
            if (n < 0) {
                n = 1;
            }
            simpleViewer.openDefaultFileAtPage(simpleViewer.properties.getRecentDocuments()[0], n);
        }
    }

    private void openFile(File file, String string) {
        try {
            Object object;
            boolean bl = this.currentCommands.openUpFile(file.getCanonicalPath());
            String string2 = null;
            int n = -1;
            if (this.decode_pdf.getOutlineAsXML() != null) {
                object = this.decode_pdf.getOutlineAsXML().getFirstChild();
                if (object != null) {
                    string2 = this.currentGUI.getBookmark(string);
                }
                if (string2 != null) {
                    n = Integer.parseInt(string2);
                }
            }
            if (string2 == null && (string2 = this.decode_pdf.getIO().convertNameToRef(string)) != null) {
                object = new OutlineObject(string2);
                this.decode_pdf.getIO().readObject((PdfObject)object);
                if (bl) {
                    this.currentCommands.processPage();
                }
                this.decode_pdf.getFormRenderer().getActionHandler().gotoDest((PdfObject)object, 3, 339034948);
            }
            if (string2 == null) {
                throw new PdfException("Unknown bookmark " + string);
            }
            if (n > -1) {
                this.commonValues.setCurrentPage(n);
                if (bl) {
                    this.currentCommands.processPage();
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " processing file");
            Values.setProcessing(false);
        }
    }

    private void openFile(File file, int n) {
        try {
            boolean bl = this.currentCommands.openUpFile(file.getCanonicalPath());
            this.commonValues.setCurrentPage(n);
            if (bl) {
                this.currentCommands.processPage();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " processing file");
            Values.setProcessing(false);
        }
    }

    public Object executeCommand(int n, Object[] objectArray) {
        if (!this.isSetup) {
            throw new RuntimeException("You must call simpleViewer.setupViewer(); before you call any commands");
        }
        return this.currentCommands.executeCommand(n, objectArray);
    }

    public SearchList getSearchResults() {
        return this.currentCommands.getSearchList();
    }

    public boolean isProcessing() {
        SimpleViewer simpleViewer = this;
        return simpleViewer.commonValues.isProcessing();
    }

    public void addExternalHandler(Object object, int n) {
        this.decode_pdf.addExternalHandler(object, n);
    }

    public void dispose() {
        this.commonValues = null;
        this.currentPrinter = null;
        if (this.thumbnails != null) {
            this.thumbnails.dispose();
        }
        this.thumbnails = null;
        this.properties.dispose();
        this.properties = null;
        if (this.currentGUI != null) {
            this.currentGUI.dispose();
        }
        this.currentGUI = null;
        this.searchFrame = null;
        this.currentCommands = null;
        this.mouseHandler = null;
        this.scalingValues = null;
        if (this.decode_pdf != null) {
            this.decode_pdf.dispose();
        }
        this.decode_pdf = null;
        Messages.dispose();
    }
}

