/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public class LabColorSpace
extends GenericColorSpace {
    private int r;
    private int g;
    private int b;
    private float lastL = -1.0f;
    private float lastA = 65536.0f;
    private float lastBstar;
    private Hashtable cache = new Hashtable();
    private static final float C1 = 0.12841855f;
    private static final float C2 = 0.13793103f;
    private static final float C3 = 0.20689656f;
    private static final float C4 = 0.39215687f;
    private static final float C5 = 128.0f;

    public LabColorSpace(float[] fArray, float[] fArray2, float[] fArray3) {
        this.value = 1847602;
        this.setCIEValues(fArray, fArray2, fArray3, null, null);
    }

    @Override
    public byte[] convertIndexToRGB(byte[] byArray) {
        this.isConverted = true;
        int n = byArray.length;
        for (int i = 0; i < n; i += 3) {
            float f = (float)(byArray[i] & 0xFF) * 0.39215687f;
            float f2 = (float)(byArray[i + 1] & 0xFF) - 128.0f;
            float f3 = (float)(byArray[i + 2] & 0xFF) - 128.0f;
            this.convertToRGB(f, f2, f3);
            byArray[i] = (byte)this.r;
            byArray[i + 1] = (byte)this.g;
            byArray[i + 2] = (byte)this.b;
        }
        return byArray;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl) {
        BufferedImage bufferedImage;
        block3: {
            bufferedImage = null;
            try {
                Raster raster = LabColorSpace.readRasterFromJPeg(byArray);
                raster = LabColorSpace.cleanupRaster(raster, n3, n4, 3);
                int n5 = raster.getWidth();
                int n6 = raster.getHeight();
                int n7 = n5 * n6;
                byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                for (int i = 0; i < n7 * 3; i += 3) {
                    float f = (float)(byArray2[i] & 0xFF) * 0.39215687f;
                    float f2 = (float)(byArray2[i + 1] & 0xFF) - 128.0f;
                    float f3 = (float)(byArray2[i + 2] & 0xFF) - 128.0f;
                    this.convertToRGB(f, f2, f3);
                    byArray2[i] = (byte)this.r;
                    byArray2[i + 1] = (byte)this.g;
                    byArray2[i + 2] = (byte)this.b;
                }
                bufferedImage = new BufferedImage(n5, n6, 1);
                DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
                int[] nArray = new int[]{0, 1, 2};
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n5, n6, n5 * 3, 3, nArray, null);
                bufferedImage.setData(writableRaster);
            }
            catch (Exception exception) {
                bufferedImage = null;
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
            }
        }
        return bufferedImage;
    }

    @Override
    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        block3: {
            bufferedImage = null;
            int n3 = n * n2;
            try {
                for (int i = 0; i < n3 * 3; i += 3) {
                    float f = (float)(byArray[i] & 0xFF) * 0.39215687f;
                    float f2 = (float)(byArray[i + 1] & 0xFF) - 128.0f;
                    float f3 = (float)(byArray[i + 2] & 0xFF) - 128.0f;
                    this.convertToRGB(f, f2, f3);
                    byArray[i] = (byte)this.r;
                    byArray[i + 1] = (byte)this.g;
                    byArray[i + 2] = (byte)this.b;
                }
                bufferedImage = new BufferedImage(n, n2, 1);
                Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray, n, n2);
                bufferedImage.setData(raster);
            }
            catch (Exception exception) {
                bufferedImage = null;
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
            }
        }
        return bufferedImage;
    }

    private void convertToRGB(float f, float f2, float f3) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 100.0f) {
            f = 100.0f;
        }
        if (f2 < this.R[0]) {
            f2 = this.R[0];
        } else if (f2 > this.R[1]) {
            f2 = this.R[1];
        }
        if (f3 < this.R[2]) {
            f3 = this.R[2];
        } else if (f3 > this.R[3]) {
            f3 = this.R[3];
        }
        if (this.lastL != f || this.lastA != f2 || this.lastBstar != f3) {
            int n = (int)f;
            int n2 = (int)(f2 - this.R[0]);
            int n3 = (int)(f3 - this.R[2]);
            Integer n4 = new Integer((n << 16) + (n2 << 8) + n3);
            Object v = this.cache.get(n4);
            if (v != null) {
                int n5 = (Integer)v;
                this.r = n5 >> 16 & 0xFF;
                this.g = n5 >> 8 & 0xFF;
                this.b = n5 & 0xFF;
            } else {
                int n6;
                double d = ((double)f + 16.0) / 116.0;
                double[] dArray = new double[]{d + (double)f2 / 500.0, d, d - (double)f3 / 200.0};
                float[] fArray = new float[3];
                for (n6 = 0; n6 < 3; ++n6) {
                    fArray[n6] = dArray[n6] >= 0.2068965584039688 ? (float)((double)this.W[n6] * dArray[n6] * dArray[n6] * dArray[n6]) : (float)((double)(this.W[n6] * 0.12841855f) * (dArray[n6] - 0.13793103396892548));
                    if (!(fArray[n6] < 0.0f)) continue;
                    fArray[n6] = 0.0f;
                }
                fArray = this.cs.toRGB(fArray);
                this.r = (int)(fArray[0] * 255.0f);
                this.g = (int)(fArray[1] * 255.0f);
                this.b = (int)(fArray[2] * 255.0f);
                if (this.r < 0) {
                    this.r = 0;
                }
                if (this.g < 0) {
                    this.g = 0;
                }
                if (this.b < 0) {
                    this.b = 0;
                }
                if (this.r > 255) {
                    this.r = 255;
                }
                if (this.g > 255) {
                    this.g = 255;
                }
                if (this.b > 255) {
                    this.b = 255;
                }
                n6 = (this.r << 16) + (this.g << 8) + this.b;
                this.cache.put(n4, new Integer(n6));
            }
            this.lastL = f;
            this.lastA = f2;
            this.lastBstar = f3;
        }
    }

    @Override
    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.setColor(fArray, n);
    }

    @Override
    public final void setColor(float[] fArray, int n) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        this.convertToRGB(f, f2, f3);
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }
}

