/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.gfx;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.sf.robocode.io.Logger;
import net.sf.robocode.ui.gfx.ColorUtil;

public class ImageUtil {
    public static Image getImage(String filename) {
        URL url = ImageUtil.class.getResource(filename);
        if (url == null) {
            Logger.logError((String)("Could not load image because of invalid filename: " + filename));
            return null;
        }
        try {
            BufferedImage result = ImageIO.read(url);
            if (result == null) {
                String message = "Could not load image: " + filename;
                Logger.logError((String)message);
                throw new Error();
            }
            return result;
        }
        catch (IOException e) {
            Logger.logError((String)("Could not load image: " + filename));
            return null;
        }
    }

    public static BufferedImage getBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics g = bufferedImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static Image createColouredRobotImage(Image img, Color color) {
        return color == null ? img : (img == null ? null : Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(img.getSource(), new ColorFilter(color))));
    }

    private static class ColorFilter
    extends RGBImageFilter {
        private final float[] hsl;

        public ColorFilter(Color color) {
            this.hsl = ColorUtil.fromRGBtoHSL(color.getRed(), color.getGreen(), color.getBlue());
        }

        public int filterRGB(int x, int y, int argb) {
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            float[] HSL = ColorUtil.fromRGBtoHSL(r, g, b);
            if (HSL[1] > 0.0f) {
                float L = Math.min(1.0f, (this.hsl[2] + HSL[2]) / 2.0f + this.hsl[2] / 7.0f);
                return argb & 0xFF000000 | ColorUtil.fromHSLtoRGB(this.hsl[0], this.hsl[1], L);
            }
            return argb;
        }
    }
}

