/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.robocode.ui.dialog.Wizard;
import net.sf.robocode.ui.dialog.WizardController;
import net.sf.robocode.ui.dialog.WizardListener;
import net.sf.robocode.ui.dialog.WizardPanel;

public class WizardTabbedPane
extends JTabbedPane
implements Wizard {
    private WizardController wizardController;
    private int currentIndex = 0;
    private final WizardListener listener;
    private final EventHandler eventHandler = new EventHandler();

    public WizardTabbedPane(WizardListener listener) {
        this.listener = listener;
        this.initialize();
    }

    public void back() {
        this.setSelectedIndex(this.currentIndex - 1);
    }

    public Component getCurrentPanel() {
        return this.getSelectedComponent();
    }

    public WizardController getWizardController() {
        if (this.wizardController == null) {
            this.wizardController = new WizardController(this);
        }
        return this.wizardController;
    }

    public WizardListener getWizardListener() {
        return this.listener;
    }

    public void initialize() {
        this.addChangeListener(this.eventHandler);
        this.addContainerListener(this.eventHandler);
    }

    public boolean isBackAvailable() {
        return this.currentIndex > 0;
    }

    public boolean isCurrentPanelReady() {
        Component c = this.getCurrentPanel();
        return !(c instanceof WizardPanel) || ((WizardPanel)c).isReady();
    }

    public boolean isNextAvailable() {
        return this.currentIndex < this.getComponentCount() - 1 && this.isCurrentPanelReady();
    }

    public boolean isReady() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof WizardPanel) || ((WizardPanel)c).isReady()) continue;
            return false;
        }
        return true;
    }

    public void next() {
        this.setSelectedIndex(this.currentIndex + 1);
    }

    public void setWizardControllerOnPanel(WizardPanel panel) {
        panel.setWizardController(this.getWizardController());
    }

    public class EventHandler
    implements ContainerListener,
    ChangeListener {
        public void componentRemoved(ContainerEvent e) {
        }

        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof WizardPanel) {
                WizardTabbedPane.this.setWizardControllerOnPanel((WizardPanel)e.getChild());
                WizardTabbedPane.this.getWizardController().stateChanged(new ChangeEvent(e.getChild()));
            }
        }

        public void stateChanged(ChangeEvent e) {
            WizardTabbedPane.this.currentIndex = WizardTabbedPane.this.getSelectedIndex();
            WizardTabbedPane.this.getWizardController().stateChanged(e);
        }
    }
}

