/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.robocode.ui.dialog.Wizard;

public class WizardController
extends JPanel
implements ChangeListener {
    private final EventHandler eventHandler = new EventHandler();
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private JButton cancelButton;
    private boolean focusOnEnabled;
    private Wizard wizard = null;

    private void backButtonActionPerformed() {
        this.wizard.back();
    }

    private void cancelButtonActionPerformed() {
        this.wizard.getWizardListener().cancelButtonActionPerformed();
    }

    private void finishButtonActionPerformed() {
        this.wizard.getWizardListener().finishButtonActionPerformed();
    }

    private JButton getBackButton() {
        if (this.backButton == null) {
            this.backButton = new JButton();
            this.backButton.setText("Back");
            this.backButton.setMnemonic('B');
            this.backButton.addActionListener(this.eventHandler);
        }
        return this.backButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic('C');
            this.cancelButton.addActionListener(this.eventHandler);
        }
        return this.cancelButton;
    }

    private JButton getFinishButton() {
        if (this.finishButton == null) {
            this.finishButton = new JButton();
            this.finishButton.setText("Finish");
            this.finishButton.setMnemonic('F');
            this.finishButton.addActionListener(this.eventHandler);
        }
        return this.finishButton;
    }

    public void setFinishButtonText(String text) {
        this.getFinishButton().setText(text);
    }

    public void setFinishButtonTextAndMnemonic(String text, char mnemonic, int mnemonicIndex) {
        this.getFinishButton().setText(text);
        this.getFinishButton().setMnemonic(mnemonic);
        this.getFinishButton().setDisplayedMnemonicIndex(mnemonicIndex);
    }

    private JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton();
            this.nextButton.setText("Next");
            this.nextButton.setMnemonic('N');
            this.nextButton.addActionListener(this.eventHandler);
        }
        return this.nextButton;
    }

    private void initialize() {
        this.add(this.getBackButton());
        this.add(this.getNextButton());
        this.add(new JLabel("     "));
        this.add(this.getFinishButton());
        this.add(this.getCancelButton());
    }

    private void nextButtonActionPerformed() {
        this.wizard.next();
    }

    private void setBackButtonEnabled(boolean enabled) {
        this.getBackButton().setEnabled(enabled);
    }

    public void setFinishButtonEnabled(boolean enabled) {
        this.getFinishButton().setEnabled(enabled);
        if (this.focusOnEnabled && enabled) {
            this.getFinishButton().requestFocus();
        }
    }

    private void setNextButtonEnabled(boolean enabled) {
        this.getNextButton().setEnabled(enabled);
    }

    protected WizardController(Wizard wizard) {
        this.wizard = wizard;
        this.initialize();
        this.stateChanged(null);
    }

    public void stateChanged(ChangeEvent e) {
        this.setBackButtonEnabled(this.wizard.isBackAvailable());
        this.setNextButtonEnabled(this.wizard.isNextAvailable());
        this.setFinishButtonEnabled(this.wizard.isReady());
    }

    public boolean getFocusOnEnabled() {
        return this.focusOnEnabled;
    }

    public void setFocusOnEnabled(boolean focusOnEnabled) {
        this.focusOnEnabled = focusOnEnabled;
    }

    class EventHandler
    implements ActionListener {
        EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == WizardController.this.getFinishButton()) {
                WizardController.this.finishButtonActionPerformed();
            }
            if (e.getSource() == WizardController.this.getCancelButton()) {
                WizardController.this.cancelButtonActionPerformed();
            }
            if (e.getSource() == WizardController.this.getNextButton()) {
                WizardController.this.nextButtonActionPerformed();
            }
            if (e.getSource() == WizardController.this.getBackButton()) {
                WizardController.this.backButtonActionPerformed();
            }
        }
    }
}

