/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;

public class ConsoleScrollPane
extends JScrollPane {
    private final int MAX_ROWS = 500;
    private JTextArea textArea;
    private int lines;
    private int maxRows;

    public ConsoleScrollPane() {
        this.setViewportView(this.getTextPane());
        this.lines = 0;
    }

    public JTextArea getTextPane() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setEditable(false);
            this.textArea.setTabSize(4);
            this.textArea.setBackground(Color.DARK_GRAY);
            this.textArea.setForeground(Color.WHITE);
            this.textArea.setBounds(0, 0, 1000, 1000);
            ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(1);
        }
        return this.textArea;
    }

    public void append(String text) {
        ++this.lines;
        this.getTextPane().append(text);
        if (this.lines > 500) {
            int from;
            this.lines = 0;
            String[] rows = this.getText().split("\n");
            StringBuilder sb = new StringBuilder();
            for (int i = from = Math.min(rows.length, Math.max(250, rows.length - 250)); i < rows.length; ++i) {
                sb.append(rows[i]);
                sb.append('\n');
                ++this.lines;
            }
            this.setText(sb.toString());
        }
    }

    public String getSelectedText() {
        return this.getTextPane().getSelectedText();
    }

    public String getText() {
        return this.getTextPane().getText();
    }

    public void setText(String text) {
        JTextArea textArea = this.getTextPane();
        textArea.setText(text);
        this.maxRows = Math.max(this.maxRows, textArea.getLineCount());
        textArea.setRows(this.maxRows);
    }

    public void processStream(InputStream input) {
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                this.append(line + "\n");
            }
        }
        catch (IOException e) {
            this.append("SYSTEM: IOException: " + e);
        }
        this.scrollToBottom();
    }

    public void scrollToBottom() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConsoleScrollPane.this.getViewport().scrollRectToVisible(new Rectangle(0, Short.MAX_VALUE, 1, 1));
                ConsoleScrollPane.this.getViewport().repaint();
            }
        });
    }
}

