/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.robocode.repository.INamedFileSpecification;
import net.sf.robocode.ui.BrowserManager;

public class RobotDescriptionPanel
extends JPanel {
    private JLabel robotNameLabel;
    private final JLabel[] descriptionLabel = new JLabel[3];
    private JPanel descriptionPanel;
    private JButton detailsButton;
    private JLabel robocodeVersionLabel;
    private JLabel filePathLabel;
    private INamedFileSpecification currentRobotSpecification;
    private static final String BLANK_STRING = "                                                                        ";
    private final EventHandler eventHandler = new EventHandler();

    public RobotDescriptionPanel() {
        this.initialize();
    }

    private JLabel getFilePathLabel() {
        if (this.filePathLabel == null) {
            this.filePathLabel = new JLabel();
            this.filePathLabel.setText(" ");
        }
        return this.filePathLabel;
    }

    private JLabel getDescriptionLabel(int index) {
        if (this.descriptionLabel[index] == null) {
            this.descriptionLabel[index] = new JLabel();
            this.descriptionLabel[index].setFont(new Font("Monospaced", 0, 10));
            this.descriptionLabel[index].setHorizontalAlignment(2);
            this.descriptionLabel[index].setText(BLANK_STRING);
        }
        return this.descriptionLabel[index];
    }

    private JPanel getDescriptionPanel() {
        if (this.descriptionPanel == null) {
            this.descriptionPanel = new JPanel();
            this.descriptionPanel.setAlignmentY(0.5f);
            this.descriptionPanel.setLayout(new BoxLayout(this.descriptionPanel, 1));
            this.descriptionPanel.setBorder(BorderFactory.createEtchedBorder());
            for (int i = 0; i < 3; ++i) {
                this.descriptionPanel.add(this.getDescriptionLabel(i));
            }
        }
        return this.descriptionPanel;
    }

    private JButton getDetailsButton() {
        if (this.detailsButton == null) {
            this.detailsButton = new JButton("Webpage");
            this.detailsButton.setMnemonic('W');
            this.detailsButton.setVisible(false);
            this.detailsButton.setAlignmentY(0.5f);
            this.detailsButton.addActionListener(this.eventHandler);
        }
        return this.detailsButton;
    }

    private JLabel getRobocodeVersionLabel() {
        if (this.robocodeVersionLabel == null) {
            this.robocodeVersionLabel = new JLabel();
        }
        return this.robocodeVersionLabel;
    }

    private JLabel getRobotNameLabel() {
        if (this.robotNameLabel == null) {
            this.robotNameLabel = new JLabel();
            this.robotNameLabel.setHorizontalAlignment(0);
            this.robotNameLabel.setText(" ");
        }
        return this.robotNameLabel;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.getRobotNameLabel(), "Center");
        JPanel q = new JPanel();
        q.setLayout(new FlowLayout(1, 1, 1));
        q.add(this.getRobocodeVersionLabel());
        p.add((Component)q, "East");
        q = new JPanel();
        q.setLayout(new FlowLayout(1, 1, 1));
        p.add((Component)q, "West");
        this.add((Component)p, "North");
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.getDetailsButton());
        this.add((Component)p, "West");
        p = new JPanel();
        p.setLayout(new FlowLayout(1, 1, 1));
        p.add(this.getDescriptionPanel());
        this.add((Component)p, "Center");
        p = new JPanel();
        p.setLayout(new FlowLayout(1, 1, 1));
        p.add(this.getFilePathLabel());
        this.add((Component)p, "South");
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.add((Component)p, "East");
    }

    public void showDescription(INamedFileSpecification robotSpecification) {
        this.currentRobotSpecification = robotSpecification;
        if (robotSpecification == null) {
            this.getRobotNameLabel().setText(" ");
            for (int i = 0; i < 3; ++i) {
                this.getDescriptionLabel(i).setText(BLANK_STRING);
            }
            this.getDetailsButton().setVisible(false);
            this.getRobocodeVersionLabel().setText(" ");
            this.getFilePathLabel().setText(" ");
        } else {
            String s;
            String name = robotSpecification.getUniqueFullClassNameWithVersion();
            if (name.charAt(name.length() - 1) == '*') {
                name = name.substring(0, name.length() - 1) + " (development version)";
            }
            if ((s = robotSpecification.getAuthorName()) != null && s.length() > 0) {
                name = name + " by " + s;
            }
            this.getRobotNameLabel().setText(name);
            if (robotSpecification.getJarFile() != null) {
                this.getFilePathLabel().setText(robotSpecification.getJarFile().getPath());
            } else {
                this.getFilePathLabel().setText(robotSpecification.getFilePath());
            }
            String desc = robotSpecification.getDescription();
            if (desc != null) {
                StringTokenizer tok = new StringTokenizer(desc, "\n");
                for (int count = 0; tok.hasMoreTokens() && count < 3; ++count) {
                    String line = tok.nextToken();
                    if (line == null) continue;
                    if (line.length() > BLANK_STRING.length()) {
                        line = line.substring(0, BLANK_STRING.length());
                    }
                    for (int i = line.length(); i < BLANK_STRING.length(); ++i) {
                        line = line + " ";
                    }
                    this.getDescriptionLabel(count).setText(line);
                }
            }
            for (int i = count; i < 3; ++i) {
                this.getDescriptionLabel(i).setText(BLANK_STRING);
            }
            URL u = robotSpecification.getWebpage();
            this.getDetailsButton().setVisible(u != null && u.toString().length() > 0);
            String v = robotSpecification.getRobocodeVersion();
            this.getRobocodeVersionLabel().setText(v == null ? "" : "Built for " + v);
        }
        this.getDescriptionPanel().setMaximumSize(this.getDescriptionPanel().getPreferredSize());
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            URL htmlFile;
            if (e.getSource() == RobotDescriptionPanel.this.getDetailsButton() && RobotDescriptionPanel.this.currentRobotSpecification != null && (htmlFile = RobotDescriptionPanel.this.currentRobotSpecification.getWebpage()) != null && htmlFile.toString().length() > 0) {
                try {
                    BrowserManager.openURL(htmlFile.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

