/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.robocode.settings.ISettingsListener;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.dialog.WizardPanel;

public class PreferencesViewOptionsTab
extends WizardPanel {
    private static final int MIN_TPS = 1;
    private static final int DEFAULT_TPS = 30;
    private static final int FAST_TPS = 45;
    private static final int MAX_TPS = 10000;
    private final EventHandler eventHandler = new EventHandler();
    private JCheckBox visibleRobotEnergyCheckBox;
    private JCheckBox visibleRobotNameCheckBox;
    private JCheckBox visibleScanArcsCheckBox;
    private JCheckBox visibleExplosionsCheckBox;
    private JCheckBox visibleGroundCheckBox;
    private JCheckBox visibleExplosionDebrisCheckBox;
    private JButton defaultViewOptionsButton;
    private JButton enableAllViewOptionsButton;
    private JButton disableAllViewOptionsButton;
    private JTextField desiredTpsTextField;
    private JLabel desiredTpsLabel;
    private JCheckBox displayFpsCheckBox;
    private JCheckBox displayTpsCheckBox;
    private JPanel visibleOptionsPanel;
    private JPanel tpsOptionsPanel;
    private JButton minTpsButton;
    private JButton defaultTpsButton;
    private JButton fastTpsButton;
    private JButton maxTpsButton;
    private final ISettingsManager properties;

    public PreferencesViewOptionsTab(ISettingsManager properties) {
        this.properties = properties;
        this.initialize();
    }

    private void defaultViewOptionsButtonActionPerformed() {
        this.enableAllViewOptionsButtonActionPerformed();
        this.getVisibleScanArcsCheckBox().setSelected(false);
    }

    private void enableAllViewOptionsButtonActionPerformed() {
        this.getVisibleRobotEnergyCheckBox().setSelected(true);
        this.getVisibleRobotNameCheckBox().setSelected(true);
        this.getVisibleScanArcsCheckBox().setSelected(true);
        this.getVisibleExplosionsCheckBox().setSelected(true);
        this.getVisibleGroundCheckBox().setSelected(true);
        this.getVisibleExplosionDebrisCheckBox().setSelected(true);
    }

    private void disableAllViewOptionsButtonActionPerformed() {
        this.getVisibleRobotEnergyCheckBox().setSelected(false);
        this.getVisibleRobotNameCheckBox().setSelected(false);
        this.getVisibleScanArcsCheckBox().setSelected(false);
        this.getVisibleExplosionsCheckBox().setSelected(false);
        this.getVisibleGroundCheckBox().setSelected(false);
        this.getVisibleExplosionDebrisCheckBox().setSelected(false);
    }

    private void desiredTpsTextFieldStateChanged() {
        this.fireStateChanged();
        try {
            int tps = Integer.parseInt(this.getDesiredTpsTextField().getText());
            String s = "" + tps;
            if (tps < 1) {
                s = "Too low, must be at least 1";
            } else if (tps > 10000) {
                s = "Too high, max is 10000";
            }
            this.getDesiredTpsLabel().setText("Desired TPS: " + s);
        }
        catch (NumberFormatException e) {
            this.getDesiredTpsLabel().setText("Desired TPS: ???");
        }
    }

    private void maxTpsButtonActionPerformed() {
        this.getDesiredTpsTextField().setText("10000");
    }

    private void minTpsButtonActionPerformed() {
        this.getDesiredTpsTextField().setText("1");
    }

    private void fastTpsButtonActionPerformed() {
        this.getDesiredTpsTextField().setText("45");
    }

    private void defaultTpsButtonActionPerformed() {
        this.getDesiredTpsTextField().setText("30");
    }

    private JButton getDefaultViewOptionsButton() {
        if (this.defaultViewOptionsButton == null) {
            this.defaultViewOptionsButton = new JButton("Defaults");
            this.defaultViewOptionsButton.setMnemonic('u');
            this.defaultViewOptionsButton.setDisplayedMnemonicIndex(4);
            this.defaultViewOptionsButton.addActionListener(this.eventHandler);
        }
        return this.defaultViewOptionsButton;
    }

    private JButton getEnableAllViewOptionsButton() {
        if (this.enableAllViewOptionsButton == null) {
            this.enableAllViewOptionsButton = new JButton("Enable all");
            this.enableAllViewOptionsButton.setMnemonic('a');
            this.enableAllViewOptionsButton.setDisplayedMnemonicIndex(7);
            this.enableAllViewOptionsButton.addActionListener(this.eventHandler);
        }
        return this.enableAllViewOptionsButton;
    }

    private JButton getDisableAllViewOptionsButton() {
        if (this.disableAllViewOptionsButton == null) {
            this.disableAllViewOptionsButton = new JButton("Disable all");
            this.disableAllViewOptionsButton.setMnemonic('i');
            this.disableAllViewOptionsButton.setDisplayedMnemonicIndex(1);
            this.disableAllViewOptionsButton.addActionListener(this.eventHandler);
        }
        return this.disableAllViewOptionsButton;
    }

    private JLabel getDesiredTpsLabel() {
        if (this.desiredTpsLabel == null) {
            this.desiredTpsLabel = new JLabel("Desired TPS: ");
        }
        return this.desiredTpsLabel;
    }

    private JTextField getDesiredTpsTextField() {
        if (this.desiredTpsTextField == null) {
            this.desiredTpsTextField = new JTextField();
            this.desiredTpsTextField.setColumns(5);
            this.desiredTpsTextField.getDocument().addDocumentListener(this.eventHandler);
        }
        return this.desiredTpsTextField;
    }

    private JCheckBox getDisplayFpsCheckBox() {
        if (this.displayFpsCheckBox == null) {
            this.displayFpsCheckBox = new JCheckBox("Display FPS in titlebar");
            this.displayFpsCheckBox.setMnemonic('P');
            this.displayFpsCheckBox.setDisplayedMnemonicIndex(9);
        }
        return this.displayFpsCheckBox;
    }

    private JCheckBox getDisplayTpsCheckBox() {
        if (this.displayTpsCheckBox == null) {
            this.displayTpsCheckBox = new JCheckBox("Display TPS in titlebar");
            this.displayTpsCheckBox.setMnemonic('T');
            this.displayTpsCheckBox.setDisplayedMnemonicIndex(8);
        }
        return this.displayTpsCheckBox;
    }

    private JButton getDefaultTpsButton() {
        if (this.defaultTpsButton == null) {
            this.defaultTpsButton = new JButton("Default");
            this.defaultTpsButton.addActionListener(this.eventHandler);
        }
        return this.defaultTpsButton;
    }

    private JButton getMinTpsButton() {
        if (this.minTpsButton == null) {
            this.minTpsButton = new JButton("Minimum");
            this.minTpsButton.addActionListener(this.eventHandler);
        }
        return this.minTpsButton;
    }

    private JButton getMaxTpsButton() {
        if (this.maxTpsButton == null) {
            this.maxTpsButton = new JButton("Max");
            this.maxTpsButton.addActionListener(this.eventHandler);
        }
        return this.maxTpsButton;
    }

    private JButton getFastTpsButton() {
        if (this.fastTpsButton == null) {
            this.fastTpsButton = new JButton("Fast");
            this.fastTpsButton.addActionListener(this.eventHandler);
        }
        return this.fastTpsButton;
    }

    private JPanel getTpsOptionsPanel() {
        if (this.tpsOptionsPanel == null) {
            this.tpsOptionsPanel = new JPanel();
            this.tpsOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Turns Per Second (TPS)"));
            this.tpsOptionsPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.anchor = 18;
            c.gridwidth = 0;
            this.tpsOptionsPanel.add((Component)this.getDisplayTpsCheckBox(), c);
            this.tpsOptionsPanel.add((Component)this.getDisplayFpsCheckBox(), c);
            this.tpsOptionsPanel.add((Component)new JLabel(" "), c);
            this.tpsOptionsPanel.add((Component)this.getDesiredTpsLabel(), c);
            this.getDesiredTpsLabel().setHorizontalAlignment(0);
            JPanel p = new JPanel();
            JPanel q = new JPanel();
            q.setLayout(new GridLayout(1, 3));
            p.add(q);
            p.add(this.getDesiredTpsTextField());
            q = new JPanel();
            p.add(q);
            c.gridwidth = 0;
            this.tpsOptionsPanel.add((Component)p, c);
            this.tpsOptionsPanel.add((Component)new JLabel(" "), c);
            c.gridwidth = 1;
            c.fill = 0;
            c.weighty = 1.0;
            c.weightx = 0.0;
            this.tpsOptionsPanel.add((Component)this.getMinTpsButton(), c);
            this.tpsOptionsPanel.add((Component)this.getDefaultTpsButton(), c);
            this.tpsOptionsPanel.add((Component)this.getFastTpsButton(), c);
            this.tpsOptionsPanel.add((Component)this.getMaxTpsButton(), c);
        }
        return this.tpsOptionsPanel;
    }

    private JPanel getVisibleOptionsPanel() {
        if (this.visibleOptionsPanel == null) {
            this.visibleOptionsPanel = new JPanel();
            this.visibleOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Arena"));
            this.visibleOptionsPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.anchor = 18;
            c.gridwidth = 0;
            this.visibleOptionsPanel.add((Component)this.getVisibleRobotEnergyCheckBox(), c);
            this.visibleOptionsPanel.add((Component)this.getVisibleRobotNameCheckBox(), c);
            this.visibleOptionsPanel.add((Component)this.getVisibleScanArcsCheckBox(), c);
            this.visibleOptionsPanel.add((Component)this.getVisibleExplosionsCheckBox(), c);
            this.visibleOptionsPanel.add((Component)this.getVisibleGroundCheckBox(), c);
            this.visibleOptionsPanel.add((Component)this.getVisibleExplosionDebrisCheckBox(), c);
            this.visibleOptionsPanel.add((Component)new JLabel(" "), c);
            c.gridwidth = 1;
            c.fill = 0;
            c.weighty = 1.0;
            c.weightx = 0.0;
            this.visibleOptionsPanel.add((Component)this.getEnableAllViewOptionsButton(), c);
            this.visibleOptionsPanel.add((Component)this.getDisableAllViewOptionsButton(), c);
            this.visibleOptionsPanel.add((Component)new JLabel("     "), c);
            this.visibleOptionsPanel.add((Component)this.getDefaultViewOptionsButton(), c);
        }
        return this.visibleOptionsPanel;
    }

    private JCheckBox getVisibleRobotEnergyCheckBox() {
        if (this.visibleRobotEnergyCheckBox == null) {
            this.visibleRobotEnergyCheckBox = new JCheckBox("Visible Robot Energy");
            this.visibleRobotEnergyCheckBox.setMnemonic('y');
            this.visibleRobotEnergyCheckBox.setDisplayedMnemonicIndex(19);
        }
        return this.visibleRobotEnergyCheckBox;
    }

    private JCheckBox getVisibleRobotNameCheckBox() {
        if (this.visibleRobotNameCheckBox == null) {
            this.visibleRobotNameCheckBox = new JCheckBox("Visible Robot Name");
            this.visibleRobotNameCheckBox.setMnemonic('V');
        }
        return this.visibleRobotNameCheckBox;
    }

    private JCheckBox getVisibleScanArcsCheckBox() {
        if (this.visibleScanArcsCheckBox == null) {
            this.visibleScanArcsCheckBox = new JCheckBox("Visible Scan Arcs");
            this.visibleScanArcsCheckBox.setMnemonic('b');
            this.visibleScanArcsCheckBox.setDisplayedMnemonicIndex(4);
        }
        return this.visibleScanArcsCheckBox;
    }

    private JCheckBox getVisibleExplosionsCheckBox() {
        if (this.visibleExplosionsCheckBox == null) {
            this.visibleExplosionsCheckBox = new JCheckBox("Visible Explosions");
            this.visibleExplosionsCheckBox.setMnemonic('x');
            this.visibleExplosionsCheckBox.setDisplayedMnemonicIndex(9);
        }
        return this.visibleExplosionsCheckBox;
    }

    private JCheckBox getVisibleGroundCheckBox() {
        if (this.visibleGroundCheckBox == null) {
            this.visibleGroundCheckBox = new JCheckBox("Visible Ground");
            this.visibleGroundCheckBox.setMnemonic('G');
            this.visibleGroundCheckBox.setDisplayedMnemonicIndex(8);
        }
        return this.visibleGroundCheckBox;
    }

    private JCheckBox getVisibleExplosionDebrisCheckBox() {
        if (this.visibleExplosionDebrisCheckBox == null) {
            this.visibleExplosionDebrisCheckBox = new JCheckBox("Visible Explosion Debris");
            this.visibleExplosionDebrisCheckBox.setMnemonic('E');
            this.visibleExplosionDebrisCheckBox.setDisplayedMnemonicIndex(8);
        }
        return this.visibleExplosionDebrisCheckBox;
    }

    private void initialize() {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.getVisibleOptionsPanel());
        this.add(this.getTpsOptionsPanel());
        final ISettingsManager props = this.properties;
        this.loadPreferences(props);
        props.addPropertyListener(new ISettingsListener(){

            public void settingChanged(String property) {
                if (property.equals("robocode.options.battle.desiredTPS")) {
                    PreferencesViewOptionsTab.this.desiredTpsTextField.setText("" + props.getOptionsBattleDesiredTPS());
                }
            }
        });
    }

    private void loadPreferences(ISettingsManager robocodeProperties) {
        this.getDisplayFpsCheckBox().setSelected(robocodeProperties.getOptionsViewFPS());
        this.getDisplayTpsCheckBox().setSelected(robocodeProperties.getOptionsViewTPS());
        this.getVisibleRobotNameCheckBox().setSelected(robocodeProperties.getOptionsViewRobotNames());
        this.getVisibleRobotEnergyCheckBox().setSelected(robocodeProperties.getOptionsViewRobotEnergy());
        this.getVisibleScanArcsCheckBox().setSelected(robocodeProperties.getOptionsViewScanArcs());
        this.getVisibleExplosionsCheckBox().setSelected(robocodeProperties.getOptionsViewExplosions());
        this.getVisibleGroundCheckBox().setSelected(robocodeProperties.getOptionsViewGround());
        this.getVisibleExplosionDebrisCheckBox().setSelected(robocodeProperties.getOptionsViewExplosionDebris());
        this.getDesiredTpsTextField().setText("" + robocodeProperties.getOptionsBattleDesiredTPS());
    }

    public void storePreferences() {
        ISettingsManager props = this.properties;
        props.setOptionsViewFPS(this.getDisplayFpsCheckBox().isSelected());
        props.setOptionsViewTPS(this.getDisplayTpsCheckBox().isSelected());
        props.setOptionsViewRobotNames(this.getVisibleRobotNameCheckBox().isSelected());
        props.setOptionsViewRobotEnergy(this.getVisibleRobotEnergyCheckBox().isSelected());
        props.setOptionsViewScanArcs(this.getVisibleScanArcsCheckBox().isSelected());
        props.setOptionsViewExplosions(this.getVisibleExplosionsCheckBox().isSelected());
        props.setOptionsViewGround(this.getVisibleGroundCheckBox().isSelected());
        props.setOptionsViewExplosionDebris(this.getVisibleExplosionDebrisCheckBox().isSelected());
        props.setOptionsBattleDesiredTPS(Integer.parseInt(this.getDesiredTpsTextField().getText()));
        this.properties.saveProperties();
    }

    public boolean isReady() {
        try {
            int tps = Integer.parseInt(this.getDesiredTpsTextField().getText());
            if (tps < 1) {
                return false;
            }
            if (tps > 10000) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private class EventHandler
    implements ActionListener,
    DocumentListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == PreferencesViewOptionsTab.this.enableAllViewOptionsButton) {
                PreferencesViewOptionsTab.this.enableAllViewOptionsButtonActionPerformed();
            } else if (src == PreferencesViewOptionsTab.this.disableAllViewOptionsButton) {
                PreferencesViewOptionsTab.this.disableAllViewOptionsButtonActionPerformed();
            } else if (src == PreferencesViewOptionsTab.this.defaultViewOptionsButton) {
                PreferencesViewOptionsTab.this.defaultViewOptionsButtonActionPerformed();
            } else if (src == PreferencesViewOptionsTab.this.defaultTpsButton) {
                PreferencesViewOptionsTab.this.defaultTpsButtonActionPerformed();
            } else if (src == PreferencesViewOptionsTab.this.minTpsButton) {
                PreferencesViewOptionsTab.this.minTpsButtonActionPerformed();
            } else if (src == PreferencesViewOptionsTab.this.fastTpsButton) {
                PreferencesViewOptionsTab.this.fastTpsButtonActionPerformed();
            } else if (src == PreferencesViewOptionsTab.this.maxTpsButton) {
                PreferencesViewOptionsTab.this.maxTpsButtonActionPerformed();
            }
        }

        public void changedUpdate(DocumentEvent e) {
            PreferencesViewOptionsTab.this.desiredTpsTextFieldStateChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            PreferencesViewOptionsTab.this.desiredTpsTextFieldStateChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            PreferencesViewOptionsTab.this.desiredTpsTextFieldStateChanged();
        }
    }
}

