/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.dialog.WizardPanel;

public class PreferencesSoundOptionsTab
extends WizardPanel {
    private final ISettingsManager properties;
    private final EventHandler eventHandler = new EventHandler();
    private JPanel soundOptionsPanel;
    private JPanel mixerOptionsPanel;
    private JCheckBox enableSoundCheckBox;
    private JCheckBox enableGunshotCheckBox;
    private JCheckBox enableBulletHitCheckBox;
    private JCheckBox enableRobotDeathCheckBox;
    private JCheckBox enableWallCollisionCheckBox;
    private JCheckBox enableRobotCollisionCheckBox;
    private JButton enableAllSoundsButton;
    private JButton disableAllSoundsButton;
    private JComboBox mixerComboBox;
    private JButton mixerDefaultButton;
    private JCheckBox enableMixerVolumeCheckBox;
    private JCheckBox enableMixerPanCheckBox;

    public PreferencesSoundOptionsTab(ISettingsManager properties) {
        this.properties = properties;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(1, 3));
        this.add(this.getSoundOptionsPanel());
        this.add(this.getMixerOptionsPanel());
        this.add(new JPanel());
        this.loadPreferences(this.properties);
    }

    private JPanel getSoundOptionsPanel() {
        if (this.soundOptionsPanel == null) {
            this.soundOptionsPanel = new JPanel();
            this.soundOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sound Effects"));
            this.soundOptionsPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.anchor = 18;
            c.gridwidth = 0;
            this.soundOptionsPanel.add((Component)this.getEnableSoundCheckBox(), c);
            this.soundOptionsPanel.add((Component)this.getEnableGunshotCheckBox(), c);
            this.soundOptionsPanel.add((Component)this.getEnableBulletHitCheckBox(), c);
            this.soundOptionsPanel.add((Component)this.getEnableRobotDeathCheckBox(), c);
            this.soundOptionsPanel.add((Component)this.getEnableWallCollisionCheckBox(), c);
            this.soundOptionsPanel.add((Component)this.getEnableRobotCollisionCheckBox(), c);
            this.soundOptionsPanel.add((Component)new JLabel(" "), c);
            c.gridwidth = 1;
            c.fill = 0;
            c.weighty = 1.0;
            c.weightx = 0.0;
            this.soundOptionsPanel.add((Component)this.getEnableAllSoundsButton(), c);
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.soundOptionsPanel.add((Component)this.getDisableAllSoundsButton(), c);
            if (AudioSystem.getMixerInfo().length == 0) {
                for (Component child : this.soundOptionsPanel.getComponents()) {
                    child.setEnabled(false);
                }
            }
        }
        return this.soundOptionsPanel;
    }

    private JCheckBox getEnableSoundCheckBox() {
        if (this.enableSoundCheckBox == null) {
            this.enableSoundCheckBox = new JCheckBox("Enable Sound");
            this.enableSoundCheckBox.setMnemonic('E');
        }
        return this.enableSoundCheckBox;
    }

    private JCheckBox getEnableGunshotCheckBox() {
        if (this.enableGunshotCheckBox == null) {
            this.enableGunshotCheckBox = new JCheckBox("Gun Shots");
            this.enableGunshotCheckBox.setMnemonic('G');
        }
        return this.enableGunshotCheckBox;
    }

    private JCheckBox getEnableBulletHitCheckBox() {
        if (this.enableBulletHitCheckBox == null) {
            this.enableBulletHitCheckBox = new JCheckBox("Bullet Hit");
            this.enableBulletHitCheckBox.setMnemonic('H');
            this.enableBulletHitCheckBox.setDisplayedMnemonicIndex(7);
        }
        return this.enableBulletHitCheckBox;
    }

    private JCheckBox getEnableRobotDeathCheckBox() {
        if (this.enableRobotDeathCheckBox == null) {
            this.enableRobotDeathCheckBox = new JCheckBox("Robot Death Explosions");
            this.enableRobotDeathCheckBox.setMnemonic('x');
            this.enableRobotDeathCheckBox.setDisplayedMnemonicIndex(13);
        }
        return this.enableRobotDeathCheckBox;
    }

    private JCheckBox getEnableRobotCollisionCheckBox() {
        if (this.enableRobotCollisionCheckBox == null) {
            this.enableRobotCollisionCheckBox = new JCheckBox("Robot Collisions");
            this.enableRobotCollisionCheckBox.setMnemonic('t');
            this.enableRobotCollisionCheckBox.setDisplayedMnemonicIndex(4);
        }
        return this.enableRobotCollisionCheckBox;
    }

    private JCheckBox getEnableWallCollisionCheckBox() {
        if (this.enableWallCollisionCheckBox == null) {
            this.enableWallCollisionCheckBox = new JCheckBox("Wall Collisions");
            this.enableWallCollisionCheckBox.setMnemonic('l');
            this.enableWallCollisionCheckBox.setDisplayedMnemonicIndex(2);
        }
        return this.enableWallCollisionCheckBox;
    }

    private JButton getEnableAllSoundsButton() {
        if (this.enableAllSoundsButton == null) {
            this.enableAllSoundsButton = new JButton("Enable all");
            this.enableAllSoundsButton.setMnemonic('a');
            this.enableAllSoundsButton.setDisplayedMnemonicIndex(7);
            this.enableAllSoundsButton.addActionListener(this.eventHandler);
        }
        return this.enableAllSoundsButton;
    }

    private JButton getDisableAllSoundsButton() {
        if (this.disableAllSoundsButton == null) {
            this.disableAllSoundsButton = new JButton("Disable all");
            this.disableAllSoundsButton.setMnemonic('i');
            this.disableAllSoundsButton.setDisplayedMnemonicIndex(1);
            this.disableAllSoundsButton.addActionListener(this.eventHandler);
        }
        return this.disableAllSoundsButton;
    }

    private JPanel getMixerOptionsPanel() {
        if (this.mixerOptionsPanel == null) {
            this.mixerOptionsPanel = new JPanel();
            this.mixerOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Mixer"));
            this.mixerOptionsPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 0;
            c.weightx = 1.0;
            c.insets = new Insets(3, 3, 3, 3);
            this.mixerOptionsPanel.add((Component)new JLabel("Select mixer:"), c);
            c.gridy = 1;
            this.mixerOptionsPanel.add((Component)this.getMixerComboBox(), c);
            c.insets = new Insets(3, 3, 15, 3);
            c.gridy = 2;
            this.mixerOptionsPanel.add((Component)this.getMixerDefaultButton(), c);
            c.insets = new Insets(3, 3, 3, 3);
            c.gridy = 3;
            this.mixerOptionsPanel.add((Component)new JLabel("Enable mixer features:"), c);
            c.insets = new Insets(0, 0, 0, 0);
            c.gridy = 4;
            this.mixerOptionsPanel.add((Component)this.getEnableMixerVolumeCheckBox(), c);
            c.gridy = 5;
            this.mixerOptionsPanel.add((Component)this.getEnableMixerPanCheckBox(), c);
            if (AudioSystem.getMixerInfo().length == 0) {
                for (Component child : this.mixerOptionsPanel.getComponents()) {
                    child.setEnabled(false);
                }
            }
        }
        return this.mixerOptionsPanel;
    }

    private JComboBox getMixerComboBox() {
        if (this.mixerComboBox == null) {
            Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
            Line.Info clipLineInfo = new Line.Info(Clip.class);
            Vector<Mixer.Info> mixers = new Vector<Mixer.Info>();
            for (Mixer.Info mi : mixerInfo) {
                if (AudioSystem.getMixer(mi).getSourceLineInfo(clipLineInfo).length <= 0) continue;
                mixers.add(mi);
            }
            this.mixerComboBox = new JComboBox(mixers);
            this.mixerComboBox.setRenderer(new MixerInfoCellRenderer());
            this.mixerComboBox.addActionListener(this.eventHandler);
        }
        return this.mixerComboBox;
    }

    private JButton getMixerDefaultButton() {
        if (this.mixerDefaultButton == null) {
            this.mixerDefaultButton = new JButton("Default");
            this.mixerDefaultButton.setMnemonic('u');
            this.mixerDefaultButton.setDisplayedMnemonicIndex(4);
            this.mixerDefaultButton.addActionListener(this.eventHandler);
        }
        return this.mixerDefaultButton;
    }

    private JCheckBox getEnableMixerVolumeCheckBox() {
        if (this.enableMixerVolumeCheckBox == null) {
            this.enableMixerVolumeCheckBox = new JCheckBox("Volume");
            this.enableMixerVolumeCheckBox.setMnemonic('V');
            this.enableMixerVolumeCheckBox.addActionListener(this.eventHandler);
        }
        return this.enableMixerVolumeCheckBox;
    }

    private JCheckBox getEnableMixerPanCheckBox() {
        if (this.enableMixerPanCheckBox == null) {
            this.enableMixerPanCheckBox = new JCheckBox("Pan");
            this.enableMixerPanCheckBox.setMnemonic('P');
            this.enableMixerPanCheckBox.addActionListener(this.eventHandler);
        }
        return this.enableMixerPanCheckBox;
    }

    private void loadPreferences(ISettingsManager robocodeProperties) {
        this.getEnableSoundCheckBox().setSelected(robocodeProperties.getOptionsSoundEnableSound());
        this.getEnableGunshotCheckBox().setSelected(robocodeProperties.getOptionsSoundEnableGunshot());
        this.getEnableBulletHitCheckBox().setSelected(robocodeProperties.getOptionsSoundEnableBulletHit());
        this.getEnableRobotDeathCheckBox().setSelected(robocodeProperties.getOptionsSoundEnableRobotDeath());
        this.getEnableRobotCollisionCheckBox().setSelected(robocodeProperties.getOptionsSoundEnableRobotCollision());
        this.getEnableWallCollisionCheckBox().setSelected(robocodeProperties.getOptionsSoundEnableWallCollision());
        this.getEnableMixerVolumeCheckBox().setSelected(robocodeProperties.getOptionsSoundEnableMixerVolume());
        this.getEnableMixerPanCheckBox().setSelected(robocodeProperties.getOptionsSoundEnableMixerPan());
        this.setMixerCompoBox(robocodeProperties.getOptionsSoundMixer());
    }

    public void storePreferences() {
        ISettingsManager props = this.properties;
        props.setOptionsSoundEnableSound(this.getEnableSoundCheckBox().isSelected());
        props.setOptionsSoundEnableGunshot(this.getEnableGunshotCheckBox().isSelected());
        props.setOptionsSoundEnableBulletHit(this.getEnableBulletHitCheckBox().isSelected());
        props.setOptionsSoundEnableRobotDeath(this.getEnableRobotDeathCheckBox().isSelected());
        props.setOptionsSoundEnableRobotCollision(this.getEnableRobotCollisionCheckBox().isSelected());
        props.setOptionsSoundEnableWallCollision(this.getEnableWallCollisionCheckBox().isSelected());
        props.setOptionsSoundEnableMixerVolume(this.getEnableMixerVolumeCheckBox().isSelected());
        props.setOptionsSoundEnableMixerPan(this.getEnableMixerPanCheckBox().isSelected());
        Mixer mixer = AudioSystem.getMixer((Mixer.Info)this.getMixerComboBox().getSelectedItem());
        props.setOptionsSoundMixer(mixer.getClass().getSimpleName());
        this.properties.saveProperties();
    }

    public boolean isReady() {
        return true;
    }

    private void setMixerCompoBox(String mixerName) {
        for (Mixer.Info mi : AudioSystem.getMixerInfo()) {
            if (!AudioSystem.getMixer(mi).getClass().getSimpleName().equals(mixerName)) continue;
            this.getMixerComboBox().setSelectedItem(mi);
            break;
        }
    }

    private void enableAllSoundsButtonActionPerformed() {
        this.enableSoundCheckBox.setSelected(true);
        this.enableGunshotCheckBox.setSelected(true);
        this.enableBulletHitCheckBox.setSelected(true);
        this.enableRobotDeathCheckBox.setSelected(true);
        this.enableWallCollisionCheckBox.setSelected(true);
        this.enableRobotCollisionCheckBox.setSelected(true);
    }

    private void disableAllSoundsButtonActionPerformed() {
        this.enableSoundCheckBox.setSelected(false);
        this.enableGunshotCheckBox.setSelected(false);
        this.enableBulletHitCheckBox.setSelected(false);
        this.enableRobotDeathCheckBox.setSelected(false);
        this.enableWallCollisionCheckBox.setSelected(false);
        this.enableRobotCollisionCheckBox.setSelected(false);
    }

    private void mixerComboBoxActionPerformed() {
        boolean panSupported;
        boolean volumeSupported;
        Mixer mixer = AudioSystem.getMixer((Mixer.Info)this.mixerComboBox.getSelectedItem());
        Line.Info lineInfo = mixer.getSourceLineInfo(new Line.Info(Clip.class))[0];
        try {
            Line line = mixer.getLine(lineInfo);
            volumeSupported = line.isControlSupported(FloatControl.Type.MASTER_GAIN);
            panSupported = line.isControlSupported(FloatControl.Type.PAN);
        }
        catch (LineUnavailableException e) {
            volumeSupported = false;
            panSupported = false;
        }
        this.enableMixerVolumeCheckBox.setEnabled(volumeSupported);
        this.enableMixerPanCheckBox.setEnabled(panSupported);
    }

    private void mixerDefaultButtonActionPerformed() {
        this.setMixerCompoBox("DirectAudioDevice");
    }

    private static class MixerInfoCellRenderer
    extends BasicComboBoxRenderer {
        private MixerInfoCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Mixer.Info mi = (Mixer.Info)value;
            if (mi != null) {
                String text = mi.getName();
                if (!"Unknown Version".equals(mi.getVersion())) {
                    text = text + ' ' + mi.getVersion();
                }
                if (!"Unknown Vendor".equals(mi.getVendor())) {
                    text = text + " by " + mi.getVendor();
                }
                this.setText(text);
            }
            return component;
        }
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == PreferencesSoundOptionsTab.this.enableAllSoundsButton) {
                PreferencesSoundOptionsTab.this.enableAllSoundsButtonActionPerformed();
            } else if (src == PreferencesSoundOptionsTab.this.disableAllSoundsButton) {
                PreferencesSoundOptionsTab.this.disableAllSoundsButtonActionPerformed();
            } else if (src == PreferencesSoundOptionsTab.this.mixerComboBox) {
                PreferencesSoundOptionsTab.this.mixerComboBoxActionPerformed();
            } else if (src == PreferencesSoundOptionsTab.this.mixerDefaultButton) {
                PreferencesSoundOptionsTab.this.mixerDefaultButtonActionPerformed();
            }
        }
    }
}

