/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.dialog.WizardPanel;

public class PreferencesDevelopmentOptionsTab
extends WizardPanel {
    private JPanel optionsPanel;
    private JButton browseButton;
    private JTextField pathTextField;
    public final ISettingsManager properties;
    private final EventHandler eventHandler = new EventHandler();

    public PreferencesDevelopmentOptionsTab(ISettingsManager properties) {
        this.properties = properties;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.getOptionsPanel());
        this.loadPreferences(this.properties);
    }

    private JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Development"));
            GridBagLayout layout = new GridBagLayout();
            this.optionsPanel.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(5, 5, 5, 5);
            c.anchor = 18;
            c.fill = 2;
            c.gridwidth = 2;
            c.weightx = 0.0;
            this.optionsPanel.add((Component)new JLabel("If you are using an external IDE to develop robots, you may enter the classpath to those robots here."), c);
            c.gridy = 1;
            this.optionsPanel.add((Component)new JLabel("Example:  c:\\eclipse\\workspace\\MyRobotProject" + File.pathSeparator + "c:\\eclipse\\workspace\\AnotherRobotProject"), c);
            c.fill = 0;
            c.gridwidth = 1;
            c.gridy = 2;
            c.insets = new Insets(3, 3, 3, 3);
            this.optionsPanel.add((Component)this.getBrowseButton(), c);
            c.fill = 2;
            c.weightx = 1.0;
            c.gridx = 1;
            c.insets = new Insets(5, 5, 5, 5);
            this.optionsPanel.add((Component)this.getPathTextField(), c);
            c.fill = 3;
            c.weighty = 1.0;
            c.gridy = 3;
            this.optionsPanel.add((Component)new JPanel(), c);
        }
        return this.optionsPanel;
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton("Browse");
            this.browseButton.setMnemonic('o');
            this.browseButton.setDisplayedMnemonicIndex(2);
            this.browseButton.addActionListener(this.eventHandler);
        }
        return this.browseButton;
    }

    private JTextField getPathTextField() {
        if (this.pathTextField == null) {
            this.pathTextField = new JTextField("", 80);
        }
        return this.pathTextField;
    }

    private void loadPreferences(ISettingsManager robocodeProperties) {
        this.getPathTextField().setText(robocodeProperties.getOptionsDevelopmentPath());
    }

    public void storePreferences() {
        this.properties.setOptionsDevelopmentPath(this.getPathTextField().getText());
        this.properties.saveProperties();
    }

    public boolean isReady() {
        return true;
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PreferencesDevelopmentOptionsTab.this.getBrowseButton()) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                if (chooser.showOpenDialog(PreferencesDevelopmentOptionsTab.this.optionsPanel) == 0) {
                    PreferencesDevelopmentOptionsTab.this.pathTextField.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        }
    }
}

