/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ConsoleScrollPane
extends JScrollPane {
    private final int MAX_ROWS = 500;
    private JTextArea textPane;
    private int lines;
    private final Rectangle bottomRect = new Rectangle(0, Short.MAX_VALUE, 1, 1);
    private final Runnable scroller = new Runnable(){

        public void run() {
            ConsoleScrollPane.this.getViewport().scrollRectToVisible(ConsoleScrollPane.this.bottomRect);
            ConsoleScrollPane.this.getViewport().repaint();
        }
    };

    public ConsoleScrollPane() {
        this.initialize();
    }

    public void append(String text) {
        ++this.lines;
        this.getTextPane().append(text);
        if (this.lines > 500) {
            int from;
            this.lines = 0;
            String[] rows = this.getTextPane().getText().split("\n");
            StringBuilder sb = new StringBuilder();
            for (int i = from = Math.min(rows.length, Math.max(250, rows.length - 250)); i < rows.length; ++i) {
                sb.append(rows[i]);
                sb.append('\n');
                ++this.lines;
            }
            this.getTextPane().setText(sb.toString());
        }
    }

    public Dimension getAreaSize() {
        return this.getTextPane().getPreferredSize();
    }

    public String getSelectedText() {
        return this.getTextPane().getSelectedText();
    }

    public String getText() {
        return this.getTextPane().getText();
    }

    public JTextArea getTextPane() {
        if (this.textPane == null) {
            this.textPane = new JTextArea();
            this.textPane.setBackground(Color.lightGray);
            this.textPane.setBounds(0, 0, 1000, 1000);
            this.textPane.setEditable(false);
        }
        return this.textPane;
    }

    private void initialize() {
        this.lines = 0;
        this.setViewportView(this.getTextPane());
    }

    public void processStream(InputStream input) {
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int tabIndex = line.indexOf("\t");
                while (tabIndex >= 0) {
                    line = line.substring(0, tabIndex) + "    " + line.substring(tabIndex + 1);
                    tabIndex = line.indexOf("\t");
                }
                this.append(line + "\n");
            }
        }
        catch (IOException e) {
            this.append("IOException: " + e);
        }
        this.scrollToBottom();
    }

    public void scrollToBottom() {
        SwingUtilities.invokeLater(this.scroller);
    }

    public void setText(String text) {
        this.getTextPane().setText(text);
    }
}

