/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.robocode.ui.dialog.ConsoleScrollPane;

public class ConsoleDialog
extends JDialog {
    private JPanel consoleDialogContentPane;
    private JPanel buttonsPanel;
    private ConsoleScrollPane scrollPane;
    private JButton okButton;
    private JMenu editMenu;
    private JMenuItem editCopyMenuItem;
    private JMenuBar consoleDialogMenuBar;
    private final EventHandler eventHandler = new EventHandler();

    public ConsoleDialog() {
        this.initialize();
    }

    public ConsoleDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initialize();
    }

    public void append(String text) {
        this.getScrollPane().append(text);
    }

    public void editCopyActionPerformed() {
        String s = this.getScrollPane().getSelectedText();
        if (s == null) {
            s = this.getScrollPane().getText();
        }
        StringSelection ss = new StringSelection(s);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setPreferredSize(new Dimension(100, 30));
            this.buttonsPanel.setLayout(new GridBagLayout());
            this.buttonsPanel.setMinimumSize(new Dimension(20, 20));
            this.buttonsPanel.setMaximumSize(new Dimension(1000, 30));
            GridBagConstraints constraintsOKButton = new GridBagConstraints();
            constraintsOKButton.gridx = 1;
            constraintsOKButton.gridy = 1;
            constraintsOKButton.ipadx = 34;
            constraintsOKButton.insets = new Insets(2, 173, 3, 168);
            this.getButtonsPanel().add((Component)this.getOkButton(), constraintsOKButton);
        }
        return this.buttonsPanel;
    }

    private JPanel getConsoleDialogContentPane() {
        if (this.consoleDialogContentPane == null) {
            this.consoleDialogContentPane = new JPanel();
            this.consoleDialogContentPane.setLayout(new BorderLayout());
            this.consoleDialogContentPane.add((Component)this.getButtonsPanel(), "South");
            this.consoleDialogContentPane.add((Component)this.getScrollPane(), "Center");
            this.consoleDialogContentPane.registerKeyboardAction(this.eventHandler, KeyStroke.getKeyStroke(10, 0), 0);
        }
        return this.consoleDialogContentPane;
    }

    public JMenuBar getConsoleDialogMenuBar() {
        if (this.consoleDialogMenuBar == null) {
            this.consoleDialogMenuBar = new JMenuBar();
            this.consoleDialogMenuBar.add(this.getEditMenu());
        }
        return this.consoleDialogMenuBar;
    }

    public JMenuItem getEditCopyMenuItem() {
        if (this.editCopyMenuItem == null) {
            this.editCopyMenuItem = new JMenuItem("Copy");
            this.editCopyMenuItem.addActionListener(this.eventHandler);
        }
        return this.editCopyMenuItem;
    }

    public JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu("Edit");
            this.editMenu.add(this.getEditCopyMenuItem());
        }
        return this.editMenu;
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(this.eventHandler);
        }
        return this.okButton;
    }

    private ConsoleScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new ConsoleScrollPane();
        }
        return this.scrollPane;
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setSize(426, 240);
        this.setContentPane(this.getConsoleDialogContentPane());
        this.setJMenuBar(this.getConsoleDialogMenuBar());
    }

    public void okButtonActionPerformed() {
        this.dispose();
    }

    public void processStream(InputStream in) {
        this.scrollPane.processStream(in);
    }

    public void scrollToBottom() {
        this.getScrollPane().scrollToBottom();
    }

    public void setText(String text) {
        this.getScrollPane().setText(text);
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ConsoleDialog.this.getOkButton() || e.getSource() == ConsoleDialog.this.getConsoleDialogContentPane()) {
                ConsoleDialog.this.okButtonActionPerformed();
            }
            if (e.getSource() == ConsoleDialog.this.getEditCopyMenuItem()) {
                ConsoleDialog.this.editCopyActionPerformed();
            }
        }
    }
}

