/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.IWindowManagerExt;
import net.sf.robocode.ui.dialog.ResultsTableCellRenderer;

public abstract class BaseScoreDialog
extends JDialog {
    protected final IWindowManagerExt windowManager;
    private final EventHandler eventHandler = new EventHandler();
    protected JPanel contentPane;
    protected JScrollPane scrollPane;
    protected JTable table;
    protected Dimension tableSize;

    public BaseScoreDialog(IWindowManager windowManager, boolean modal) {
        super((Frame)windowManager.getRobocodeFrame(), modal);
        this.windowManager = (IWindowManagerExt)windowManager;
    }

    protected void initialize() {
        this.addComponentListener(this.eventHandler);
        this.setDefaultCloseOperation(1);
        this.setContentPane(this.getDialogContentPane());
    }

    protected JPanel getDialogContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new BorderLayout());
            this.contentPane.add((Component)this.getScrollPane(), "Center");
        }
        return this.contentPane;
    }

    protected JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.getViewport().setScrollMode(1);
            this.scrollPane.setViewportView(this.getTable());
            this.scrollPane.setColumnHeaderView(this.table.getTableHeader());
            this.scrollPane.addComponentListener(this.eventHandler);
            this.tableSize = new Dimension(this.getTable().getColumnModel().getTotalColumnWidth(), this.getTable().getModel().getRowCount() * this.getTable().getRowHeight());
            this.table.setPreferredScrollableViewportSize(this.tableSize);
            this.table.setPreferredSize(this.tableSize);
            this.table.setMinimumSize(this.tableSize);
        }
        return this.scrollPane;
    }

    protected JTable getTable() {
        if (this.table == null) {
            this.table = new JTable();
            this.table.setAutoResizeMode(0);
            this.table.setColumnSelectionAllowed(true);
            this.table.setRowSelectionAllowed(true);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.setResultsData();
            this.pack();
        }
        return this.table;
    }

    protected abstract AbstractTableModel getTableModel();

    protected void onDialogShown() {
    }

    protected void onDialogHidden() {
        this.dispose();
    }

    protected void scrollPaneComponentResized() {
        Dimension scrollPaneExtent = this.getScrollPane().getViewport().getExtentSize();
        if (this.tableSize != null && this.tableSize.width < scrollPaneExtent.width) {
            this.getTable().setAutoResizeMode(2);
            this.getTable().setSize(scrollPaneExtent);
            this.getTable().sizeColumnsToFit(-1);
        } else {
            if (this.tableSize != null) {
                this.getTable().setSize(this.tableSize);
                this.getTable().sizeColumnsToFit(-1);
            }
            this.table.setAutoResizeMode(0);
        }
        this.validate();
        this.repaint();
    }

    protected void setResultsData() {
        this.getTable().setModel(this.getTableModel());
        int maxScoreColWidth = 0;
        for (int x = 0; x < this.getTableModel().getColumnCount(); ++x) {
            if (x != 1) {
                this.getTable().getColumnModel().getColumn(x).setCellRenderer(new ResultsTableCellRenderer(false));
            }
            TableColumn column = this.getTable().getColumnModel().getColumn(x);
            column.setHeaderRenderer(new ResultsTableCellRenderer(true));
            Component comp = column.getHeaderRenderer().getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            for (int y = 0; y < this.getTableModel().getRowCount(); ++y) {
                comp = this.getTable().getDefaultRenderer(this.getTableModel().getColumnClass(x)).getTableCellRendererComponent(this.getTable(), this.getTableModel().getValueAt(y, x), false, false, 0, x);
                if (comp.getPreferredSize().width <= width) continue;
                width = comp.getPreferredSize().width;
            }
            TableColumn col = this.getTable().getColumnModel().getColumn(x);
            col.setPreferredWidth(width);
            col.setMinWidth(width);
            col.setWidth(width);
            if (x < 3 || width <= maxScoreColWidth) continue;
            maxScoreColWidth = width;
        }
    }

    private class EventHandler
    implements ComponentListener {
        private EventHandler() {
        }

        public void componentShown(ComponentEvent e) {
            BaseScoreDialog.this.onDialogShown();
        }

        public void componentHidden(ComponentEvent e) {
            BaseScoreDialog.this.onDialogHidden();
        }

        public void componentResized(ComponentEvent e) {
            if (e.getSource() == BaseScoreDialog.this.getScrollPane()) {
                BaseScoreDialog.this.scrollPaneComponentResized();
            }
        }

        public void componentMoved(ComponentEvent e) {
        }
    }
}

