/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.robocode.ui.BrowserManager;
import net.sf.robocode.ui.dialog.RobocodeFrame;
import net.sf.robocode.version.IVersionManager;

public final class AboutBox
extends JDialog {
    private static final Color BG_COLOR = SystemColor.controlHighlight;
    private static final String TAG_ROBOCODE_VERSION = "<robocode:version>";
    private static final String TAG_ROBOCODE_ICON_SRC = "<robocode:icon-src>";
    private static final String TAG_SYSCOLOR_CTRL_HIGHLIGHT = "<syscolor:ctrl-highlight>";
    private static final String TAG_JAVA_VERSION = "<java:version>";
    private static final String TAG_JAVA_VENDOR = "<java:vendor>";
    private static final String HTML_TEMPLATE = "<head><style type=\"text/css\">p, td {font-family: sans-serif;font-size: 10px}</style></head><body bgcolor=\"<syscolor:ctrl-highlight>\"><table><tr><td valign=\"top\"><img src=\"<robocode:icon-src>\"></td><td><table width=\"100%\"><tr><td width=\"100%\"><b>Robocode</b><br><br>&copy;&nbsp;Copyright 2001, 2008<br>Mathew A. Nelson and Robocode contributors</td><td><b>Version: <robocode:version></b><br><br><a href=\"http://robocode.sourceforge.net\">robocode.sourceforge.net</a><br>&nbsp;</td></tr></table><center><br><b>Original Author</b><br>Designed and programmed by Mathew A. Nelson<br>Graphics by Garett S. Hourihan<br><br><b>Featuring RoboRumble@Home</b><br>Originally designed and programmed by Albert P\ufffdrez<br><br><b>Main Contributors:</b><br>Flemming N. Larsen (Robocode administrator, developer, integrator, lots of features),<br>Pavel Savara (Robocode administrator, developer, integrator, robot interfaces, battle events, refactorings),<br><br><b>Other Contributors:</b><br>Cubic Creative (the design and ideas for the JuniorRobot class),<br>Christian D. Schnell (for the Codesize utility),<br>Luis Crespo (sound engine, single-step debugging, ranking panel),<br>Matthew Reeder (editor enhancements, keyboard shortcuts, HyperThreading bugfixes),<br>Titus Chen (bugfixes for robot teleportation, bad wall collision detection, team ranking,<br>replay scores and robot color flickering),<br>Robert D. Maupin (optimizations with collections and improved CPU constant benchmark),<br>Ascander Jr (graphics for ground tiles),<br>Stefan Westen (onPaint method from RobocodeSG),<br>Nathaniel Troutman (fixing memory leaks due to circular references)<br>Aaron Rotenberg (for the Robot Cache Cleaner utility),<br>Julian Kent (nano precision timing of allowed robot time),<br>Joachim Hofer (fixing problem with wrong results in RoboRumble),<br>Endre Palatinus, Eniko Nagy, Attila Csizofszki and Laszlo Vigh (score % in results/rankings)<br><br><b>Java Runtime Environment</b><br>Java <java:version> by <java:vendor></center></td></tr></table></body>";
    private final String robocodeVersion;
    private final URL iconURL;
    private JPanel aboutBoxContentPane;
    private JEditorPane mainPanel;
    private JPanel buttonPanel;
    private JButton okButton;
    private String htmlText;
    private final ActionListener eventHandler = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AboutBox.this.getOkButton()) {
                AboutBox.this.dispose();
            }
        }
    };
    private final HyperlinkListener hyperlinkHandler = new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    BrowserManager.openURL(event.getURL().toExternalForm());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    };

    public AboutBox(RobocodeFrame owner, IVersionManager versionManager) {
        super((Frame)owner, true);
        this.robocodeVersion = versionManager.getVersion();
        this.iconURL = AboutBox.class.getResource("/net/sf/robocode/ui/icons/robocode-icon.png");
        this.setDefaultCloseOperation(2);
        this.setTitle("About Robocode");
        this.setContentPane(this.getAboutBoxContentPane());
        this.setResizable(false);
    }

    private JPanel getAboutBoxContentPane() {
        if (this.aboutBoxContentPane == null) {
            this.aboutBoxContentPane = new JPanel();
            this.aboutBoxContentPane.setLayout(new BorderLayout());
            this.aboutBoxContentPane.add((Component)this.getButtonPanel(), "South");
            this.aboutBoxContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.aboutBoxContentPane;
    }

    private JEditorPane getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JEditorPane("text/html", this.getHtmlText());
            this.mainPanel.setBackground(BG_COLOR);
            this.mainPanel.setEditable(false);
            this.mainPanel.addHyperlinkListener(this.hyperlinkHandler);
        }
        return this.mainPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBackground(BG_COLOR);
            this.buttonPanel.setLayout(new FlowLayout());
            this.buttonPanel.add(this.getOkButton());
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(this.eventHandler);
        }
        return this.okButton;
    }

    private String getHtmlText() {
        if (this.htmlText == null) {
            this.htmlText = HTML_TEMPLATE.replaceAll(TAG_ROBOCODE_VERSION, this.robocodeVersion).replaceAll(TAG_ROBOCODE_ICON_SRC, this.iconURL.toString()).replaceAll(TAG_SYSCOLOR_CTRL_HIGHLIGHT, AboutBox.toHtmlColor(BG_COLOR)).replaceAll(TAG_JAVA_VERSION, System.getProperty("java.version")).replaceAll(TAG_JAVA_VENDOR, System.getProperty("java.vendor"));
        }
        return this.htmlText;
    }

    private static String toHtmlColor(Color color) {
        return "#" + AboutBox.toHexDigits(color.getRed()) + AboutBox.toHexDigits(color.getGreen()) + AboutBox.toHexDigits(color.getBlue());
    }

    private static String toHexDigits(int value) {
        return "" + AboutBox.toHexDigit(value >> 4) + AboutBox.toHexDigit(value & 0xF);
    }

    private static char toHexDigit(int value) {
        int v = value & 0xF;
        if (v < 10) {
            return (char)(48 + v);
        }
        return (char)(65 + (v - 10));
    }
}

