/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.battle;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Timer;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.battle.events.BattleEventDispatcher;
import net.sf.robocode.battle.snapshot.RobotSnapshot;
import net.sf.robocode.io.Logger;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleErrorEvent;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattleMessageEvent;
import robocode.control.events.BattlePausedEvent;
import robocode.control.events.BattleResumedEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.RoundEndedEvent;
import robocode.control.events.RoundStartedEvent;
import robocode.control.events.TurnEndedEvent;
import robocode.control.events.TurnStartedEvent;
import robocode.control.snapshot.IRobotSnapshot;
import robocode.control.snapshot.ITurnSnapshot;

public final class AwtBattleAdaptor
extends BattleAdaptor {
    private final IBattleManager battleManager;
    private final BattleEventDispatcher battleEventDispatcher = new BattleEventDispatcher();
    private final BattleObserver observer;
    private final Timer timerTask;
    private final AtomicReference<ITurnSnapshot> snapshot;
    private final AtomicBoolean isRunning;
    private final AtomicBoolean isPaused;
    private StringBuilder[] outCache;
    private ITurnSnapshot lastSnapshot;
    private int fps;
    private long measuredFrameCounter;
    private long measuredFrameStartTime;
    private final boolean skipSameFrames;

    public AwtBattleAdaptor(IBattleManager battleManager, int maxFps, boolean skipSameFrames) {
        this.battleManager = battleManager;
        this.snapshot = new AtomicReference<Object>(null);
        this.skipSameFrames = skipSameFrames;
        this.timerTask = new Timer(1000 / maxFps, new TimerTask());
        this.isRunning = new AtomicBoolean(false);
        this.isPaused = new AtomicBoolean(false);
        this.observer = new BattleObserver();
        battleManager.addListener((IBattleListener)this.observer);
        this.battleEventDispatcher.addListener((IBattleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.timerTask.stop();
            this.battleManager.removeListener((IBattleListener)this.observer);
            this.battleEventDispatcher.removeListener((IBattleListener)this);
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void addListener(IBattleListener listener) {
        this.battleEventDispatcher.addListener(listener);
    }

    public synchronized void removeListener(IBattleListener listener) {
        this.battleEventDispatcher.removeListener(listener);
    }

    public void onBattleStarted(BattleStartedEvent event) {
        this.repaintTask(true, false);
        this.timerTask.start();
    }

    public void onBattleFinished(BattleFinishedEvent event) {
        this.timerTask.stop();
        this.repaintTask(true, true);
    }

    public void onBattleResumed(BattleResumedEvent event) {
        if (this.isRunning.get()) {
            this.timerTask.start();
        }
    }

    public void onBattlePaused(BattlePausedEvent event) {
        this.timerTask.stop();
    }

    public void onRoundStarted(RoundStartedEvent event) {
        this.repaintTask(true, false);
    }

    public void onRoundEnded(RoundEndedEvent event) {
        this.repaintTask(true, true);
    }

    public ITurnSnapshot getLastSnapshot() {
        return this.lastSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintTask(boolean forceRepaint, boolean readoutText) {
        block10: {
            try {
                ITurnSnapshot current = this.snapshot.get();
                if (!this.isRunning.get() || current == null) {
                    this.lastSnapshot = null;
                    this.battleEventDispatcher.onTurnEnded(new TurnEndedEvent(null));
                    break block10;
                }
                if (this.lastSnapshot == current && this.skipSameFrames && !forceRepaint) break block10;
                this.lastSnapshot = current;
                IRobotSnapshot[] robots = null;
                if (readoutText) {
                    AtomicReference<ITurnSnapshot> atomicReference = this.snapshot;
                    synchronized (atomicReference) {
                        robots = this.lastSnapshot.getRobots();
                        for (int i = 0; i < robots.length; ++i) {
                            RobotSnapshot robot = (RobotSnapshot)robots[i];
                            robot.setOutputStreamSnapshot(this.outCache[i].toString());
                            this.outCache[i].setLength(0);
                        }
                    }
                }
                this.battleEventDispatcher.onTurnEnded(new TurnEndedEvent(this.lastSnapshot));
                if (readoutText) {
                    for (IRobotSnapshot robot : robots) {
                        ((RobotSnapshot)robot).setOutputStreamSnapshot(null);
                    }
                }
                this.calculateFPS();
            }
            catch (Throwable t) {
                Logger.logError((Throwable)t);
            }
        }
    }

    public int getFPS() {
        return this.fps;
    }

    private void calculateFPS() {
        long deltaTime;
        if (this.measuredFrameCounter++ == 0L) {
            this.measuredFrameStartTime = System.nanoTime();
        }
        if ((deltaTime = System.nanoTime() - this.measuredFrameStartTime) / 1000000000L >= 1L) {
            this.fps = (int)(this.measuredFrameCounter * 1000000000L / deltaTime);
            this.measuredFrameCounter = 0L;
        }
    }

    static /* synthetic */ StringBuilder[] access$402(AwtBattleAdaptor x0, StringBuilder[] x1) {
        x0.outCache = x1;
        return x1;
    }

    private class BattleObserver
    extends BattleAdaptor {
        private BattleObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTurnEnded(final TurnEndedEvent event) {
            AwtBattleAdaptor.this.snapshot.set(event.getTurnSnapshot());
            IRobotSnapshot[] robots = event.getTurnSnapshot().getRobots();
            AtomicReference atomicReference = AwtBattleAdaptor.this.snapshot;
            synchronized (atomicReference) {
                for (int i = 0; i < robots.length; ++i) {
                    IRobotSnapshot robot = robots[i];
                    if (robot.getOutputStreamSnapshot() == null || robot.getOutputStreamSnapshot().length() == 0) continue;
                    AwtBattleAdaptor.this.outCache[i].append(robot.getOutputStreamSnapshot());
                }
            }
            if (AwtBattleAdaptor.this.isPaused.get()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        AwtBattleAdaptor.this.battleEventDispatcher.onTurnEnded(event);
                    }
                });
            }
        }

        public void onRoundStarted(final RoundStartedEvent event) {
            AwtBattleAdaptor.this.snapshot.set(event.getStartSnapshot());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onRoundStarted(event);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBattleStarted(final BattleStartedEvent event) {
            AwtBattleAdaptor.this.isRunning.set(true);
            AwtBattleAdaptor.this.isPaused.set(false);
            AwtBattleAdaptor.this.snapshot.set(null);
            AtomicReference atomicReference = AwtBattleAdaptor.this.snapshot;
            synchronized (atomicReference) {
                AwtBattleAdaptor.access$402(AwtBattleAdaptor.this, new StringBuilder[event.getRobotsCount()]);
                for (int i = 0; i < event.getRobotsCount(); ++i) {
                    ((AwtBattleAdaptor)AwtBattleAdaptor.this).outCache[i] = new StringBuilder(1024);
                }
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleStarted(event);
                }
            });
        }

        public void onBattleFinished(final BattleFinishedEvent event) {
            AwtBattleAdaptor.this.isRunning.set(false);
            AwtBattleAdaptor.this.isPaused.set(false);
            AwtBattleAdaptor.this.snapshot.set(null);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleFinished(event);
                }
            });
        }

        public void onBattleCompleted(final BattleCompletedEvent event) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleCompleted(event);
                }
            });
        }

        public void onBattlePaused(final BattlePausedEvent event) {
            AwtBattleAdaptor.this.isPaused.set(true);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattlePaused(event);
                }
            });
        }

        public void onBattleResumed(final BattleResumedEvent event) {
            AwtBattleAdaptor.this.isPaused.set(false);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleResumed(event);
                }
            });
        }

        public void onRoundEnded(final RoundEndedEvent event) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onRoundEnded(event);
                }
            });
        }

        public void onTurnStarted(final TurnStartedEvent event) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onTurnStarted(event);
                }
            });
        }

        public void onBattleMessage(final BattleMessageEvent event) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleMessage(event);
                }
            });
        }

        public void onBattleError(final BattleErrorEvent event) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtBattleAdaptor.this.battleEventDispatcher.onBattleError(event);
                }
            });
        }
    }

    private class TimerTask
    implements ActionListener {
        private TimerTask() {
        }

        public void actionPerformed(ActionEvent e) {
            AwtBattleAdaptor.this.repaintTask(false, true);
        }
    }
}

